/**
 * @fileoveriew Menu - places a div element on the page and renders HTML input buttons to build a menu structure
 *
 * @author Martin Donnelly
 * 
 */
/**
 * @class TiledMenu - A variant on the Menu utility.
 * (Nigel: Not sure why Martin's built this - it would have been more appropriate to modify OU.util.Menu)
 * @Deprecated - Should use OU.util.Menu
 */
OU.util.TiledMenu = function ( params ) {
    this.menus = params.menus;
    this.container = params.container;
    this.register = params.dontRegister || false;
    this.x = params.x || this.container.x || 0;
    this.y = params.y || this.container.y || 0;
    this.w = params.w || this.container.w;
    this.h = params.h || this.container.h;
    this.showHighlight = params.showHighlight===false ? false : true;
    this.style = this.menus.style || 'horizontal';
    this.shadow = this.menus.shadow || false;
    this.title = params.title || '';
    this.zIndex = params.zIndex || OU.CONTROLLER_LEVEL - 1;
    OU.util.TiledMenu.prototype.init = function () {
        var menus = this.menus, i,
            autoLoad = this.menus.autoLoad;
        this.menuId = OU.menus.length; // get the menuId for this menu activity
        OU.menus[this.menuId] = this;    // and store this menu in the controllers array of menus
        this.menuDiv = new OU.util.Div({
            dontRegister:this.register,
            x:this.x,
            y:this.y,
            w:this.w,
            h:"auto",
            zIndex:this.zIndex,
            container:this.container,
            showScroll:false
        });
        OU.nobbleDoneBar(this.menuDiv.div);
        menus.selected = [];
        for (i = menus.levels; i--;)
            menus.selected[i] = OU.LocalStorage.load("ou.menus." + this.container.instance + "." + this.menuId + "._" + i) || 0;
        this.render(this.menuId==0 && autoLoad);
    };
    OU.util.TiledMenu.prototype.resize = function ( params ) {
        this.x = params.x || this.container.x || 0;
        this.y = params.y || this.container.y || 0;
        this.w = params.w || this.container.w;
        this.h = params.h || this.container.h;
        this.menuDiv.resize({
            x:this.x,
            y:this.y,
            w:this.w,
            h:"auto"
        });
    };
    OU.util.TiledMenu.prototype.render = function ( doLoad ) {
        var menus = this.menus, bH = OU.controlHeight, i, j, h = "", menu = menus, button, section,
            buttonEl, bFn, self = this;
        for (i = 0; i < menus.levels; i++) {
            if (!menus.shadow)
                h += "<div class='_menudiv' style='height: " + bH + "px'>";
            else
                h += "<div class='_menudivShadow' style='height: " + bH + "px'>";
            if (this.title!='')
                h += '<strong>' + this.title + '</strong><br/>';
            for (j = 0; j < menu.sections.length; j++) {
                section = menu.sections[j];
                if (section.type=='button') {
                    button = section;
                    h += "<a href='' ";
                    //   if ((section.selected) && this.showHighlight)
                    if ((section.step==parseInt(menu.selected[0]) + 1) && this.showHighlight)
                        h += "class='_abutton highlighted' ";
                    else
                        h += "class='_abutton' ";
                    h += "id='ou.menu." + this.menuId + "." + i + "." + j + "' ";
                    if (!button.img) {
                        h += ">" + button.title + "</a>";
                    }
                    else {
                        //       h += ">"+ "<span style='vertical-align:middle;'><img src='" + button.img + "' alt='" + button.title + "' title='" + button.title + "'></span>"+"</a>";
                        h += ">" + "<img src='" + button.img + "' alt='" + button.title + "' title='" + button.title + "'/>" + "</a>";
                    }
                    if (this.style=='vertical') {
                        h += "<br clear='left'/>";
                    }
                    if (doLoad && j==menus.selected[i] && button.menu===undefined)
                        this.loadContent(button);
                }
                else {
                    h += '<' + section.type + '>' + section.content + '</' + section.type + '>';
                }
            }
            h += "</div>";
            menu = menu.sections[menus.selected[i]].menu;
            if (menu===undefined)
                i = menus.levels;
        }
        this.menuDiv.div.innerHTML = h;
        /**
         * We have Nobbled the Done Bar for the Menu's DIV (in other words we are capturing and preventing the default events)
         * So, we need to handle the events ourselves to make the buttons work.
         * bFn handles the event and calls the relevant step
         * @private
         */
        bFn = function () {
            var id = this.getAttribute("id"),
                bits = id.split("."),
                nBits = bits.length;
            self.step(parseInt(bits[nBits - 2]), parseInt(bits[nBits - 1]));
        };
        /*
         * This loop then attachs an event listener to each button to call bFn when it's hit
         */
        menu = menus;
        for (i = 0; i < menus.levels; i++) {
            for (j = 0; j < menu.sections.length; j++) {
                section = menu.sections[j];
                if (section.type=='button') {
                    buttonEl = document.getElementById("ou.menu." + this.menuId + "." + i + "." + j);
                    if (buttonEl) {
                        buttonEl.addEventListener("mousedown", bFn, false);
                        buttonEl.addEventListener("touchstart", bFn, false);
                    }
                }
            }
            menu = menu.sections[menus.selected[i]].menu;
            if (menu===undefined)
                i = menus.levels;
        }
    };
    OU.util.TiledMenu.prototype.loadContent = function ( button ) {
        if (button.step!==undefined) {
            this.container.controller.step(button.step);
        }
        if (button.controller!==undefined) {
            this.container.controller.overrideSection(button.controller);
        }
        if (button.activityPopup!==undefined) {
            this.container.controller.addActivity(button.activityPopup);
        }
    };
    OU.util.TiledMenu.prototype.step = function ( levelId, buttonId ) {
        var menus = this.menus, menu, i, button;
        menus.selected[levelId] = buttonId;
        menu = menus;
        for (i = 0; i < menus.levels; i++) {
            if (menus.selected[i] > menu.sections.length - 1)
                menus.selected[i] = menu.sections.length - 1;
            button = menu.sections[menus.selected[i]];
            if (button.menu===undefined) {
                this.loadContent(button);
            }
            else {
                menu = button.menu;
            }
        }
        this.render(false);
        for (i = menus.levels; i--;) {
            OU.LocalStorage.save("ou.menus." + this.container.instance + "." + this.menuId + "._" + i, menus.selected[i]);
        }
    };
    this.init();
};

