var single_choice = (function () {
    "use strict";
    var data = "", i, numTries = 0, radios = "";

    var init = function (questionNum) {
        var optionString = "", optionNum = 1, captions, request = new XMLHttpRequest();
        var protocol = location.protocol;
        request.onreadystatechange = function () {
		
            //alert(request.readyState);
			if ((protocol === "http" || protocol === "https") && request.
			readyState === 4) {
                {
				
                    if (request.status !== 200) {
                        alert("Error loading data: " + request.status);
                    }
                }
            }
        };
        request.open("GET", "./data/data"+questionNum+".json", false);
        request.send(null);
        try {
            data = JSON.parse(request.responseText);
        } catch (e) {
            alert("Parsing error:" + e);
            return;
        }

        radios = data.html.replace(/__\] \[__/g, "__][__").split("[__RADIO__]");
        for (i = 1; i < radios.length; i++) {
            captions = radios[i].split("__]");
            optionString = optionString + radios[i - 1] + "<input type='radio' id='rb" + i + "' name='group1' value='rb" + (optionNum++) + "'/>" +
                "<label for='rb" + i + "'>" + captions[0].replace(/\[__/g, "") + "</label>";
        }
        optionString = optionString.replace(/\[__(.*?)__\]/g, "");
		
		document.getElementById("feedback").innerHTML = "";
        document.getElementById("question").innerHTML = optionString;
        document.getElementById("check").innerHTML = data.buttonCaption || "Check";
		numTries = 0;
		enableOptions();
    };

    var checkAnswers = function () {
        var feedback = "", correct = false;
		//console.log("correct answer is " + data.correct);
        for (i = 1; i < radios.length; i++) {
            correct = document.getElementById("rb" + data.correct).checked;
        }

        if (correct) {
            feedback = " Your answer is correct. " + (data.extraCorrectFeedback || "") + (data.extraFeedback || "");
            disableOptions();
        }
        else {
            numTries++;

            if (!correct) {
                feedback += " Your answer is" + (numTries > 1 ? " still" : "") + " incorrect. ";
            }
            if (numTries < data.maxTries) {
                feedback += "Try again.";
            }

            if (numTries >= data.maxTries) {//fill in correct answers
                feedback += (data.extraIncorrectFeedback || "") + (data.extraFeedback || "");
                disableOptions();
            }
        }
        document.getElementById("feedback").innerHTML = feedback;
        document.getElementById("feedback").style.display = "block";
    };

    var disableOptions = function () {
        for (i = 1; i < radios.length; i++) {
            document.getElementById("rb" + i).disabled = "disabled";
        }
        document.getElementById("check").disabled = "disabled";
    };
	
	 var enableOptions = function () {
        for (i = 1; i < radios.length; i++) {
            document.getElementById("rb" + i).disabled = false;
        }
        document.getElementById("check").disabled = false;
    };

    return {
        init: init,
        checkAnswers: checkAnswers,
        disableOptions: disableOptions
    };
}());

//single_choice.init();