/*
 * Function to create a tab navigation system for OSL.
 * data is used to construct the tabs.
 * Each nested object must be named in numerical order.
 * The id must be in numerical order and correspond to the div id's in index.html
 * You can add or remove tabs by editing the data object and index.html
 *
 */

var data = {
  "0": {"id": "tab0", "name": "<i>Streptococcus pneumoniae</i>"},
  "1": {"id": "tab1", "name": "<i>Escherichia coli</i>"},
  "2": {"id": "tab2", "name": "MRSA"},
  "3": {"id": "tab3", "name": "<i>Mycobacterium tuberculosis</i>"},
  "4": {"id": "tab4", "name": "<i>Klebsiella pneumoniae</i>"},
  "5": {"id": "tab5", "name": "<i>Neisseria gonorrhoeae</i>"}
};
var tabNav = (function () {
  /*
   * createTabs
   * uses data Object.
   * Creates #tabs div and adds tabs to it from the data file.
   * Binds click and keydown behaviour
   * The first tab is set to active.
   */
  var createTabs = function (data) {
    $("#main-content").append("<div id='tabs'></div>");
    var j = 1;
    $.each(data, function (i, v) {
      if (v.slides) {
        paginationManager.activateSlides(v.id, i)
      }
      var classNames = "tab";
      $("#tabs").append("<div id='" + v.id + "' tabindex='" + j + "' class='" + classNames + "'>" + v.name + "</div>");
      $("#tab" + i).bind("keydown",function (event) {
        keyDownTab(event, "#tab" + i)
      }).bind("click", function (event) {
            clickTab(event, "#tab" + i)
          });
      j++;
    });
    $("#tab0").addClass("active");
  };

  var keyDownTab = function (event, id) {
    if (event.which == 13) {
      $(".active").removeClass("active");
      $(id).addClass("active");
      $(".content").hide();
      $(id + "c").show();
    }
  };

  var clickTab = function (event, id) {
    $(".active").removeClass("active");
    $(id).addClass("active");
    $(".content").addClass("display-none");
    $(id + "c").removeClass("display-none");
  };
  return{
    createTabs: createTabs
  }
})();

var paginationManager = (function () {
  var paperSort = {};
  var activateSlides = function (id, num) {
    $("#" + id + "c").append("<div id='" + id + "c_paginator' class='paginator'></div>");
    var contentId = id + "c";
    paginationDots(contentId, num);
  };
  var paginationDots = function (id, num) {
    if ($(".paginator").length) {
      var pageElem = id + "_paginator";
      paperSort[pageElem] = Raphael(pageElem, "870", "40");
      var numSlides = data[num].slides.length;
      var xDiv = 0;
      // Quick fix for aligning circles and titles. Would be nice to improve this time permitting.
      //TODO @shousden improve this section below.
      if(numSlides <= 3)
      {
        xDiv = 550/numSlides;
      }
      else {
        xDiv = 740/numSlides;
      }
      //var xDiv = 700 / data[num].slides.length;
      var var1 = data[num].slides.length * xDiv / 2;
      var startPos = 435 - var1;
      var endPos = 435 + var1 - xDiv;
      var pathString = "M" + startPos + " 18L" + endPos + " 18Z";
      var l = paperSort[pageElem].path(pathString);
      l.attr("stroke", "#7b7b7b");
      l.attr("stroke-width", 4);
      var pageSet = paperSort[pageElem].set();
      $.each(data[num].slides, function (k, v) {
        var xPos = k * xDiv;
        var finalX = startPos + xPos;
        var textX = startPos + xPos;
        var fillString = "#fff";
        var stroke = 3;
        var yPos = 25;
        if (id=="tab0c")
        {
          yPos = 50;
        }

        pageSet.push(paperSort[pageElem].circle(finalX, 18, 15)
            .attr({fill: "#fff", stroke: "#7b7b7b", "stroke-width": stroke, focusable: true })
            .click(function () {
              pageSet.attr({"fill": "#fff"});
              pageSet[k].attr({"fill": "#7b7b7b"});
              $("#" + id + " .slide").hide();
              $("#" + id + "_slide" + k).show();
              $(".pagination-link").removeClass("active-link");
              $("#"+ pageElem + k).addClass("active-link");
            }));
        $("#"+pageElem).append("<a id='"+ pageElem + k +"' href='#' class='pagination-link' style='left: "+textX+ "px;'>"+ v +"</a>");
        $("#" + pageElem + k).bind("click", function () {
          $(".pagination-link").removeClass("active-link");
          $("#"+ pageElem + k).addClass("active-link");
          pageSet.attr({"fill": "#fff"});
          pageSet[k].attr({"fill": "#7b7b7b"});
          $("#" + id + " .slide").hide();
          $("#" + id + "_slide" + k).show();
        });
        if(k == 0){
          $("#"+ pageElem + "0").addClass("active-link");
          pageSet[k].attr({"fill": "#7b7b7b"});
        }
      });

    }
  };
  return {
    activateSlides: activateSlides
  };
})();

$(document).ready(function () {
  tabNav.createTabs(data);
});

