var data;
    var chart;

    // data sourced from https://www.ons.gov.uk/peoplepopulationandcommunity/crimeandjustice/datasets/recordedcrimedataatpoliceforcearealevel
    function returnData(url) {
        var req = new XMLHttpRequest();
        req.open('GET', url, false);
        req.send(null);
        return req.responseText;
    }

    (function () {
        data = JSON.parse(returnData("data.json"));
        setupForces();
        setupDates();
        setupView();
    }());

    function setupView(){
        document.querySelector("#slct-view").onchange=function(){
            changeView(this.querySelectorAll("option")[this.selectedIndex].innerText)
        }
        changeView(document.querySelector("#slct-view").value)
    }
    function changeView(opt){
        document.querySelector("#table_div").classList.remove("show")
        document.querySelector("#chart_div").classList.remove("show")
        document.querySelector("#"+String(opt).toLowerCase()+"_div").classList.add("show");
        VLE.resize_iframe();
    }
    function displayCharts() {
        if (chart) {
            chart.destroy();
            chart = null;
            var chartP=document.querySelector("#chart_div").appendChild(document.createElement("p"));
            chartP.innerText="Please specify force/s and crime/s to view chart";
            document.querySelector("#table_div").innerHTML=""
            var tblP=document.querySelector("#table_div").appendChild(document.createElement("p"));
            tblP.innerText="Please specify force/s and crime/s to view table";
        }
        if(document.getElementById("crime_slct0").selectedIndex >0 || document.getElementById("crime_slct1").selectedIndex> 0) {
        var series=[]
        var datasets=document.querySelectorAll(".dataset");
        var minYear = Number(document.querySelector("#dateFrom_slct").value.split("-").join("."));
        var maxYear = Number(document.querySelector("#dateUntil_slct").value.split("-").join("."));
        for(var i=0; i<datasets.length; i++){
            var chartData = [];
            if(datasets[i].querySelector(".force_slct").value!=="" || datasets[i].querySelector(".crime_slct").value!==""){
                if (typeof data[datasets[i].querySelector(".force_slct").value] !== "undefined") {
                    if (typeof data[datasets[i].querySelector(".force_slct").value].offences[datasets[i].querySelector(".crime_slct").value] !== "undefined") {
                        for (var j in data[datasets[i].querySelector(".force_slct").value].offences[datasets[i].querySelector(".crime_slct").value]) {
                            var num = Number(j.split("-").join("."));
                            if (minYear <= num && maxYear >= num) {
                                var newDate=j.split("-")[1]+"/01/"+j.split("-")[0];
                                chartData.push([new Date(newDate).getTime(),data[document.querySelectorAll(".dataset")[i].querySelector(".force_slct").value].offences[document.querySelectorAll(".dataset")[i].querySelector(".crime_slct").value][j]])
                            }
                        }
                        series.push({
                            data:chartData,
                            name:datasets[i].querySelector(".force_slct").value+" - "+datasets[i].querySelector(".crime_slct").value
                        });
                    }
                }
            }
        }
        createTable(series)
        chart = Highcharts.chart('chart_div', {
            chart: {
                style: {
                    fontFamily: 'arial, sans-serif',
                    fontSize: '14px'
                }
            },credits: {
                enabled: false
              },
            title: {
                text: "",
                style: {
                color: '#000',
                fontSize:'14px'
            }
            },
            exporting: {
                enabled: false
            },
            yAxis: {
                title: {
                    text: 'Number of recorded crimes',
                    style: {
                        color: '#000',
                        fontSize:'14px'
                    }
                },
                labels: {
                    style: {
                        color: '#000',
                        fontSize:'14px'
                    }
                }
            },
             colors:["#213c4a","#00adaf","#fcc21a","#000000"],
            xAxis: {
                title: {
                    text: 'Date',
                    style: {
                        color: '#000',
                        fontSize:'14px'
                    }
                },
                labels: {
                    style: {
                        color: '#000',
                        fontSize:'14px'
                    },
                    formatter: function() {   
                        var d=new Date(Number(this.value));
                        return d.toLocaleString('en-GB', { month: 'long' })+" "+d.getFullYear();
                    }
                }
            },
            tooltip: {
                xDateFormat: '%b %Y',
                shared: true,
                formatter: function() {  
                    var d=new Date(Number(this.x));
                       // return d.toLocaleString('default', { month: 'long' })+" "+d.getFullYear()+"<br>"+this.points[i].point;
                       return ['<b>' + d.toLocaleString('default', { month: 'long' }) +" "+d.getFullYear()+ '</b><br><br>'].concat(
                this.points ?
                    this.points.map(function (point) {
                        return '' +point.series.name + ': ' + point.y + '<br>';
                    }) : []
            );
                    }
            },
            legend: {
                itemStyle: {
                    color: '#000',
                    fontSize:'14px'
                }
            },
            series: series

        });
        }

        
        VLE.resize_iframe();
    }
    function createTable(tblData){
        /**/
        
           
        var newData={}
        for(var i=0; i<tblData.length; i++){
            for(var j=0; j<tblData[i].data.length; j++){
                if(typeof newData[tblData[i].data[j][0]]==="undefined"){
                    newData[tblData[i].data[j][0]]={}
                }
                if(typeof newData[tblData[i].data[j][0]][tblData[i].name]==="undefined"){
                    newData[tblData[i].data[j][0]][tblData[i].name]={}
                }
                newData[tblData[i].data[j][0]][tblData[i].name]=tblData[i].data[j][1]
            }
        }
        var tbl=document.createElement("table");
        var tHead=tbl.appendChild(document.createElement("thead"));
        var tBody=tbl.appendChild(document.createElement("tbody"));
        var rowCount=0;
        var d = new Date(0);
        for(var k in newData){
            if(rowCount===0){
                var theadTr = tHead.appendChild(document.createElement("tr"));
                var theadTd=theadTr.appendChild(document.createElement("th"));
                theadTd.innerHTML="Date";
                for(var l in newData[k]) {
                    var theadTd=theadTr.appendChild(document.createElement("th"));
                    theadTd.innerHTML=l;
                }
            }
            var tbodyTr = tBody.appendChild(document.createElement("tr"));
                var tbodyTd=tbodyTr.appendChild(document.createElement("td"));
               d=new Date(Number(k));
                tbodyTd.innerHTML= d.toLocaleString('en-GB', { month: 'long' })+" "+d.getFullYear()
                for(var m in newData[k]) {
                    var tbodyTd=tbodyTr.appendChild(document.createElement("td"));
                    tbodyTd.innerHTML=newData[k][m];
                }
            rowCount++;
        }
        document.getElementById("table_div").innerHTML="";
        document.getElementById("table_div").appendChild(tbl)
    }

    function setupForces() {
        var dataSets=document.querySelectorAll(".dataset");
        dataSets.toLocaleString("default")
        for(var j=0; j<dataSets.length; j++){
            dataSets[j].querySelector(".crime_slct").innerHTML = "";
            dataSets[j].querySelector(".force_slct").innerHTML = "";
            var optInit =  dataSets[j].querySelector(".force_slct").appendChild(document.createElement("option"));
            optInit.innerText = "Select a force";
            optInit.value = "Select a force";
            for (var i in data) {
                var opt =  dataSets[j].querySelector(".force_slct").appendChild(document.createElement("option"));
                opt.innerText = i;
                opt.value = i;
            }
            dataSets[j].querySelector(".force_slct").onchange = function () {
                if (typeof data[this.value] === "undefined") {
                    this.parentNode.parentNode.querySelector(".crime_slct").innerHTML = "";
                    this.parentNode.parentNode.querySelector(".crime_slct").parentNode.classList.add("hidden");
                } else {
                    setupCrimes(this);
                    this.parentNode.parentNode.querySelector(".crime_slct").parentNode.classList.remove("hidden");
                }
                displayCharts(this);
            };
        }
    }

    function setupCrimes(el) {
        el.parentNode.parentNode.querySelector(".crime_slct").innerHTML = "";
        var optInit = el.parentNode.parentNode.querySelector(".crime_slct").appendChild(document.createElement("option"));
        optInit.innerText = "Select a crime";
        optInit.value = "Select a crime";
        if (el.value !== "Select a force") {
            for (var j in data[el.value].offences) {
                var opt = el.parentNode.parentNode.querySelector(".crime_slct").appendChild(document.createElement("option"));
                opt.innerText = j;
                opt.value = j;
            }
        }
        el.parentNode.parentNode.querySelector(".crime_slct").onchange = function () {
            displayCharts(this);
        };
    }

    function setupDates() {
        var dates=["2016-09","2016-10","2016-11","2016-12","2017-01","2017-02","2017-03","2017-04","2017-05","2017-06","2017-07","2017-08","2017-09","2017-10","2017-11","2017-12","2018-01","2018-02","2018-03","2018-04","2018-05","2018-06","2018-07","2018-08","2018-09","2018-10","2018-11","2018-12","2019-01","2019-02","2019-03","2019-04","2019-05","2019-06","2019-07","2019-08","2019-09","2019-10","2019-11","2019-12","2020-01","2020-02","2020-03","2020-04","2020-05","2020-06","2020-07","2020-07","2020-08","2020-09","2020-10","2020-11","2020-12","2021-01"]

        var dateSlcts = [document.querySelector("#dateFrom_slct"), document.querySelector("#dateUntil_slct")];
        for (var i = 0; i < dateSlcts.length; i++) {
            dateSlcts[i].innerHTML = "";
            for (var j=0; j<dates.length; j++) {
                var opt = dateSlcts[i].appendChild(document.createElement("option"));
                opt.innerText = dates[j];
                opt.value = dates[j];
            }
            dateSlcts[i].onchange = function () {
                var yearFrom = Number(document.querySelector("#dateFrom_slct").value.split("-").join("."));
                var yearUntil = Number(document.querySelector("#dateUntil_slct").value.split("-").join("."));
                if (yearFrom > yearUntil) {
                    if (this.id === "dateFrom_slct") {
                        document.querySelector("#dateUntil_slct").value = document.querySelector("#dateUntil_slct").querySelectorAll("option")[document.querySelector("#dateUntil_slct").querySelectorAll("option").length - 1].value;
                    } else if (this.id === "dateUntil_slct") {
                        document.querySelector("#dateFrom_slct").value = document.querySelector("#dateFrom_slct").querySelectorAll("option")[0].value;
                    }
                }
                displayCharts(this);
                VLE.resize_iframe();
            };
        }
        document.querySelector("#dateUntil_slct").value = document.querySelector("#dateUntil_slct").querySelectorAll("option")[document.querySelector("#dateUntil_slct").querySelectorAll("option").length - 1].value;
        document.querySelector("#dateFrom_slct").value = document.querySelector("#dateFrom_slct").querySelectorAll("option")[0].value;

    }

    function tidyCSV() {
        //download a years worth of CSVs from https://data.police.uk/data/
        //change year variable to match
        //run this tidyCSV() function
        var year = 2016;
        var dates = ["01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"];
        var forces = JSON.parse(returnData("https://data.police.uk/api/forces"));
        for (var i in forces) {
            var newCSV = [];
            for (var j = 0; j < dates.length; j++) {
                var csv = returnData("format/orig/" + year + "-" + dates[j] + "-" + forces[i].id + "-street.csv");
                csv = csv.split("\r").join("").split("\n");
                for (var k = 0; k < csv.length; k++) {
                    var newRow = [];
                    csv[k] = csv[k].split(",");
                    if (csv[k][1] !== "Month" && csv[k][1] !== "") {
                        newRow.push(csv[k][1]);
                        newRow.push(csv[k][2]);
                        newRow.push(csv[k][9]);
                        newCSV.push(newRow);
                    }
                }
            }
            newCSV = newCSV.join("\r\n");
            exportData(newCSV, forces[i].id + "-" + year);
        }
    }

    function exportData(newCSV, filename) {
        var exportedFilename = filename + '.csv' || 'export.csv';

        var blob = new Blob([newCSV], {type: 'text/csv;charset=utf-8;'});
        if (navigator.msSaveBlob) { // IE 10+
            navigator.msSaveBlob(blob, exportedFilename);
        } else {
            var link = document.createElement("a");
            if (link.download !== undefined) { // feature detection
                // Browsers that support HTML5 download attribute
                var url = URL.createObjectURL(blob);
                link.setAttribute("href", url);
                link.setAttribute("download", exportedFilename);
                link.style.visibility = 'hidden';
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            }
        }
    }

    //user the getJSONfromNewCSV function after updating the CSVs via orig -> cleaned
    //copy cntents in console to data.json
    function getJSONfromNewCSV() {
        var newJSON = {};
        var dates = ["2016","2017","2018","2019"];
        var forces = JSON.parse(returnData("https://data.police.uk/api/forces"));
        var dateList={}
        for (var i = 0; i < forces.length; i++) {
            for (var j = 0; j < dates.length; j++) {
                var csv = returnData("format/cleaned/" + forces[i].id + "-" + dates[j] + ".csv");
                csv = csv.split("\r").join("").split("\n");
                for (var k = 0; k < csv.length; k++) {
                    csv[k] = csv[k].split(",");
                    if(csv[k][1]!==""){
                        if (typeof newJSON[csv[k][1]] === "undefined") {
                            newJSON[csv[k][1]] = {};
                            newJSON[csv[k][1]].offences = {};
                        }
                        if (typeof newJSON[csv[k][1]].offences[csv[k][2]] === "undefined") {
                            newJSON[csv[k][1]].offences[csv[k][2]] = {};
                        }
                        if (typeof newJSON[csv[k][1]].offences[csv[k][2]][csv[k][0]] === "undefined") {
                            newJSON[csv[k][1]].offences[csv[k][2]][csv[k][0]] = 0;
                        }
                        newJSON[csv[k][1]].offences[csv[k][2]][csv[k][0]]++;
                        dateList[csv[k][0]]=""
                    }

                }
            }
        }
        console.log(JSON.stringify(newJSON));

        createDateList(dateList)
    }
    function createDateList(dateList){
        //COPY the contents of the console log to populate the date select lists.
        var dateArr=[]
        for(var l in dateList){
            dateArr.push(l)
        }
        console.log(JSON.stringify(dateArr))
    }
