// re-style content in an iframe based on the parent document
// pass the id of an element to take the style from (usually the iframe's parent)
function makeChameleon(css_host_element_id) {
  if (window.parent.document.getElementById(css_host_element_id)) {
    var calc_style = null;
    if (window.getComputedStyle) {
      calc_style = window.parent.window.getComputedStyle(window.parent.document.getElementById(css_host_element_id));
    }
    else {
      calc_style = window.parent.document.getElementById(css_host_element_id).currentStyle;
    }
    if (calc_style) {
      // basic styles
      var doc_body = document.getElementsByTagName('body')[0];
      doc_body.style.backgroundColor = calc_style.backgroundColor;
      doc_body.style.color = calc_style.color;
      doc_body.style.fontFamily = calc_style.fontFamily;
      doc_body.style.fontSize = calc_style.fontSize;
      // text input fields
      var doc_text_inputs = document.getElementsByTagName('input');
      for (var ctr=0; ctr<doc_text_inputs.length; ctr++) {
        doc_text_inputs[ctr].style.fontSize = calc_style.fontSize;
      }
    }
  }
}