/**
 * @fileOverview GraphDragLineActivity - A non-assessed exercise where user drags a line into position and given feedback as to whether they are corrct or if the line is too high/low. Any number of fixed lines can be added. All lines will have labels.
 * This is activity type 2a for Social Sciences DD209
 * 
 * STILL IN DEVELOPMENT - W.I.P.!!!!
 *
 * Usage:
 * <ul>
 * <li> Make a copy of this file</li>
 * <li> Rename the class (OU.activity.GraphDragLineActivity) to your new activity name</li>
 * <li> Add your code</li>
 * </ul>
 *
 * Additional functions that are not defined in this file but are available to all activities:
 * <ul>
 * <li> this.header(h) - changes current H1 and H2 tags, where parameter h is of format: { h1: 'optional H1', h2: 'optional H2' }</li>
 * <li> this.loadCSSFile(f) - loads additional CSS from the file f - which is a file path relative to the activity data folder</li>
 * <li> this.addMessengerParams(paramsArray) - See documentation for Messenger functions in OU.js</li>
 * </ul>
 *
 * @author Gareth Hudson <gareth.hudson@open.ac.uk>
 */

// Load in any util elements that are required
OU.require('OU.util.Layer');
OU.require('OU.util.Button');
OU.require('OU.util.Div');


/**
 * @class GraphDragLineActivity - A template for activities that extend the OU.util.Activity class
 * @extends OU.util.Activity
 * @param {Object} data - Holds the data content for a specific instance of the activity
 * @param {String|undefined} instance - A unique identifier name for this instance, defaults to 'a1'
 * @param {Controller Object|undefined} controller - A reference to the controller that initialised this instance, if undefined, the superclass will generate a new controller and create the reference to it as 'this.controller'
 */
OU.activity.GraphDragLineActivity = function(data,instance,controller) {

    /**
     * canvasView - this is the function that is first called when the activity is launched,
     *              assuming you are in a browser that supports canvas.
     *
     * Typical tasks for this function are:
     * <ul>
     * <li> Define and initialise and activity wide variables</li>
     * <li> Initialise Layers & Divs</li>
     * <li> Call a loading function</li>
     * <li> Initiating the activity by calling any methods that</li>
     * </ul>
     */
    OU.activity.GraphDragLineActivity.prototype.canvasView = function() {
        // Most activities should have a background layer
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw default background
        //
        // Create the feedback text div
        this.feedbackText = new OU.util.Div({
            container:this,
            x:20,
            y:this.h-40,
            w:this.w-30,
            h:40
        });

        // Create the text info layer
        this.textInfoLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // Create the points layer
        this.pointsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // Create the labels layer
        this.labelsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // layer for the main graph and fixed items
        this.graphLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // layer for the user moveable line
        this.lineMoveLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.buttonsLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:this.w-this.data.submitbutton.w,
            y:this.h-40,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        // Submit button
        var btnActionLevel = this;
        this.buttonSubmit = new OU.util.Button({
            layer:this.buttonsLayer,
            txt:this.data.submitbutton.label,
            verticalPadding:2,
            disabled:false,
            onClick:function () {
                btnActionLevel.submitAction();
            },
            x:0,
            y:0,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        
        this.lineMoveLayer.events.clickable.push(this);
        // *Your code starts here*
        /** create graphData to hold changing values for the graph */
        this.graphData = function() {
        }
        this.graphData.xMove = 0;
        this.graphData.yMove = 0;
        this.graphData.userClickPositionsXY = [];
        this.graphData.numberUserAttemptsMade = 0;
        this.activityIsActive = true;
        this.resize();
    };
    
    // Called by user clicking the submit button
    OU.activity.GraphDragLineActivity.prototype.submitAction = function(){
        // Record an additional attempt made by the user.
        this.graphData.numberUserAttemptsMade++;
        // Are they corrector incorrect?
        if ((this.data.linemove[0][0].y-this.graphData.yMove) > this.data.correctlinemoveposition.y-5 && this.data.linemove[0][0].y-this.graphData.yMove < this.data.correctlinemoveposition.y+5){
            // Yes,they're correct so tell them
            clearTimeout(this.feedbackTimeout);
            this.feedbackText.div.innerHTML = this.data.feedbacktext.correct;
            //disable the submit button
            this.buttonSubmit.disable();
            // clear the isHit function so that user can no longer move the lines
            /*
            this.isHit = function() {
                return false;
            }
            */
            this.renderCorrectAnswer();
        } else if ((this.data.linemove[0][0].y-this.graphData.yMove) > this.data.correctlinemoveposition.y){
            // No, they're incorrect and have dragged it above the correct position
            if (this.graphData.numberUserAttemptsMade == this.data.numberofattempts) {
                // and they've run out of attempts
                this.feedbackText.div.innerHTML = this.data.feedbacktext.abovefinal;
                this.renderCorrectAnswer();
            } else {
                // they've still got some attempts left
                this.feedbackText.div.innerHTML = this.data.feedbacktext.above;
                this.clearFeedbackTimeout();
            }
        } else {
            // No, they're incorrect and have dragged it below the correct position
            if (this.graphData.numberUserAttemptsMade == this.data.numberofattempts) {
                // and they've run out of attempts
                this.feedbackText.div.innerHTML = this.data.feedbacktext.belowfinal;
                this.renderCorrectAnswer();
            } else {
                // they've still got some attempts left
                this.feedbackText.div.innerHTML = this.data.feedbacktext.below;
                this.clearFeedbackTimeout();
            }
        }
    }
    
    OU.activity.GraphDragLineActivity.prototype.clearFeedbackTimeout = function(){
        //console.log(this.buttonSubmit.txt);
        //this.buttonSubmit.txt = 'Reset';
        //this.buttonSubmit.render();
        var self = this;
        clearTimeout(this.feedbackTimeout);
        this.feedbackTimeout = setTimeout(function () {
            self.clearFeedback();
        }, this.data.feedbacktext.incorrectsecstimeout*1000);
    }
    OU.activity.GraphDragLineActivity.prototype.clearFeedback = function(){
        this.feedbackText.div.innerHTML = '';
    }
    
    OU.activity.GraphDragLineActivity.prototype.submitAnswer = function(){
    ////console.log('submit button pressed'+this.w);
    }
   
    OU.activity.GraphDragLineActivity.prototype.renderCorrectAnswer = function(){
        /** draw the correct answer line(s) and display to the user, disable submit button and prevent further move of lines
         */
        ////console.log('renderCorrectAnswer');
        var ctx = this.lineMoveLayer.context;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.translate(this.lineMoveLayer.w*0.13, this.data.yaxis.end*this.scaleFactor*1.1);
        // draw the moveable line
        ctx.strokeStyle=this.data.linemovecolour;
        ctx.lineWidth=2;
        for (var y=0; y<this.data.correctlines.length; y++) {
            for(var i=1; i<this.data.correctlines[y].length; i++) {
                ctx.beginPath();
                ctx.moveTo((this.data.correctlines[y][i-1].x)*this.scaleFactor,-(this.data.correctlines[y][i-1].y)*this.scaleFactor);
                ctx.lineTo((this.data.correctlines[y][i].x)*this.scaleFactor,-(this.data.correctlines[y][i].y)*this.scaleFactor);
                ctx.stroke();
            }
        }
        ctx.textAlign = 'right';
        ctx.font='12px Arial';
        for (var i=0; i<this.data.linemovelabels.oncorrect.length; i++) {
            if (this['labelDiv'+i]) {
                this['labelDiv'+i].remove();
            }
            this['labelDiv'+i] = new OU.util.Div ({
                innerHTML:this.data.linemovelabels.oncorrect[i].text,
                container:this.lineMoveLayer,
                x:(this.data.correctlines[i][this.data.correctlines[i].length-1].x-20 + this.graphLayer.w*0.13 -80)*this.scaleFactor,
                y:(this.data.yaxis.end - this.data.correctlines[i][this.data.correctlines[i].length-1].y + this.data.linemovelabels.initial[i].yaddition + this.graphLayer.h*0.1)*this.scaleFactor,
                w:80,
                h:30,
                style:'text-align:right; font-family:Arial; font-size:12px'
            });
        }
        ctx.restore();
        //disable the submit button
        //this.buttonSubmit.disable();
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Reset',
            onClick:function () {
                //console.log(btnActionLevel);
                //window.OU.activity.GraphDragLineActivity.prototype.resetActivity();
                btnActionLevel.resetActivity();
            }
        });
        this.buttonSubmit.enable();
        this.buttonSubmit.render();
        // clear the isHit function so that user can no longer move the lines
        /*
        OU.activity.GraphDragLineActivity.prototype.isHit = function() {
            return false;
        }
        */
        this.activityIsActive = false;
    };
    
    OU.activity.GraphDragLineActivity.prototype.resetActivity = function() {
        //console.log(this.buttonSubmit);
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Submit',
            onClick:function () {
                btnActionLevel.submitAction();
            }
        });
        this.graphData.xMove = 0;
        this.graphData.yMove = 0;
        this.graphData.userClickPositionsXY = [];
        this.graphData.numberUserAttemptsMade = 0;
        this.activityIsActive = true;
        this.feedbackText.div.innerHTML = '';
        this.resize();
    };
    
    OU.activity.GraphDragLineActivity.prototype.isHit = function ( x, y, evState ) {
        ////console.log('isHit');
        //console.log('x:'+x+', y:'+y);
        var gd = this.graphData, dX, dY, edX, edY, bH = OU.controlHeight;
        var ctx = this.lineMoveLayer.context;
        // find the X,Y position of the cursor and show to user
        //var xPos = Math.round((x-this.lineMoveLayer.w*0.13)/this.scaleFactor);
        //var yPos = (-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor*1.1)/this.scaleFactor);
        var xPos = Math.round((x-this.lineMoveLayer.w*0.13)/this.scaleFactor)+this.data.xaxis.start;
        if (this.data.yaxis.start < 0){
            var yPos = (-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor*1.1)/this.scaleFactor)+this.data.yaxis.start-(this.lineMoveLayer.h*0.1);
        } else {
            var yPos = (-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor*1.1)/this.scaleFactor); 
        }
        //
        if (evState && this.activityIsActive) {
            if (this.inDrag) {
                dX = x - this.dragStartX;
                dY = y - this.dragStartY;
                console.log(dX + ',' + dY);
                if (this.data.axistomove == 'x' || this.data.axistomove == 'both') {
                    gd.xMove += dX/this.scaleFactor;
                }
                if (this.data.axistomove == 'y' || this.data.axistomove == 'both') {
                    gd.yMove += dY/this.scaleFactor;
                }
                this.dragStartX = x;
                this.dragStartY = y;
                this.renderMovingLinesWithInfo(); 
            }
            else {
                this.dragStartX = x;
                this.dragStartY = y;
                this.inDrag = true;
                var ctxPoints = this.pointsLayer.context;
                //
                this.graphData.userClickPositionsXY[this.graphData.userClickPositionsXY.length] = [Math.round(parseInt(xPos)/5)*5,Math.round(parseInt(yPos)/5)*5];
            ////console.log(this.graphData.userClickPositionsXY);
            }
        } else {
            this.inDrag = false;
        }
        
        if(this.data.showcursorposition) {
            this.renderTextInfoLayer(Math.round(parseInt(xPos)/5)*5,Math.round(parseInt(yPos)/5)*5,x,y);
        }
    };
    OU.activity.GraphDragLineActivity.prototype.renderTextInfoLayer = function(xPos,yPos,x,y) {
        var ctx = this.textInfoLayer.context;
        
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        
        if (xPos>=this.data.xaxis.start && xPos<=this.data.xaxis.end && yPos>=this.data.yaxis.start && yPos<=this.data.yaxis.end){
            var message = xPos + ", " + yPos;
            ctx.fillText(message,x-2,y-5); 
        }
        
        ctx.restore();
    };
    OU.activity.GraphDragLineActivity.prototype.render = function() {
        var ctx = this.graphLayer.context,xTrans,yTrans,xLabelMove=0,yLabelMove=0;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        /** This if statement will set zero x,y to the correct position if the axis have negative values */
        if (this.data.xaxis.start < 0) {
            xTrans = this.graphLayer.w*0.13 + (0-this.data.xaxis.start)*this.scaleFactor;
        } else {
            xTrans = this.graphLayer.w*0.13;
            xLabelMove = 50;
        }
        if (this.data.yaxis.start < 0) {
            yTrans = (this.data.yaxis.end-this.data.yaxis.start-(0-this.data.yaxis.start))*this.scaleFactor*1.1
        } else {
            yTrans = (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor*1.1;
            yLabelMove = 60;
        }
        //ctx.translate(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor*1.1);
        ctx.translate(xTrans, yTrans);
        this.renderAxis();
        ctx.textAlign = 'center';
        ctx.font='14px Arial';
        //ctx.fillText(this.data.xaxis.label,((this.data.xaxis.end+this.data.xaxis.start)/2)*this.scaleFactor,-(this.data.yaxis.start-40-xLabelMove)*this.scaleFactor);
        ctx.fillText(this.data.xaxis.label,((this.data.xaxis.end+this.data.xaxis.start)/2)*this.scaleFactor,-(this.data.yaxis.start-this.data.xaxis.labelposadjust-xLabelMove)*this.scaleFactor);
        ctx.rotate(-0.5*Math.PI);
        //ctx.fillText(this.data.yaxis.label ,((this.data.yaxis.end+this.data.yaxis.start)/2)*this.scaleFactor,(this.data.xaxis.start-50-yLabelMove)*this.scaleFactor);
        ctx.fillText(this.data.yaxis.label ,((this.data.yaxis.end+this.data.yaxis.start)/2)*this.scaleFactor,(this.data.xaxis.start-this.data.xaxis.labelposadjust-yLabelMove)*this.scaleFactor);
        ctx.restore();
        this.buttonSubmit.render();
    };
    
    OU.activity.GraphDragLineActivity.prototype.renderAxis = function() {
        var ctx = this.graphLayer.context;
        //ctx.rect(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor*0.1, (this.data.xaxis.end-this.data.xaxis.start)*this.scaleFactor, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor);
        //ctx.clip();
        
        var gd = this.graphData;
        ctx.strokeStyle='#000000';
        ctx.lineWidth=2;
        // draw the y axis
        ctx.beginPath();
        ctx.moveTo(0,-this.data.yaxis.start*this.scaleFactor);
        ctx.lineTo(0, -this.data.yaxis.end*this.scaleFactor);
        ctx.stroke();
        // draw the x axis
        ctx.beginPath();
        ctx.moveTo(this.data.xaxis.start*this.scaleFactor, 0);
        ctx.lineTo(this.data.xaxis.end*this.scaleFactor, 0);
        //ctx.lineTo((this.data.xaxis.end-this.data.xaxis.start)*this.scaleFactor, 0);
        ctx.stroke();
        // draw the y axis markers and text labels
        ctx.textAlign = 'right';
        ctx.font='12px Arial';
        var labelOddEven = 0;
        for(var i= this.data.yaxis.start; i<=this.data.yaxis.end; i+= this.data.yaxis.interval){
            labelOddEven++;
            // the y axis markers
            ctx.beginPath();
            ctx.moveTo(0, -i*this.scaleFactor);
            ctx.strokeStyle='#000000';
            ctx.lineWidth=2;
            ctx.lineTo(-10, -i*this.scaleFactor);
            ctx.stroke();
            // the yaxis labels
            switch(this.data.yaxis.markerlabels) {
                case 'all':
                    //console.log(labelOddEven%2 == 1);
                    ctx.fillText(i,-12,-i*this.scaleFactor);
                    break;
                case 'odd':
                    if (labelOddEven%2 == 1) {
                        ctx.fillText(i,-12,-i*this.scaleFactor);
                    }
                    break;
                case 'even':
                    if (labelOddEven%2 == 0) {
                        ctx.fillText(i,-12,-i*this.scaleFactor);
                    }
                    break;
            }
            // draw the horizontal grid lines
            //if (i>this.data.yaxis.start) {
            ctx.beginPath();
            //ctx.moveTo(0, -i*this.scaleFactor);
            ctx.moveTo(this.data.xaxis.start*this.scaleFactor, -i*this.scaleFactor);
            ctx.strokeStyle='#DDDDDD';
            ctx.lineWidth=0.5;
            ctx.lineTo(this.data.xaxis.end*this.scaleFactor, -i*this.scaleFactor);
            ctx.stroke();
            // in between vertical gris lines
            //ctx.moveTo(0, -i*this.scaleFactor + (this.data.yaxis.interval/2)*this.scaleFactor);
            if (i>this.data.yaxis.start) {    
                ctx.beginPath();
                ctx.moveTo(this.data.xaxis.start*this.scaleFactor, -i*this.scaleFactor + (this.data.yaxis.interval/2)*this.scaleFactor);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(this.data.xaxis.end*this.scaleFactor, -i*this.scaleFactor + (this.data.yaxis.interval/2)*this.scaleFactor);
                ctx.stroke();
            }
        }
        // draw the x axis markers and text labels
        ctx.textAlign = 'center';
        labelOddEven = 0;
        //var markerText = this.data.xaxis.start;
        for(var i= this.data.xaxis.start; i<=this.data.xaxis.end; i+= this.data.xaxis.interval){
            //for(var i= 0; i<=this.data.xaxis.end-this.data.xaxis.start; i+= this.data.xaxis.interval){
            labelOddEven++;
            // the x axis markers
            ctx.beginPath();
            ctx.moveTo(i*this.scaleFactor, 0);
            ctx.strokeStyle='#000000';
            ctx.lineWidth=2;
            ctx.lineTo(i*this.scaleFactor, 10);
            ctx.stroke();
            // the x axis labels
            switch(this.data.xaxis.markerlabels) {
                case 'all':
                    //console.log(labelOddEven%2 == 1);
                    ctx.fillText(i,i*this.scaleFactor,20);
                    //ctx.fillText(markerText,i*this.scaleFactor,20);
                    break;
                case 'odd':
                    if (labelOddEven%2 == 1) {
                        ctx.fillText(i,i*this.scaleFactor,20);
                    //ctx.fillText(markerText,i*this.scaleFactor,20);
                    }
                    break;
                case 'even':
                    if (labelOddEven%2 == 0) {
                        ctx.fillText(i,i*this.scaleFactor,20);
                    //ctx.fillText(markerText,i*this.scaleFactor,20);
                    }
                    break;
            }
            // draw the vertical grid lines
            //if (i>0){
            
            ctx.beginPath();
            ctx.moveTo(i*this.scaleFactor, -this.data.yaxis.start*this.scaleFactor);
            ctx.strokeStyle='#DDDDDD';
            ctx.lineWidth=0.5;
            ctx.lineTo(i*this.scaleFactor, -this.data.yaxis.end*this.scaleFactor);
            ctx.stroke();
            // in between vertical gris lines
            if (i>this.data.xaxis.start) {
                ctx.beginPath();
                ctx.moveTo(i*this.scaleFactor - (this.data.xaxis.interval/2)*this.scaleFactor, -this.data.yaxis.start*this.scaleFactor);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(i*this.scaleFactor - (this.data.xaxis.interval/2)*this.scaleFactor, -this.data.yaxis.end*this.scaleFactor);
                ctx.stroke();
            }
        //markerText+=this.data.xaxis.interval;
        }
        // draw all the fixed lines
        for (var y=0; y<this.data.lines.length; y++) {
            ctx.strokeStyle=this.data.linecolours[y];
            ctx.lineWidth=2;
            ctx.beginPath();
            ctx.moveTo(this.data.lines[y][0].x*this.scaleFactor,-this.data.lines[y][0].y*this.scaleFactor);
            for(var i=1; i<this.data.lines[y].length; i++) {
                ctx.lineTo(this.data.lines[y][i].x*this.scaleFactor,-this.data.lines[y][i].y*this.scaleFactor);
            }
            ctx.stroke();
        }
        // add any desired labels to the graph
        ctx.textAlign = 'left';
        for (var i=0; i<this.data.graphlabels.length; i++) {
            //ctx.fillText(this.data.graphlabels[i].text,this.data.graphlabels[i].x*this.scaleFactor,-this.data.graphlabels[i].y*this.scaleFactor); 
            if (this['labelDivFixed'+i]) {
                this['labelDivFixed'+i].remove();
            }
            this['labelDivFixed'+i] = new OU.util.Div ({
                innerHTML:this.data.graphlabels[i].text,
                container:this.graphLayer,
                x:(this.data.graphlabels[i].x + this.graphLayer.w*0.13+170)*this.scaleFactor,
                y:(this.data.yaxis.end - this.data.graphlabels[i].y + this.graphLayer.h*0.1 + 50)*this.scaleFactor,
                w:80,
                h:30,
                style:'text-align:left; font-family:Arial; font-size:12px'
            });
        }
        
        // call function to draw the user moveable lines
        this.renderMovingLinesWithInfo();
    };
    
    OU.activity.GraphDragLineActivity.prototype.renderMovingLinesWithInfo = function() {
        var ctx = this.lineMoveLayer.context,gd = this.graphData,xTrans,yTrans;
        // ************************************ To Finish - if statement below ***************************************
        /*
        if (this.data.linemove[0][0].x-gd.xMove < this.data.xaxis.start) {
            gd.xMove = 0;
        //return false;
        }
        if (this.data.linemove[0][0].y-gd.yMove < this.data.yaxis.start) {
            gd.yMove = 0;
        //return false;
        }
        */
        // ************************************ To Finish - if statement above ***************************************
        
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        //*
        ctx.beginPath();
        //ctx.rect(left, top, right, bottom);
        ctx.rect(this.lineMoveLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor*0.1, (this.data.xaxis.end-this.data.xaxis.start)*this.scaleFactor, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor);
        ctx.clip();
        //*/
        /** This if statement will set zero x,y to the correct position if the axis have negative values */
        if (this.data.xaxis.start < 0) {
            xTrans = this.lineMoveLayer.w*0.13 + (0-this.data.xaxis.start)*this.scaleFactor;
        } else {
            xTrans = this.lineMoveLayer.w*0.13;
        }
        if (this.data.yaxis.start < 0) {
            yTrans = (this.data.yaxis.end-this.data.yaxis.start-(0-this.data.yaxis.start))*this.scaleFactor*1.1
        } else {
            yTrans = (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor*1.1;
        }
        ctx.translate(xTrans, yTrans);
        
        //ctx.translate(this.lineMoveLayer.w*0.13, this.data.yaxis.end*this.scaleFactor*1.1);
        
        // draw the moveable line
        ctx.strokeStyle=this.data.linemovecolour;
        ctx.lineWidth=2;
        ctx.textAlign = 'right';
        ctx.font='12px Arial';
        
        for (var y=0; y<this.data.linemove.length; y++) {
            for(var i=1; i<this.data.linemove[y].length; i++) {
                // this big 'if' statement will prevent the line being drawn beyond the max/min x/y of the graph
                //if (this.data.linemove[y][i].y+(-gd.yMove) <= this.data.yaxis.end && this.data.linemove[y][i].y+(-gd.yMove) >= this.data.yaxis.start && this.data.linemove[y][i].x+gd.xMove <= this.data.xaxis.end && this.data.linemove[y][i].x+gd.xMove >= this.data.xaxis.start && this.data.linemove[y][i-1].y+(-gd.yMove) <= this.data.yaxis.end && this.data.linemove[y][i-1].y+(-gd.yMove) >= this.data.yaxis.start && this.data.linemove[y][i-1].x+gd.xMove <= this.data.xaxis.end && this.data.linemove[y][i-1].x+gd.xMove >= this.data.xaxis.start) {
                    ctx.beginPath();
                    ctx.moveTo((this.data.linemove[y][i-1].x+gd.xMove)*this.scaleFactor,-(this.data.linemove[y][i-1].y-gd.yMove)*this.scaleFactor);
                    ctx.lineTo((this.data.linemove[y][i].x+gd.xMove)*this.scaleFactor,-(this.data.linemove[y][i].y-gd.yMove)*this.scaleFactor);
                    ctx.stroke();
                //}
            }
        }
        // add text lables for the lines, which move with the lines as they're dragged
        for (var i=0; i<this.data.linemovelabels.initial.length; i++) {
            //console.log((this.data.yaxis.end - this.data.linemove[i][this.data.linemove[i].length-1].y+gd.yMove + this.graphLayer.h*0.1)*this.scaleFactor);
            //console.log((this.graphLayer.w*0.1)*this.scaleFactor);
            // if it already exists, move it
            if (this['labelDiv'+i]) {
                //this['labelDiv'+i].remove();
                if ((this.data.yaxis.end - this.data.linemove[i][this.data.linemove[i].length-1].y+gd.yMove + this.graphLayer.h*0.1)*this.scaleFactor > (this.graphLayer.w*0.1)*this.scaleFactor) {
                    this['labelDiv'+i].resize({
                        x:(this.data.linemove[i][this.data.linemove[i].length-1].x+gd.xMove-20 + this.graphLayer.w*0.13 -80)*this.scaleFactor,
                        y:(this.data.yaxis.end - this.data.linemove[i][this.data.linemove[i].length-1].y+gd.yMove + this.data.linemovelabels.initial[i].yaddition + this.graphLayer.h*0.1)*this.scaleFactor
                        });
                }
            } else {
                // it doesn't exist yet so create and position it/
                this['labelDiv'+i] = new OU.util.Div ({
                    innerHTML:this.data.linemovelabels.initial[i].text,
                    container:this.lineMoveLayer,
                    x:(this.data.linemove[i][this.data.linemove[i].length-1].x+gd.xMove-20 + this.graphLayer.w*0.13 -80)*this.scaleFactor,
                    y:(this.data.yaxis.end - this.data.linemove[i][this.data.linemove[i].length-1].y+gd.yMove + this.data.linemovelabels.initial[i].yaddition + this.graphLayer.h*0.1)*this.scaleFactor,
                    w:80,
                    h:30,
                    style:'text-align:right; font-family:Arial; font-size:12px'
                });
                
            }
        }
        
        
        ctx.restore();
        
    };
    
    OU.activity.GraphDragLineActivity.prototype.checkPositionOfMovedLine = function() {
    }
    /**
     * accessibleView - this function is called instead of canvasView if the browser does not support HTML5 canvas
     */
    OU.activity.GraphDragLineActivity.prototype.accessibleView = function() {
        OU.activity.GraphDragLineActivity.superClass_.accessibleView.call(this); // call the superclass method is you want to extend it, remove this line to override the method instead

    // Note this function can be removed or commented out if you want to use the default accessibleView method

    // *Your code starts here*
    };
    /**
     * resize - called whenever the outer bounds of the activity change, ie when the browser window is resized, or a mobile device is rotated.
     *
     * This function should do the following:
     * <ul>
     * <li>Resize all visible elements</li>
     * <li>Re-layout all visible elements</li>
     * <li>Actually re-render the current view of the activity</li>
     * </ul>
     */
    OU.activity.GraphDragLineActivity.prototype.resize = function() {
        OU.activity.GraphDragLineActivity.superClass_.resize.call(this); // call the superclass resize

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        if (this.h > this.w){
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
        } else {
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
        }
        //this.graphLayer.resize({x:0,y:0,w:this.w,h:this.h});
        // this.lineMoveLayer.resize({x:0,y:0,w:this.w,h:this.h});
        this.textInfoLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.pointsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.labelsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        // work out the scaleFactor for sizing and rendering everything
        
        var yscale = (this.graphLayer.h * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        var xscale = (this.graphLayer.w * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
        if (yscale > xscale) {
            this.scaleFactor = xscale;
        } else {
            this.scaleFactor = yscale;
        }
        // reposition the button layer
        this.buttonsLayer.resize({
            x:(this.data.xaxis.end+(-this.data.xaxis.start))*this.scaleFactor,
            y:((this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor)+(this.data.yaxis.end*this.scaleFactor*0.2)-10,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        this.feedbackText.resize({
            x:30,
            y:(this.data.yaxis.end*this.scaleFactor)+(this.data.yaxis.end*this.scaleFactor*0.2)+this.data.submitbutton.h,
            w:this.w-60,
            h:40
        });
        this.render();
    //
    };

    /**
     * remove - called when the activity is being removed by a controller.
     *
     * This function should do the following:
     * <ul>
     * <li> Remove any elements that may remain in memory</li>
     * <li> Stop any animation loops, including killing any Intervals </li>
     * </ul>
     * You do not need to remove most library elements, such as Layers, Divs, etc. as they are removed automatically
     */
    OU.activity.GraphDragLineActivity.prototype.remove = function() {
        OU.activity.GraphDragLineActivity.superClass_.remove.call(this); // call the superclass remove

    // *Your removal code here*
    // If you have nothing to remove, then this function can be deleted or commented out
    };

    // call the superclass's constructor
    OU.base(this,data,instance,controller);
};
// Call our inherits function to implement the class inheritance
OU.inherits(OU.activity.GraphDragLineActivity,OU.util.Activity);
