/**
 * GWTable - Works just like an HTML div object, but also allows you to save element values
 *     (eg, from a table/form, where the user has entered data)
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 * @author Will Rawes
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Div');
OU.activity.GWTable = function ( data, instance, controller ) {
    OU.obj[instance] = this;
    OU.activity.GWTable.prototype.init = function () {
        this.controlsLayer = new OU.util.Layer({
            container:this,
            'id':'controls',
            hasEvents:true
        });
        var i
            , clickable = this.controlsLayer.events.clickable
            , ctx = this.controlsLayer.context
            ;
        this.bH = OU.controlHeight;
        this.buttons = [];
        this.instance = instance || 'h1';
        this.data = data || {};
        this.controller = controller;
        var self = this, re = /accessible/;
        if (!re.test(window.location) && !!document.createElement('canvas').getContext) {

            // create Canvas & Context
            OU.initPage();
            this.bgLayer = new OU.util.Layer({
                container:this
            });
            this.bgLayer.context.gradRect(); // draw background on backdrop layer
            this.margin = this.data.margin || 40;
            this.htmlDiv = new OU.util.Div({
                x:this.x + this.margin,
                y:this.y + this.margin,
                w:this.w - this.margin * 2,
                h:this.h - this.margin * 4,
                container:this
            });
            this.insertHtml();
        }
        else {
            this.accessible(false); // render the accessible version
        }
        for (i = this.data.buttons.length; i--;) {
            this.buttons[i] = new OU.util.ControlButton({
                txt:self.data.buttons[i].name,
                x:self.w / 2 + 200 + i * self.bH * 5,
                y:11,
                w:self.bH * 4,
                h:self.bH,
                context:ctx,
                onOffIndicator:true,
                onOff:self.bestFitOn,
                onClick:self.data.buttons[i].fn
            });
            clickable.push(this.buttons[i]);
        }
        OU.onOrientChange(function () {
            self.resize();
        });
    };
    OU.activity.GWTable.prototype.setIntro = function ( s ) {
        if (document.getElementById("ougwIntro"))document.getElementById("ougwIntro").innerHTML = s.replace("__ORDERED__", OU.LocalStorage.load("ougwTOrdered")=="1" ? "now" : "not yet") + "<br/>";
    };
    OU.activity.GWTable.prototype.insertHtml = function () {
        var s = '', i, id, e, self = this;
        s = this.setGWTable(this);
        OU.LocalStorage.save("ougwTableHTML", s);
        this.htmlDiv.div.innerHTML = "<span style='font-size:14px;'><span id='ougwTable'>" + s + "</span><span style='position:absolute;left:52%;top:2%;'><span id='ougwIntro'></span><span id='gwtcomment'></span>\n\
</span>" + this.data.html + "</span>";
        //add listeners to the elements we need to save
        for (i = this.data.saveIDs.length; i--;) {
            id = this.data.saveIDs[i];
            e = document.getElementById(id);
            e.onchange = function () {
                self.saveVars();
            };
        }
        this.setIntro(this.data.intro);
        this.loadVars();
    };
    OU.activity.GWTable.prototype.setGWTable = function () {
//function setGWTable(ths){
        var ths = this;
        self = this;
        if (ths)self = ths;
        var i, id, e, gwData = OU.LocalStorage.load("ougwData"), s = '', rn = 0, result = [];
        if (!gwData)gwData = "";
        var rws = gwData.split(";")
            , t = [], v = []
            , vs = ["Solar constant", "CO<sub>2</sub>", "H<sub>2</sub>O", "Aerosol", "Albedo", "Ice and snow", "Cloud cover"]
            , is = [1368, 377, 30.55, 0, 0.087, 0.1, 0.508]
            , dcp = function ( v, n ) {
                var p = Math.pow(10, n);
                return ((v * p) | 0) / p;
            };
        if (rws[0]!=="") {
            for (i = 0; i < rws.length - 1; i++) {
                var p = rws[i].indexOf(":"), p2 = rws[i].indexOf(",", p)
                    , c = parseInt(rws[i].substring(1, p))
                    ;
                v[i] = parseFloat(rws[i].substring(p + 1, p2));
                t[i] = parseFloat(rws[i].substring(p2 + 1));
                var chg = (v[i] - is[c]) * 100 / (is[c]===0. ? 1. : is[c]);
                result[rn] = [vs[c], dcp(chg, 1), dcp(t[i], 2)
                    , dcp((t[i] - 15.08) / chg, 3)];
                s = s
                    + "<tr id='" + i + "' name='p' onclick='swap(this);' style='display:none;font-size:8px;'><td><a type='button' id='" + i + "' >&#x25ba;&#160;&#160;&#160;&#160;&#160;&#160;</a></td><td></td><td></td><td></td></tr>"
                    + "<tr id='d' onclick='select(this);' style='background:#eee;'><td>"
                    + result[rn][0] + "</td><td>" + result[rn][1] + "%</td><td>" + result[rn][2] + "</td><td>" + result[rn][3] + "</td></tr>";
                rn++;
            }
            self.result = result;
        }
        s += "<tr id='" + i + "' name='p' onclick='swap(this);' style='display:none;font-size:8px;background:#fee;'><td><a type='button' id='" + i + "' >&#x25ba;&#160;&#160;&#160;&#160;&#160;&#160;</a></td><td></td><td></td><td></td></tr>";
        s = "<table style='width:35%'><tr style='background:#ddf;'><td>Factor</td><td>Change</td><td>GMST/°C</td><td>Sensitivity</td></tr>"
            + "<tr><td> </td><td>None</td><td>15.08</td><td> </td></tr>"
            + s + "</table>";
        var tw = (parseInt(self.htmlDiv.div.style.width.replace("px", "")) / 8) | 0;
        s = "<span style='font-size:14px;'>" + s.replace(/\<td/g, "<td style='width:" + tw + "px;' ")
            + "</span>";
        return s;
    };
    OU.activity.GWTable.prototype.saveVars = function () {
        var i, id, e;
        for (i = this.data.saveIDs.length; i--;) {
            id = this.data.saveIDs[i];
            e = document.getElementById(id);
            OU.LocalStorage.save('ou.GWTable.' + this.data.saveTitle + '.' + id, e.value);
        }
    };
    OU.activity.GWTable.prototype.loadVars = function () {
        var i, id, e;
        for (i = this.data.saveIDs.length; i--;) {
            id = this.data.saveIDs[i];
            e = document.getElementById(id);
            e.value = OU.LocalStorage.load('ou.GWTable.' + this.data.saveTitle + '.' + id) || '';
        }
    };
    OU.activity.GWTable.prototype.resize = function () {
        this.x = this.y = this.w = this.h = undefined;
        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        this.htmlDiv.resize({
            x:this.x + this.margin,
            y:this.y + this.margin,
            w:this.w - this.margin * 2,
            h:this.h - this.margin * 4,
            container:this
        });
        for (var i = this.buttons.length; i--;) {
            this.buttons[i].resize({
                container:this,
                y:this.h - (this.bH++) * 4
            });
            this.buttons[i].render();
        }
        this.doRender = true;
        OU.resizeCloseButton(this);
    };
    OU.activity.GWTable.prototype.accessible = function () {
        var h = '<div id="accessibleView">';
        h += this.data.html;
        h += '</div>';
        document.body.innerHTML = '';
        var accessible = document.createElement('div');
        accessible.innerHTML = h;
        document.body.appendChild(accessible);
    };
    this.init();
};
