/**
 * @fileOverview GraphUserPivotLineActivity - A non-assessed exercise where user clicks onto the graph and drags the end point to pivot the line about the origin, such as 0,0, therefore changing the angle and gradient . Any number of fixed lines can be added. All lines will have labels.
 * This is activity type 3a for Social Sciences DD209
 * 
 * STILL IN DEVELOPMENT - W.I.P.!!!!
 *
 * Usage:
 * <ul>
 * <li> Make a copy of this file</li>
 * <li> Rename the class (OU.activity.GraphUserPivotLineActivity) to your new activity name</li>
 * <li> Add your code</li>
 * </ul>
 *
 * Additional functions that are not defined in this file but are available to all activities:
 * <ul>
 * <li> this.header(h) - changes current H1 and H2 tags, where parameter h is of format: { h1: 'optional H1', h2: 'optional H2' }</li>
 * <li> this.loadCSSFile(f) - loads additional CSS from the file f - which is a file path relative to the activity data folder</li>
 * <li> this.addMessengerParams(paramsArray) - See documentation for Messenger functions in OU.js</li>
 * </ul>
 *
 * @author Gareth Hudson <gareth.hudson@open.ac.uk>
 */

// Load in any util elements that are required
OU.require('OU.util.Layer');
OU.require('OU.util.Button');
OU.require('OU.util.Div');


/**
 * @class GraphUserPivotLineActivity - A template for activities that extend the OU.util.Activity class
 * @extends OU.util.Activity
 * @param {Object} data - Holds the data content for a specific instance of the activity
 * @param {String|undefined} instance - A unique identifier name for this instance, defaults to 'a1'
 * @param {Controller Object|undefined} controller - A reference to the controller that initialised this instance, if undefined, the superclass will generate a new controller and create the reference to it as 'this.controller'
 */
OU.activity.GraphUserPivotLineActivity = function(data,instance,controller) {

    /**
     * canvasView - this is the function that is first called when the activity is launched,
     *              assuming you are in a browser that supports canvas.
     *
     * Typical tasks for this function are:
     * <ul>
     * <li> Define and initialise and activity wide variables</li>
     * <li> Initialise Layers & Divs</li>
     * <li> Call a loading function</li>
     * <li> Initiating the activity by calling any methods that</li>
     * </ul>
     */
    OU.activity.GraphUserPivotLineActivity.prototype.canvasView = function() {
        // Most activities should have a background layer
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw default background
        // feedback text
        this.feedbackText = new OU.util.Div({
            container:this,
            x:20,
            y:this.h-40,
            w:this.w-30,
            h:40
        });


        this.textInfoLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.colouredAreasLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.pointsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.labelsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        
        // layer for the main graph and fixed items
        this.graphLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // layer for the user moveable line
        this.lineMoveLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.buttonsLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:this.w-this.data.submitbutton.w,
            y:this.h-40,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        // Submit button
        var btnActionLevel = this;
        this.buttonSubmit = new OU.util.Button({
            layer:this.buttonsLayer,
            txt:this.data.submitbutton.label,
            verticalPadding:2,
            disabled:false,
            onClick:function () {
                btnActionLevel.checkAnswer();
            },
            x:0,
            y:0,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        
        this.lineMoveLayer.events.clickable.push(this);
        // *Your code starts here*
        this.graphData = function() {
        }
        this.graphData.xMove = 0;
        this.graphData.yMove = 0;
        this.graphData.userClickPositionsXY = [];
        this.activityIsActive = true;
        this.graphData.drawPointsPositions = [];
        //console.log(this.graphData.userClickPositionsXY);
        this.fractionForCalculatingCorrectClick = this.data.xyvalsforequation.x/this.data.xyvalsforequation.y;
        this.graphData.numberUserAttemptsMade = 0;
        this.graphData.correctAngle = Math.round(this.calcHypotAngle(this.data.xyvalsforequation.x-this.data.pivotline.startx,this.data.xyvalsforequation.y-this.data.pivotline.starty));
        //console.log('correctAngle = '+this.graphData.correctAngle);
        this.graphData.originalAngle = Math.round(this.calcHypotAngle(this.data.pivotline.endx-this.data.pivotline.startx,this.data.pivotline.endy-this.data.pivotline.starty));
        //console.log('correctAngle = '+this.graphData.correctAngle);
        this.graphData.userCorrect = false;
        this.resize();
    };
    
    OU.activity.GraphUserPivotLineActivity.prototype.checkAnswer = function(){
        this.graphData.numberUserAttemptsMade++;
        //this.disable();
        if (this.graphData.userAngle <= this.graphData.correctAngle+this.data.answeramountangleleeway && this.graphData.userAngle >= this.graphData.correctAngle-this.data.answeramountangleleeway) {
            //console.log('correct');
            this.graphData.userCorrect = true;
            this.feedbackText.div.innerHTML = this.data.feedbacktext.correct;
            //this.buttonSubmit.disable();
            this.activityIsActive = false;
            clearTimeout(this.feedbackTimeout);
            this.showResetButton();
        } else if ((this.graphData.originalAngle < this.graphData.correctAngle && this.graphData.userAngle < this.graphData.originalAngle) || (this.graphData.originalAngle > this.graphData.correctAngle && this.graphData.userAngle > this.graphData.originalAngle)) {
            
            //console.log('wrong direction');
            if (this.graphData.numberUserAttemptsMade >= this.data.numberofattempts || this.graphData.userCorrect == true){
                //this.feedbackText.div.innerHTML = this.data.feedbacktext.wrongdirection + this.data.feedbacktext.displaycorrect;
                this.feedbackText.div.innerHTML = this.data.feedbacktext.wrongdirectionfinal;
                //this.buttonSubmit.disable();
                this.activityIsActive = false;
                this.showCorrectAnswer();
                clearTimeout(this.feedbackTimeout);
            } else {
               this.feedbackText.div.innerHTML = this.data.feedbacktext.wrongdirection; 
                this.clearFeedbackTimeout();
            }
        } else if ((this.graphData.originalAngle < this.graphData.correctAngle && this.graphData.userAngle > this.graphData.correctAngle+this.data.answeramountangleleeway) || (this.graphData.originalAngle > this.graphData.correctAngle && this.graphData.userAngle < this.graphData.correctAngle-this.data.answeramountangleleeway)) {
            //console.log('too far');
            if (this.graphData.numberUserAttemptsMade >= this.data.numberofattempts || this.graphData.userCorrect == true){
                //this.feedbackText.div.innerHTML = this.data.feedbacktext.toofar + this.data.feedbacktext.displaycorrect;
                this.feedbackText.div.innerHTML = this.data.feedbacktext.toofarfinal;
                //this.buttonSubmit.disable();
                this.activityIsActive = false;
                this.showCorrectAnswer();
                clearTimeout(this.feedbackTimeout);
            } else {
                this.feedbackText.div.innerHTML = this.data.feedbacktext.toofar;
                this.clearFeedbackTimeout();
            }
        } else {
            //console.log('not far enough');
            if (this.graphData.numberUserAttemptsMade >= this.data.numberofattempts || this.graphData.userCorrect == true){
                //this.feedbackText.div.innerHTML = this.data.feedbacktext.notfarenough + this.data.feedbacktext.displaycorrect;
                this.feedbackText.div.innerHTML = this.data.feedbacktext.notfarenoughfinal;
                //this.buttonSubmit.disable();
                this.activityIsActive = false;
                this.showCorrectAnswer();
                clearTimeout(this.feedbackTimeout);
            } else {
                this.feedbackText.div.innerHTML = this.data.feedbacktext.notfarenough;
                this.clearFeedbackTimeout();
            }
        }
        this.drawColouredAreas();
    }
    
    OU.activity.GraphUserPivotLineActivity.prototype.clearFeedbackTimeout = function(){
        //console.log(this.buttonSubmit.txt);
        //this.buttonSubmit.txt = 'Reset';
        //this.buttonSubmit.render();
        var self = this;
        clearTimeout(this.feedbackTimeout);
        this.feedbackTimeout = setTimeout(function () {
            self.clearFeedback();
        }, this.data.feedbacktext.incorrectsecstimeout*1000);
    }
    OU.activity.GraphUserPivotLineActivity.prototype.clearFeedback = function(){
        this.feedbackText.div.innerHTML = '';
    }
    
    OU.activity.GraphUserPivotLineActivity.prototype.drawColouredAreas = function(){
        if (this.graphData.numberUserAttemptsMade >= this.data.numberofattempts || this.graphData.userCorrect == true){
            //this.buttonSubmit.disable();
            // Show the coloured areas of the graph if desired
            if (this.data.displaycolouredareasoncompletion) {
                this.lineMoveLayer.context.clearRect(0, 0, this.w, this.h);
                this.pointsLayer.context.clearRect(0, 0, this.w, this.h);
                var ctx = this.colouredAreasLayer.context;
                ctx.save();
                ctx.clearRect(0, 0, this.w, this.h);
                ctx.translate(this.graphLayer.w*0.13, this.data.yaxis.end*this.scaleFactorY*1.1);
                ctx.lineWidth = 1;
                // Draw and colour the area below the original line - START
                ctx.fillStyle = "#AAAA00";
                ctx.beginPath();
                ctx.moveTo(this.data.pivotline.startx*this.scaleFactorX,-this.data.pivotline.starty*this.scaleFactorY);
                ctx.lineTo(this.data.pivotline.endx*this.scaleFactorX, - this.data.pivotline.endy*this.scaleFactorY);
                ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -this.data.yaxis.start*this.scaleFactorY);
                ctx.lineTo(this.data.xaxis.start*this.scaleFactorX,-this.data.yaxis.start*this.scaleFactorY);
                ctx.lineTo(this.data.pivotline.startx*this.scaleFactorX,-this.data.pivotline.starty*this.scaleFactorY);
                ctx.fill();
                ctx.stroke();
                // Draw and colour the area below the original line - END
                // Draw and colour the area above the correct line - START
                ctx.fillStyle = "#AA00AA";
                ctx.beginPath();
                ctx.moveTo(this.data.pivotline.startx*this.scaleFactorX,-this.data.pivotline.starty*this.scaleFactorY);
                ctx.lineTo(this.data.xyvalsforequation.x*this.scaleFactorX, - this.data.xyvalsforequation.y*this.scaleFactorY);
                ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -this.data.yaxis.end*this.scaleFactorY);
                ctx.lineTo(this.data.xaxis.start*this.scaleFactorX,-this.data.yaxis.end*this.scaleFactorY);
                ctx.lineTo(this.data.pivotline.startx*this.scaleFactorX,-this.data.pivotline.starty*this.scaleFactorY);
                ctx.fill();
                ctx.stroke();
                // Draw and colour the area above the correct line - END
                // Draw and colour the area between the original and correct lines - START
                ctx.fillStyle = "#00AAAA";
                ctx.beginPath();
                ctx.moveTo(this.data.pivotline.startx*this.scaleFactorX,-this.data.pivotline.starty*this.scaleFactorY);
                ctx.lineTo(this.data.xyvalsforequation.x*this.scaleFactorX, - this.data.xyvalsforequation.y*this.scaleFactorY);
                ctx.lineTo(this.data.pivotline.endx*this.scaleFactorX, - this.data.pivotline.endy*this.scaleFactorY);
                ctx.lineTo(this.data.pivotline.startx*this.scaleFactorX,-this.data.pivotline.starty*this.scaleFactorY);
                ctx.fill();
                ctx.stroke();
            // Draw and colour the area between the original and correct lines - END
            }
        }
        
    }
    
    /** Calculate the angle of the hypotenuse line */
    OU.activity.GraphUserPivotLineActivity.prototype.calcHypotAngle = function(adjacent, opposite) {
        /** opposite = y height
         *  adjacent = x length
         *  hySq is the square of the hypotenuse
         *  hy is the hypotenuse
         *  Now to work out the hypotenuse  */
        var op = opposite;
        var ad = adjacent;
        var hySq = (op*op) + (ad*ad);
        var hy = Math.sqrt(hySq);
        //console.log('ad = '+ad+', op = '+op+', hy = '+hy);
        /** Now to work out the angle of the hypotenuse (hyAn)
         *  this is equal to the inverse Sin of opposite divided by hypotenuse */
        var hyAn = Math.asin(op/hy)*180/Math.PI;
        //console.log(hyAn);
        /** Now return the angle from this called function */
        return hyAn;
    }
    
    OU.activity.GraphUserPivotLineActivity.prototype.isHit = function ( x, y, evState ) {
        //console.log('isHit');
        if (this.activityIsActive) {
            var gd = this.graphData, dX, dY, edX, edY, bH = OU.controlHeight;
            var ctx = this.lineMoveLayer.context;
            // find the X,Y position of the cursor and show to user
            var xPos = Math.round((x-this.lineMoveLayer.w*0.13)/this.scaleFactorX);
            var yPos = -(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1)/this.scaleFactorY;
            //
            if (evState) {
                if (this.inDrag) {
                    dX = x - this.dragStartX;
                    dY = y - this.dragStartY;
                    //console.log(dX + ',' + dY);
                    if (this.data.axistomove == 'x' || this.data.axistomove == 'both') {
                        gd.xMove += dX/this.scaleFactorX;
                    }
                    if (this.data.axistomove == 'y' || this.data.axistomove == 'both') {
                        gd.yMove += dY/this.scaleFactorY;
                    }
                    this.dragStartX = x;
                    this.dragStartY = y;
                    this.renderMovingLinesWithInfo(); 
                }
                else {
                    this.dragStartX = x;
                    this.dragStartY = y;
                    this.inDrag = true;
                    var ctxPoints = this.pointsLayer.context;
                    //
                    this.graphData.userClickPositionsXY[this.graphData.userClickPositionsXY.length] = [Math.round(parseInt(xPos)/5)*5,Math.round(parseInt(yPos)/5)*5];
                //console.log(this.graphData.userClickPositionsXY);
                }
            } else {
                this.inDrag = false;
            }

            if(this.data.showcursorposition) {
            //this.renderTextInfoLayer(Math.round(parseInt(xPos)/5)*5,Math.round(parseInt(yPos)/5)*5,x,y);
            }
        }
    };
    
    /** Add the label to the end of the pivot line, from info in data.js */
    OU.activity.GraphUserPivotLineActivity.prototype.renderTextInfoLayer = function(xPos,yPos,x,y,ang) {
        var ctx = this.textInfoLayer.context;
        var gd = this.graphData;
        if (this['labelDivFixed']) {
            this['labelDivFixed'].remove();
        }
        this['labelDivFixed'] = new OU.util.Div ({
            innerHTML:this.data.linemovelabels.text,
            container:this.textInfoLayer,
            x:(this.data.pivotline.endx+gd.xMove+this.data.linemovelabels.xplus)*this.scaleFactorX,
            y:(this.data.yaxis.end - (this.data.pivotline.endy-gd.yMove+this.data.linemovelabels.yplus) + this.graphLayer.h*0.1 + 50)*this.scaleFactorY,
            w:80,
            h:30,
            style:'text-align:right; font-family:Arial; font-size:12px'
        });
    };
    
    OU.activity.GraphUserPivotLineActivity.prototype.render = function() {
        var ctx = this.graphLayer.context;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.translate(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
        this.renderAxis();
        ctx.textAlign = 'center';
        ctx.font='14px Arial';
        ctx.fillText(this.data.xaxis.label,(this.data.xaxis.end/2)*this.scaleFactorX,40);
        ctx.rotate(-0.5*Math.PI);
        ctx.fillText(this.data.yaxis.label ,(this.data.yaxis.end/2)*this.scaleFactorY,-50);
        ctx.restore();
        this.buttonSubmit.render();
        this.drawColouredAreas();
    };
    
    OU.activity.GraphUserPivotLineActivity.prototype.renderAxis = function() {
        var ctx = this.graphLayer.context;
        var gd = this.graphData;
        ctx.strokeStyle='#000000';
        ctx.lineWidth=2;
        // draw the y axis
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(0, - this.data.yaxis.end*this.scaleFactorY);
        ctx.stroke();
        // draw the y axis
        ctx.beginPath();
        ctx.moveTo(0, 0);
        ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, 0);
        ctx.stroke();
        // draw the y axis markers and text labels
        ctx.textAlign = 'right';
        ctx.font='12px Arial';
        var labelOddEven = 0;
        for(var i= this.data.yaxis.start; i<=this.data.yaxis.end; i+= this.data.yaxis.interval){
            // the y axis markers
            labelOddEven++;
            ctx.beginPath();
            ctx.moveTo(0, -i*this.scaleFactorY);
            ctx.strokeStyle='#000000';
            ctx.lineWidth=2;
            ctx.lineTo(-10, -i*this.scaleFactorY);
            ctx.stroke();
            // the yaxis labels
            switch(this.data.yaxis.markerlabels) {
                case 'all':
                    //console.log(labelOddEven%2 == 1);
                    ctx.fillText(i,-12,-i*this.scaleFactorY);
                    break;
                case 'odd':
                    if (labelOddEven%2 == 1) {
                        ctx.fillText(i,-12,-i*this.scaleFactorY);
                    }
                    break;
                case 'even':
                    if (labelOddEven%2 == 0) {
                        ctx.fillText(i,-12,-i*this.scaleFactorY);
                    }
                    break;
            }
            // draw the horizontal grid lines
            if (i>0){
                ctx.beginPath();
                ctx.moveTo(0, -i*this.scaleFactorY);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -i*this.scaleFactorY);
                // in between vertical gris lines
                ctx.moveTo(0, -i*this.scaleFactorY + (this.data.yaxis.interval/2)*this.scaleFactorY);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -i*this.scaleFactorY + (this.data.yaxis.interval/2)*this.scaleFactorY);
                ctx.stroke();
            }
        }
        // draw the x axis markers and text labels
        ctx.textAlign = 'center';
        labelOddEven = 0;
        for(var i= this.data.xaxis.start; i<=this.data.xaxis.end; i+= this.data.xaxis.interval){
            // the x axis markers
            labelOddEven++;
            ctx.beginPath();
            ctx.moveTo(i*this.scaleFactorX, 0);
            ctx.strokeStyle='#000000';
            ctx.lineWidth=2;
            ctx.lineTo(i*this.scaleFactorX, 10);
            ctx.stroke();
            // the x axis labels
            switch(this.data.xaxis.markerlabels) {
                case 'all':
                    //console.log(labelOddEven%2 == 1);
                    ctx.fillText(i,i*this.scaleFactorX,20);
                    break;
                case 'odd':
                    if (labelOddEven%2 == 1) {
                        ctx.fillText(i,i*this.scaleFactorX,20);
                    }
                    break;
                case 'even':
                    if (labelOddEven%2 == 0) {
                        ctx.fillText(i,i*this.scaleFactorX,20);
                    }
                    break;
            }
            // draw the vertical grid lines
            if (i>0){
                ctx.beginPath();
                ctx.moveTo(i*this.scaleFactorX, 0);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(i*this.scaleFactorX, -this.data.yaxis.end*this.scaleFactorY);
                // in between vertical gris lines
                ctx.moveTo(i*this.scaleFactorX - (this.data.xaxis.interval/2)*this.scaleFactorX, 0);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(i*this.scaleFactorX - (this.data.xaxis.interval/2)*this.scaleFactorX, -this.data.yaxis.end*this.scaleFactorY);
                ctx.stroke();
            }
        }
        // draw all the fixed lines
        for (var y=0; y<this.data.lines.length; y++) {
            ctx.strokeStyle=this.data.linecolours[y];
            ctx.lineWidth=2;
            ctx.beginPath();
            ctx.moveTo(this.data.lines[y][0].x*this.scaleFactorX,-this.data.lines[y][0].y*this.scaleFactorY);
            for(var i=1; i<this.data.lines[y].length; i++) {
                ctx.lineTo(this.data.lines[y][i].x*this.scaleFactorX,-this.data.lines[y][i].y*this.scaleFactorY);
            }
            ctx.stroke();
        }
        // add any desired labels to the graph
        /*
        ctx.textAlign = 'left';
        for (var i=0; i<this.data.graphlabels.length; i++) {
            ctx.fillText(this.data.graphlabels[i].text,this.data.graphlabels[i].x*this.scaleFactorX,-this.data.graphlabels[i].y*this.scaleFactorY);            
        }
        */
        // add any desired labels to the graph
        ctx.textAlign = 'left';
        for (var i=0; i<this.data.graphlabels.length; i++) {
            //ctx.fillText(this.data.graphlabels[i].text,this.data.graphlabels[i].x*this.scaleFactor,-this.data.graphlabels[i].y*this.scaleFactor); 
            if (this['labelDivFixed'+i]) {
                this['labelDivFixed'+i].remove();
            }
            this['labelDivFixed'+i] = new OU.util.Div ({
                innerHTML:this.data.graphlabels[i].text,
                container:this.graphLayer,
                x:(this.data.graphlabels[i].x + this.graphLayer.w*0.13+120)*this.scaleFactorX,
                y:(this.data.yaxis.end - this.data.graphlabels[i].y + this.graphLayer.h*0.1 + 50)*this.scaleFactorY,
                w:80,
                h:30,
                style:'text-align:left; font-family:Arial; font-size:12px'
            });
            //console.log((this.data.graphlabels[i].x + this.graphLayer.w*0.1+120)*this.scaleFactorX);
            //console.log((this.data.yaxis.end - this.data.graphlabels[i].y + this.graphLayer.h*0.1 + 50)*this.scaleFactorY);
            
        }
        
        
        
        // call function to draw the user moveable lines
        if (this.activityIsActive) {
            this.renderMovingLinesWithInfo();
        } else {
            this.showCorrectAnswer();
        }
        
        
    };
    
    OU.activity.GraphUserPivotLineActivity.prototype.renderMovingLinesWithInfo = function() {
        var ctx = this.lineMoveLayer.context;
        var gd = this.graphData;
        //console.log(this.data.pivotline.endy + gd.yMove);
        // ************************************ To Finish - if statement below ***************************************
        
        if (this.data.pivotline.endx-gd.xMove < this.data.xaxis.start) {
            gd.xMove = 0;
        //return false;
        }
        if (this.data.pivotline.endy-gd.yMove < this.data.yaxis.start) {
            gd.yMove = 0;
        //return false;
        }
        
        // ************************************ To Finish - if statement above ***************************************
        
        
        // this big 'if' statement will prevent the line being drawn beyond the max/min x/y of the graph
        if (this.data.pivotline.endy+(-gd.yMove) <= this.data.yaxis.end && this.data.pivotline.endy+(-gd.yMove) >= this.data.yaxis.start && this.data.pivotline.endx+gd.xMove <= this.data.xaxis.end && this.data.pivotline.endx+gd.xMove >= this.data.xaxis.start) {
            ctx.save();
            ctx.clearRect(0, 0, this.w, this.h);
            ctx.translate(this.lineMoveLayer.w*0.13, this.data.yaxis.end*this.scaleFactorY*1.1);
            // draw the moveable line
            ctx.strokeStyle=this.data.linemovecolour;
            ctx.lineWidth=2;
            ctx.textAlign = 'right';
            ctx.font='12px Arial';
            ctx.beginPath();
            ctx.moveTo(this.data.pivotline.startx*this.scaleFactorX,-this.data.pivotline.starty*this.scaleFactorY);
            ctx.lineTo((this.data.pivotline.endx+gd.xMove)*this.scaleFactorX,-(this.data.pivotline.endy-gd.yMove)*this.scaleFactorY);
            ctx.stroke();
            //
            var ang = Math.round(this.calcHypotAngle(Math.round(parseInt(this.data.pivotline.endx-this.data.pivotline.startx+gd.xMove)/5)*5,Math.round(parseInt(this.data.pivotline.endy-this.data.pivotline.starty-gd.yMove)/5)*5));
            gd.userAngle = ang;
            //
            this.renderTextInfoLayer(Math.round(parseInt(this.data.pivotline.endx+gd.xMove)/5)*5,Math.round(parseInt(this.data.pivotline.endy-gd.yMove)/5)*5,(this.data.pivotline.endx+gd.xMove)*this.scaleFactorX,-(this.data.pivotline.endy-gd.yMove)*this.scaleFactorY,ang);
            //
            var ctxPoints = this.pointsLayer.context;
            ctxPoints.save();
            ctxPoints.clearRect(0, 0, this.w, this.h);
            ctxPoints.translate(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
            ctxPoints.fillStyle = "#000000";
            ctxPoints.fill();
            ctxPoints.lineWidth = 1;
            ctxPoints.strokeStyle = "black";
            ctxPoints.beginPath();
            ctxPoints.arc(this.data.pivotline.startx*this.scaleFactorX, -this.data.pivotline.starty*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
            ctxPoints.stroke();
            ctxPoints.beginPath();
            ctxPoints.arc((this.data.pivotline.endx+gd.xMove)*this.scaleFactorX, -(this.data.pivotline.endy-gd.yMove)*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
            ctxPoints.stroke();
            ctxPoints.restore();
            ctx.restore();
        }
    };
    
    OU.activity.GraphUserPivotLineActivity.prototype.showCorrectAnswer = function() {
        var ctx = this.lineMoveLayer.context;
        var ctxPoints = this.pointsLayer.context;
        ctxPoints.clearRect(0, 0, this.w, this.h);
        var gd = this.graphData;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.translate(this.lineMoveLayer.w*0.13, this.data.yaxis.end*this.scaleFactorY*1.1);
        // draw the correct line
        ctx.strokeStyle=this.data.linemovecolour;
        ctx.lineWidth=2;
        ctx.textAlign = 'right';
        ctx.font='12px Arial';
        ctx.beginPath();
        var crctY = this.data.xaxis.end/(this.data.xyvalsforequation.x / this.data.xyvalsforequation.y);
        ctx.moveTo(this.data.pivotline.startx*this.scaleFactorX,-this.data.pivotline.starty*this.scaleFactorY);
        ctx.lineTo(this.data.xaxis.end*this.scaleFactorX,-crctY*this.scaleFactorY);
        ctx.stroke();
        ctx.restore();
        this['labelDivFixed'].remove();
        this['labelDivFixed'] = new OU.util.Div ({
            innerHTML:this.data.linemovelabels.text,
            container:this.textInfoLayer,
            x:(this.data.xaxis.end+this.data.linemovelabels.xplus)*this.scaleFactorX,
            y:(this.data.yaxis.end - (crctY+this.data.linemovelabels.yplus) + this.graphLayer.h*0.1 + 50)*this.scaleFactorY,
            w:80,
            h:30,
            style:'text-align:right; font-family:Arial; font-size:12px'
        });
        this.showResetButton();
    };
    
    OU.activity.GraphUserPivotLineActivity.prototype.showResetButton = function() {
        //this.buttonSubmit.enable();
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Reset',onClick:function () {
                //console.log(btnActionLevel);
                btnActionLevel.resetActivity();
            }
        });
        this.buttonSubmit.render();
    };
    
    OU.activity.GraphUserPivotLineActivity.prototype.resetActivity = function() {
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Submit',onClick:function () {
                btnActionLevel.checkAnswer();
            }
        });
        this.buttonSubmit.render();
        this.graphData.xMove = 0;
        this.graphData.yMove = 0;
        this.graphData.userClickPositionsXY = [];
        this.activityIsActive = true;
        this.graphData.drawPointsPositions = [];
        this.graphData.numberUserAttemptsMade = 0;
        this.feedbackText.div.innerHTML = "";
        this.graphData.userCorrect = false;
        this.resize();
    };
    
    OU.activity.GraphUserPivotLineActivity.prototype.checkPositionOfMovedLine = function() {
    }
    /**
     * accessibleView - this function is called instead of canvasView if the browser does not support HTML5 canvas
     */
    OU.activity.GraphUserPivotLineActivity.prototype.accessibleView = function() {
        OU.activity.GraphUserPivotLineActivity.superClass_.accessibleView.call(this); // call the superclass method is you want to extend it, remove this line to override the method instead

    // Note this function can be removed or commented out if you want to use the default accessibleView method

    // *Your code starts here*
    };
    /**
     * resize - called whenever the outer bounds of the activity change, ie when the browser window is resized, or a mobile device is rotated.
     *
     * This function should do the following:
     * <ul>
     * <li>Resize all visible elements</li>
     * <li>Re-layout all visible elements</li>
     * <li>Actually re-render the current view of the activity</li>
     * </ul>
     */
    OU.activity.GraphUserPivotLineActivity.prototype.resize = function() {
        OU.activity.GraphUserPivotLineActivity.superClass_.resize.call(this); // call the superclass resize

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        if (this.h > this.w){
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
        } else {
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
        }
        //this.graphLayer.resize({x:0,y:0,w:this.w,h:this.h});
        // this.lineMoveLayer.resize({x:0,y:0,w:this.w,h:this.h});
        this.textInfoLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.colouredAreasLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.pointsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.labelsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        // work out the scaleFactor for sizing and rendering everything
        /** //////////////////////////////////////////////////////////////////////////////////////////////////////////
         *  Different scaleFactors for X and Y so that axis can have different max values,
         *  such as Y 0 - 1500, X 0 - 1.2 */
        if (this.graphLayer.h > this.graphLayer.w) {
            this.scaleFactorX = (this.graphLayer.w * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
            this.scaleFactorY = (this.graphLayer.w * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        } else {
            this.scaleFactorX = (this.graphLayer.h * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
            this.scaleFactorY = (this.graphLayer.h * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        }
        /** //////////////////////////////////////////////////////////////////////////////////////////////////////////*/
        // reposition the button layer
        this.buttonsLayer.resize({
            x:this.data.xaxis.end*this.scaleFactorX,
            y:(this.data.yaxis.end*this.scaleFactorY)+(this.data.yaxis.end*this.scaleFactorY*0.2)-10,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        this.feedbackText.resize({
            x:30,
            y:(this.data.yaxis.end*this.scaleFactorY)+(this.data.yaxis.end*this.scaleFactorY*0.2)+this.data.submitbutton.h,
            w:this.w-60,
            h:40
        });
        this.render();
    //
    };

    /**
     * remove - called when the activity is being removed by a controller.
     *
     * This function should do the following:
     * <ul>
     * <li> Remove any elements that may remain in memory</li>
     * <li> Stop any animation loops, including killing any Intervals </li>
     * </ul>
     * You do not need to remove most library elements, such as Layers, Divs, etc. as they are removed automatically
     */
    OU.activity.GraphUserPivotLineActivity.prototype.remove = function() {
        OU.activity.GraphUserPivotLineActivity.superClass_.remove.call(this); // call the superclass remove

    // *Your removal code here*
    // If you have nothing to remove, then this function can be deleted or commented out
    };

    // call the superclass's constructor
    OU.base(this,data,instance,controller);
};
// Call our inherits function to implement the class inheritance
OU.inherits(OU.activity.GraphUserPivotLineActivity,OU.util.Activity);
