/**
 * @fileOverview GraphUserPlotLineActivity - A non-assessed exercise where user clicks points onto the graph with their line being drawn after a certain number of clicks and given feedback as to whether they are corrct or if the clicks are too high/low. Any number of fixed lines can be added. All lines will have labels.
 * This is activity type 1e for Social Sciences DD209
 * 
 * STILL IN DEVELOPMENT - W.I.P.!!!!!
 *
 * Usage:
 * <ul>
 * <li> Make a copy of this file</li>
 * <li> Rename the class (OU.activity.GraphUserPlotLineActivity) to your new activity name</li>
 * <li> Add your code</li>
 * </ul>
 *
 * Additional functions that are not defined in this file but are available to all activities:
 * <ul>
 * <li> this.header(h) - changes current H1 and H2 tags, where parameter h is of format: { h1: 'optional H1', h2: 'optional H2' }</li>
 * <li> this.loadCSSFile(f) - loads additional CSS from the file f - which is a file path relative to the activity data folder</li>
 * <li> this.addMessengerParams(paramsArray) - See documentation for Messenger functions in OU.js</li>
 * </ul>
 *
 * @author Gareth Hudson <gareth.hudson@open.ac.uk>
 */

// Load in any util elements that are required
OU.require('OU.util.Layer');
OU.require('OU.util.Button');
OU.require('OU.util.Div');


/**
 * @class GraphUserPlotLineActivity - A template for activities that extend the OU.util.Activity class
 * @extends OU.util.Activity
 * @param {Object} data - Holds the data content for a specific instance of the activity
 * @param {String|undefined} instance - A unique identifier name for this instance, defaults to 'a1'
 * @param {Controller Object|undefined} controller - A reference to the controller that initialised this instance, if undefined, the superclass will generate a new controller and create the reference to it as 'this.controller'
 */
OU.activity.GraphUserPlotLineActivity = function(data,instance,controller) {

    /**
     * canvasView - this is the function that is first called when the activity is launched,
     *              assuming you are in a browser that supports canvas.
     *
     * Typical tasks for this function are:
     * <ul>
     * <li> Define and initialise and activity wide variables</li>
     * <li> Initialise Layers & Divs</li>
     * <li> Call a loading function</li>
     * <li> Initiating the activity by calling any methods that</li>
     * </ul>
     */
    OU.activity.GraphUserPlotLineActivity.prototype.canvasView = function() {
        // Most activities should have a background layer
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw default background
        // feedback text
        this.feedbackText = new OU.util.Div({
            container:this,
            x:20,
            y:this.h-40,
            w:this.w-30,
            h:40
        });


        this.textInfoLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        
        this.pointsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.labelsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // layer for the main graph and fixed items
        this.graphLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // layer for the user moveable line
        this.lineMoveLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.buttonsLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:this.w-this.data.submitbutton.w,
            y:this.h-40,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        // Submit button
        var btnActionLevel = this;
        this.buttonSubmit = new OU.util.Button({
            layer:this.buttonsLayer,
            txt:this.data.submitbutton.label,
            verticalPadding:2,
            disabled:true,
            onClick:function () {
                //btnActionLevel.renderLineFromUserClickPoints();
                this.disable();
                btnActionLevel.resetCanvasAndVals();
            },
            x:0,
            y:0,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        
        this.lineMoveLayer.events.clickable.push(this);
        // *Your code starts here*
        this.graphData = function() {
        }
        this.graphData.xMove = 0;
        this.graphData.yMove = 0;
        this.graphData.userClickPositionsXY = [];
        this.activityIsActive = true;
        this.graphData.drawPointsPositions = [];
        
        if (this.data.startuserlinefromlocation.yes) {
            this.graphData.userClickPositionsXY[0] = [this.data.startuserlinefromlocation.x,this.data.startuserlinefromlocation.y];
        }
        ////console.log(this.graphData.userClickPositionsXY);
        this.fractionForCalculatingCorrectClick = this.data.xyvalsforequation.x/this.data.xyvalsforequation.y;
        this.graphData.numberUserAttemptsMade = 0;
        this.graphData.xyvalsforlinenotusingequation = [];
        this.graphData.xyvalsforlinenotusingequation = this.data.xyvalsforlinenotusingequation.clone();
        //console.log('data.xyvalsforlinenotusingequation = '+JSON.stringify(this.data.xyvalsforlinenotusingequation));
        //console.log('graphData.xyvalsforlinenotusingequation = '+JSON.stringify(this.graphData.xyvalsforlinenotusingequation));
        //
        /*
        if (this.data.snapcursorxypostonearest <= 0) {
            this.data.snapcursorxypostonearest = 1;
        }
        */
        this.resize();
    };
    OU.activity.GraphUserPlotLineActivity.prototype.submitAnswer = function(){
    ////console.log('submit button pressed'+this.w);
    }
    
    Object.prototype.clone = function() {
    var newObj = (this instanceof Array) ? [] : {};
    for (i in this) {
        if (i == 'clone') continue;
            if (this[i] && typeof this[i] == "object") {
                newObj[i] = this[i].clone();
            } else newObj[i] = this[i];
        } return newObj;
    };
    
    OU.activity.GraphUserPlotLineActivity.prototype.resetCanvasAndVals = function(){
        this.graphData.userClickPositionsXY = [];
        
        if (this.data.startuserlinefromlocation.yes) {
            this.graphData.userClickPositionsXY[0] = [this.data.startuserlinefromlocation.x,this.data.startuserlinefromlocation.y];
        }
        this.pointsLayer.context.clearRect(0, 0, this.w, this.h);
        this.lineMoveLayer.context.clearRect(0, 0, this.w, this.h);
        // Set boolean activityIsActive to true so that the user can do the exercise again if they wish
        this.activityIsActive = true;
        this.feedbackText.div.innerHTML = '';
        this.graphData.drawPointsPositions = [];
        this.graphData.xyvalsforlinenotusingequation = this.data.xyvalsforlinenotusingequation.clone();
        //console.log('data.xyvalsforlinenotusingequation = '+JSON.stringify(this.data.xyvalsforlinenotusingequation));
        //console.log('graphData.xyvalsforlinenotusingequation = '+JSON.stringify(this.graphData.xyvalsforlinenotusingequation));
    }
   /*
    OU.activity.GraphUserPlotLineActivity.prototype.renderCorrectAnswer = function(){
        // draw the correct answer line(s) and display to the user, disable submit button and prevent further move of lines
        //console.log('renderCorrectAnswer');
        var ctx = this.lineMoveLayer.context;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.translate(this.lineMoveLayer.w*0.1, this.data.yaxis.end*this.scaleFactorY*1.1);
        // draw the moveable line
        ctx.strokeStyle=this.data.linemovecolour;
        ctx.lineWidth=2;
        for (var y=0; y<this.data.correctlines.length; y++) {
            for(var i=1; i<this.data.correctlines[y].length; i++) {
                ctx.beginPath();
                ctx.moveTo((this.data.correctlines[y][i-1].x)*this.scaleFactorX,-(this.data.correctlines[y][i-1].y)*this.scaleFactorY);
                ctx.lineTo((this.data.correctlines[y][i].x)*this.scaleFactorX,-(this.data.correctlines[y][i].y)*this.scaleFactorY);
                ctx.stroke();
            }
        }
        ctx.textAlign = 'right';
        ctx.font='12px Arial';
        for (var i=0; i<this.data.linemovelabels.oncorrect.length; i++) {
            if (this['labelDiv'+i]) {
                this['labelDiv'+i].remove();
            }
            this['labelDiv'+i] = new OU.util.Div ({
                innerHTML:this.data.linemovelabels.oncorrect[i].text,
                container:this.lineMoveLayer,
                x:(this.data.correctlines[i][this.data.correctlines[i].length-1].x-20 + this.graphLayer.w*0.1 -80)*this.scaleFactorX,
                y:(this.data.yaxis.end - this.data.correctlines[i][this.data.correctlines[i].length-1].y + this.graphLayer.h*0.1)*this.scaleFactorY,
                w:80,
                h:30,
                style:'text-align:right; font-family:Arial; font-size:12px'
            });
        }
        ctx.restore();
        //disable the submit button
        this.buttonSubmit.disable();
        // clear the isHit function so that user can no longer move the lines
        OU.activity.GraphUserPlotLineActivity.prototype.isHit = function() {
            return false;
        }
        
    }
    */
    OU.activity.GraphUserPlotLineActivity.prototype.isHit = function ( x, y, evState ) {
        ////console.log('isHit');
        var gd = this.graphData, dX, dY, edX, edY, bH = OU.controlHeight;
        var ctx = this.lineMoveLayer.context;
        // find the X,Y position of the cursor and show to user
        if (this.data.snapcursorxypostonearest < 1) {
            var xPos = Math.round(((x-this.lineMoveLayer.w*0.13)/this.scaleFactorX)*10)/10;
            var yPos = Math.round((-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1)/this.scaleFactorY)*10)/10;
            //console.log(xPos);
        } else {
            //var xPos = Math.round((x-this.lineMoveLayer.w*0.1)/this.scaleFactorX);
            //var yPos = -(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1)/this.scaleFactorY;
            var xPos = Math.round(((x-this.lineMoveLayer.w*0.13)/this.scaleFactorX)/this.data.snapcursorxypostonearest)*this.data.snapcursorxypostonearest;
            var yPos = Math.round((-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1)/this.scaleFactorY)/this.data.snapcursorxypostonearest)*this.data.snapcursorxypostonearest;
        }
        
        //
        if (evState) {
            if (!this.inDrag && this.activityIsActive) {
                this.dragStartX = x;
                this.dragStartY = y;
                this.inDrag = true;
                var ctxPoints = this.pointsLayer.context;
                // Dots where the user clicks
                // If the user has to click 'anywhere' in an 'imaginary' line
                if (this.graphData.xyvalsforlinenotusingequation.length == 0) {
                    //console.log('click points on imaginary line');
                    if (xPos > this.data.xaxis.start && xPos < this.data.xaxis.end && yPos > this.data.yaxis.start && yPos < this.data.yaxis.end) {
                        //if ((Math.round(parseInt(xPos)/5)*5) / (Math.round(parseInt(yPos)/5)*5) == this.fractionForCalculatingCorrectClick) {
                        if (xPos / yPos == this.fractionForCalculatingCorrectClick) {
                            // save the x,y values of the dots for redraw on resize
                            this.graphData.drawPointsPositions[this.graphData.drawPointsPositions.length] = [x,y];
                            // store the xPos,yPos values for drawing the line along the points
                            //this.graphData.userClickPositionsXY[this.graphData.userClickPositionsXY.length] = [Math.round(parseInt(xPos)/5)*5,Math.round(parseInt(yPos)/5)*5];
                            this.graphData.userClickPositionsXY[this.graphData.userClickPositionsXY.length] = [xPos,yPos];
                            this.feedbackText.div.innerHTML = this.data.feedbacktext.correct;
                            this.clearFeedbackTimeout();
                            this.renderLineFromUserClickPoints();
                        } else {
                            ////console.log('off target');
                            this.feedbackText.div.innerHTML = this.data.feedbacktext.incorrect;
                            this.clearFeedbackTimeout();
                        }
                    }
                } else {
                    //console.log('click specific points');
                    // the user has to click on specific points as listed in data.xyvalsforlinenotusingequation
                    for (var i=0; i<this.graphData.xyvalsforlinenotusingequation.length; i++) {
                        //if (Math.round(parseInt(xPos)/5)*5 == this.graphData.xyvalsforlinenotusingequation[i].x && Math.round(parseInt(yPos)/5)*5 == this.graphData.xyvalsforlinenotusingequation[i].y) {
                        if (xPos == this.graphData.xyvalsforlinenotusingequation[i].x && yPos == this.graphData.xyvalsforlinenotusingequation[i].y) {
                            //console.log('good point');
                            // save the x,y values of the dots for redraw on resize
                            this.graphData.drawPointsPositions[this.graphData.drawPointsPositions.length] = [x,y];
                            // store the xPos,yPos values for drawing the line along the points
                            //this.graphData.userClickPositionsXY[this.graphData.userClickPositionsXY.length] = [Math.round(parseInt(xPos)/5)*5,Math.round(parseInt(yPos)/5)*5];
                            this.graphData.userClickPositionsXY[this.graphData.userClickPositionsXY.length] = [xPos,yPos];
                            this.feedbackText.div.innerHTML = this.data.feedbacktext.correct;
                            this.clearFeedbackTimeout();
                            this.renderLineFromUserClickPoints();
                            this.graphData.xyvalsforlinenotusingequation.splice(i,1);
                            break;
                        } else {
                            //console.log('bad point');
                            this.feedbackText.div.innerHTML = this.data.feedbacktext.incorrect;
                            this.clearFeedbackTimeout();
                        }
                    }
                }
                
            }
        } else {
            this.inDrag = false;
        }

        if(this.data.showcursorposition) {
            this.renderTextInfoLayer(xPos,yPos,x,y);
            /*
            //round "original" to 1 decimal   var result=Math.round(original*10)/10  //returns 28.5
            if (this.data.snapcursorxypostonearest < 1) {
                //this.renderTextInfoLayer(Math.round(parseInt(xPos)*10)/10,Math.round(parseInt(yPos)*10)/10,x,y);
                this.renderTextInfoLayer(xPos,yPos,x,y);
            } else {
                this.renderTextInfoLayer(Math.round(parseInt(xPos)/this.data.snapcursorxypostonearest)*this.data.snapcursorxypostonearest,Math.round(parseInt(yPos)/this.data.snapcursorxypostonearest)*this.data.snapcursorxypostonearest,x,y);
            }
            */
        }
    };
    
    OU.activity.GraphUserPlotLineActivity.prototype.clearFeedbackTimeout = function(){
        //console.log(this.buttonSubmit.txt);
        //this.buttonSubmit.txt = 'Reset';
        //this.buttonSubmit.render();
        var self = this;
        clearTimeout(this.feedbackTimeout);
        this.feedbackTimeout = setTimeout(function () {
            self.clearFeedback();
        }, this.data.feedbacktext.incorrectsecstimeout*1000);
    }
    OU.activity.GraphUserPlotLineActivity.prototype.clearFeedback = function(){
        this.feedbackText.div.innerHTML = '';
    }
    
    
    OU.activity.GraphUserPlotLineActivity.prototype.renderLineFromUserClickPoints = function() {
        //console.log(this.graphData.userClickPositionsXY);
        this.clickDrawStart = this.data.startuserlinefromlocation.drawafternumcorrectclicks;
        var ctx = this.lineMoveLayer.context;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.translate(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
        
        // draw the moveable line
        ctx.strokeStyle=this.data.linemovecolour;
        ctx.lineWidth=2;
        ////console.log(this.graphData.userClickPositionsXY);
        if (this.graphData.userClickPositionsXY.length > this.clickDrawStart || (this.graphData.userClickPositionsXY.length == this.clickDrawStart && !this.data.startuserlinefromlocation.yes)) {
            if (!this.data.showverticalbars) {
                for (i=1; i<this.graphData.userClickPositionsXY.length; i++) {
                    var xValMoveTo = this.graphData.userClickPositionsXY[i-1][0]*this.scaleFactorX;
                    var xValLineTo = this.graphData.userClickPositionsXY[i][0]*this.scaleFactorX;
                    var yValMoveTo = this.graphData.userClickPositionsXY[i-1][1]*this.scaleFactorY;
                    var yValLineTo = this.graphData.userClickPositionsXY[i][1]*this.scaleFactorY;
                    //-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactor*1.1)/this.scaleFactor
                    ctx.beginPath();
                    ctx.moveTo(xValMoveTo,-yValMoveTo);
                    ctx.lineTo(xValLineTo,-yValLineTo);
                    ctx.stroke();
                ////console.log(yValMoveTo+','+(-yValLineTo));
                }
            }
            clearTimeout(this.feedbackTimeout);
            this.feedbackText.div.innerHTML = this.data.feedbacktext.displaycorrect;
            // enable the reset button
            this.buttonSubmit.enable();
            // set boolean activityIsActive to false to that the user can't add anymore dots and get anymore feedback
            this.activityIsActive = false;
        }
        
        //
        var ctxPoints = this.pointsLayer.context;
        ctxPoints.save();
        ctxPoints.clearRect(0, 0, this.w, this.h);
        ctxPoints.translate(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
        if (this.data.startuserlinefromlocation.yes) {
            var iVal = 1;
        } else {
            var iVal = 0;
        }
        for (i=iVal; i<this.graphData.userClickPositionsXY.length; i++) {
            ////console.log(this.graphData.userClickPositionsXY[i]);
            var ctxPoints = this.pointsLayer.context;
            ctxPoints.beginPath();
            ctxPoints.arc(this.graphData.userClickPositionsXY[i][0]*this.scaleFactorX, -this.graphData.userClickPositionsXY[i][1]*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
            //ctxPoints.arc(Math.round(x/5)*5, Math.round(y/5)*5, 3, 0, 2 * Math.PI, false);
            ctxPoints.fillStyle = "#000000";
            ctxPoints.fill();
            ctxPoints.lineWidth = 1;
            ctxPoints.strokeStyle = "black";
            ctxPoints.stroke();
            if (this.data.showverticalbars) {
                ctx.lineWidth=20;
                ctx.beginPath();
                ctx.moveTo(this.graphData.userClickPositionsXY[i][0]*this.scaleFactorX,-this.data.yaxis.start);
                ctx.lineTo(this.graphData.userClickPositionsXY[i][0]*this.scaleFactorX,-this.graphData.userClickPositionsXY[i][1]*this.scaleFactorY);
                ctx.stroke();
            }
        }
        ctx.restore();
        ctxPoints.restore();
    }
    
    OU.activity.GraphUserPlotLineActivity.prototype.renderTextInfoLayer = function(xPos,yPos,x,y) {
        var ctx = this.textInfoLayer.context;
        
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        
        if (xPos>=this.data.xaxis.start && xPos<=this.data.xaxis.end && yPos>=this.data.yaxis.start && yPos<=this.data.yaxis.end){
            var message = xPos + ", " + yPos;
            ctx.fillText(message,x-2,y-5); 
        }
        
        ctx.restore();
    };
    OU.activity.GraphUserPlotLineActivity.prototype.render = function() {
        var ctx = this.graphLayer.context;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.translate(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
        this.renderAxis();
        ctx.textAlign = 'center';
        ctx.font='14px Arial';
        ctx.fillText(this.data.xaxis.label,(this.data.xaxis.end/2)*this.scaleFactorX,40);
        ctx.rotate(-0.5*Math.PI);
        ctx.fillText(this.data.yaxis.label ,(this.data.yaxis.end/2)*this.scaleFactorY,-50);
        ctx.restore();
        this.buttonSubmit.render();
        this.renderLineFromUserClickPoints();
    };
    
    OU.activity.GraphUserPlotLineActivity.prototype.renderAxis = function() {
        var ctx = this.graphLayer.context;
        var gd = this.graphData;
        ctx.strokeStyle='#000000';
        ctx.lineWidth=2;
        // draw the y axis
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(0, - this.data.yaxis.end*this.scaleFactorY);
        ctx.stroke();
        // draw the y axis
        ctx.beginPath();
        ctx.moveTo(0, 0);
        ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, 0);
        ctx.stroke();
        // draw the y axis markers and text labels
        ctx.textAlign = 'right';
        ctx.font='12px Arial';
        var labelOddEven = 0;
        for(var i= this.data.yaxis.start; i<=this.data.yaxis.end; i+= this.data.yaxis.interval){
            // the y axis markers
            labelOddEven++;
            ctx.beginPath();
            ctx.moveTo(0, -i*this.scaleFactorY);
            ctx.strokeStyle='#000000';
            ctx.lineWidth=2;
            ctx.lineTo(-10, -i*this.scaleFactorY);
            ctx.stroke();
            // the yaxis labels
            //ctx.fillText(i,-12,-i*this.scaleFactorY);
            switch(this.data.yaxis.markerlabels) {
                case 'all':
                    //console.log(labelOddEven%2 == 1);
                    ctx.fillText(i,-12,-i*this.scaleFactorY);
                    break;
                case 'odd':
                    if (labelOddEven%2 == 1) {
                        ctx.fillText(i,-12,-i*this.scaleFactorY);
                    }
                    break;
                case 'even':
                    if (labelOddEven%2 == 0) {
                        ctx.fillText(i,-12,-i*this.scaleFactorY);
                    }
                    break;
            }
            // draw the horizontal grid lines
            if (i>0){
                ctx.beginPath();
                ctx.moveTo(0, -i*this.scaleFactorY);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -i*this.scaleFactorY);
                // in between vertical gris lines
                ctx.moveTo(0, -i*this.scaleFactorY + (this.data.yaxis.interval/2)*this.scaleFactorY);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -i*this.scaleFactorY + (this.data.yaxis.interval/2)*this.scaleFactorY);
                ctx.stroke();
            }
        }
        // draw the x axis markers and text labels
        ctx.textAlign = 'center';
        labelOddEven = 0;
        for(var i= this.data.xaxis.start; i<=this.data.xaxis.end; i+= this.data.xaxis.interval){
            labelOddEven++;
            // the x axis markers
            ctx.beginPath();
            ctx.moveTo(i*this.scaleFactorX, 0);
            ctx.strokeStyle='#000000';
            ctx.lineWidth=2;
            ctx.lineTo(i*this.scaleFactorX, 10);
            ctx.stroke();
            // the x axis labels
            //ctx.fillText(i,i*this.scaleFactorX,20);
            switch(this.data.xaxis.markerlabels) {
                case 'all':
                    //console.log(labelOddEven%2 == 1);
                    ctx.fillText(i,i*this.scaleFactorX,20);
                    break;
                case 'odd':
                    if (labelOddEven%2 == 1) {
                        ctx.fillText(i,i*this.scaleFactorX,20);
                    }
                    break;
                case 'even':
                    if (labelOddEven%2 == 0) {
                        ctx.fillText(i,i*this.scaleFactorX,20);
                    }
                    break;
            }
            // draw the vertical grid lines
            if (i>0){
                ctx.beginPath();
                ctx.moveTo(i*this.scaleFactorX, 0);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(i*this.scaleFactorX, -this.data.yaxis.end*this.scaleFactorY);
                // in between vertical gris lines
                ctx.moveTo(i*this.scaleFactorX - (this.data.xaxis.interval/2)*this.scaleFactorX, 0);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(i*this.scaleFactorX - (this.data.xaxis.interval/2)*this.scaleFactorX, -this.data.yaxis.end*this.scaleFactorY);
                ctx.stroke();
            }
        }
        // draw all the fixed lines
        for (var y=0; y<this.data.lines.length; y++) {
            ctx.strokeStyle=this.data.linecolours[y];
            ctx.lineWidth=2;
            ctx.beginPath();
            ctx.moveTo(this.data.lines[y][0].x*this.scaleFactorX,-this.data.lines[y][0].y*this.scaleFactorY);
            for(var i=1; i<this.data.lines[y].length; i++) {
                ctx.lineTo(this.data.lines[y][i].x*this.scaleFactorX,-this.data.lines[y][i].y*this.scaleFactorY);
            }
            ctx.stroke();
        }
        // add any desired labels to the graph
        ctx.textAlign = 'left';
        //console.log(this.data.graphlabels.length);
        for (var i=0; i<this.data.graphlabels.length; i++) {
            ctx.fillText(this.data.graphlabels[i].text,this.data.graphlabels[i].x*this.scaleFactorX,-this.data.graphlabels[i].y*this.scaleFactorY);            
        }
        
        
    };
    
    
    
    OU.activity.GraphUserPlotLineActivity.prototype.checkPositionOfMovedLine = function() {
    }
    /**
     * accessibleView - this function is called instead of canvasView if the browser does not support HTML5 canvas
     */
    OU.activity.GraphUserPlotLineActivity.prototype.accessibleView = function() {
        OU.activity.GraphUserPlotLineActivity.superClass_.accessibleView.call(this); // call the superclass method is you want to extend it, remove this line to override the method instead

    // Note this function can be removed or commented out if you want to use the default accessibleView method

    // *Your code starts here*
    };
    /**
     * resize - called whenever the outer bounds of the activity change, ie when the browser window is resized, or a mobile device is rotated.
     *
     * This function should do the following:
     * <ul>
     * <li>Resize all visible elements</li>
     * <li>Re-layout all visible elements</li>
     * <li>Actually re-render the current view of the activity</li>
     * </ul>
     */
    OU.activity.GraphUserPlotLineActivity.prototype.resize = function() {
        OU.activity.GraphUserPlotLineActivity.superClass_.resize.call(this); // call the superclass resize

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        if (this.h > this.w){
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
        } else {
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
        }
        //this.graphLayer.resize({x:0,y:0,w:this.w,h:this.h});
        // this.lineMoveLayer.resize({x:0,y:0,w:this.w,h:this.h});
        this.textInfoLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.pointsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.labelsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        // work out the scaleFactor for sizing and rendering everything
        /*
        var yscale = (this.graphLayer.h * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        var xscale = (this.graphLayer.w * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
        if (yscale > xscale) {
            this.scaleFactor = xscale;
        } else {
            this.scaleFactor = yscale;
        }
        */
        // work out the scaleFactor for sizing and rendering everything
        /** //////////////////////////////////////////////////////////////////////////////////////////////////////////
         *  Different scaleFactors for X and Y so that axis can have different max values,
         *  such as Y 0 - 1500, X 0 - 1.2 */
        if (this.graphLayer.h > this.graphLayer.w) {
            this.scaleFactorX = (this.graphLayer.w * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
            this.scaleFactorY = (this.graphLayer.w * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        } else {
            this.scaleFactorX = (this.graphLayer.h * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
            this.scaleFactorY = (this.graphLayer.h * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        }
        /** //////////////////////////////////////////////////////////////////////////////////////////////////////////*/
        
        // reposition the button layer
        this.buttonsLayer.resize({
            x:this.data.xaxis.end*this.scaleFactorX,
            y:(this.data.yaxis.end*this.scaleFactorY)+(this.data.yaxis.end*this.scaleFactorY*0.2)-10,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        this.feedbackText.resize({
            x:30,
            y:(this.data.yaxis.end*this.scaleFactorY)+(this.data.yaxis.end*this.scaleFactorY*0.2)+this.data.submitbutton.h,
            w:this.w-60,
            h:40
        });
        this.render();
    //
    };

    /**
     * remove - called when the activity is being removed by a controller.
     *
     * This function should do the following:
     * <ul>
     * <li> Remove any elements that may remain in memory</li>
     * <li> Stop any animation loops, including killing any Intervals </li>
     * </ul>
     * You do not need to remove most library elements, such as Layers, Divs, etc. as they are removed automatically
     */
    OU.activity.GraphUserPlotLineActivity.prototype.remove = function() {
        OU.activity.GraphUserPlotLineActivity.superClass_.remove.call(this); // call the superclass remove

    // *Your removal code here*
    // If you have nothing to remove, then this function can be deleted or commented out
    };

    // call the superclass's constructor
    OU.base(this,data,instance,controller);
};
// Call our inherits function to implement the class inheritance
OU.inherits(OU.activity.GraphUserPlotLineActivity,OU.util.Activity);
