/**
 * @fileOverview Audio - Simple audio activity
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

OU.require('OU.util.Instruction');
OU.require('OU.util.Div');
OU.require('OU.util.Layer');
/** 
 * @class
 * @extends OU.util.Activity
 */
OU.activity.Audio = function(data,instance,controller) {

    OU.activity.Audio.prototype.canvasView = function() {
        this.bgLayer = new OU.util.Layer({
            container:this,
            hasEvents: true
        });
        this.bgLayer.context.gradRect(); // draw background on backdrop layer

        this.initAudio();
    };
    OU.activity.Audio.prototype.resize = function() {
        OU.activity.Audio.superClass_.resize.call(this); // call the parent class resize        
        var a = document.getElementById('_audio_'+this.instance);

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        this.audioDiv.resize({
            x: this.x,
            y: this.y,
            w: this.w,
            h: this.h
        });
        a.setAttribute("width", this.w);
        a.setAttribute("height", this.h);
    };
    OU.activity.Audio.prototype.initAudio = function() {
        var i,h,audio = this.data.audio,
        vW=this.w,vH=this.h;

        this.audioDiv = new OU.util.Div({
            x:this.x,
            y:this.y,
            w:vW,
            h:vH,
            container: this
        });

        h="<audio id='_audio_"+this.instance+"' controls='controls'>";
        for(i=audio.sources.length; i--;) {
            h = h + "<source src='"+this.dataDir+audio.sources[i].src+"' type='"+audio.sources[i].type+"' />";
        }
        h = h+ "Your browser does not support HTML5 audio. Please use a browser that does.</audio>";

        this.audioDiv.div.innerHTML=h;

        this.audio = document.getElementById('_audio_'+this.instance);
        if(OU.IS_IPAD) {
            new OU.util.Instruction({
                container: this,
                message: "Please start audio playback when you are ready.",
                duration: 2000
            });
        }
        else {
            this.audio.play();
        }
    };

    OU.base(this,data,instance,controller);
};
OU.inherits(OU.activity.Audio,OU.util.Activity);

