/**
 * @fileOverview A Carbon Calculator, ported to HTML5 from original flash source...
 *
 *  \\esaki\LTS-MCT_Courses_ECM\U116\IMD\quickcalculatorfinal-v5
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Div');
OU.require('OU.util.ImageLoader');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.CarbonCalc = function ( data, instance, controller ) {
    OU.activity.CarbonCalc.prototype.canvasView = function () {
        var self = this;
        this.Constants = {
            UKpersh:1.13367,
            UKperhw:0.44229,
            UKperdla:0.74259,
            UKperinfra:1.836,
            UKfoot:"12.4",
            UKinfra:"3.0",
            UKgoods:"2.4",
            UKfood:"2.9",
            UKtravel:"1.8",
            UKhouse:"2.3",
            UKTarget:"10.0"
        };
        this.footprint = {
            house:0,
            travel:0,
            food:0,
            goods:0,
            infra:0,
            total:0
        };
        this.currentFootprint = {
            house:0,
            travel:0,
            food:0,
            goods:0,
            infra:0,
            total:0
        };
        this.answers = [];
        this.questionNum = 1;
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.infoLayer = new OU.util.Layer({
            container:this
        });
        this.progressLayer = new OU.util.Layer({
            container:this,
            y:this.h - 150,
            h:150
        });
        this.progressLayer.context.lineWidth = 2;
        this.progressLayer.context.strokeStyle = '#fff';
        this.progressLayer.context.fillStyle = '#fff';
        this.questionNum = 1;
        this.questionDiv = new OU.util.Div({
            x:this.x + this.w / 2,
            y:this.y + 150,
            w:this.w / 2 - 40,
            h:this.h - 300,
            container:this
        });
        this.imageLoader = new OU.util.ImageLoader({
            container:this,
            data:this.data,
            onLoad:function () {
                self.resize();
                self.renderQuestion();
            }
        });
    };
    OU.activity.CarbonCalc.prototype.resize = function () {
        OU.activity.CarbonCalc.superClass_.resize.call(this); // call the parent class resize    
        var bctx = this.bgLayer.context;
        this.bgLayer.resize();
        bctx.gradRect();
        if (this.data.background.image!==undefined)
            bctx.drawImage(this.data.background.image, this.x, this.y, this.w, this.h);
        this.infoLayer.resize();
        this.infoLayer.context.font = 'bold 12px ' + OU.theme.font;
        this.progressLayer.resize({
            y:this.h - 150,
            h:150
        });
        this.questionDiv.resize({
            x:this.x + this.w / 2,
            y:this.y + 150,
            w:this.w / 2 - 40,
            h:this.h - 300
        });
        bctx.background({
            col:'rgba(255,255,255,0.4)',
            radius:20
        }, {
            x:this.x + this.w / 2,
            y:this.y + 150,
            w:this.w / 2 - 40,
            h:this.h - 300
        });
        bctx.background({
            col:'rgba(255,255,255,0.4)',
            radius:20
        }, {
            x:40,
            y:this.y + 150,
            w:this.w / 2 - 80,
            h:this.h - 300
        });
        new OU.util.DynText({
            txt:this.data.title,
            x:this.x,
            y:this.y,
            w:this.w,
            h:150,
            fontSize:60,
            context:bctx,
            colour:'rgba(255,255,255,0.9)',
            align:'left'
        });
        this.calcFootprint();
        this.renderProgress();
        this.renderBarChart();
    };
    OU.activity.CarbonCalc.prototype.render = function () {
        this.calcFootprint();
        this.renderProgress();
        this.renderBarChart();
        this.renderQuestion();
    };
    OU.activity.CarbonCalc.prototype.questionColour = function ( q ) {
        var c = this.data.colours;
        if (q < 10)
            return c[0]; // Home
        if (q < 15)
            return c[1]; // Transport
        if (q < 17)
            return c[2]; // Food
        if (q < 19)
            return c[3]; // Goods
        return c[4]; // Infra
    };
    OU.activity.CarbonCalc.prototype.renderProgress = function () {
        var n = 18, h = 75, l = this.w - 100, ctx = this.progressLayer.context,
            i, c = Math.PI * 2, q = this.questionNum, r;
        ctx.clearRect(0, 0, this.w, this.h);
        if (q > 18)
            return;
        ctx.beginPath();
        ctx.lineWidth = 2;
        ctx.strokeStyle = '#fff';
        ctx.fillStyle = '#fff';
        ctx.moveTo(50, h);
        ctx.lineTo(this.w - 50, h);
        ctx.stroke();
        for (i = n; i--;) {
            ctx.fillStyle = this.questionColour(i + 1);
            if (i < q) {
                r = 10;
            }
            else {
                r = 5;
                //                ctx.fillStyle='#fff';
            }
            ctx.beginPath();
            ctx.arc(50 + i * (l / (n - 1)), h, r, 0, c, false);
            ctx.fill();
        }
        ctx.beginPath();
        ctx.fillStyle = this.questionColour(q);
        ctx.arc(50 + (q - 1) * (l / (n - 1)), h, r, 0, c, false);
        ctx.fill();
        ctx.stroke();
    };
    OU.activity.CarbonCalc.prototype.renderBarChart = function () {
        var ctx = this.infoLayer.context, self = this,
            newStack, newYouStack, tStack, oldTStack, mid,
            fills = this.data.colours,
            fp = this.currentFootprint,
            tfp = this.footprint,
            base = this.h - 225,
            aW = this.w / 2 - 80,
            ukX = 40 + aW / 12,
            youX = 40 + 4.5 * aW / 6,
            bW = aW / 6,
            stack, youStack,
            max = fp.total * 1.2, // (((fp.total*1.2) / 5)| 0)*5, //TODO calc max
            scale = (base - 175) / max;
        if (max < 15) {
            max = 15;
            scale = (base - 175) / max;
        }
        else if (max < fp.total) {
            max = max + 5;
            scale = (base - 175) / max;
        }
        this.infoLayer.clear();
        ctx.globalAlpha = 1;
        ctx.fillStyle = '#000';
        ctx.textAlign = 'left';
        ctx.fillText('UK Average', ukX, base + 20);
        ctx.textAlign = 'right';
        ctx.fillText('Your footprint', youX + bW, base + 20);
        ctx.textAlign = 'center';
        stack = base;
        youStack = base;
        ctx.beginPath();
        ctx.fillStyle = fills[0];
        ctx.fillRect(ukX, stack - 2.3 * scale, bW, 2.3 * scale);
        ctx.fillStyle = '#000';
        newStack = stack - 2.3 * scale;
        newYouStack = youStack - fp.house * scale;
        oldTStack = tStack = (((newStack + stack) / 2) + ((newYouStack + youStack) / 2)) / 2;
        ctx.globalAlpha = 1;
        ctx.fillText('Home & Energy', ukX + 2.5 * aW / 6, tStack);
        ctx.beginPath();
        ctx.moveTo(ukX + aW / 6, stack);
        ctx.lineTo(ukX + 4 * aW / 6, stack); // - below home
        ctx.stroke();
        if (this.questionNum < 10)  // home
            ctx.globalAlpha = 0.2;
        ctx.beginPath();
        ctx.fillStyle = fills[0];
        ctx.fillRect(youX, youStack - fp.house * scale, bW, fp.house * scale);
        stack = newStack;
        youStack = newYouStack;
        newStack = stack - 1.8 * scale;
        newYouStack = youStack - fp.travel * scale;
        tStack = (((newStack + stack) / 2) + ((newYouStack + youStack) / 2)) / 2;
        mid = (oldTStack + tStack) / 2;
        ctx.moveTo(ukX + aW / 6, stack); //  - above home
        ctx.bezierCurveTo(ukX + 1.5 * aW / 6, stack, ukX + 1.5 * aW / 6, mid, ukX + 2 * aW / 6, mid);
        ctx.lineTo(ukX + 3 * aW / 6, mid);
        ctx.bezierCurveTo(ukX + 3.5 * aW / 6, mid, ukX + 3.5 * aW / 6, youStack, ukX + 4 * aW / 6, youStack);
        ctx.stroke();
        ctx.globalAlpha = 1; //
        ctx.beginPath();
        ctx.fillStyle = fills[1];
        ctx.fillRect(ukX, stack - 1.8 * scale, bW, 1.8 * scale);
        ctx.fillStyle = '#000';
        ctx.fillText('Travel', ukX + 2.5 * aW / 6, tStack);
        if (this.questionNum < 15) // travel
            ctx.globalAlpha = 0.2;
        ctx.beginPath();
        ctx.fillStyle = fills[1];
        ctx.fillRect(youX, youStack - fp.travel * scale, bW, fp.travel * scale);
        stack = newStack;
        youStack = newYouStack;
        oldTStack = tStack;
        newStack = stack - 2.9 * scale;
        newYouStack = youStack - fp.food * scale;
        tStack = (((newStack + stack) / 2) + ((newYouStack + youStack) / 2)) / 2;
        mid = (oldTStack + tStack) / 2;
        ctx.moveTo(ukX + aW / 6, stack); // - above travel
        ctx.bezierCurveTo(ukX + 1.5 * aW / 6, stack, ukX + 1.5 * aW / 6, mid, ukX + 2 * aW / 6, mid);
        ctx.lineTo(ukX + 3 * aW / 6, mid);
        ctx.bezierCurveTo(ukX + 3.5 * aW / 6, mid, ukX + 3.5 * aW / 6, youStack, ukX + 4 * aW / 6, youStack);
        ctx.stroke();
        ctx.globalAlpha = 1;
        ctx.fillStyle = '#000';
        ctx.fillText('Food', ukX + 2.5 * aW / 6, tStack);
        ctx.beginPath();
        ctx.fillStyle = fills[2];
        ctx.fillRect(ukX, stack - 2.9 * scale, bW, 2.9 * scale);
        if (this.questionNum < 17) // food
            ctx.globalAlpha = 0.2;
        ctx.beginPath();
        ctx.fillStyle = fills[2];
        ctx.fillRect(youX, youStack - fp.food * scale, bW, fp.food * scale);
        stack = newStack;
        youStack = newYouStack;
        oldTStack = tStack;
        newStack = stack - 2.4 * scale;
        newYouStack = youStack - fp.goods * scale;
        tStack = (((newStack + stack) / 2) + ((newYouStack + youStack) / 2)) / 2;
        mid = (oldTStack + tStack) / 2;
        ctx.moveTo(ukX + aW / 6, stack); //  above food
        ctx.bezierCurveTo(ukX + 1.5 * aW / 6, stack, ukX + 1.5 * aW / 6, mid, ukX + 2 * aW / 6, mid);
        ctx.lineTo(ukX + 3 * aW / 6, mid);
        ctx.bezierCurveTo(ukX + 3.5 * aW / 6, mid, ukX + 3.5 * aW / 6, youStack, ukX + 4 * aW / 6, youStack);
        ctx.stroke();
        ctx.globalAlpha = 1;
        ctx.fillStyle = '#000';
        ctx.fillText('Goods & Services', ukX + 2.5 * aW / 6, tStack);
        ctx.beginPath();
        ctx.fillStyle = fills[3];
        ctx.fillRect(ukX, stack - 2.4 * scale, bW, 2.4 * scale);
        if (this.questionNum < 19)
            ctx.globalAlpha = 0.2; // goods
        ctx.beginPath();
        ctx.fillStyle = fills[3];
        ctx.fillRect(youX, youStack - fp.goods * scale, bW, fp.goods * scale);
        stack = newStack;
        youStack = newYouStack;
        oldTStack = tStack;
        newStack = stack - 3 * scale;
        newYouStack = youStack - fp.infra * scale;
        tStack = (((newStack + stack) / 2) + ((newYouStack + youStack) / 2)) / 2;
        mid = (oldTStack + tStack) / 2;
        ctx.moveTo(ukX + aW / 6, stack);
        ctx.bezierCurveTo(ukX + 1.5 * aW / 6, stack, ukX + 1.5 * aW / 6, mid, ukX + 2 * aW / 6, mid);
        ctx.lineTo(ukX + 3 * aW / 6, mid);
        ctx.bezierCurveTo(ukX + 3.5 * aW / 6, mid, ukX + 3.5 * aW / 6, youStack, ukX + 4 * aW / 6, youStack);
        ctx.stroke();
        ctx.beginPath();
        ctx.fillStyle = fills[4];
        ctx.fillRect(youX, youStack - fp.infra * scale, bW, fp.infra * scale);
        ctx.globalAlpha = 1;
        ctx.beginPath();
        ctx.fillStyle = fills[4];
        ctx.fillRect(ukX, stack - 3 * scale, bW, 3 * scale);
        ctx.fillStyle = '#000';
        ctx.fillText('Government & Industry', ukX + 2.5 * aW / 6, tStack);
        stack = newStack;
        youStack = newYouStack;
        if (this.questionNum < 19)
            ctx.globalAlpha = 0.2; // goods
        mid = (stack + youStack) / 2;
        ctx.moveTo(ukX + aW / 6, stack);
        ctx.bezierCurveTo(ukX + 1.5 * aW / 6, stack, ukX + 1.5 * aW / 6, mid, ukX + 2 * aW / 6, mid);
        ctx.lineTo(ukX + 3 * aW / 6, mid);
        ctx.bezierCurveTo(ukX + 3.5 * aW / 6, mid, ukX + 3.5 * aW / 6, youStack, ukX + 4 * aW / 6, youStack);
        ctx.stroke();
        stack = newStack;
        youStack = newYouStack;
        ctx.globalAlpha = 1;
        ctx.fillStyle = '#000';
        ctx.textAlign = 'left';
        ctx.fillText('12.4', ukX, stack - 20);
        ctx.textAlign = 'right';
        ctx.fillText(fp.total.nDecimals(1), youX + bW, youStack - 20);
        if (fp.total!=tfp.total) {
            if (Math.abs(fp.total - tfp.total) < 0.01) { // if close then make equal to stop pointless loops
                fp.house = tfp.house;
                fp.travel = tfp.travel;
                fp.food = tfp.food;
                fp.goods = tfp.goods;
                fp.infra = tfp.infra;
                fp.total = tfp.total;
            }
            else {
                fp.house = fp.house + (tfp.house - fp.house) / 10;
                fp.travel = fp.travel + (tfp.travel - fp.travel) / 10;
                fp.food = fp.food + (tfp.food - fp.food) / 10;
                fp.goods = fp.goods + (tfp.goods - fp.goods) / 10;
                fp.infra = fp.infra + (tfp.infra - fp.infra) / 10;
                fp.total = fp.house + fp.food + fp.travel + fp.goods + fp.infra;
            }
            setTimeout(function () {
                self.renderBarChart();
            }, 40);
        }
    };
    OU.activity.CarbonCalc.prototype.answerQuestion = function () {
        switch(this.questionNum) {
            case 1:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 15:
            case 16:
                this.answers[this.questionNum] = this.radioValue(document.forms[0].radinput);
                break;
            case 2:
            case 8:
            case 9:
            case 10:
            case 11:
            case 12:
            case 13:
            case 14:
            case 17:
            case 18:
                this.answers[this.questionNum] = document.getElementById('textval').value;
                break;
        }
        this.questionNum++;
        this.render();
    };
    OU.activity.CarbonCalc.prototype.radioValue = function ( buttonGroup ) {
        var i;
        if (buttonGroup[0]) { // if the button group is an array (one button is not an array)
            for (i = buttonGroup.length; i--;) {
                if (buttonGroup[i].checked)
                    return buttonGroup[i].value;
            }
        }
        if (buttonGroup.checked)
            return buttonGroup.value;
        return "0";
    };
    OU.activity.CarbonCalc.prototype.prevQuestion = function () {
        this.questionNum--;
        if (this.questionNum < 1)
            this.questionNum = 1;
        this.render();
    };
    OU.activity.CarbonCalc.prototype.renderQuestion = function () {
        var fp = this.footprint, h = "<form><div style='background:transparent; height: " + (this.h / 2) + "px; padding-top: 20px;'>";
        switch(this.questionNum) {
            case 1: // house type
                h = h + "<p><strong>1. What type of home do you live in?</strong></p>";
                h = h + "<p><input type='radio' name='radinput' id='rad1' value='0' checked='checked' /><label for='rad1'>Flat or maisonette</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad2' value='1' /><label for='rad2'>Mid-terrace house</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad3' value='2' /><label for='rad3'>Semi-detached or end-of-terrace house</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad4' value='3' /><label for='rad4'>Detached house</label><br/></p>";
                break;
            case 2: // occupancy
                h = h + "<p><strong>2. How many people (adults and children) live in your household?</strong></p>";
                h = h + "<p>It doesn't have to be a whole number, for example if some are not resident all the time.</p><p>Include long-term visitors and/or lodger(s). (UK average is 2.3)</p>";
                h = h + "<p><input type='text' id='textval' /> occupants<br/></p>";
                break;
            case 3: // main fuel type
                h = h + "<p><strong>3. What <strong>main</strong> fuel do you use to heat the rooms?</strong></p>";
                h = h + "<p><input type='radio' name='radinput' id='rad1' value='0' checked='checked' /><label for='rad1'>Mains gas</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad2' value='1' /><label for='rad2'>Bulk LPG or bottled gas</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad3' value='2' /><label for='rad3'>Oil</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad4' value='3' /><label for='rad4'>Coal</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad5' value='4' /><label for='rad5'>Electricity</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad6' value='5' /><label for='rad6'>Green-tariff electricity</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad7' value='6' /><label for='rad7'>Wood</label><br/></p>";
                break;
            case 4: // additional fuel type
                h = h + "<p><strong>4. Do you use any additional fuel to heat the rooms?</strong></p>";
                h = h + "<p><input type='radio' name='radinput' id='rad1' value='0' checked='checked' /><label for='rad1'>None</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad2' value='1' /><label for='rad2'>Mains gas</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad3' value='2' /><label for='rad3'>Bulk LPG or bottled gas</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad4' value='3' /><label for='rad4'>Oil</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad5' value='4' /><label for='rad5'>Coal</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad6' value='5' /><label for='rad6'>Electricity</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad7' value='6' /><label for='rad7'>Green-tariff electricity</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad8' value='7' /><label for='rad8'>Wood</label><br/></p>";
                break;
            case 5: // hot water fuel
                h = h + "<p><strong>5. What <strong>main</strong> fuel do you use to heat the <strong>hot water</strong>?</strong></p>";
                h = h + "<p><input type='radio' name='radinput' id='rad1' value='0' checked='checked' /><label for='rad1'>Mains gas</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad2' value='1' /><label for='rad2'>Bulk LPG or bottled gas</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad3' value='2' /><label for='rad3'>Oil</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad4' value='3' /><label for='rad4'>Coal</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad5' value='4' /><label for='rad5'>Electricity</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad6' value='5' /><label for='rad6'>Green-tariff electricity</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad7' value='6' /><label for='rad7'>Wood</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad8' value='7' /><label for='rad8'>Solar</label><br/></p>";
                break;
            case 6: // additional water fuel type
                h = h + "<p><strong>6. Do you use any additional fuel to heat the hot water?</strong></p>";
                h = h + "<p><input type='radio' name='radinput' id='rad1' value='0' checked='checked' /><label for='rad1'>None</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad2' value='1' /><label for='rad2'>Mains gas</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad3' value='2' /><label for='rad3'>Bulk LPG or bottled gas</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad4' value='3' /><label for='rad4'>Oil</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad5' value='4' /><label for='rad5'>Coal</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad6' value='5' /><label for='rad6'>Electricity</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad7' value='6' /><label for='rad7'>Green-tariff electricity</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad8' value='7' /><label for='rad8'>Wood</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad9' value='8' /><label for='rad9'>Solar</label><br/></p>";
                break;
            case 7: // Build age
                h = h + "<p><strong>7. Choose the closest description of your home.</strong></p>";
                h = h + "<p><input type='radio' name='radinput' id='rad1' value='0' checked='checked' /><label for='rad1'>Built before 1991, no energy-saving measures</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad2' value='1' /><label for='rad2'>Built before 1991, some insulation and/or double glazing</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad3' value='2' /><label for='rad3'>Built before 1991, extra wall insulation, double glazing and draughtproofing throughout</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad4' value='3' /><label for='rad4'>Built 1991-2002; no additional insulation</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad5' value='4' /><label for='rad5'>Built 1991-2002; improved insulation</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad6' value='5' /><label for='rad6'>Built after 2002</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad7' value='6' /><label for='rad7'>Designed super-insulated eco-house</label><br/></p>";
                break;
            case 8: // number of rooms
                h = h + "<p><strong>8. How many living, dining and bedrooms does your household occupy?</strong></p>";
                h = h + "<p> It doesn't have to be a whole number, for example, if some rooms are only partly occupied. (UK average is between 5 and 6.)</p>";
                h = h + "<p><input type='text' id='textval' /> rooms<br/></p>";
                break;
            case 9: // Household greeness
                h = h + "<p><strong>9. How well do the members of your household manage their energy use?</strong></p>";
                h = h + "<p>Give yourselves a score out of ten for energy management. Where 1 is highly wasteful and 10 is highly economical household energy practices.</p>";
                h = h + "<p><select id='textval' /><option value='0'>1</option><option value='1'>2</option><option value='2'>3</option><option value='3'>4</option><option value='4'>5</option><option value='5'>6</option><option value='6'>7</option><option value='7'>8</option><option value='8'>9</option><option value='9'>10</option></select><br/></p>";
                break;
            case 10: // miles per year
                h = h + "<p><strong>10. Approximately how much car travel do you do a YEAR, as passenger or driver?</strong></p>";
                h = h + "<p>Include commuting to and from work, social, domestic and leisure trips.</p>";
                h = h + "<p><strong>Exclude</strong> car travel for business or work.</p>";
                h = h + "<p>To convert kilometres to miles divide by 1.61 (e.g. 8000 km = 4969 miles)</p>";
                h = h + "<p><input type='text' id='textval' /> miles per year<br/></p>";
                break;
            case 11: // Car occupancy
                h = h + "<p><strong>11. Estimate the average number of people in the car during your car journeys.</strong></p>";
                h = h + "<p>It doesn't have to be a whole number. (UK average for non-business trips is 1.6.)</p>";
                h = h + "<p><input type='text' id='textval' /> occupants<br/></p>";
                break;
            case 12: // public transport
                h = h + "<p><strong>12. Approximately how many hours a MONTH do you <em>routinely</em> travel on public transport? </strong></p>";
                h = h + "<p>Include commuting to and from work, social, domestic and leisure trips. (UK average is approximately 4.5 hours per month.) </p>";
                h = h + "<p><strong>Exclude</strong> business travel and <em><strong>all flying</strong></em>.</p>";
                h = h + "<p><input type='text' id='textval' /> hours per month<br/></p>";
                break;
            case 13: // trains, coach or ship
                h = h + "<p><strong>13. For <em>non-routine</em> trips and visits and holidays, approximately how many hours per YEAR do you travel by train, coach or ship?</strong></p>";
                h = h + "<p><strong>Exclude</strong> business travel.</p>";
                h = h + "<p><input type='text' id='textval' /> hours per year<br/></p>";
                break;
            case 14: // flights
                h = h + "<p><strong>14. For holidays, trips and visits, approximately how many hours flying do you do per YEAR?</strong></p>";
                h = h + "<p><strong>Exclude</strong> flights for business or work. </p>";
                h = h + "<p><input type='text' id='textval' /> hours per year<br/></p>";
                break;
            case 15: // diet
                h = h + "<p><strong>15. What is the closest description of your usual diet?</strong></p>";
                h = h + "<p><input type='radio' name='radinput' id='rad1' value='0' checked='checked' /><label for='rad1'>No animal products at all</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad2' value='1' /><label for='rad2'>Small/occassional amounts of meat, fish and dairy</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad3' value='2' /><label for='rad3'>No meat, moderate amounts of eggs and dairy, little or no fish</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad4' value='3' /><label for='rad4'>No meat, generous amounts of eggs and dairy, little or no fish</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad5' value='4' /><label for='rad5'>Moderate amounts of meat,fish or dairy at many/most meals</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad6' value='5' /><label for='rad6'>High meat consumption, mostly pork and chicken</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad7' value='6' /><label for='rad7'>High meat consumption, mostly beef or lamb</label><br/></p>";
                break;
            case 16: // processed food
                h = h + "<p><strong>16. How much of your food is bought ready-processed?</strong></p>";
                h = h + "<p><input type='radio' name='radinput' id='rad1' value='0' checked='checked' /><label for='rad1'>Nearly all meals home made from fresh and/or dried ingredients</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad2' value='1' /><label for='rad2'>Most meals home-made from fresh/dried and processed ingredients</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad3' value='2' /><label for='rad3'>Most meals home-made from mostly processed ingredients</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad4' value='3' /><label for='rad4'>Mostly ready meals, frozen fods, and/or takeaways, some fresh/dried ingredients</label><br/>";
                h = h + "<input type='radio' name='radinput' id='rad5' value='4' /><label for='rad5'>Nearly all ready meals, frozen foods and/or takeaways</label><br/></p>";
                break;
            case 17: // Household income
                h = h + "<p><strong>17. What is the approximate annual income of the whole household, after tax and deductions?</strong></p>";
                h = h + "<p>Choose the amount closest to your household's income. (UK average 2009 household income: approximately £31 000)</p>";
                h = h + "<p><select id='textval' /><option value='0'>2500</option><option value='1'>5,000</option><option value='2'>8,000</option><option value='3'>11,000</option><option value='4'>14,000</option><option value='5'>17,000</option><option value='6'>20,000</option><option value='7'>23,000</option><option value='8'>26,000</option><option value='9'>29,000</option><option value='10'>32,000</option><option value='11'>36,000</option><option value='12'>40,000</option><option value='13'>45,000</option><option value='14'>50,000</option><option value='15'>60000</option><option value='16'>75,000</option><option value='17'>90,000</option><option value='18'>120,000</option><option value='19'>170,000</option></select><br/></p>";
                break;
            case 18: // Household greeness (services)
                h = h + "<p><strong>18. How 'green' is your household? </strong></p>";
                h = h + "<p>Give yourselves a score out of ten for your usual goods/services spending and consumption practices. Where 1 is very non-green (high emissions) and 10 is very green (low emissions) household spending/consumption.</p>";
                h = h + "<p><select id='textval' /><option value='0'>1</option><option value='1'>2</option><option value='2'>3</option><option value='3'>4</option><option value='4'>5</option><option value='5'>6</option><option value='6'>7</option><option value='7'>8</option><option value='8'>9</option><option value='9'>10</option></select><br/></p>";
                break;
            case 19: // Results
                this.calcFootprint();
                h = h + "<p><strong>Results:</strong></p><table>";
                h = h + "<tr><th>Your results</th><td></td><td>UK Average</tr>";
                h = h + "<tr><th>" + fp.house + "</th><td>Home Energy emissions</td><td>2.3</tr>";
                h = h + "<tr><th>" + fp.travel + "</th><td>Personal Travel emissions</td><td>1.8</td></tr>";
                h = h + "<tr><th>" + fp.food + "</th><td>Personal Food emissions</td><td>2.9</td></tr>";
                h = h + "<tr><th>" + fp.goods + "</th><td>Goods and Services emissions</td><td>2.4</td></tr>";
                h = h + "<tr><th>" + fp.infra + "</th><td>Your share of national emissions</td><td>3.0</td></tr>";
                h = h + "<tr><th>" + fp.total + "</th><th>Your Carbon Footprint<br/>(tonnes CO<sub>2</sub>e per year)</th><td>12.4</td></tr></table>";
                break;
        }
        h = h + "</div><div>";
        if (this.questionNum > 1)
            h = h + "<input type='button' value='Back' onClick='OU.obj[\"" + this.instance + "\"].prevQuestion();' />";
        if (this.questionNum < 19)
            h = h + "<input type='button' value='Next' onClick='OU.obj[\"" + this.instance + "\"].answerQuestion();' />";
        h = h + "</div></form>";
        this.questionDiv.div.innerHTML = h;
    };
    OU.activity.CarbonCalc.prototype.calcFootprint = function () {
        var processedData = this.calculateValues(this.answers),
            fp = this.footprint;
        fp.house = this.calculateHouse(processedData).nDecimals(2);
        fp.travel = this.calculateTravel(processedData).nDecimals(2);
        fp.food = this.calculateFood(processedData).nDecimals(2);
        fp.goods = this.calculateGoods(processedData, this.answers).nDecimals(2);
        fp.infra = this.calculateInfra(processedData, this.answers).nDecimals(2);
        fp.total = fp.house + fp.food + fp.travel + fp.goods + fp.infra;
        fp.total = fp.total.nDecimals(2);
    };
    OU.activity.CarbonCalc.prototype.calculateValues = function ( dataArray ) {
        var myValues = [];
        switch(dataArray[1]) {
            case "0" :
                myValues[1] = 0.58;
                break;
            case "1" :
                myValues[1] = 0.76;
                break;
            case "2" :
                myValues[1] = 1.0;
                break;
            case "3" :
                myValues[1] = 1.3;
                break;
        }
        myValues[2] = dataArray[2];
        myValues[2] = Math.pow(myValues[2], -0.61) * 102 / 61;
        switch(dataArray[3]) {
            case "0" :
                myValues[3] = 0.9;
                break;
            case "1" :
                myValues[3] = 1.0;
                break;
            case "2" :
                myValues[3] = 1.25;
                break;
            case "3" :
                myValues[3] = 1.8;
                break;
            case "4" :
                myValues[3] = 2.2;
                break;
            case "5" :
                myValues[3] = 1.8;
                break;
            case "6" :
                myValues[3] = 0.125;
                break;
        }
        myValues[3] = myValues[3] * 0.85;
        switch(dataArray[4]) {
            case "0" :
                myValues[4] = myValues[3] / 0.85;
                break;
            case "1" :
                myValues[4] = 0.9;
                break;
            case "2" :
                myValues[4] = 1.0;
                break;
            case "3" :
                myValues[4] = 1.25;
                break;
            case "4" :
                myValues[4] = 1.8;
                break;
            case "5" :
                myValues[4] = 2.2;
                break;
            case "6" :
                myValues[4] = 1.8;
                break;
            case "7" :
                myValues[4] = 0.125;
                break;
        }
        myValues[4] = myValues[4] * 0.15;
        switch(dataArray[5]) {
            case "0" :
                myValues[5] = 0.9;
                break;
            case "1" :
                myValues[5] = 1.0;
                break;
            case "2" :
                myValues[5] = 1.25;
                break;
            case "3" :
                myValues[5] = 1.8;
                break;
            case "4" :
                myValues[5] = 2.2;
                break;
            case "5" :
                myValues[5] = 1.8;
                break;
            case "6" :
                myValues[5] = 0.125;
                break;
            case "7" :
                myValues[5] = 0.1;
                break;
        }
        myValues[5] = myValues[5] * 0.7;
        switch(dataArray[6]) {
            case "0" :
                myValues[6] = myValues[5] / 0.7;
                break;
            case "1" :
                myValues[6] = 0.9;
                break;
            case "2" :
                myValues[6] = 1.0;
                break;
            case "3" :
                myValues[6] = 1.25;
                break;
            case "4" :
                myValues[6] = 1.8;
                break;
            case "5" :
                myValues[6] = 2.2;
                break;
            case "6" :
                myValues[6] = 1.8;
                break;
            case "7" :
                myValues[6] = 0.125;
                break;
            case "8" :
                myValues[6] = 0.1;
                break;
        }
        myValues[6] = myValues[6] * 0.3;
        switch(dataArray[7]) {
            case "0" :
                myValues[7] = 1.6;
                break;
            case "1" :
                myValues[7] = 1.3;
                break;
            case "2" :
                myValues[7] = 1.0;
                break;
            case "3" :
                myValues[7] = 0.8;
                break;
            case "4" :
                myValues[7] = 0.7;
                break;
            case "5" :
                myValues[7] = 0.6;
                break;
            case "6" :
                myValues[7] = 0.2;
                break;
        }
        myValues[8] = 0.131 * dataArray[8] + 0.3;
        myValues[9] = (11 - (1 * dataArray[9] + 1)) / 10 + 0.4;
        // 0.00034 / mile
        myValues[10] = 0.00034 * dataArray[10];// assume occupancy of 1 until next question is answered
        myValues[11] = 1 * dataArray[11];
        if (myValues[11]!=0) {
            myValues[10] = myValues[10] / myValues[11];
        }
        myValues[12] = 0.0026 * 10.5 * dataArray[12];
        myValues[13] = dataArray[13] * 0.0022; // myValues[13] * 6 / 1000;
        myValues[14] = dataArray[14] * 80 * 1.9 / 1000;
        switch(dataArray[15]) {
            case "0" :
                myValues[15] = 0.4;
                break;
            case "1" :
                myValues[15] = 0.6;
                break;
            case "2" :
                myValues[15] = 0.8;
                break;
            case "3" :
                myValues[15] = 0.9;
                break;
            case "4" :
                myValues[15] = 1.1;
                break;
            case "5" :
                myValues[15] = 1.2;
                break;
            case "6" :
                myValues[15] = 1.4;
                break;
            default :
                myValues[15] = 0;
                break;
        }
        switch(dataArray[16]) {
            case "0" :
                myValues[16] = 0.7;
                break;
            case "1" :
                myValues[16] = 0.9;
                break;
            case "2" :
                myValues[16] = 1.0;
                break;
            case "3" :
                myValues[16] = 1.2;
                break;
            case "4" :
                myValues[16] = 1.4;
                break;
            default :
                myValues[16] = 0;
                break;
        }
        switch(dataArray[17]) {
            case "0" :
                myValues[17] = 2500;
                break;
            case "1" :
                myValues[17] = 5000;
                break;
            case "2" :
                myValues[17] = 8000;
                break;
            case "3" :
                myValues[17] = 11000;
                break;
            case "4" :
                myValues[17] = 14000;
                break;
            case "5" :
                myValues[17] = 17000;
                break;
            case "6" :
                myValues[17] = 20000;
                break;
            case "7" :
                myValues[17] = 23000;
                break;
            case "8" :
                myValues[17] = 26000;
                break;
            case "9" :
                myValues[17] = 29000;
                break;
            case "10" :
                myValues[17] = 32000;
                break;
            case "11" :
                myValues[17] = 36000;
                break;
            case "12" :
                myValues[17] = 40000;
                break;
            case "13" :
                myValues[17] = 45000;
                break;
            case "14" :
                myValues[17] = 50000;
                break;
            case "15" :
                myValues[17] = 60000;
                break;
            case "16" :
                myValues[17] = 75000;
                break;
            case "17" :
                myValues[17] = 90000;
                break;
            case "18" :
                myValues[17] = 120000;
                break;
            case "19" :
                myValues[17] = 170000;
                break;
        }
        myValues[17] = myValues[17] / 1000;
        myValues[18] = (5 - (1 * dataArray[18] + 1) / 2) / 5 + 0.5;
        return myValues;
    };
    OU.activity.CarbonCalc.prototype.calculateHouse = function ( processed ) {
        var a = this.answers;
        if (a[9]!==undefined)
            return this.Constants.UKpersh * processed[1] * (processed[3]
                + processed[4]) * processed[7] * processed[8] * processed[9] * processed[2]
                + this.Constants.UKperhw * (processed[5]
                + processed[6]) * processed[7] * processed[9] * processed[2]
                + this.Constants.UKperdla * processed[9] * processed[2];
        else
            return 2.3;
    };
    OU.activity.CarbonCalc.prototype.calculateTravel = function ( processed ) {
        var a = this.answers;
        if (a[14]!==undefined)
            return processed[10] + processed[12] + processed[14] + processed[13];
        else
            return 1.8;
    };
    OU.activity.CarbonCalc.prototype.calculateFood = function ( processed ) {
        var a = this.answers;
        if (a[16]!==undefined)
            return processed[15] * processed[16] * 2.9;
        else
            return 2.9;
    };
    OU.activity.CarbonCalc.prototype.calculateGoods = function ( processed, raw ) {
        var a = this.answers;
        if (a[18]!==undefined)
            return processed[17] * 0.73 * 0.67 * 0.37 * processed[18] / raw[2];
        else
            return 2.4;
    };
    OU.activity.CarbonCalc.prototype.calculateInfra = function ( processed, raw ) {
        var a = this.answers;
        if (a[18]!==undefined)
            return this.Constants.UKperinfra + (processed[17] * 0.73 * 33 / 100 * 0.37 * processed[18] / raw[2]);
        else
            return 3.0;
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.CarbonCalc, OU.util.Activity);
