/**
 * @fileOverview EmptyActivity - A template for activities that extend the OU.util.Activity class
 *
 * Usage:
 * <ul>
 * <li> Make a copy of this file</li>
 * <li> Rename the class (OU.activity.EmptyActivity) to your new activity name</li>
 * <li> Add your code</li>
 * </ul>
 *
 * Additional functions that are not defined in this file but are available to all activities:
 * <ul>
 * <li> this.header(h) - changes current H1 and H2 tags, where parameter h is of format: { h1: 'optional H1', h2: 'optional H2' }</li>
 * <li> this.loadCSSFile(f) - loads additional CSS from the file f - which is a file path relative to the activity data folder</li>
 * <li> this.addMessengerParams(paramsArray) - See documentation for Messenger functions in OU.js</li>
 * <li> this.defineActivityAPI(json object) - defines an API for this activity
 * </ul>
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

// Load in any util elements that are required
OU.require('OU.util.Layer');

/**
 * @class EmptyActivity - A template for activities that extend the OU.util.Activity class
 * @extends OU.util.Activity
 * @param {Object} data - Holds the data content for a specific instance of the activity
 * @param {String} instance - (Optional) A unique identifier name for this instance, defaults to 'a1'
 * @param {OU.util.Controller} controller - (Optional) A reference to the controller that initialised this instance, if undefined, the superclass will generate a new controller and create the reference to it as 'this.controller'
 */
OU.activity.EmptyActivity = function(data,instance,controller) {

    /**
     * canvasView - this is the function that is first called when the activity is launched,
     *              assuming you are in a browser that supports canvas.
     *
     * Typical tasks for this function are:
     * <ul>
     * <li> Define and initialise and activity wide variables</li>
     * <li> Initialise Layers & Divs</li>
     * <li> Call a loading function</li>
     * <li> Initiating the activity by calling any methods that</li>
     * </ul>
     */
    OU.activity.EmptyActivity.prototype.canvasView = function() {

        // Most activities should have a background layer
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw default background

        // *Your code starts here*
    };
    /**
     * accessibleView - this function is called instead of canvasView if the browser does not support HTML5 canvas
     */
    OU.activity.EmptyActivity.prototype.accessibleView = function() {
        OU.activity.EmptyActivity.superClass_.accessibleView.call(this); // call the superclass method is you want to extend it, remove this line to override the method instead

        // Note this function can be removed or commented out if you want to use the default accessibleView method

        // *Your code starts here*
    };
    /**
     * resize - called whenever the outer bounds of the activity change, ie when the browser window is resized, or a mobile device is rotated.
     *
     * This function should do the following:
     * <ul>
     * <li>Resize all visible elements</li>
     * <li>Re-layout all visible elements</li>
     * <li>Actually re-render the current view of the activity</li>
     * </ul>
     */
    OU.activity.EmptyActivity.prototype.resize = function() {
        OU.activity.EmptyActivity.superClass_.resize.call(this); // call the superclass resize

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();

    };

    /**
     * remove - called when the activity is being removed by a controller.
     *
     * This function should do the following:
     * <ul>
     * <li> Remove any elements that may remain in memory</li>
     * <li> Stop any animation loops, including killing any Intervals </li>
     * </ul>
     * You do not need to remove most library elements, such as Layers, Divs, etc. as they are removed automatically
     */
    OU.activity.EmptyActivity.prototype.remove = function() {
        OU.activity.EmptyActivity.superClass_.remove.call(this); // call the superclass remove

        // *Your removal code here*
        // If you have nothing to remove, then this function can be deleted or commented out
    };

    // call the superclass's constructor
    OU.base(this,data,instance,controller);
};
// Call our inherits function to implement the class inheritance
OU.inherits(OU.activity.EmptyActivity,OU.util.Activity);
