/**
 * GraphPlotter
 *
 * @author Will Rawes
 *
 * Copyright © 2012 The Open University
 */

OU.require('OU.activity.Controller');
OU.require('OU.util.Layer');
OU.require('OU.util.Keyboard');
OU.require('OU.util.HtmlBox');
 

OU.activity.GraphPlotter = function ( data, instance, controller ) {
    OU.loadCSS('data/style.css');
    if(!OU.GPBackground)OU.GPBackground='#fcfcfc';//'transparent';
    if(!OU.GPDivStyle)OU.GPDivStyle="position:absolute;border:solid 1px #ccc;border-radius:5px;padding:14px;background:"+OU.GPBackground+";overflow:visible;";
    OU.activity.GraphPlotter.prototype.canvasView = function () {
        var self = this, i, j, v;
        OUGPSelf = self;
        self.name = this.data.name;
        this.pageNum = 0;
        this.scale = this.data.scale;
        this.layer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            zIndex:OU.OVERLAY_CONTROLLER_LEVEL
        });
        this.layer.canvas.style.background = '#f00';
        this.margin = (this.data.margin || 40)*OU.dpr;
        this.margin += 40*OU.dpr;
        this.buttons = [];
        this.bis = [];
        if (0)this.link = " onclick='";
        else this.link = " href='javascript:";
        for (i = this.data.buttons.length; i--;) {
            if (self.data.tablet) {
                this.buttons[i] = new OU.util.Button({
                    container:self,
                    layer:self.layer,
                    txt:self.data.buttons[i].txt,
                    verticalPadding:2,
                    onOffIndicator:(self.data.buttons[i].onOff || false),
                    disabled:self.data.buttons[i].disabled,
                    context:self.layer.context,
                    onClick:self.data.buttons[i].action,
                    onClickParam:self
                });
                this.bis[this.data.buttons[i].txt] = this.buttons[i];
            }
            else {
                this.buttons[i] = new OU.util.Div({
                    container:self,
                    style:"",
                    zIndex:OU.OVERLAY_CONTROLLER_LEVEL
                });
                this.buttons[i].render = function () {
                };
                this.buttons[i].div.innerHTML = "<input type='button' onclick='" + self.data.buttons[i].actionTxt + "' style='font-size:70%;' value='" + self.data.buttons[i].txt + "'/>";
            }
            this.buttons[i].pageNum = this.data.buttons[i].pageNum;
            this.buttons[i]._x = this.data.buttons[i].x;
            this.buttons[i]._y = this.data.buttons[i].y;
            this.buttons[i].id = this.data.buttons[i].txt;
        }
        this.divs = [];
        this.dvs = [];
        this.tabIndex = 0;
        for (i = self.data.divs.length; i--;) {
            this.divs[i] = new OU.util.HtmlBox({
                container:self,
                style:"background:" + (self.data.background || "transparent") + ";"
                + (self.data.divStyle || "") + self.data.divs[i].style
            });
            this.divs[i]._x = this.data.divs[i].x;
            this.divs[i]._y = this.data.divs[i].y;
            this.divs[i]._w = this.data.divs[i].w;
            this.divs[i]._h = this.data.divs[i].h;
            this.divs[i].vis = false;
            this.divs[i].div.id = self.data.divs[i].id;
            this.divs[i].div.setHTML = function ( s ) {
                this.innerHTML = s;
            };
            this.divs[i].div.setHTML(self.data.divs[i].html);
            this.dvs[this.divs[i].div.id] = this.divs[i];
        }
        this.dvs["hintD"].div.style.zIndex += 10;
        /*
         if(this.data.keypad){
         this.keypad={};
         this.keypad=new OU.util.Keyboard({
         x:(this.data.keypad.x || 0.01),
         y:(this.data.keypad.y || 0.01),
         w:0.2*0.7,
         h:0.52*0.7,
         keys:(this.data.keypad.numbers?"7\u00a08\u00a09\u00a0\n 4\u00a05\u00a06\u00a0\n 1\u00a02\u00a03\u00a0\n 0\u00a0.\u00a0-\u00a0E\u00a0":null),
         ok:true,
         okFn:function(){
         OU.thsKP.dispDiv.innerHTML=OU.thsKP.div.div.innerHTML;
         OU.thsKP.setVisible(false);
         OU.LocalStorage.save("OU"+self.name+"TbCell"+OU.thsKP.dispDiv.id+"",
         (document.getElementById(OU.thsKP.dispDiv.id)?document.getElementById(OU.thsKP.dispDiv.id).innerHTML||"" : ""));
         },
         background:'#fcfcfc',
         formatting:false,
         unicode:false,
         space:false,
         specials:this.data.textPad || false,
         container:this,
         zIndex:OU.OVERLAY_CONTROLLER_LEVEL
         });
         OU.thsKP=this.keypad;
         this.keypad.resize=function(){};
         }//*/
        self.showEl = function ( i, b ) {
            if (i.style)i.style.display = b;
            else {
                var itm = document.getElementById(i);
                if (itm)itm.style.display = b;
            }
        };
        if (this.data.keypad || this.data.calculator) {
            this.calculator = new OU.util.Keyboard({
                x:0.01,
                y:0.4,
                h:0.65,
                calculate:true,
                scientific:true,
                ok:true,
                okFn:function () {
                    if(!OU.thsKP.dispDiv){
                        OU.thsKP.setVisible(false);
                        return;
                    }
                    OU.thsKP.dispDiv.innerHTML = OU.thsKP.div.div.innerHTML;
                    OU.thsKP.dispDiv.style.border = 'solid 1px';
                    OU.thsKP.setVisible(false);
                    OU.LocalStorage.save("OU" + self.name + "TbCell" + OU.thsKP.dispDiv.id + "",
                        (document.getElementById(OU.thsKP.dispDiv.id) ? document.getElementById(OU.thsKP.dispDiv.id).innerHTML || "" : ""));
                },
                background:'#fcfcfc',
                formatting:false,
                unicode:false,
                space:false,
                specials:false,
                container:this,
                zIndex:OU.OVERLAY_CONTROLLER_LEVEL + 1000
            });
            OU.thsKP = this.calculator;
            this.keypad = {
                resize:function () {
                }
            };
        }
        else {
            this.calculator = {
                okB:{},
                setVisible:function () {
                },
                resize:function () {
                }
            }
        }
        /// Plotting activity ///
        this.textNum = function ( v, dp ) {
            if (dp) {
                dp = Math.pow(10, dp);
                v = parseFloat(v);
                v = (parseInt(v * dp + (v < 0 ? -0.5 : 0.5))) / dp;
            }
            var s = String(v)
            , e = null
            , p = s.indexOf("e")
            , r = [], p1, p2
            ;
            p1 = s.indexOf(".");
            p2 = s.indexOf("00000000");
            if (p > 0) {
                e = s.substring(p + 1);
                s = s.substring(0, p);
            }
            if (p1 > 0) {
                if (p2 > p1)r = [s.substring(0, p2), e];
                else {
                    p2 = s.indexOf("99999999");
                    if (p2 > p1)r = [(parseFloat(s.substring(0, p2)) + 0.1)
                        , e];
                    else {
                        r = [s, e];
                    }
                }
            }
            else r = [s, e];
            return r;
        };
        self.setTxtIn = function ( id, v, s ) {
            if (this.keypad) {
                s = "";
                return "<div style='position:relative;width:90%;'><div id='" + id + "' style='min-height:"+((window.innerHeight/40)|0)+"px;' class='inputDiv' onclick='this.style.border=\"solid 3px\";OU.thsKP.dispDiv=this;OU.thsKP.setVisible(true,\" \"+this.innerHTML);' " + s + ">" + (v===null || v===undefined ? "" : v) + 	"</div></div>";
            }
            else {
                if (s) {
                    s = "'OU.LocalStorage.save(\"" + s + "\",this.value);'";
                    s = " onkeyup=" + s + " onmouseup=" + s + " ";
                }
                else s = "";
                return "<input id='" + id + "' type='text' style='width:60%' value='" + v + "' " + s + "/>";
            }
        };
        if (this.data.tableSet) {
            var tmp = [], ii = 0;
            this.answerData = [];
            this.error = [];
            this.pointSetting = this.data.dataTitle + "__N__";
            this.pBlank = [];
            this.blank = false;
            this.nBlanks = 0;
            for (i = 0; i < this.data.tableSet.length; i++) {
                var line = '';
                tmp[i] = [];
                //                if(i>0)this.answerData[i-1]=[];
                for (j = 0; j < this.data.tableSet[i].length; j++) {
                    var itm = this.data.tableSet[i][j], val;
                    if (itm.charAt(0)==="I") {
                        tmp[i][j] = itm;
                        var id = "ti" + (i - 1) + "_" + j;
                        if (this.keypad)line += "<div id='" + id + "' style='min-height:"+((window.innerHeight/40)|0)+"px;' class='inputDiv' onclick='this.style.border=\"solid 3px\";OU.thsKP.dispDiv=this;OU.thsKP.setVisible(true,\" \"+this.innerHTML);'>" + (OU.LocalStorage.load("OU" + self.name + "TbCell" + id) || "") + "</div>";
                        else line += "<input type='text' id='" + id + "' style='width:10%;' value='" + (OU.LocalStorage.load("OU" + self.name + "TbCell" + id) || "") + "' onkeyup='OU.LocalStorage.save(\"OU" + self.name + "TbCell" + id + "\",(document.getElementById(" + id + ").value||\"\"));'/>";
                    } else if (itm.charAt(0)==="R") {
                        var s = itm.substring(1)
                        , p = (s || "").indexOf("#A#")
                        , d, s2
                        , fn = function ( v ) {
                            return v;
                        };
                        if (p > 0)s2 = s.substring(0, p);
                        else s2 = s;
                        var r, rs, dt = OU.LocalStorage.load("ou.savehtml." + s2);
                        if (!dt) {
                            r = "\u00a0Blank\u00a0";
                            this.blank = true;
                        }
                        else {
                            d = parseFloat((dt).replace(/\;/g, "_"));
                            if (this.data.tableFunctions)
                                if (this.data.tableFunctions[j] && !isNaN(d))
                                    fn = this.data.tableFunctions[j];
                            if (p > 0) {
                                if (i > 0)if (!this.answerData[ii])this.answerData[ii] = [];
                                if (j===this.data.xColAnswer - 1)this.answerData[ii][0] = fn(parseFloat(s.substring(p + 3)));
                                if (j===this.data.yColAnswer - 1)this.answerData[ii][1] = fn(parseFloat(s.substring(p + 3)));
                            }
                            r = fn(d);
                            if (isNaN(r))r = "";
                            else {
                                rs = self.textNum(r, self.data.tableDecPlaces[j]);
                                if (rs[1])r = rs[0] + "E" + rs[1];
                                else r = rs[0];
                            }
                        }
                        tmp[i][j] = r;
                        line += r;
                        val = r;
                    }
                    else {
                        tmp[i][j] = itm;
                        line += itm;
                        val = itm;
                    }
                    if (self.data.errorCol)
                        if (j==self.data.errorCol - 1)this.error[i - 1] = parseFloat(val);
                    line += "\t";
                }
                if (line.indexOf("\u00a0Blank\u00a0") >= 0) {
                    this.pBlank[i] = true;
                    this.nBlanks++;
                }
                else {
                    if (i > 0) {
                        var xp = parseFloat(tmp[i][this.data.xColAnswer - 1].replace("I", "")),
                        yp = parseFloat(tmp[i][this.data.yColAnswer - 1].replace("I", ""));
                        if (!this.answerData[ii])this.answerData[ii] = [];
                        if (this.answerData[ii][0]===undefined)this.answerData[ii][0] = xp;
                        if (this.answerData[ii][1]===undefined)this.answerData[ii][1] = yp;
                        ii++;
                    }
                    this.pBlank[i] = false;
                }
                line += "__N__";
                this.pointSetting += line;
            }
            this.pointSetting = this.pointSetting.replace(/\t__N__/g, "__N__");
            this.pointSetting = this.pointSetting.substring(0, this.pointSetting.lastIndexOf("__N__"));
        }
        if (!OU.LocalStorage.load("OU" + self.name + "Files"))
            OU.LocalStorage.save("OU" + self.name + "Files", ""); // Empty files list, start from default tmp_6.csv data
        OU.LocalStorage.save("tmp_6.csv", "");
        var lineCol = ['#000', '#000', '#0a0', '#00a', '#a00', '#aa0', '#0aa', '#a0a']
        , ptsCol = ['#000', '#000', '#0a0', '#00a', '#a00', '#aa0', '#0aa', '#a0a']
        , plotCol = [0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        , markers = (this.data.markers || [0, 1, 2, 3, 4, 5, 6, 7, 7, 7])
        , muc = [" ", "\u25a0", "\u25a1", "\u25b2", "\u25b3", "\u25cb", "\u25cf", "\u00d7"]
        , lines = (this.data.lines || [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
        , xCol = 0
        , xmn, xmx, ymn, ymx
        , contents0 = (this.data.csvData || "Title__N__<em>Column A</em>	<strong>Column B &#960;</strong>	<strong><em>C</em></strong>	<strong><em>Column D</em></strong>__N__1.0	2.0	2.141592653589793	NaN__N__2.0	3.0	2.141592653589793	NaN__N__4.0	4.0	3.141592653589793	NaN__N__3.0	2.0	4.141592653589793	NaN__N__11.0	1.0	6.141592653589793	NaN__N__NaN	NaN	NaN	NaN__N__NaN	NaN	NaN	NaN__N__NaN	NaN	NaN	NaN__N__NaN	NaN	NaN	NaN")
        , tData
        ;
        if (!OU.LocalStorage.load("tmp_6.csv") || OU.LocalStorage.load("tmp_6.csv")==="")OU.LocalStorage.save("tmp_6.csv", contents0);
        this.lineWidth = 2;
        this.drawVal = function ( ctx, fs, v, x, y ) {
            var r = self.textNum(v);
            ctx.fillStyle = "#000";
            if (r[1]) {
                ctx.textAlign = 'right';
                ctx.fillText(r[0] + "\u00d710", x, y);
                ctx.textAlign = 'left';
                ctx.font = ((fs * .7) | 0) + "pt helvetica,ariel,sans";
                ctx.fillText(String(r[1]).replace(" ", ""), x, y - 5);
                ctx.font = fs + "pt helvetica,ariel,sans";
            }
            else ctx.fillText(r[0], x, y);
        };
        this.showPhC = function ( j ) {
            self.bis["Start again"].params.disable = false;
            self.bis["Calculate"].params.disable = false;
        };
        this.hideDiv = function ( dv ) {
            self.showEl(self.dvs[dv].div, "none");
            self.dvs[dv].vis = false;
        };
        this.showDiv = function ( dv, only ) {
            if (only) {
                self.dvs[dv].vis = true;
                self.showEl(self.dvs[dv].div, "block")
            }
            else {
                var id, i;
                for (i = self.divs.length; i--;) {
                    id = self.divs[i].div.id;
                    self.showEl(id, (dv===id ? 'block' : 'none'));
                    self.divs[i].vis = (dv===id);
                }
            }
        };
        this.calcTics = function ( mn, mx ) {
            ///  ticInterval calculation thanks to M.A.Brown
            var dif = mx - mn, n = Math.floor(Math.log(dif) / Math.log(10.0)),
            a = dif * Math.pow(10.0, -n), ticInterval, dt = 5;
            if (a < 2.0) {
                ticInterval = 0.2;
                dt = 2;
            } else if (a < 5.0) ticInterval = 0.5;
            else ticInterval = 1.0;
            ticInterval = ticInterval * Math.pow(10.0, n);
            return {
                interval:(ticInterval),
                min:(Math.floor(mn / ticInterval) * ticInterval),
                max:(Math.ceil(mx / ticInterval) * ticInterval),
                subInterval:ticInterval / dt
            }
        };
        self.setGScale = function ( xTics, yTics ) {
            self.dx = (self.data.xMax - self.data.xMin) / 150;
            self.dy = (self.data.yMax - self.data.yMin) / 150;
            self.xf = (self.data.dims.w * 2 || 1) * 0.6 / (xTics.max - xTics.min) * self.scale;
            self.yf = (self.data.dims.h * 2.1 || 1) * -0.27 / (yTics.max - yTics.min) * self.scale;
            self.x0 = -xTics.min * self.xf + (self.data.dims.x || 0.16) * self.scale;
            self.y0 = -yTics.min * self.yf + ((self.data.dims.y + self.data.dims.h * 1.6) || 1) * 0.43 * self.scale;
            self.xpt = function ( v, ok ) {
                if (!ok) {
                    if (v < self.data.xMin)v = self.data.xMin;
                    if (v > self.data.xMax)v = self.data.xMax;
                }
                return v * self.xf + self.x0;
            };
            self.ypt = function ( v, ok ) {
                if (!ok) {
                    if (v < self.data.yMin)v = self.data.yMin;
                    if (v > self.data.yMax)v = self.data.yMax;
                }
                return v * self.yf + self.y0;
            };
            self.ixpt = function ( v, ok ) {
                var r = (v - self.x0) / self.xf;
                if (ok)return r;
                if (r < self.data.xMin)return self.data.xMin;
                if (r > self.data.xMax)return self.data.xMax;
                return r;
            };
            self.iypt = function ( v, ok ) {
                var r = (v - self.y0) / self.yf;
                if (ok)return r;
                if (r < self.data.yMin)return self.data.yMin;
                if (r > self.data.yMax)return self.data.yMax;
                return r;
            };
        };
        self.setClip = function ( g, xn, yn, xx, yx ) {
            xn -= 8;
            yn += 8;
            g.save();
            g.beginPath();
            g.moveTo(xn, yn);
            g.lineTo(xn, yx);
            g.lineTo(xx, yx);
            g.lineTo(xx, yn);
            g.closePath();
            g.clip();
        };
        this.plotGraph = function ( pts, xTics, yTics ) {
            if (!self.data.dims)return;
            if (!xTics)return;
            var g = self.layer.context, ctx = g
            , i, ii, j, xx, yy, gxn, gxx, gyn, gyx
            , fs = parseInt(self.scale * .014)
            , pwr, pmax, sc;
            if (isNaN(xTics.interval) || isNaN(yTics.interval)) {
                this.message("Some selected table columns do not contain valid data.");
                return;
            }
            g.strokeStyle = '#000';
            if (!self.yTSet) {
                if (!self.data.yIntervals)yTics = self.calcTics(self.data.yMin, self.data.yMax);
                else yTics = {
                    min:self.data.yMin,
                    max:self.data.yMax,
                    interval:self.data.yIntervals.interval,
                    subInterval:self.data.yIntervals.subInterval
                }
            }
            self.lastInt = yTics.interval;
            self.lastSubInt = yTics.subInterval;
            self.setGScale(xTics, yTics);
            gxn = this.xpt(xTics.min);
            gxx = this.xpt(xTics.max);
            gyn = this.ypt(yTics.min);
            gyx = this.ypt(yTics.max);
            g.fillStyle = self.data.background;
            ctx.fillRect(0, 0, this.w, this.h);
            ctx.fillStyle = '#fff';
            ctx.strokeStyle = '#000';
            ctx.fillRect(gxn, gyn, gxx - gxn, gyx - gyn);
            ctx.fillStyle = "#000";
            ctx.font = fs + "pt helvetica,ariel,sans";
            ctx.textAlign = 'right';
            pmax = -1e20;
            for (i = yTics.min; i <= yTics.max; i += yTics.interval) {
                pwr = Math.floor(Math.log(i) / Math.LN10);
                if (pwr > pmax)pmax = pwr;
            }
            sc = Math.pow(10, pwr);
            if (Math.abs(pwr) < 3) {
                sc = 1;
                this.xPow = "";
            }
            else {
                xx = gxn - fs * 4;
                yy = (gyx + gyn) / 2;
                ctx.fillText("\u00d710", xx, yy);
                ctx.textAlign = 'left';
                ctx.font = ((fs * .7) | 0) + "pt helvetica,ariel,sans";
                ctx.fillText(String(pwr), xx, yy - fs * 0.7);
                ctx.font = fs + "pt helvetica,ariel,sans";
                ctx.textAlign = 'right';
            }
            for (ii = Math.round(yTics.min / yTics.interval); ii <= yTics.max / yTics.interval; ii++) {
                i = ii * yTics.interval;
                yy = this.ypt(i);
                ctx.beginPath();
                ctx.strokeStyle = "#000";
                ctx.moveTo(gxn - 3, yy);
                ctx.lineTo(gxn, yy);
                ctx.closePath();
                ctx.stroke();
                ctx.lineWidth = (i===0 ? 1.2 : 0.6);
                ctx.strokeStyle = (i===0 ? "#000" : "#444");
                ctx.beginPath();
                ctx.moveTo(gxn, yy);
                ctx.lineTo(gxx, yy);
                ctx.closePath();
                ctx.stroke();
                this.drawVal(ctx, fs, i / sc, gxn - fs, yy + 2);
                ctx.textAlign = 'right';
                for (j = i + yTics.subInterval; j < i + yTics.interval; j += yTics.subInterval) {
                    if (j <= yTics.max) {
                        yy = this.ypt(j);
                        ctx.strokeStyle = "#aaa";
                        ctx.lineWidth = 0.4;
                        ctx.beginPath();
                        ctx.moveTo(gxn, yy);
                        ctx.lineTo(gxx, yy);
                        ctx.closePath();
                        ctx.stroke();
                    }
                }
            }
            pmax = -1e20;
            for (i = xTics.min; i <= xTics.max; i += xTics.interval) {
                pwr = Math.floor(Math.log(i) / Math.LN10);
                if (pwr > pmax)pmax = pwr;
            }
            sc = Math.pow(10, pwr);
            if (Math.abs(pwr) < 3) {
                sc = 1;
                this.xPow = "";
            }
            else {
                this.xPow = "\u00d7 10<sup>" + pwr + "</sup>";
            }
            ctx.textAlign = 'center';
            for (ii = Math.round(xTics.min / xTics.interval); ii <= xTics.max / xTics.interval; ii++) {
                i = ii * xTics.interval;
                xx = this.xpt(i);
                ctx.beginPath();
                ctx.strokeStyle = "#000";
                ctx.moveTo(xx, gyn);
                ctx.lineTo(xx, gyn + 3);
                ctx.closePath();
                ctx.stroke();
                ctx.lineWidth = (i===0 ? 1.2 : 0.6);
                ctx.strokeStyle = (i===0 ? "#000" : "#444");
                ctx.beginPath();
                ctx.moveTo(xx, gyn);
                ctx.lineTo(xx, gyx);
                ctx.closePath();
                ctx.stroke();
                this.drawVal(ctx, fs, i / sc, xx, gyn + fs * 1.2);
                for (j = i + xTics.subInterval; j < i + xTics.interval; j += xTics.subInterval) {
                    if (j <= xTics.max) {
                        xx = this.xpt(j);
                        ctx.lineWidth = 0.4;
                        ctx.strokeStyle = "#aaa";
                        ctx.beginPath();
                        ctx.moveTo(xx, gyn);
                        ctx.lineTo(xx, gyx);
                        ctx.closePath();
                        ctx.stroke();
                    }
                }
            }
            ctx.textAlign = 'right';
            ctx.fillStyle = '#000';
            ctx.lineWidth = (this.lineWidth * fs / 10);
            var msg = "", legend = this.titles[xCol] + " " + this.xPow
            , cn, mWidth = (ctx.lineWidth * 2.5) | 0, mw2 = mWidth * 2 + 1;
            if (self.data.yTitle) {
                self.dvs["yTitleD"].div.innerHTML = self.data.yTitle;
                self.showDiv("yTitleD", true);
            }
            if (self.dvs["yAxisD"]) {
                self.plotNewGraph = function () {
                    var i, m, s;
                    if (this.keypad) {
                        i = parseFloat(document.getElementById("yIntIn").innerHTML);
                        m = parseFloat(document.getElementById("yMxIn").innerHTML);
                        s = parseFloat(document.getElementById("ySIntIn").innerHTML);
                    }
                    else {
                        i = parseFloat(document.getElementById("yIntIn").value);
                        m = parseFloat(document.getElementById("yMxIn").value);
                        s = parseFloat(document.getElementById("ySIntIn").value);
                    }
                    var isN = function ( v ) {
                        return isNaN(v) || v===0 || !isFinite(v)
                    };
                    if (isN(i) || isN(m) || isN(s))self.hint("Please provide valid numbers.");
                    else {
                        if(Math.abs(m/i)>35 || Math.abs(m/s)>70){
                            self.hint("The maximum and intervals you have provided will produce too many tic marks. Please provide a maximum that isn't too large and intervals that aren't too small.");
                        }else{
                            self.data.yMax = m;
                            self.newYTics = {
                                interval:i,
                                min:(self.data.yMin),
                                max:m,
                                subInterval:s
                            };
                            var xti = self.calcTics(self.data.xMin, self.data.xMax);
                            self.setGScale(xti, self.newYTics);
                            self.yTSet = true;
                            self.plotGraph(self.setPts, xti, self.newYTics);
                            self.hideDiv("checkD");
                        }
                        
                    }
                };
                self.showYSet = function () {
                    s = "<b><i>y</i>-axis settings</b>:<br/><br/>"
                    + "Maximum value:<br/>" + self.setTxtIn("yMxIn", self.data.yMax) + "<br/><br/>"
                    + "Tic interval:<br/>" + self.setTxtIn("yIntIn", self.lastInt) + "<br/><br/>"
                    + "Tic sub interval:<br/>" + self.setTxtIn("ySIntIn", self.lastSubInt) + "<br/><br/>";
                    self.message(s, null, null, null, "plotNewGraph();")
                };
                self.dvs["yAxisD"].div.setHTML("<a " + self.link + "OUGPSelf.showYSet();'><i>y</i>-axis settings</a>");
                self.showDiv("yAxisD", true);
            }
            self.setClip(g, self.xpt(self.data.xMin), self.ypt(self.data.yMin), self.xpt(self.data.xMax), self.ypt(self.data.yMax));
            for (i = 0; i < pts.length; i++) {
                if (pts[i]) {
                    cn = pts[i]["colN"];
                    if (self.data.showLegend!==false)legend += "<div style='padding:0px;color:" + ptsCol[cn] + "'> "
                        + (markers[cn] ? (lines[cn] ? "<del>&#160;" + muc[markers[cn]] + "&#160;</del>&#160;" : muc[markers[cn]] + "&#160;") : "<del>&#160;&#160;&#160;</del>&#160;") + (this.titles[cn].replace(/ /g, "")==="" ? "" + String.fromCharCode(65 + cn) : this.titles[cn]) + "</div>";
                    ctx.fillStyle = lineCol[cn];
                    ctx.beginPath();
                    ctx.strokeStyle = ptsCol[cn];
                    ctx.moveTo(this.xpt(pts[i][0][0]), this.ypt(pts[i][0][1]));
                    for (j = 0; j < pts[i].length; j++) {
                        xx = this.xpt(pts[i][j][0]);
                        yy = this.ypt(pts[i][j][1]);
                        if (lines[cn])ctx.lineTo(xx, yy);
                        else ctx.moveTo(xx, yy);
                        if (markers[cn]) {
                            if (self.error[j]) {
                                var yy1 = this.ypt(pts[i][j][1] - self.error[j]);
                                ctx.moveTo(xx - 8, yy1);
                                ctx.lineTo(xx + 8, yy1);
                                ctx.moveTo(xx, yy1);
                                yy1 = this.ypt(pts[i][j][1] + self.error[j]);
                                ctx.lineTo(xx, yy1);
                                ctx.moveTo(xx + 8, yy1);
                                ctx.lineTo(xx - 8, yy1);
                                ctx.moveTo(xx + 3, yy);
                                ctx.lineTo(xx - 3, yy);
                            }
                            else {
                                switch(markers[cn]) {
                                    case 1:
                                        ctx.fillRect(xx - mWidth, yy - mWidth, mw2, mw2);
                                        break;
                                    case 2:
                                        ctx.moveTo(xx - mWidth, yy - mWidth);
                                        ctx.lineTo(xx + mWidth, yy - mWidth);
                                        ctx.lineTo(xx + mWidth, yy + mWidth);
                                        ctx.lineTo(xx - mWidth, yy + mWidth);
                                        ctx.lineTo(xx - mWidth, yy - mWidth);
                                        break;
                                    case 3:
                                        ctx.moveTo(xx - mWidth, yy + mWidth);
                                        ctx.lineTo(xx, yy - mWidth);
                                        ctx.lineTo(xx + mWidth, yy + mWidth);
                                        ctx.lineTo(xx - mWidth, yy + mWidth);
                                        break;
                                    case 4:
                                        ctx.fillStyle = ctx.strokeStyle;
                                        ctx.moveTo(xx - mWidth, yy + mWidth);
                                        ctx.lineTo(xx, yy - mWidth);
                                        ctx.lineTo(xx + mWidth, yy + mWidth);
                                        ctx.lineTo(xx - mWidth, yy + mWidth);
                                        ctx.fill();
                                        break;
                                    case 5:
                                        ctx.moveTo(xx + mWidth, yy);
                                        ctx.arc(xx, yy, mWidth, 0, Math.PI * 2, false);
                                        break;
                                    case 6:
                                        ctx.fillStyle = ctx.strokeStyle;
                                        ctx.arc(xx, yy, mWidth, 0, Math.PI * 2, false);
                                        ctx.fill();
                                        break;
                                    case 7:
                                        ctx.moveTo(xx - mWidth, yy - mWidth);
                                        ctx.lineTo(xx + mWidth, yy + mWidth);
                                        ctx.moveTo(xx + mWidth, yy - mWidth);
                                        ctx.lineTo(xx - mWidth, yy + mWidth);
                                        break;
                                }
                            }
                            if (j===self.nudgeP) {
                                ctx.moveTo(xx + mWidth * 2, yy);
                                ctx.arc(xx, yy, mWidth * 2, 0, Math.PI * 2, false);
                                ctx.stroke();
                                ctx.closePath();
                                var lws = ctx.lineWidth;
                                ctx.beginPath();
                                ctx.lineWidth = 0.7;
                                ctx.strokeStyle = '#a00';
                                ctx.moveTo(xx, 0);
                                ctx.lineTo(xx, self.h);
                                ctx.moveTo(0, yy);
                                ctx.lineTo(self.w, yy);
                                ctx.stroke();
                                ctx.closePath();
                                ctx.beginPath();
                                ctx.lineWidth = lws;
                                ctx.strokeStyle = ptsCol[cn];
                            }
                            ctx.moveTo(xx, yy);
                        }
                    }
                    ctx.stroke();
                    ctx.closePath();
                }
                else msg = "Some plotted table columns do not contain valid data.";
            }
            ctx.restore();
            if (msg!=="")this.message(msg);
            this.showDiv("titleD", true);
            self.dvs["titleD"].div.innerHTML = this.graphTitle;
            this.showDiv("legendD", true);
            self.dvs["legendD"].div.innerHTML = legend;
        };
        this.clearS = function ( s ) {
            return s.replace(/	__N__/g, "__N__").replace(/__N____N__/g, "__N__");
        };
        this.checkCs = function ( s ) {
            var rows = s.split("__N__"), s2
            , cc = this.sCount(rows[0], "\t") + 1, cs, rs
            ;
            s = "";
            for (i = 0; i < rows.length - 1; i++) {
                rs = rows[i];
                cs = this.sCount(rs, "\t") + 1;
                while (cs < cc) {
                    rs += "\t";
                    cs = this.sCount(rs, "\t") + 1;
                }
                while (cs > cc) {
                    rs = rs.substring(0, rs.length - 1);
                    cs = this.sCount(rs, "\t") + 1;
                }
                s += rs + "__N__";
            }
            if (s.indexOf("__N__")==s.length - 5)s = s.substring(0, s.length - 5);
            return s;
        };
        this.showIntro = function ( s, bs, dims, redraw, fn ) {
            var warn = (this.blank ? "<b>" + (self.data.blankWarning || "Please complete as many empty boxes as you can in the previous task.") + "</b><br/><br/>" : "");
            if (!s)return;
            if (s instanceof Array) {
                s[0] = warn + s[0];
                if (s[1]) {
                    bs = "Next";
                    var ss = "";
                    for (var i = 1; i < s.length; i++)ss += "\"" + s[i] + "\",";
                    fn = "showIntro([" + ss + "]);";
                }
            }
            else s = warn + s;
            this.message(s, bs, dims, redraw, fn, "introD");
        };
        this.message = function ( s, bs, dims, redraw, fn, dvn ) {
            if (s=="")return;
            if (!dvn)dvn = "checkD";
            if (dims) {
                if (dims.x)self.dvs[dvn].div.style.left = dims.x;
                if (dims.y)self.dvs[dvn].div.style.top = dims.y;
                if (dims.w)self.dvs[dvn].div.style.width = dims.w;
                if (dims.h)self.dvs[dvn].div.style.height = dims.h;
            } else if (redraw!==false)self.resize();
            self.dvs[dvn].div.setHTML(s + (bs===-1 || self.data.introOKButton===false ? "" : "<p style='text-align:right;'><br/><a " + self.link + "OUGPSelf." + (fn || "hideDiv(\"" + dvn + "\");") + "'>&#160;" + (bs ? bs : "OK") + "&#160;</a></p>"));
            this.showDiv(dvn, true);
        };
        this.hint = function ( s ) {
            self.dvs["hintD"].div.setHTML(s + "<br/><br/><br/><a " + self.link + "OUGPSelf.hideDiv(\"hintD\");'>&#160;&#160;OK&#160;&#160;</a> ");
            this.showDiv("hintD", true);
        };
        this.check = function ( s, fn, ok ) {
            self.dvs["checkD"].div.setHTML(s + "?<br/><br/><br/><a " + self.link + "OUGPSelf." + fn + "'>" + (ok ? "OK" : "Yes") + "</a>&#160;&#160;&#160;&#160;&#160;&#160;&#160;<a " + self.link + "OUGPSelf.hideDiv(\"checkD\");'>" + (ok ? "Cancel" : "No") + "</a> ");
            this.showDiv("checkD", true);
        };
        this.sCount = function ( s, t ) {
            var p = s.indexOf(t), c = 0;
            while (p >= 0) {
                c++;
                p = s.indexOf(t, p + 1);
            }
            return c;
        };
        this.getData = function ( ins ) {
            var contents, num;
            if (!ins)contents = contents0;
            else if (ins.indexOf("__N__") > 0)contents = ins;
            else contents = (OU.LocalStorage.load(ins) || "");
            var result = [], i, j;
            var lns = contents.replace(/\n/g, "__N__").split("__N__")
            , ii = 0;
            for (i = 0; i < lns.length - 1; i++) {
                if (!this.pBlank[i]) {
                    result[ii] = lns[i + 1].split("\t");
                    for (j = result[ii].length; j--;) {
                        num = parseFloat(result[ii][j]);
                        if (!isNaN(num))result[ii][j] = num;
                    }
                    ii++;
                }
            }
            this.titles = lns[1].split("\t");
            this.graphTitle = lns[0];
            return result;
        };
        this.getPts = function ( ins ) {
            var
            tData = self.getData(ins),
            i, j, pts = [], setNum, ok = [], yCol = (self.data.yColAnswer - 1);
            if (!tData[1])return [
                [0, 0]
                ];
            if (tData[1].length < yCol || isNaN(tData[1][yCol]))
                yCol = 1;
            for (j = 0; j < tData[0].length; j++)ok[j] = (j===yCol) && (j!=xCol);
            for (i = 1; i < tData.length; i++) {
                setNum = -1;
                for (j = 0; j < tData[0].length; j++) {
                    if (ok[j])setNum++;
                    var num = (tData[i][j]);
                    if (!isNaN(num) && num!=="") {
                        if (j===xCol) {
                            if (num < xmn)xmn = num;
                            if (num > xmx)xmx = num;
                        } else if (ok[j]) {
                            if (num < ymn)ymn = num;
                            if (num > ymx)ymx = num;
                            if (!pts[setNum]) {
                                pts[setNum] = [];
                                pts[setNum]["colN"] = j;
                            }
                            pts[setNum].push([tData[i][xCol], tData[i][j]]);
                        }
                    }
                }
            }
            if (!this.pointSetting) {
                this.sortNumber = function ( a, b ) {
                    return parseFloat(a) - parseFloat(b);
                };
                for (i = 0; i < pts.length; i++)if (pts[i])pts[i] = pts[i].sort(this.sortNumber);
            }
            if (!pts[0])pts = [[[self.data.xMin,self.data.yMin]]];
            return pts;
        };
        this.loadData = function ( f ) {
            var s = OU.LocalStorage.load(f), p = s.indexOf("__N__");
            return s.substring(p + 6);
        };
        this.saveData = function ( f, s ) {
            OU.LocalStorage.save(f, this.graphTitle + "__N__" + s);
        };
        //////
        this.resize();
        this.clearCheck = function () {
            var cl, i, tp, tbOff = (self.data.dims ? 1 : 2), rows;
            if (self.setPts) {
                rows = document.getElementById("OU" + self.name + "SetTable").rows;
                for (i = self.setPts[0].length; i--;) {
                    if (rows[i + tbOff]) {
                        cl = rows[i + tbOff].cells[0];
                        tp = cl.innerHTML.indexOf("<span");
                        if (tp > 0)cl.innerHTML = cl.innerHTML.substring(0, tp);
                        self.setPts[0][i].correct = false;
                    }
                }
            }
        };
        this.resetTable = function () {
            self.bestFit = [null, null];
            self.nudgeP = 0;
            var s = self.pointSetting
            , p = s.indexOf("__N__");
            p = s.indexOf("__N__", p + 1);
            p = s.indexOf("__N__", p + 1);
            self.setTableS = s.substring(0, p);
            OU.LocalStorage.save("OU" + self.name + "SetTable", self.setTableS);
            self.clearCheck();
            self.setPts = self.getPts(self.setTableS);
            if (!self.checkPs)return;
            self.checkPs();
            self.showEl("chkB", "none");
            self.showEl("rstB", "none");
        };
        if (this.pointSetting) {
            var ls = OU.LocalStorage.load("OU" + self.name + "SetTable");
            if (ls)this.setTableS = ls;
            else this.resetTable();
            this.setXR = this.data.xMax - this.data.xMin;
            this.setYR = this.data.yMax - this.data.yMin;
            this.plotSetGraph = function ( newPt ) {
                if (!newPt) {
                    var ts = self.setTableS.split("__N__");
                    if (!self.setPts[0])self.setPts = self.getPts(self.setTableS);
                    if (self.nudgeP!=999 && self.nudgeP >= 0)ts[self.nudgeP + 2] = self.setPts[0][self.nudgeP][0] + "\t" + self.setPts[0][self.nudgeP][1];
                    self.setTableS = "";
                    for (i = 0; i < ts.length; i++)self.setTableS += ts[i] + "__N__";
                    self.setTableS = self.setTableS.substring(0, self.setTableS.lastIndexOf("__N__"));
                }
                OU.LocalStorage.save("OU" + self.name + "SetTable", self.setTableS);
                self.setPts = self.getPts(self.setTableS);
                self.plotGraph(self.setPts, self.calcTics(self.data.xMin, self.data.xMax), (self.newYTics || self.calcTics(self.data.yMin, self.data.yMax)));
                if (self.bestFit) {
                    if (self.bestFit[1] && self.bestFit[0]) {
                        var g = self.layer.context,
                        p0 = [(self.bestFit[0][0]), (self.bestFit[0][1])],
                        p1 = [(self.bestFit[1][0]), (self.bestFit[1][1])],
                        dx, dy,
                        m, c
                        ;
                        dy = p1[1] - p0[1];
                        dx = p1[0] - p0[0];
                        if (dx!==0) {
                            m = dy / dx;
                            c = p1[1] - m * p1[0];
                        }
                        else return;
                        self.bestFit.m = m;
                        self.bestFit.c = c;
                        self.setClip(g, self.xpt(self.data.xMin), self.ypt(self.data.yMin), self.xpt(self.data.xMax), self.ypt(self.data.yMax));
                        g.strokeStyle = '#a00';
                        g.beginPath();
                        g.lineWidth = 0.3;
                        g.beginPath();
                        g.moveTo(self.xpt(self.data.xMin, true), self.ypt(self.bestFit.c, true));
                        g.lineTo(self.xpt(self.data.xMax, true), self.ypt(self.bestFit.m * self.data.xMax + self.bestFit.c, true));
                        g.closePath();
                        g.stroke();
                        p0 = [self.xpt(p0[0]), self.ypt(p0[1])];
                        p1 = [self.xpt(p1[0]), self.ypt(p1[1])];
                        g.lineWidth = 2;
                        g.beginPath();
                        g.moveTo(p0[0], p0[1]);
                        g.lineTo(p1[0], p1[1]);
                        g.moveTo(p0[0] + 5, p0[1]);
                        g.arc(p0[0], p0[1], 5, 0, Math.PI * 2, false);
                        g.moveTo(p1[0] + 5, p1[1]);
                        g.arc(p1[0], p1[1], 5, 0, Math.PI * 2, false);
                        g.closePath();
                        g.stroke();
                        if (self.showRiseTread) {
                            g.fillStyle = '#080';
                            g.strokeStyle = '#080';
                            g.textAlign = 'center';
                            var d = self.ixpt(p0[0]) - self.ixpt(p1[0]);
                            g.fillText("" + self.decPlaces(Math.abs(d), self.data.xNDecPs), (p0[0] + p1[0]) / 2, p0[1] + (p0[1] < p1[1] ? -8 : 8));
                            d = self.iypt(p1[1]) - self.iypt(p0[1]);
                            d = Math.abs(d);
                            if (self.bestFit.m < 0)d = -d;
                            g.textAlign = (p1[0] < p0[0] ? 'right' : 'left');
                            g.fillText(" " + self.decPlaces(Math.abs(d), self.data.yNDecPs) + " ", p1[0], (p0[1] + p1[1]) / 2);
                            g.lineWidth = 2;
                            g.beginPath();
                            g.moveTo(p0[0], p0[1]);
                            g.lineTo(p1[0], p0[1]);
                            g.lineTo(p1[0], p1[1]);
                            g.stroke();
                        }
                        g.restore();
                    }
                }
            };
            self.setPts = self.getPts(self.setTableS);
            self.nudgeP = 0;
            this.plotSetGraph(false);
            this.nf = [1, 0];
            this.nudge = function ( first, id, lim, pi, lt, dv, fn ) {
                if (self.nf[1]==id)self.nf[0]++;
                else self.nf[0] = 1;
                self.nf[1] = id;
                if (!first) {
                    if (self.nudgeP!==999) {
                        if (self.setPts[0][self.nudgeP][pi] * lt < lt * lim)self.setPts[0][self.nudgeP][pi] += dv * (self.nf[0] > 3 ? 5 : 1);
                    }
                    else {
                        if (pi===0) {
                            var dx = (self.bestFit[0][0] - self.bestFit[1][0])
                            , dy = self.bestFit[0][1] - self.bestFit[1][1]
                            , da = (dv < 0 ? -0.03 : 0.03)
                            , cr = Math.cos(da), sr = Math.sin(da);
                            self.bestFit[1][0] = self.bestFit[0][0] - (cr * dx - sr * dy);
                            self.bestFit[1][1] = self.bestFit[0][1] - (sr * dx + cr * dy);
                        }
                        else {
                            self.bestFit[0][1] -= dv * (self.nf[0] > 3 ? 5 : 1);
                            self.bestFit[1][1] -= dv * (self.nf[0] > 3 ? 5 : 1);
                        }
                    }
                }
                self.plotSetGraph(false);
                if (self.tEnd===false)setTimeout(fn, 200);
            };
            this.nLeft = function ( first ) {
                self.nudge(first, 0, self.data.xMin, 0, -1, -self.dx, "OUGPSelf.nLeft();");
            };
            this.nRight = function ( first ) {
                self.nudge(first, 1, self.data.xMax, 0, 1, self.dx, "OUGPSelf.nRight();");
            };
            this.nUp = function ( first ) {
                self.nudge(first, 2, self.data.yMax, 1, 1, self.dy, "OUGPSelf.nUp();");
            };
            this.nDown = function ( first ) {
                self.nudge(first, 3, self.data.yMin, 1, -1, -self.dy, "OUGPSelf.nDown();");
            };
            var s = this.pointSetting.split("__N__");
            this.setTable = "<div style='display:" + (self.data.showTable===false ? "none" : "block") + ";'><table id='OU" + self.name + "SetTable'><tbody>";
            for (i = (self.data.dims ? 1 : 0); i < s.length; i++) {
                if (i < 2)this.setTable += "<tr><th" + (i==0 ? " colspan='3'" : "") + " style='text-align:center;'>" + s[i].replace(/\t/g, "</th><th style='text-align:center;'>") + "</th></tr>";
                else this.setTable += "<tr><td style='text-align:center;'>" + s[i].replace(/\t/g, "</td><td>") + "</td></tr>";
            }
            this.setTable += "</tbody></table></div>"
            + (self.data.checkTable ? "<p style='position:relative;top:80%;text-align:right;'><a id='chkTB' " + self.link + "OUGPSelf.checkTB();'>&#160;Check&#160;table&#160;</a></p>" : "")
            ;
            if (self.data.checkTable===true) {
                self.nTChks = ((OU.LocalStorage.load("OU" + self.name + "TOK")==="OK") ? 3 : 0);
            }
            else {
                OU.LocalStorage.save("OU" + self.name + "TOK", "OK");
                self.nTChks = 3;
            }
            self.checkTB = function () {
                var i, j, itm, cl, col = self.data.colToCheck - 1, tp
                , vl
                , ok, DPOk, DPOks = true, DPCh, allOK, s = "", fn, tbl = document.getElementById("OU" + self.name + "SetTable"), tbOff = (self.data.dims ? 1 : 2);
                if (self.data.checkTable)self.nTChks++;
                for (i = self.answerData.length; i--;) {
                    itm = document.getElementById("ti" + i + "_" + col);
                    if (itm) {
                        vl = (self.keypad ? itm.innerHTML : itm.value);
                        if (Math.abs(parseFloat(vl) - self.answerData[i][1]) < self.data.tableAccuracy) {
                            DPOk = true;
                            if (self.data.tableDecPlaces) {
                                var dpp = vl.indexOf(".");
                                if (dpp >= 0) {
                                    var ch = (vl.charAt(dpp + self.data.tableDecPlaces + 1));
                                    if (ch >= '0' && ch <= '9')DPOk = false;
                                    else {
                                        for (j = self.data.tableDecPlaces; j--;) {
                                            ch = vl.charAt(dpp + j + 1);
                                            if (ch < '0' || ch > '9' || ch==undefined)DPOk = false;
                                        }
                                    }
                                }
                                else DPOk = false;
                            }
                            if (!DPOk) {
                                DPCh = '!';
                                DPOks = false;
                            }
                            else DPCh = '';
                            cl = tbl.rows[i + tbOff].cells[col];
                            tp = cl.innerHTML.indexOf("\u2714");
                            if (tp < 0 && DPOk) {
                                cl.innerHTML = "" + vl + "<span class='tsp' style='color:#070;background:transparent;padding:2px;border:none;'>\u2714" + DPCh + "</span>";
                                ok++;
                            }
                        }
                    }
                }
                ok = self.sCount(tbl.innerHTML, "\u2714") - self.sCount(tbl.innerHTML, "!");
                allOK = (ok===self.answerData.length);
                s = "" + ((allOK ? "All" : ok || "None")) + " of your table entries " + (ok===1 ? "is" : "are") + " correct. " + (DPOks ? "" : " Remember to give answers to " + self.data.tableDecPlaces + " decimal place" + (self.data.tableDecPlaces!==1 ? "s" : "") + ".") + "<br/><br/>";
                if (self.nTChks < 3)s += " Try again.<br/><br/>";
                else {
                    OU.LocalStorage.save("OU" + self.name + "TOK", "OK");
                    self.showDiv("nudgesD", true);
                    s += (allOK ? "" : "<a " + self.link + "OUGPSelf.clearTableTicks();'>Solve table</a>");
                    if (self.data.dims) {
                        self.data.introText = "Plot the points by pressing on the appropriate area in the graph. "
                        + (self.data.nudgeB ? "You can nudge the points into position using the arrow buttons. " : "")
                        + "To change the position of any point, press on it.<br/><br/>"
                        + "When all " + (self.answerData.length) + " points have been placed correctly, you will be able to create and adjust a best-fit line, by pressing and dragging on the graph. "
                        + (self.data.nudgeB ? "You can then use the arrows to nudge your line into position, or pivot it by pressing and dragging." : "")
                        + "<br/><br/>"
                        ;
                        s += self.data.introText;
                    }
                    fn = "hideDiv(\"introD\");";//OUGPSelf.clearTableTicks();";
                }
                self.showIntro(s, null, null, false, fn);
            };
            self.clearTableTicks = function () {
                if (self.data.checkTable)self.showEl("chkTB", "none");
                var tbl = document.getElementById("OU" + self.name + "SetTable"), i
                , col = self.data.colToCheck - 1, rw
                , tbOff = (self.data.dims ? 1 : 2);
                for (i = self.answerData.length; i--;) {
                    rw = tbl.rows[i + tbOff];
                    rw.cells[col].innerHTML = self.answerData[i][1];
                    rw.style.height = '' + ((self.h / 3 / self.answerData.length) | 0) + 'px';
                }
            };
            var n = this.answerData.length
            , sumx = 0, sumy = 0, sumxy = 0, sumx2 = 0;
            for (i = this.answerData.length; i--;) {
                sumx += this.answerData[i][0];
                sumy += this.answerData[i][1];
                sumxy += this.answerData[i][0] * this.answerData[i][1];
                sumx2 += Math.pow(this.answerData[i][0], 2);
            }
            var den = (sumx * sumx - n * sumx2);
            this.answerData.m = (sumy * sumx - n * sumxy) / den;
            this.answerData.c = (sumx * sumxy - sumy * sumx2) / den;
            if (self.data.setBestFit===true) {
                self.bestFit = [];
                var x = (self.data.xMin + self.data.xMax) * 0.47;
                self.bestFit[0] = [x, self.answerData.m * x + self.answerData.c];
                x = (self.data.xMin + self.data.xMax) * 0.53;
                self.bestFit[1] = [x, self.answerData.m * x + self.answerData.c];
                self.bestFit.m = self.answerData.m;
                self.bestFit.c = self.answerData.c;
                self.nTChks = 3;
            }
            if (self.data.showRiseTread)self.showRiseTread = true;
            this.nCheckP = 0;
            this.nCheckBF = 0;
            this.reset = function () {
                self.resetTable();
                self.plotSetGraph(true);
                self.hideDiv("checkD");
                self.showEl("rstB", "none");
            };
            this.resetB = function () {
                self.check("<br/><br/>Reset plotted points", "reset();");
            };
            this.checkB = function () {
                var s = self.checkPs();
                if (self.ptsOK)s = s + self.checkBF();
                self.message(s, null, null, false);
            };
            this.checkPs = function () {
                var ok = 0, gw = self.data.xMax - self.data.xMin
                , gh = self.data.yMax - self.data.yMin, cl, i, j, tp, cj;
                self.clearCheck();
                self.plotSetGraph(false);
                self.layer.context.fillStyle = '#070';
                for (i = self.setPts[0].length; i--;) {
                    cj = -1;
                    for (j = self.answerData.length; j--;) {
                        if (Math.abs(self.answerData[j][0] - self.setPts[0][i][0]) / gw < 0.03 && Math.abs(self.answerData[j][1] - self.setPts[0][i][1]) / gh < 0.03) {
                            self.setPts[0][i].correct = true;
                            cj = j;
                        }
                    }
                    cl = document.getElementById("OU" + self.name + "SetTable").rows[cj + 1].cells[0];
                    tp = cl.innerHTML.indexOf("\u2714");
                    if (self.setPts[0][i].correct) {
                        self.layer.context.fillText("\u2714", self.xpt(self.setPts[0][i][0]) + self.scale * 0.009, self.ypt(self.setPts[0][i][1]) - self.scale * 0.01);
                        if (tp < 0) {
                            cl.innerHTML += "<span class='tsp' style='color:#070;background:transparent;padding:2px;border:none;'>\u2714</span>";
                        }
                    }
                }
                ok = self.sCount(document.getElementById("OU" + self.name + "SetTable").innerHTML, "\u2714");
                self.ptsOK = (ok==self.answerData.length);
                var ofS = " of the " + self.answerData.length + " points";
                return (self.ptsOK ? "All points are correctly placed.<br/><br/>" : ("" + (ok==0 ? "No " : ok) + " point"
                    + (ok==1 ? ofS + " is " : "s" + (ok > 0 ? ofS : "") + " are")) + " correctly placed."
                + ((self.nCheckP++) > 1 && !self.ptsOK ? "<br/><br/><br/><a " + self.link + "OUGPSelf.showPoints();'>Show points</a><br/><br/><br/><a " + self.link + "OUGPSelf.showPoints(true);'>Place points</a>" : " Try again. ")
                    + "<br/><br/>"
                    );
            };
            self.showPoints = function ( show, hint ) {
                var g = self.layer.context, x, y, w = self.scale * 0.005, i;
                if (show) {
                    for (i = self.answerData.length; i--;) {
                        self.nudgeP = i;
                        self.setPts[0][i] = self.answerData[i];
                        self.plotSetGraph(false);
                    }
                    self.ptsOK = true;
                    if (hint!==false) {
                        self.hint(self.placeBF());
                    }
                }
                else {
                    g.beginPath();
                    g.strokeStyle = '#080';
                    for (i = self.answerData.length; i--;) {
                        x = self.xpt(self.answerData[i][0]);
                        y = self.ypt(self.answerData[i][1]);
                        g.moveTo(x - w, y - w);
                        g.lineTo(x + w, y + w);
                        g.moveTo(x - w, y + w);
                        g.lineTo(x + w, y - w);
                    }
                    g.closePath();
                    g.stroke();
                }
                self.hideDiv("checkD");
            };
            self.showBF = function () {
                var g = self.layer.context;
                self.setClip(g, self.xpt(self.data.xMin), self.ypt(self.data.yMin), self.xpt(self.data.xMax), self.ypt(self.data.yMax));
                g.beginPath();
                g.strokeStyle = '#080';
                g.moveTo(self.xpt(self.data.xMin), self.ypt(self.answerData.m * self.data.xMin + self.answerData.c, true));
                g.lineTo(self.xpt(self.data.xMax), self.ypt(self.answerData.m * self.data.xMax + self.answerData.c, true));
                g.closePath();
                g.stroke();
                g.restore();
            };
            if (self.data.setPoints===true)self.showPoints(true, false);
            self.showDisc = function ( page ) {
                var d = self.data.discussion[page]
                , s = d.txt
                , n = self.data.discussion.length
                , dims = d.dims;
                self.showRiseTread = (self.data.showRiseTread || d.showRiseTread);
                var store = "";
                for (var c = 1; c < 50; c++) {
                    if (s.indexOf("__TEXTINPUT" + c + "__") >= 0) {
                        s = s.replace("__TEXTINPUT" + c + "__",
                            self.setTxtIn("OUGPTextIn" + c, (OU.LocalStorage.load("OU" + self.name + "TxtIn" + c)), "OU" + self.name + "TxtIn" + c
                                ));
                        if (this.keypad)store += "OU.LocalStorage.save(\"OU" + self.name + "TxtIn" + c + "\",document.getElementById(\"" + "OUGPTextIn" + c + "\").innerHTML);";
                    }
                }
                s = s.replace("__BOXINPUT__", "<textarea id='OUGPQTA' onkeyup='OU.LocalStorage.save(\"OUGPTATxt\",this.value);' ontouchend='OU.LocalStorage.save(\"OUGPTATxt\",this.value);' style='width:95%;height:50%;'>" + (OU.LocalStorage.load("OUGPTATxt") || "") + "</textarea>")
                .replace("__BOXOUTPUT__", "<p style='border:solid;border-width:1px;background:#eef;padding:3%;'><b>Your answer</b>: " + ((OU.LocalStorage.load("OUGPTATxt") || "").replace(/\n/g, "<br/>") || "") + "</p>");
                if (s.indexOf("__DISCTEXT__") >= 0)s = self.data.discussionText(self, page)
                    + s.replace("__DISCTEXT__", "");
                page++;
                if (page < n) {
                    s += "<p style='text-align:right'><a " + self.link + store + "OUGPSelf.showDisc(" + (page) + ")'>Next</a></p>";
                    self.message(s, -1, dims);
                }
                else {
                    self.message(s, "OK", dims, null, store + "showRiseTread=OUGPSelf.data.showRiseTread;OUGPSelf.hideDiv(\"checkD\");");
                }
            };
            self.placeBF = function () {
                self.bestFit = [
                [(self.data.xMin + self.data.xMax) / 2, (self.data.yMin + self.data.yMax) / 2]
                ];
                self.bestFit.m = 1e-50;
                self.bestFit.c = (self.data.yMin + self.data.yMax) / 2;
                return (self.data.extraBFFeedback || "") + "Place a best-fit line by pressing and dragging on the graph.";
            };
            self.checkBF = function () {
                if (!self.bestFit)return self.placeBF();
                if (isNaN(self.bestFit.m))return self.placeBF();
                var dy = (self.data.yMax - self.data.yMin) * 0.03
                , os = "", sok = false
                , xa = (self.data.xMin + self.data.xMax) / 2
                , y1 = self.bestFit.m * xa + self.bestFit.c
                , y2 = self.answerData.m * xa + self.answerData.c
                ;
                self.bfOK = false;
                if (self.bestFit.m * self.answerData.m < 0)os = "The slope of your best-fit line is in the wrong direction.<br/><br/>";
                else if (Math.abs(self.bestFit.m) > Math.abs(self.answerData.m) * 1.03)os = "The slope of your best-fit line is too high.<br/><br/>";
                else if (Math.abs(self.bestFit.m) < Math.abs(self.answerData.m) * 0.97)os = "The slope of your best-fit line is too low.<br/><br/>";
                else sok = true;
                if (y1 > y2 + dy)os += "Your best-fit line is placed too high.";
                else if (y1 < y2 - dy)os += "Your best-fit line is placed too low.";
                else if (sok && self.bestFit.m) {
                    os = "Your best-fit line is correctly placed.";
                    self.bfOK = true;
                }
                self.nCheckBF++;
                if (!self.bfOK && self.nCheckBF < 3)os += "<br/><br/>Try again. ";
                os += "<br/><br/>";
                if (((self.nCheckBF) > 2 || self.bfOK) && self.bestFit.m) {
                    if (!self.bfOK)os += "<a " + self.link + "OUGPSelf.showBF();'>Show best-fit line</a><br/><br/><br/>";
                    if (self.data.discussion)os += "<br/><a " + self.link + "OUGPSelf.showDisc(0);'>&#160;" + (self.data.discussion[0].buttonTxt || "Discussion") + "&#160;</a><br/><br/>";
                }
                return os;
            };
            //var down="onmousedown",up="onmouseup";
            var down = "ontouchstart", up = "ontouchend";
            var sps = " kclass='gpd' style='font-size:110%;padding:3%;color:#bdf;' onclick='' " + up + "='OUGPSelf.nf[0]=1;OUGPSelf.tEnd=true;' " + down + "='OUGPSelf.tEnd=false;";
            this.nudgesS = ""
            + (self.data.nudgeB ? "<span " + sps + "OUGPSelf.nUp(true);'>&#160;&#8593;&#160;</span><br/><br/>"
                + "<span " + sps + "OUGPSelf.nLeft(true);'>&#160;&#8592;&#160;</span>&#160;&#160;&#160;&#160;&#160;&#160;"
                + "<span " + sps + "OUGPSelf.nRight(true);'>&#160;&#8594;&#160;</span><br/><br/>"
                + "<span " + sps + "OUGPSelf.nDown(true);'>&#160;&#8595;&#160;</span><br/><br/>" : "")
            + (self.data.setBestFit && self.data.showRiseTread ?
                "<a  style='display:none;' id='chkB' " + self.link + "OUGPSelf.showDisc(0);OUGPSelf.hideDiv(\"introD\");'>&#160;Calculate gradient&#160;</a><br/><br/>"
                : "<p style='display:none;' id='chkB'>"
                + "<a " + self.link + "OUGPSelf.checkB();'>&#160;Check&#160;</a>"
                + "</p>"
                )
            + (self.data.setPoints ? "<p id='rstB'/>" : "<br/>"
                + "<p style='display:none;' id='rstB'>"
                + "<a id='rstB' " + self.link + "OUGPSelf.resetB();'>&#160;Reset&#160;</a>"
                + "</p>"
                )
            ;
            self.dvs["tableD"].div.setHTML((self.data.inLineText || "") + this.setTable + (self.data.inLineText2 || ""));
            this.showDiv("tableD", true);
            self.dvs["nudgesD"].div.setHTML(this.nudgesS);
            if (self.data.checkTable && OU.LocalStorage.load("OU" + self.name + "TOK"))self.hideDiv("nudgesD");
            else this.showDiv("nudgesD", true);
            this.showIntro(self.data.introText);
            if (self.data.dims) {
                this.getBF = function ( x, y ) {
                    if (isNaN(self.bestFit.m))return;
                    if (self.showRiseTread && self.bestFit.m) {
                        var xx = self.ixpt(x), v = self.bestFit.c + self.bestFit.m * self.ixpt(x);
                        if (v > self.data.yMax)return [(self.data.yMax - self.bestFit.c) / self.bestFit.m, self.data.yMax];
                        if (v < self.data.yMin)return [(self.data.yMin - self.bestFit.c) / self.bestFit.m, self.data.yMin];
                        return [xx, v];
                    }
                    else return [self.ixpt(x), self.iypt(y)];
                };
                this.checkPinch = function ( ev ) {
                    if (ev.touches[1] && self.ptsOK) {
                        self.bestFit = [self.getBF(ev.touches[0].clientX, ev.touches[0].clientY - self.margin), self.getBF(ev.touches[1].clientX, ev.touches[1].clientY - self.margin)];
                        self.changeBestFit = true;
                        self.nudgeP = 999;
                        self.plotSetGraph(false);
                        return true;
                    }
                    return false;
                };
                self.endM = false;
                this.layer.canvas.onmouseup =
                this.layer.canvas.ontouchend =
                function ( ev2 ) {
                    self.showEl("chkB", "block");
                    self.showEl("rstB", "block");
                    self.endM = true;
                    self.touched = false;
                    self.nudgeP = -1;
                    self.plotSetGraph(false);
                    return;
                };
                self.mn = 0;
                this.layer.canvas.onmousemove =
                this.layer.canvas.ontouchmove =
                function ( ev2 ) {
                    if (self.endM)return;
                    self.mn++;
                    if (self.mn < 3)return;
                    self.mn = 0;
                    if (self.nTChks < 3)return;
                    self.moved = true;
                    var ev, ev1;
                    if (!ev2.touches)ev1 = {
                        touches:[
                        {
                            clientX:ev2.clientX,
                            clientY:ev2.clientY
                        }
                        ]
                    };
                    else ev1 = ev2;
                    if (ev1.touches) {
                        if (self.checkPinch(ev1))return;
                        ev = {
                            clientX:ev1.touches[0].clientX,
                            clientY:ev1.touches[0].clientY
                        };
                    }
                    if (!ev)ev = {
                        clientX:ev1.clientX,
                        clientY:ev1.clientY
                    };
                    ev.clientY -= self.margin;
                    if (self.changeBestFit && self.bfp >= 0) {
                        self.bestFit[self.bfp] = self.getBF(ev.clientX, ev.clientY);
                        self.plotSetGraph(false);
                    } else if (self.nudgeP >= 0 && self.nudgeP < 999 && self.touched) {
                        var xp = self.ixpt(ev.clientX), yp = self.iypt(ev.clientY);
                        self.setPts[0][self.nudgeP] = [xp, yp];
                        self.plotSetGraph(false);
                    }
                };
                this.layer.canvas.onmousedown =
                this.layer.canvas.ontouchstart =
                function ( ev2 ) {
                    self.endM = false;
                    if (self.nTChks < 3)return;
                    self.moved = false;
                    self.touched = true;
                    var ev, ev1;
                    if (!ev2.touches)ev1 = {
                        touches:[
                        {
                            clientX:ev2.clientX,
                            clientY:ev2.clientY
                        }
                        ]
                    };
                    else ev1 = ev2;
                    if (ev1.touches) {
                        if (self.checkPinch(ev1))return;
                        ev = {
                            clientX:ev1.touches[0].clientX,
                            clientY:ev1.touches[0].clientY
                        };
                    }
                    if (!ev)ev = {
                        clientX:ev1.clientX,
                        clientY:ev1.clientY
                    };
                    ev.clientY -= self.margin;
                    var i, xp = self.ixpt(ev.clientX)
                    , yp = self.iypt(ev.clientY)
                    , hit = -1;
                    if (!self.data.setPoints) {
                        for (i = self.setPts[0].length; i--;)if (Math.abs(self.setPts[0][i][0] - xp) < self.dx * 5 && Math.abs(self.setPts[0][i][1] - yp) < self.dy * 5)hit = i;
                    }
                    var nd = document.getElementById("nudgesD");
                    self.changeBestFit = false;
                    if (self.bestFit) {
                        if (self.bestFit[0] && self.bestFit[1]) {
                            hit = -1;
                            self.bfp = -1;
                            for (i = 2; i--;)if (self.bestFit[i])if (Math.abs(self.ixpt(ev.clientX) - self.bestFit[i][0]) < self.dx * 5 && Math.abs(self.iypt(ev.clientY) - self.bestFit[i][1]) < self.dy * 5)self.bfp = i;
                            if (self.bfp >= 0) {
                                self.bestFit[self.bfp] = self.getBF(ev.clientX, ev.clientY);
                                self.changeBestFit = true;
                                self.nudgeP = 999;
                                self.plotSetGraph(false);
                            }
                        }
                    }
                    if (hit < 0) {
                        if (self.setPts[0].length > 0)self.showEl("chkB", "block");
                        if (self.setPts[0].length > self.answerData.length - 1) {
                            self.showEl("rstB", "block");
                            if (self.ptsOK) {
                                if (!self.bestFit) {
                                    self.bfp = 0;
                                    self.bestFit = [
                                    [self.ixpt(ev.clientX), self.iypt(ev.clientY)],
                                    null
                                    ];
                                    self.changeBestFit = true;
                                } else if (!self.bestFit[0]) {
                                    self.bfp = 0;
                                    self.bestFit = [
                                    [self.ixpt(ev.clientX), self.iypt(ev.clientY)],
                                    null
                                    ];
                                    self.changeBestFit = true;
                                } else if (!self.bestFit[1]) {
                                    self.bfp = 1;
                                    self.bestFit[1] = [self.ixpt(ev.clientX), self.iypt(ev.clientY)];
                                    self.changeBestFit = true;
                                }
                                self.showEl(nd, "block");
                                self.nudgeP = -1;
                                if (self.changeBestFit) {
                                    self.nudgeP = 999;
                                    self.plotSetGraph(false);
                                }
                            }
                        }
                        else {
                            self.showEl(nd, "block");
                            self.setTableS += "__N__" + xp + "\t" + yp;
                            self.nudgeP = self.setPts[0].length;
                            self.plotSetGraph(true);
                        }
                    }
                    else {
                        self.nudgeP = hit;
                        self.showEl(nd, "block");
                        self.plotSetGraph(false);
                    }
                }
            }
            if (self.dvs["helpD"] && self.data.introText) {
                self.dvs["helpD"].div.setHTML("<a class='infoButton' " + self.link + "OUGPSelf.data.introOKButton=true;OUGPSelf.showIntro(OUGPSelf.data.introText);' >&#160;&#160;&#160;</a>");
                self.showDiv("helpD", true);
            }
        }
    };
    OU.activity.GraphPlotter.prototype.resize = function () {
        var self = this, margin = this.margin
        , margin2 = margin * 2
        , s, i, bpn;
        OU.activity.GraphPlotter.superClass_.resize.call(this);
        if (this.h < (this.w * 0.5) + margin2)this.scale = (this.h - margin) * 1.5;
        else this.scale = (this.w - margin)*0.95;
        this.scale *= (this.data.scale || 1)*0.96;
        s = this.scale;
        this.layer.resize({
            x:0.01,
            y:0.01 + margin,
            w:this.w,
            h:this.h
        });
        this.calculator.resize();
        for (i = this.buttons.length; i--;) {
            bpn = true;
            if (bpn) {
                this.buttons[i].resize({
                    x:this.buttons[i]._x * s,
                    y:this.buttons[i]._y * s + margin,
                    h:s / 33,
                    w:s / 10 * this.buttons[i].id.length / 11 + 2
                });
            }
            else {
                this.buttons[i].resize({
                    x:this.w + 100,
                    y:this.buttons[i]._y * s + margin,
                    h:s / 33,
                    w:s / 10 * this.buttons[i].id.length / 11 + 2
                });
            }
            this.buttons[i].render();
        }
        for (i = this.divs.length; i--;) {
            this.divs[i].resize({
                x:this.divs[i]._x * s,
                y:this.divs[i]._y * s + margin,
                w:this.divs[i]._w * s,
                h:this.divs[i]._h * s,
                container:this
            });
            this.divs[i].div.style.fontSize = ((s / 57) | 0) + "px";
            self.showEl(this.divs[i].div, (this.divs[i].vis===false ? "none" : "block"));
        }
        if (this.dvs["helpD"])this.dvs["helpD"].resize({
            y:(this.dvs["titleD"]?parseInt(this.dvs["titleD"].div.style.top)+12:this.margin),
            container:this
        });
                this.render();
        if (this.plotSetGraph)this.plotSetGraph(false);
    };
    OU.activity.GraphPlotter.prototype.drawIm = function ( ctx, i, s ) {
        var im = this.images["imid" + i];
        ctx.drawImage(im.img, s * im.x, s * im.y, s * im.w, s * im.h);
    };
    OU.activity.GraphPlotter.prototype.render = function () {
        this.ctx = this.layer.context;
        var ctx = this.ctx, s = this.scale
        ;
        ctx.font = 'bold ' + s / 60 + 'px helvetica,ariel,sans';
        ctx.textAlign = 'left';
        if (this.data.render)this.data.render(this);
        this.doRender = false;
    };
    OU.activity.GraphPlotter.prototype.decPlaces = function ( v, p ) {
        p = Math.pow(10, p);
        return (parseInt(v * p + (v > 0 ? 0.5 : -0.5))) / p;
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.GraphPlotter, OU.util.Activity);
