OU.require('OU.util.Controller');
OU.require('OU.util.TiledMenu');
/**
 * @class
 * @extends OU.util.Controller
 */
OU.activity.TiledController = function ( TiledControllerData, instance, controller ) {
    OU.activity.TiledController.prototype.canvasView = function () {
        OU.activity.TiledController.superClass_.canvasView.call(this); // call the parent class canvasView
        var bH = OU.controlHeight;
        if (this.data.menus) {
            this.newMenus = new OU.util.TiledMenu({
                container:{
                    controller:this,
                    instance:this.instance,
                    x:this.x,
                    y:this.y,
                    w:this.w,
                    h:this.h
                },
                menus:this.data.menus,
                dontRegister:this.baseController,
                x:this.x,
                y:this.y + this.headerHeight,
                w:this.w,
                h:this.data.menus.levels * bH,
                zIndex:this.zOffset + 100
            });
            this.menuHeight = this.newMenus.h;
        }
    };
    OU.activity.TiledController.prototype.header = function ( h ) {
        console.log('header');
        return null;
        OU.activity.TiledController.superClass_.header.call(this, h); // call the parent class resize
        /* if(this.newMenus) {
         this.newMenus.resize({
         x:this.x,
         y:this.y+this.headerHeight,
         w:this.w,
         h:this.h-this.headerHeight
         });
         }*/
        this.resize();
    };
    OU.activity.TiledController.prototype.resize = function () {
        OU.activity.TiledController.superClass_.resize.call(this); // call the parent class resize 
        /*
         if (this.newMenus)
         this.newMenus.resize({
         x:this.x,
         y:this.y+this.headerHeight,
         w:this.w,
         h:this.h-this.headerHeight
         });

         */
    };
    OU.activity.TiledController.prototype.remove = function () {
        OU.activity.TiledController.superClass_.remove.call(this); // call the parent class resize 
        /*  if (this.newMenus)
         this.newMenus.menuDiv.remove();

         */
    };
    OU.activity.TiledController.prototype.step = function ( n ) { // Jump to section n
        console.log('step');
        var a, j, s = this.section, self = this;
        OU.LocalStorage.save("OU.control.sectionID." + this.instance + "." + this.data.SaveID, this.sectionNum);
        for (j = s.activities.length; j--;) {
            a = s.activities[j];
            a._zOffset = this.zOffset + 100 * (j + 1);
            if (!a._dataLoaded) {
                this.loadData(a);
                return;
            }
        }
        if (OU.requiredFiles > OU.fileCount) {
            setTimeout(function () {
                self.loadSectionTC();
            }, 40);
            return;
        }
        this.render();
        this.startSection();
    };
    OU.activity.TiledController.prototype.loadSection = function () {
        console.log('override loadSection');
        return null;
    };
    OU.activity.TiledController.prototype.loadSectionTC = function () {
        console.log('loadSection');
        //    return null;
        var a, j, s = this.section, self = this;
        OU.LocalStorage.save("OU.control.sectionID." + this.instance + "." + this.data.SaveID, this.sectionNum);
        for (j = s.activities.length; j--;) {
            a = s.activities[j];
            a._zOffset = this.zOffset + 100 * (j + 1);
            if (!a._dataLoaded) {
                this.loadData(a);
                return;
            }
        }
        if (OU.requiredFiles > OU.fileCount) {
            setTimeout(function () {
                self.loadSection();
            }, 40);
            return;
        }
        this.render();
        this.startSection();
    };
    OU.activity.TiledController.prototype.loadData = function ( activity ) {
        console.log('load data');
        var self = this;
        activity._dataLoaded = false;
        if (activity.inline!=null) {
            // loads directly into the object bypassing page injection
            activity._data = activity.inline;
            activity._dataLoaded = true;
            self.loadSectionTC();
        }
        else {
            var inc = document.createElement('script');
            inc.src = activity.data + 'data.js';
            inc.type = 'text/javascript';
            inc.onload = function () {
                activity._data = data;
                activity._dataLoaded = true;
                self.loadSectionTC();
            };
            if (document.all) { // Fix for IE's lack of 'onload' support
                inc.onreadystatechange = function () {
                    if (inc.readyState=='complete' || inc.readyState=='loaded') {
                        activity._data = data;
                        activity._dataLoaded = true;
                        self.loadSectionTC();
                    }
                }
            }
            OU.head.appendChild(inc);
        }
    };
    OU.base(this, TiledControllerData, instance, controller);
};
if (OU.util.Controller) {
    OU.inherits(OU.activity.TiledController, OU.util.Controller);
}
else {
    OU.preOnLoad.push(function () {
        OU.inherits(OU.activity.TiledController, OU.util.Controller);
    });
}