/**
 * ElectronPanel - Displays text and buttons for electrons
 *
 * @author Will Rawes
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Button');
OU.require('OU.util.Keyboard');
OU.require('OU.util.HtmlBox');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.ElectronPanel = function ( data, instance, controller ) {
    OU.loadCSS("style.css");
    OU.activity.ElectronPanel.prototype.canvasView = function () {
        if (!OU.obj)OU.obj = [];
        OU.obj[this.instance] = this;
        var self = this, act = this.instance;
        this.pageNum = act.substring(4, act.indexOf("_", 4));
        var i, v;
        this.layer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            zIndex:OU.OVERLAY_CONTROLLER_LEVEL
        });
        this.divBackground = '#fcfcfc';
        this.bBack = {col:'#222', radius:3, borderCol:'#888'};
        this.layer.resize();
        this.specPanel = OU.obj["_act1_1"];
        this.EPanel = OU.obj["_act1_2"];
        this.cloudPanel = OU.obj["_act1_3"];
/*        this.specHePanel = OU.obj["_act9_1"];
        this.EHePanel = OU.obj["_act9_2"];
        this.cloudHePanel = OU.obj["_act9_3"];
        this.specLiPanel = OU.obj["_act15_1"];
        this.ELiPanel = OU.obj["_act15_2"];
        this.cloudLiPanel = OU.obj["_act15_3"];//*/
        this.specHePanel = OU.obj["_act"+this.pageNum+"_4"];
        this.EHePanel = OU.obj["_act"+this.pageNum+"_5"];
        this.cloudHePanel = OU.obj["_act"+this.pageNum+"_6"];
        this.specLiPanel = OU.obj["_act"+this.pageNum+"_4"];
        this.ELiPanel = OU.obj["_act"+this.pageNum+"_5"];
        this.cloudLiPanel = OU.obj["_act"+this.pageNum+"_6"];
        this.qNum = 1;
        this.numTries = 0;
        this.calculator = new OU.util.Keyboard({
            keys:"0\u00a01\u00a02\u00a03\u00a04\u00a05\u00a06\u00a07\u00a08\u00a09\u00a0-\u00a0\n q\u00a0w\u00a0e\u00a0r\u00a0t\u00a0y\u00a0u\u00a0i\u00a0o\u00a0p\u00a0\n a\u00a0s\u00a0d\u00a0f\u00a0g\u00a0h\u00a0j\u00a0k\u00a0l\u00a0:\u00a0\n z\u00a0x\u00a0c\u00a0v\u00a0b\u00a0n\u00a0m\u00a0.\u00a0",
            x:0.3,
            y:0.6,
            w:0.418,
            h:0.47,
            maxChars:30,
            ok:true,
            okFn:function () {
                OU.thsKP.dispDiv.innerHTML = OU.thsKP.div.div.innerHTML;
                OU.thsKP.dispDiv.style.border = 'solid 1px';
                OU.thsKP.setVisible(false);
                OU.LocalStorage.save("OU" + self.name + "TbCell" + OU.thsKP.dispDiv.id + "",
                    (document.getElementById(OU.thsKP.dispDiv.id) ? document.getElementById(OU.thsKP.dispDiv.id).innerHTML || "" : ""));
            },
            background:'#fcfcfc',
            formatting:false,
            unicode:false,
            space:true,
            specials:false,
            container:this,
            zIndex:OU.OVERLAY_CONTROLLER_LEVEL + 1000
        });
        OU.thsKP = this.calculator;
        this.keypad = {
            resize:function () {
            }
        };
        this.setHtml = function ( itm, s ) {
            s=s.replace(/ = /g,"&#160;=&#160;").replace(/ × /g,"&#160;×&#160;").replace(/ eV/g,"&#160;eV")
            .replace(/\<i\>/g,"<i style='font-size:100%;'>")
            .replace(/\<sub\>/g,"<sub style='font-size:80%;'>")
            .replace(/\<sup\>/g,"<sup style='font-size:80%;'>")
            ;
            if (s.indexOf("<input type='text'") >= 0) {
                s = s.replace("<input type='text'", "<span style='position:relative;ddisplay:block;display:-moz-inline-block; display:-moz-inline-box; display:inline-block;font-size:100%;background:#fff;width:50%;height:6%;border:solid 1px;border-radius:3px;' class='inputDiv'  onclick='this.style.border=\"solid 3px\";OU.thsKP.dispDiv=this;OU.thsKP.setVisible(true,\" \"+this.innerHTML);' ").replace("</input>", "</span>");
            }
            itm.div.innerHTML = s;
        };
        this.htmlBox = new OU.util.HtmlBox({
            html:"",
            unclosable:true,
            handleScrolling:false,
            style:"",//'overflow:visible',
            container:this
        });
        this.setHtml(this.htmlBox, self.data.html + (self.data.txtQ01 || ""));
        this.htmlBox.div.style.borderStyle = 'solid';
        this.htmlBox.div.style.borderColor = '#ddd';
        this.htmlBox.div.style.borderWidth = '1px';
        this.htmlBox.div.style.background = this.divBackground;
        this.htmlBox.div.style.padding = '10px';
        this.htmlBox.div.style.zIndex = OU.OVERLAY_CONTROLLER_LEVEL+400;
        this.feedbackB = new OU.util.HtmlBox({
            html:"",
            unclosable:true,
            handleScrolling:false,
            style:"",//'overflow:visible',
            container:this
        });
        this.setHtml(this.feedbackB, self.data.html + (self.data.txtQ01 || ""));
        this.feedbackB.show = function ( th, b, s ) {
            var h = self.h * 8;
            this.shown = b;
            if (s) {
                var p = s.indexOf("Press the N");
                if (p < 0)s = s + "<br/><br/>"
                    + (th.buttons[0].params.txt.indexOf("ontinue") < 0 ? "Press " + th.buttons[0].params.txt + " to continue." : "Press the Continue button.");
                self.setHtml(this, s);
            }
            this.div.style.width = self.w * 0.93 + "px";
            this.div.style.height = h * 0.65 + "px";
            this.div.style.left = self.w * 0.37 + "px";
            if (b)this.div.style.top = h * 0.4 + "px";
            else this.div.style.top = -th.h * 50 + "px";
        };
        this.feedbackB.show(this, false, "");
        this.feedbackB.div.style.borderStyle = 'solid';
        this.feedbackB.div.style.borderColor = '#ddd';
        this.feedbackB.div.style.borderWidth = '3px';
        this.feedbackB.div.style.background = this.divBackground;
        this.feedbackB.div.style.padding = '10px';
        this.titleBox = new OU.util.HtmlBox({
            html:"", //"<h1>"+self.data.title.replace(":",":<br/>")+"</h1>",
            unclosable:true,
            handleScrolling:false,
            style:'overflow:visible',
            container:this
        });
        v = this.data.audio;
        if (v) {
            this.audioH = "<audio id='_aud' controls='controls' width='" + this.w * 5 + "' height='40'>";
            for (i = v.sources.length; i--;) {
                this.audioH = this.audioH + "<source src='data/" + v.sources[i].src + "' type='" + v.sources[i].type + "' />";
            }
            this.audioH = this.audioH + "</audio>";
            this.audioBox = new OU.util.HtmlBox({
                html:self.audioH,
                style:'overflow:visible',
                container:this
            });
            this.audio = document.getElementById('_aud');
            this.audio.play();
        }
        this.buttons = [];
        this.bx = 0;
        for (i = 0; i < this.data.buttons.length; i++) {
            this.buttons[i] = new OU.util.Button({
                txt:self.data.buttons[i].txt,
                x:self.bx,
                y:0,
                padding:0,
                verticalPadding:0,
                background:this.bBack,
                layer:self.layer,
                onClick:self.data.buttons[i].action,
                onClickParam:self,
                container:self
            });
            this.bx += this.w / 3.6;
        }
        this.resize();
    };
    OU.activity.ElectronPanel.prototype.resize = function () {
        if (!this.titleBox.div)return;
        OU.activity.ElectronPanel.superClass_.resize.call(this);
        var self = this, bx = 0, i, its, fs;
        this.layer.resize();
        this.titleBox.resize({
            x:0.01,
            y:-self.h * 0.1,
            w:self.w * 1.9,
            h:self.h / 1.3
        });
        this.calculator.resize();
        this.titleBox.div.style.fontSize = ((this.h / 7) | 0) + "px";
        bx = this.w / 4 * 2.9;
        for (i = this.buttons.length; i--;) {
            if (this.buttons[i]) {
                this.buttons[i].resize({
                    x:bx, //i*this.w/3.7+this.w/25,
                    w:this.w / 4,
                    h:this.h * 0.6
                });
                bx -= this.w / 3.7;
            }
        }
        OU.EPNum=this.pageNum;
        if (OU.obj["_act9_3"])OU.obj["_act9_3"].EPNum = this.pageNum;
        if (OU.obj["_act15_3"])OU.obj["_act15_3"].EPNum = this.pageNum;
        if (OU.obj["_act1_3"])OU.obj["_act1_3"].EPNum = this.pageNum;
        fs = "" + ((this.w / 31) | 0) + "px";
        this.htmlBox.div.style.fontSize = fs;
        var resSp=(this.specPanel.specLayer?this.specPanel.specLayer.y > 0 && this.pageNum > 7 : false);
        if (this.EPanel.eLayer.x > 0 && this.pageNum > 7)
            this.htmlBox.resize({
                x:this.w * 0.65,
                y:this.cloudPanel.layer.y, //this.h*3.7,
                w:this.w * 1.,
                h:this.h * 6.3
            });
        else if(resSp){
            this.htmlBox.resize({
                x:this.w * 0.34,
                y:this.specPanel.specLayer.y + this.specPanel.specLayer.h, //this.h*5.9,
                w:this.w * 1.68,
                h:this.h * 4.3
            });
            
    }else if (this.cloudPanel.layer.x > 0 && this.pageNum > 7)
            this.htmlBox.resize({
                x:this.w * 0.02,
                y:this.cloudPanel.layer.y, //this.h*3.7,
                w:this.w * .72,
                h:this.h * 6.6
            });
        else
            this.htmlBox.resize({
                x:this.w * 0.34,
                y:this.cloudPanel.layer.y, //this.h*3.7,
                w:this.w * 1.04,
                h:this.h * 6.3
            });
        if (this.audioBox) {
            this.audioBox.resize({
                x:this.w * 0.32,
                y:this.h * 9.2,
                w:this.w * .7,
                h:this.h * 0.5
            });
        }
        this.feedbackB.show(this, this.feedbackB.shown);
        this.feedbackB.div.style.fontSize = ((this.h / 3.8) | 0) + "px";
        this.render();
        this.doRender = true;
    };
    OU.activity.ElectronPanel.prototype.point = function ( v, o ) {
        return 15 + v * this.scale - o;
    };
    OU.activity.ElectronPanel.prototype.render = function () {
        var ctx = this.layer.context, i
            , im;
        if (this.images) {
            for (i = this.images.length; i--;) {
                var imd = this.images[i], id = "imid" + i;
                im = document.getElementById(id);
                if (!im)im = document.createElement("img");
                im.id = id;
                im.src = imd.src;
                ctx.drawImage(im, this.w * imd.x, this.h * imd.y, this.w * imd.w, this.w * imd.h);
            }
        }
        for (i = this.buttons.length; i--;)if (this.buttons[i])this.buttons[i].render();
        this.doRender = false;
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.ElectronPanel, OU.util.Activity);
