/**
 * @fileoverview  Alt Controller Activity
 *
 * @author Martin Donnelly
 */
OU.require('OU.util.Controller');
OU.require('OU.util.Button');
OU.require('OU.util.DynText');
OU.require('OU.util.Layer');
OU.require('OU.util.Div');
OU.require('OU.util.Menu');
OU.require('OU.util.Instruction');
/**
 * The original sequential style controller extends the base OU.util.Controller class
 *
 * @class
 * @extends OU.util.Controller
 */
OU.activity.MDController = function ( controllerData, instance, controller ) { //NOTE: controllerData is intentionally not called data, so as not to be confused with the global variable data, that we use to load activity data.
    OU.activity.MDController.prototype.canvasView = function () {
        OU.activity.MDController.superClass_.canvasView.call(this); // call the parent class canvasView
        //  console.log("++++ MDController.canvasView");
        var bH = OU.controlHeight;
        // this.useControlBar = this.data.controlBar===false ? false : true;
        this.useControlBar = false;
        this.currentBackground = null;
        this.id = controllerData.options.id || "noid";
        console.log("++++ MDController.canvasView:" + this.id);
        if (!this.useControlBar)
            this.useNextPrev = false;
        else
            this.useNextPrev = this.data.sequentialButtons===false ? false : true;
        if (this.useControlBar) {
            this.controlLayer = new OU.util.Layer({
                dontRegister:this.baseController,
                x:this.x,
                y:this.y + this.h - bH,
                w:this.w,
                h:bH,
                zIndex:OU.CONTROLLER_LEVEL - 1,
                container:this,
                hasEvents:true,
                themeClass:"OUcontrolBar"
            });
            this.footerHeight = bH;
        }
        //       var cInner = this.controller || null;
        this.displayLayer = null;
        if (this.controller) {
            this.displayLayer = new OU.util.Layer({
                container:this,
                hasEvents:true,
                id:'c_front'

            });
        }
    };
    /**
     *
     */
    OU.activity.MDController.prototype.resize = function () {
        OU.activity.MDController.superClass_.resize.call(this); // call the parent class resize
        var bH = OU.controlHeight;
        if (this.currentBackground!=undefined) {
            this.bgLayer.resize();
            this.bgLayer.context.drawImage(this.currentBackground, 0, 0, this.bgLayer.w, this.bgLayer.h);
        }
    };
    /**
     *
     */
    OU.activity.MDController.prototype.remove = function () {
        OU.activity.MDController.superClass_.remove.call(this); // call the parent class remove
        console.log("---- MDController.canvasView:" + this.id);
        if (this.controller!==undefined) {
            if (this.useControlBar) {
                this.controlLayer.remove();
            }
        }
    };
    OU.activity.MDController.prototype.setBackground = function ( b ) {
        // this.controlLayer.events.flush();
        console.log("setting the background");
        if (this.currentBackground!=b) {
            this.currentBackground = b;
            this.bgLayer.context.drawImage(b, 0, 0, this.bgLayer.w, this.bgLayer.h);
        }
    };
    OU.activity.MDController.prototype.nextSection = function () {
        // this.controlLayer.events.flush();
        this.chgSection(this.sectionNum + 1);
    };
    OU.activity.MDController.prototype.prevSection = function () {
        //this.controlLayer.events.flush();
        this.chgSection(this.sectionNum - 1);
    };
    OU.activity.MDController.prototype.setSection = function ( i ) {
        // this.controlLayer.events.flush();
        this.chgSection(i);
    };
    OU.base(this, controllerData, instance, controller);
};
if (OU.util.Controller) {
    OU.inherits(OU.activity.MDController, OU.util.Controller);
}
else {
    OU.preOnLoad.push(function () {
        OU.inherits(OU.activity.MDController, OU.util.Controller);
    });
}


