/**
 * Created by JetBrains WebStorm.
 * User: md7967
 * Date: 05/12/11
 * Time: 10:28
 */
/**
 * OU.activity.Planner Object
 * @param {JSON array} data Data as included in the data/data.js file
 *
 * @author Martin Donnelly
 *
 * $Header: $
 *
 * currently disabled:
 * tea can be used to encrypt the stored data, currently unsure if it works on the iPad
 *
 * TODO - check encryption?
 */
OU.require('OU.util.DynText', '../library/js/util/dynText.js');
OU.require('OU.util.Layer', '../library/js/util/layer.js');
OU.require('OU.util.ImageLoader', '../library/js/util/imageloader.js');
//OU.require('OU.util.Tea', '../library/js/util/tea.js');
OU.activity.Planner = function ( data, instance, controller ) {
    OU.obj[instance] = this; // push this object into the OU object array using it's instance name
    OU.activity.Planner.prototype.init = function () {
        this.data = data || {};
        this.instance = instance || 'pln';
        this.controller = controller;
        var re = /accessible/,
            self = this;
        if (!re.test(window.location) && !!document.createElement('canvas').getContext) {
            this.config = {
                controlHeight:60,
                // height of control bar (accessible button)
                // animation settings
                sliderSpeed:2,
                inertiaFactor:1000, // set to minimum 2 for no inertia effect
                fps:40, // 40ms : 25 fps
                // 40ms = 25 fps
                // internal values below - will be overwritten anyway
                maxWidth:1024,
                // overwritten by canvas width
                maxHeight:768
            };
            this.clickable = new OU.util.TypedArray();
            this.aRGB = [];
            this.aColour = [];
            this.progress = {};
            this.displayStatus = true;
            this.progressID = 0;
            this.currentPage = 1;
            this.nextPage = 0;
            if (this.data.sections!=undefined) {
                this.totalPages = (this.data.sections.length ? this.data.sections.length : 0) + 1;
            }
            else {
                this.totalPages = 1;
            }
            this.inertia = 1;
            this.dormant = this.config.fps;
            this.CurX = 0;
            this.NextX = 0;
            this.breaker = 0;
            this.moveDirection = true;
            this.slideMotion = true;
            this.bufferA = null;
            this.bufferB = null;
            this.countdown = 1;
            this.slidecount = 0;
            //   this.rebuildProgressCache();
            var tProgress = OU.LocalStorage.load(this.data.uid + '.progress');
            if (tProgress==undefined) {
                this.progress = this.rebuildProgressCache();
            }
            else {
                //  var cupotea = new OU.util.Tea();
                //  this.progress = JSON.parse(cupotea.decrypt(tProgress, this.data.uid));
                this.progress = JSON.parse(tProgress);
            }
            this.displayMode();
            // create Canvas & Context
            OU.initPage();
            this.bgLayer = new OU.util.Layer({
                container:this
            });
            this.bgLayer.context.gradRect(); // draw background on backdrop layer
            if (this.displayStatus) {
                this.graphicLayer = new OU.util.Layer({
                    container:this,
                    hasEvents:false
                });
                this.controlLayer = new OU.util.Layer({
                    container:this,
                    hasEvents:true
                });
                var controlCtx = this.controlLayer.context;
                this.controlLayer.events.moveRight = function () {
                    self.nextSlide();
                    // //console.log("moveRight");
                };
                this.controlLayer.events.moveLeft = function () {
                    self.prevSlide();
                    // //console.log("moveLeft");
                };
            }
            else {
                this.graphicLayer = new OU.util.Layer({
                    container:this,
                    hasEvents:true
                });
            }
            if (this.displayStatus) {
                this.defineAreas();
            }
            else {
                this.defineUpdateAreas();
            }
            OU.onOrientChange(function () {
                self.resize();
            });
        }
        else {
            this.accessible(false); // render the accessible version
        }
        this.redraw();
    };
    OU.activity.Planner.prototype.rebuildProgressCache = function () {
        var cache = {};
        var progress = [];
        var log = [], e;
        //   var cupotea = new OU.util.Tea();
        for (var i in data.sections) {
            ////console.log(data.sections[i]);
            for (var t in data.sections[i].items) {
                e = {
                    id:data.sections[i].items[t].id,
                    totalpoints:data.sections[i].items[t].totalpoints,
                    score:0

                };
                progress[progress.length] = e;
            }
        }
        cache.progress = progress;
        cache.log = log;
        var cacheTXT = JSON.stringify(cache);
        //   cacheTXT = cupotea.encrypt(cacheTXT, data.uid);
        OU.LocalStorage.save(this.data.uid + '.progress', cacheTXT);
        return cache;
    };
    OU.activity.Planner.prototype.resize = function () {

        ////console.log("Planner resize");
        this.x = undefined;
        this.y = undefined;
        this.w = undefined;
        this.h = undefined;
        this.bgLayer.resize();
        this.bgLayer.context.gradRect(); // draw background on backdrop layer
        this.graphicLayer.resize();
        if (this.displayStatus) {
            this.defineAreas();
        }
        else {
            this.defineUpdateAreas();
        }
        this.redraw();
    };
    OU.activity.Planner.prototype.defineUpdateAreas = function () {
        var w = this.w * 0.6;
        var h = (w / 16 * 9);
        var x = (this.w - w ) / 2;
        var y = (this.h - h) / 2;
        this.panel = {
            x:x, y:y,
            w:w,
            h:h
        };
        this.textArea = {
            x:0, y:0, w:w, h:(h / 3) * 2
        };
        this.buttonArea =
        {
            x:0, y:(h / 3) * 2, w:w, h:(h / 3)
        };
    };
    OU.activity.Planner.prototype.defineAreas = function () {
        if (this.w < this.h * 3) { // portrait
            ////console.log('portrait');
            this.titleBar = {
                x:0, y:0,
                w:this.w,
                h:this.h * 0.05
            };
            this.graphicOU = {
                x:this.w * 0.7,
                y:this.titleBar.h,
                w:this.w * 0.3,
                h:(this.h - this.titleBar.h) / 2

            };
            this.graphicChart = {
                x:this.graphicOU.x,
                y:this.graphicOU.y + this.graphicOU.h,
                w:this.graphicOU.w,
                h:this.graphicOU.h

            };
        }
        else {
            ////console.log('Landscape');
            this.titleBar = {
                x:0, y:0,
                w:this.w,
                h:this.h * 0.05
            };
            this.graphicOU = {
                x:this.w * 0.7,
                y:this.titleBar.h,
                w:this.w * 0.3,
                h:(this.h - this.titleBar.h) / 2

            };
            this.graphicChart = {
                x:this.graphicOU.x,
                y:this.graphicOU.y + this.graphicOU.h,
                w:this.graphicOU.w,
                h:this.graphicOU.h

            };
        }
    };
    OU.activity.Planner.prototype.getScore = function ( id ) {
        for (var i in this.progress.progress) {
            if (this.progress.progress[i].id==id) return this.progress.progress[i].score;
        }
        return -1;
    };
    OU.activity.Planner.prototype.redraw = function () {
        if (this.displayStatus) {
            this.renderStatusV2();
            // this.renderStatus();
        }
        else {
            this.ask();
        }
    };
    OU.activity.Planner.prototype.ask = function () {
        var txt = this.data.item.txt ? this.data.item.txt : 'Are you sure you wish to mark this portion as complete?';
        var butX, butY, butW, butH, tbutX, tbutY;
//container: this,
        var ctx = this.graphicLayer.context, self = this;
        var clickable = this.graphicLayer.events.clickable;
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.save();
        ctx.fillStyle = 'rgba(26,26,26,0.75)';
        ctx.fillRect(this.panel.x + 5, this.panel.y + 5, this.panel.w, this.panel.h);
        ctx.fillStyle = '#afdfe4';
        ctx.strokeStyle = '#1a1a1a';
        ctx.fillRect(this.panel.x, this.panel.y, this.panel.w, this.panel.h);
        ctx.fillStyle = 'rgba(242,242,242,0.75)';
        ctx.fillRect(this.panel.x + this.buttonArea.x, this.panel.y + this.buttonArea.y, this.buttonArea.w, this.buttonArea.h);
        ctx.strokeRect(this.panel.x, this.panel.y, this.panel.w, this.panel.h);
        var bSections = this.buttonArea.w / 4;
        butW = 100;
        butH = 40;
        butX = (bSections - butW) / 2;
        butY = (this.buttonArea.h - butH) / 2;
        tbutX = this.panel.x + this.buttonArea.x + bSections + butX;
        tbutY = this.panel.y + this.buttonArea.y + butY;
        clickable.length = 0;
        if (this.previouslyCompleted()) {
            txt = "You have previously completed this activity";
            butX = (this.buttonArea.w - butW) / 2;
            tbutX = this.panel.x + butX;
            new OU.util.DynText({
                txt:txt,
                x:this.panel.x + this.textArea.x,
                y:this.panel.y + this.textArea.y,
                w:this.textArea.w,
                h:this.textArea.h,
                context:ctx,
                propTextHeight:0.5,
                fontWeight:'bold'
            });
            clickable.push(new OU.util.Button({
                txt:'OK',
                x:tbutX,
                y:tbutY,
                w:butW,
                h:butH,
                context:ctx,
                onClick:self.processNO
            }));
        }
        else {
            clickable.push(new OU.util.Button({
                txt:'Yes',
                x:tbutX,
                y:tbutY,
                w:butW,
                h:butH,
                context:ctx,
                onClick:self.processYES,
                onClickParam:{
                    progress:this.progress,
                    progressID:this.progressID,
                    self:self
                }
            }));
            clickable.push(new OU.util.Button({
                txt:'No',
                x:tbutX + bSections,
                y:tbutY,
                w:butW,
                h:butH,
                context:ctx,
                onClick:self.processNO
            }));
            new OU.util.DynText({
                txt:txt,
                x:this.panel.x + this.textArea.x,
                y:this.panel.y + this.textArea.y,
                w:this.textArea.w,
                h:this.textArea.h,
                context:ctx,
                propTextHeight:0.5,
                fontWeight:'bold'
            });
        }
        ctx.restore();
    };
    OU.activity.Planner.prototype.done = function () {
        var txt = this.data.item.txt ? this.data.item.txt : 'Are you sure you wish to mark this portion as complete?';
        var butX, butY, butW, butH, tbutX, tbutY;
//container: this,
        var ctx = this.graphicLayer.context, self = this;
        var clickable = this.graphicLayer.events.clickable;
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.save();
        ctx.fillStyle = 'rgba(26,26,26,0.75)';
        ctx.fillRect(this.panel.x + 5, this.panel.y + 5, this.panel.w, this.panel.h);
        ctx.fillStyle = '#afdfe4';
        ctx.strokeStyle = '#1a1a1a';
        ctx.fillRect(this.panel.x, this.panel.y, this.panel.w, this.panel.h);
        ctx.fillStyle = 'rgba(242,242,242,0.75)';
        ctx.fillRect(this.panel.x + this.buttonArea.x, this.panel.y + this.buttonArea.y, this.buttonArea.w, this.buttonArea.h);
        ctx.strokeRect(this.panel.x, this.panel.y, this.panel.w, this.panel.h);
        var bSections = this.buttonArea.w / 4;
        butW = 100;
        butH = 40;
        butX = (bSections - butW) / 2;
        butY = (this.buttonArea.h - butH) / 2;
        tbutX = this.panel.x + this.buttonArea.x + bSections + butX;
        tbutY = this.panel.y + this.buttonArea.y + butY;
        clickable.length = 0;
        txt = "Thank you, this has been recorded";
        butX = (this.buttonArea.w - butW) / 2;
        tbutX = this.panel.x + butX;
        new OU.util.DynText({
            txt:txt,
            x:this.panel.x + this.textArea.x,
            y:this.panel.y + this.textArea.y,
            w:this.textArea.w,
            h:this.textArea.h,
            context:ctx,
            propTextHeight:0.5,
            fontWeight:'bold'
        });
        clickable.push(new OU.util.Button({
            txt:'OK',
            x:tbutX,
            y:tbutY,
            w:butW,
            h:butH,
            context:ctx,
            onClick:self.processNO
        }));
        ctx.restore();
    };
    OU.activity.Planner.prototype.previouslyCompleted = function () {
        var progress = this.progress, progressID = this.progressID;
        if (progress.log!==undefined && progress.log.length > 0) {
            for (var i in progress.log) {
                if (progress.log[i]==parseInt(progressID)) {
                    return true;
                }
            }
        }
        return false;
    };
    OU.activity.Planner.prototype.processYES = function () {
        //window.location = back;
        var self = this.onClickParam.self;
        var progress = self.progress, progressID = self.progressID;
        //   var cupotea = new OU.util.Tea();
        ////console.log("YES!!");
        // ok lets check to see if this has been ack before.
        if (progress.log!==undefined && progress.log.length > 0) {
            for (var i in progress.log) {
                if (progress.log[i]==parseInt(progressID)) {
                    return null;
                }
            }
        }
        progress.log[progress.log.length] = parseInt(progressID);
        var points = self.data.item.points;
        for (var j in points) {
            for (var p in progress.progress) {
                if (progress.progress[p].id==points[j]) {
                    progress.progress[p].score++;
                }
            }
        }
        var cacheTXT = JSON.stringify(progress);
        //    cacheTXT = cupotea.encrypt(cacheTXT, self.data.uid);
        OU.LocalStorage.save(self.data.uid + '.progress', cacheTXT);
        self.done();
    };
    OU.activity.Planner.prototype.processNO = function () {
        //window.location = back;
        ////console.log("NO!");
        var re = /back=(.*)/i, back, matches = re.exec(window.location);
        if (back!=undefined) {
            back = matches[1];
            window.location = back;
        }
        else {
            window.close();
        }
    };
    OU.activity.Planner.prototype.saveProgress = function () {
        var cache = this.progress;
        ////console.log("save progress");
        var cacheTXT = JSON.stringify(cache);
        //cacheTXT = cupotea.encrypt(cacheTXT, data.uid);
        OU.LocalStorage.save(this.data.uid + '.progress', cacheTXT);
    };
    OU.activity.Planner.prototype.renderStatusV2 = function () {
        ////console.log("redraw");
        var ctx = this.graphicLayer.context, cr, cy, cx, gy, gx;
        var ctrctx = this.controlLayer.context;
        var pmSettings = {x:(this.w - 200) / 2, y:this.h - 50, w:200, h:10, context:ctrctx, currentPage:this.currentPage, totalPages:this.totalPages};
        ctx.clearRect(0, 0, this.w, this.h);
        ctrctx.clearRect(0, 0, this.w, this.h);
        if (this.data.title) {
            new OU.util.pageTitle({
                txt:this.data.title,
                context:ctrctx,
                x:0, y:0,
                w:this.titleBar.w,
                h:this.titleBar.h

            });
        }
        if (this.currentPage==1) {
            this.populatePageOne(ctx);
        }
        else {
            this.populatePageN(this.currentPage, ctx);
        }
        this.pageMarker(pmSettings);
        this.populateTotalPercent(ctrctx);
    };
    OU.activity.Planner.prototype.renderStatus = function () {
        ////console.log("redraw");
        var ctx = this.graphicLayer.context, cr, cy, cx, gy, gx;
        ctx.clearRect(0, 0, this.w, this.h);
        if (this.data.title) {
            new OU.util.pageTitle({
                txt:this.data.title,
                context:ctx,
                x:0, y:0,
                w:this.titleBar.w,
                h:this.titleBar.h

            });
        }
        ctx.save();
        ctx.fillStyle = '#ffffff';
        ctx.fillRect(10, 10, 10, 10);
        //ctx.fillRect(this.graphicOU.x,this.graphicOU.y,this.graphicOU.w,this.graphicOU.h);
        ctx.clearRect(this.graphicOU.x, this.graphicOU.y, this.graphicOU.w, this.graphicOU.h);
        //  ctx.fillStyle = '#00ff00';
//        ctx.fillRect(this.graphicChart.x,this.graphicChart.y,this.graphicChart.w,this.graphicChart.h);
        ctx.clearRect(this.graphicChart.x, this.graphicChart.y, this.graphicChart.w, this.graphicChart.h);
        ctx.restore();
        this.score++;
        var p = this.populate();
        if (this.graphicChart.w < this.graphicChart.h) {
            cr = (this.graphicChart.w - 1) / 2;
            cy = (this.graphicChart.h / 2);
            gy = (this.graphicOU.h - (cr * 2)) / 2;
            this.arctest(this.graphicChart.x + cr, this.graphicChart.y + cy, cr, p);
            ctx.glyph({
                type:"activityicon",
                x:this.graphicOU.x,
                y:this.graphicOU.y + gy,
                w:cr * 2,
                h:cr * 2

            });
        }
        else {
            cr = (this.graphicChart.h - 1) / 2;
            cx = (this.graphicChart.w / 2);
            gx = (this.graphicOU.w - (cr * 2)) / 2;
            this.arctest(this.graphicChart.x + cx, this.graphicChart.y + cr, cr, p);
            ctx.glyph({
                type:"activityicon",
                x:this.graphicOU.x + gx,
                y:this.graphicOU.y,
                w:cr * 2,
                h:cr * 2

            });
        }
        //  ctx.fillStyle='#800000';
        // ctx.fillRect(0,this.titleBar.h,this.w * 0.7,this.h -this.titleBar.h);
    };
    OU.activity.Planner.prototype.arctest = function ( centerX, centerY, radius, p ) {
        var ctx = this.graphicLayer.context, cr = 255, cg = 40, cb = 0, tm, pc = p, cs, tx, ty;
        if (pc==undefined) pc = 0;
        if (pc > 100) pc = 100;
        var startVal = 115;
        // startVal = 45;
        var pStep = (315 - startVal ) / 100;
        var radiusB = (radius / 15) * 8;
//    var startingAngle = 0 * Math.PI;
//    var endingAngle = 1 * Math.PI;
        var startingAngle = 315 * Math.PI / 180;
        var endingAngle = startVal * Math.PI / 180;
        var startingAngleB = startVal * Math.PI / 180;
        var endingAngleB = 315 * Math.PI / 180;
        var counterclockwise = true;
        var percentAngle = (startVal + (pStep * pc)) * Math.PI / 180;
        ////console.log(percentAngle);
        //   ctx.fillStyle = "#00ffff";
        //   ctx.fillRect(x-r,y-r,r*2,r*2);
        // paint the inside
        ctx.beginPath();
        ctx.arc(centerX, centerY, radius, startingAngle,
            endingAngle, counterclockwise);
        ctx.arc(centerX, centerY, radiusB, startingAngleB,
            endingAngleB, false);
        ctx.lineWidth = 1;
        ctx.strokeStyle = "black"; // line color
        ctx.fillStyle = "#ffffff";
        ctx.closePath();
        //ctx.stroke();
        ctx.fill();
        // Paint the percentage
        ctx.beginPath();
        ctx.arc(centerX, centerY, radius, percentAngle,
            endingAngle, counterclockwise);
        ctx.arc(centerX, centerY, radiusB, startingAngleB,
            percentAngle, false);
        ctx.lineWidth = 1;
        ctx.strokeStyle = "black"; // line color
        cr -= (pc * 2.55);
        cg += (pc * 1.47);
        cb += (pc * 0.63);
        cs = 'rgb(' + parseInt(cr) + ',' + parseInt(cg) + ',' + parseInt(cb) + ')';
        ctx.fillStyle = "#ff0000";
        ctx.fillStyle = cs;
        ctx.closePath();
        //ctx.stroke();
        ctx.fill();
        // nowdraw the outline
        ctx.beginPath();
        ctx.arc(centerX, centerY, radius, startingAngle,
            endingAngle, counterclockwise);
        ctx.arc(centerX, centerY, radiusB, startingAngleB,
            endingAngleB, false);
        ctx.lineWidth = 1;
        ctx.strokeStyle = "black"; // line color
        ctx.closePath();
        ctx.stroke();
        ctx.fillStyle = "#000000";
        ctx.font = parseInt(radiusB - 3) + "px " + OU.theme.font;
        //tm = ctx.measureText(parseInt(p)+'%');
        tm = ctx.measureText('100%');
        ////console.log(tm.width);
        tx = (centerX + radius) - tm.width;
        ty = centerY;
        ctx.fillText(parseInt(p) + '%', tx, ty, radius / 2);
    };
    OU.activity.Planner.prototype.percentBar = function ( settings ) {
        /*
         var barColours = [
         ['#d59898','#d56868'], // red
         ['#98d6d5','#68d6d5'], // cyan
         ['#d698d5','#d668d5'], // purple
         ['#d6d598','#d6d598'], // yellow
         ['#9898d5','#6868d5'], // blue
         ['#98d598','#68d568']  // green
         ];

         */
        var barColours = [
            ['#F79062', '#B96C4A'],
            // orange
            ['#8DCB65', '#6A994C'],
            // green
            ['#C26CB4', '#935287'],
            // purple
            ['#EAD245', '#B09E33'],
            // yellow
            ['#4581E8', '#3362AF'],
            // blue
            ['#F46161', '#B74949'],
            // reddish
            ['#61F4F4', '#49B7B7'] // teal
        ];
        var greyColours = ['#f2f2f2', '#b7b7b7'];
        var total = 0;
        var ctx = settings.context;
        var stops = settings.stops;
        var x = settings.x;
        var y = settings.y;
        var w = settings.w;
        var h = settings.h;
        var o = settings.o ? settings.o : 0;
        var highlight = settings.highlight ? settings.highlight : 0;
        //var cO = settings.cO ? settings.cO : false;
        var cO = settings.cO;
        var r = h / 2;
        var distance = w - h;
        var steps = distance / 100;
        ctx.save();
        ctx.fillStyle = '#606060';
        ctx.roundRect(x, y, w, h, r);
        ctx.fill();
        var lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
        var finalCol = 0;
        var pos = 0;
        for (var t = 0; t < stops.length; t++) {
            finalCol = t;
//            lineargradient = ctx.createLinearGradient(x,y+2,x,y+h-2);
//            lineargradient.addColorStop(0,barColours[t][0]);
//            lineargradient.addColorStop(1,barColours[t][1]);
            if (cO==undefined) {
                lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
                lineargradient.addColorStop(0, barColours[t][0]);
                lineargradient.addColorStop(1, barColours[t][1]);
            }
            else {
                if (cO==-1) {
                    lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
                    lineargradient.addColorStop(0, greyColours[0]);
                    lineargradient.addColorStop(1, greyColours[1]);
                }
                else {
                    lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
                    lineargradient.addColorStop(0, barColours[cO][0]);
                    lineargradient.addColorStop(1, barColours[cO][1]);
                }
            }
            ctx.fillStyle = lineargradient;
            pos = parseInt(steps * stops[t]);
            ctx.fillRect(x + r + o - 1, y + 2, pos + 2, h - 4);
            o += pos;
            total += stops[t];
            //if (o > 100) o = 100;
        }
        if (cO==undefined) {
            lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
            lineargradient.addColorStop(0, barColours[0][0]);
            lineargradient.addColorStop(1, barColours[0][1]);
        }
        else {
            if (cO==-1) {
                lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
                lineargradient.addColorStop(0, greyColours[0]);
                lineargradient.addColorStop(1, greyColours[1]);
            }
            else {
                lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
                lineargradient.addColorStop(0, barColours[cO][0]);
                lineargradient.addColorStop(1, barColours[cO][1]);
            }
        }
        ctx.fillStyle = lineargradient;
        var coords = {x:x + 2, y:y + 2, w:100, h:h - 4, r:r - 2};
        leftCap(coords);
        ctx.fill();
        if (cO==undefined) {
            lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
            lineargradient.addColorStop(0, barColours[finalCol][0]);
            lineargradient.addColorStop(1, barColours[finalCol][1]);
        }
        else {
            if (cO==-1) {
                lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
                lineargradient.addColorStop(0, greyColours[0]);
                lineargradient.addColorStop(1, greyColours[1]);
            }
            else {
                lineargradient = ctx.createLinearGradient(x, y + 2, x, y + h - 2);
                lineargradient.addColorStop(0, barColours[cO][0]);
                lineargradient.addColorStop(1, barColours[cO][1]);
            }
        }
        ctx.fillStyle = lineargradient;
        coords = {x:x + r + r + o - 2, y:y + 2, w:100, h:h - 4, r:r - 2};
        rightCap(coords);
        ctx.fill();
        //var params = {context:ctx,x:x,y:y,w:w,h:20,stops:[75],title:{text:'Total Progress',height:20},showpercent:true};
        ctx.fillStyle = '#1A1A1A';
        if (settings.title!=undefined) {
            // draw the title for the bar
            var title = settings.title;
            if (title.height) {
                ctx.font = title.height + 'px ' + OU.theme.font;
            }
            ctx.fillText(title.text, x, y - ((title.height / 3) * 2), w);
        }
        if (settings.showpercent) {
            var txt = parseInt(total) + "%";
            if (title.height) {
                ctx.font = title.height + 'px ' + OU.theme.font;
            }
            var metrics = ctx.measureText(txt);
            ctx.fillText(txt, x + w - metrics.width, y - ((title.height / 3) * 2), w);
        }
        ctx.restore();
        /*
         // draw segments...

         lineargradient = ctx.createLinearGradient(x,y+2,x,y+h-2);

         lineargradient.addColorStop(0,'rgba(128,128,128,0.25)');
         lineargradient.addColorStop(1,'rgba(200,200,200,0.25)');

         //ctx.strokeStyle = 'rgba(255,255,255,0.5)';
         ctx.fillStyle = lineargradient;

         // ctx.strokeStyle = '#ff0000';

         //ctx.beginPath();
         for (var t =0;t<=10;t++)
         {

         //    ctx.moveTo(x + r + ((t*10)*steps), y+2);
         //    ctx.lineTo(x + r + ((t*10)*steps), y+h-4);

         ctx.fillRect(x + r + ((t*10)*steps),y+2,2,h-4);


         }
         */
        //ctx.stroke();
        function leftCap( coords ) {
            var x = coords.x;
            var y = coords.y;
            var w = coords.w;
            var h = coords.h;
            var r = coords.r;
            var r2d = Math.PI / 180;
            ctx.beginPath();
            ctx.moveTo(x + r, y);
//        ctx.lineTo(x + w - r, y);
//        ctx.arc(x + w - r, y + r, r, r2d * 270, r2d * 360, false);
//        ctx.lineTo(x + w, y + h - r);
//        ctx.arc(x + w - r, y + h - r, r, r2d * 0, r2d * 90, false);
//        ctx.lineTo(x + r, y + h);
            ctx.arc(x + r, y + h - r, r, r2d * 90, r2d * 180, false);
            ctx.lineTo(x, y + r);
            ctx.arc(x + r, y + r, r, r2d * 180, r2d * 270, false);
            ctx.closePath();
        }

        function rightCap( coords ) {
            var x = coords.x;
            var y = coords.y;
            var w = coords.w;
            var h = coords.h;
            var r = coords.r;
            var r2d = Math.PI / 180;
            ctx.beginPath();
            ctx.moveTo(x - r, y);
//        ctx.lineTo(x + w - r, y);
            ctx.arc(x - r, y + r, r, r2d * 270, r2d * 360, false);
            ctx.arc(x - r, y + r, r, r2d * 0, r2d * 90, false);
            ctx.lineTo(x - r, y);
            //  ctx.arc(x  - r, y + h - r, r, r2d * 0, r2d * 90, false);
            ctx.lineTo(x + r, y + h);
            //ctx.arc(x + r, y + h + r, r, r2d * 90, r2d * 180, false);
            // ctx.lineTo(x-r, y + r);
            //ctx.arc(x - r, y + r, r, r2d * 0, r2d * 270, false);
            ctx.closePath();
        }
    };
    OU.activity.Planner.prototype.pageMarker = function ( settings ) {
        var currentPage = settings.currentPage;
        var totalPages = settings.totalPages;
        var x = settings.x;
        var y = settings.y;
        var w = settings.w;
        var h = settings.h;
        var r = h / 2, wx;
        var ctx = settings.context;
        ctx.save();
        ctx.fillStyle = 'rgba(96,96,96,0.5)';
        var segments = w / totalPages;
        var segI = segments * 0.8;
        var segO = segments * 0.1;
        ctx.roundRect(x, y, w, h, r);
        ctx.fill();
        ctx.fillStyle = '#ff0000';
        for (var t = 0; t < totalPages; t++) {
            wx = x + (t * segments) + segO;
            ctx.fillStyle = '#606060';
            ctx.fillRect(wx, y + 2, segI, h - 4);
            if (t + 1==currentPage) {
                ctx.fillStyle = '#ffffff';
                ctx.fillRect(wx + 1, y + 3, segI - 2, h - 6);
            }
        }
    };
    OU.activity.Planner.prototype.nextSlide = function () {
        this.slidecount++;
        console.log("slideCount: " + this.slidecount);
        //  this.currentPage++;
        if (this.currentPage==this.totalPages) return null;
        var ctx = this.graphicLayer.context, cr, cy, cx, gy, gx;
        var ctrctx = this.controlLayer.context;
        ctrctx.clearRect(0, 0, this.w, this.h);
        if (this.currentPage > this.totalPages) this.currentPage = this.totalPages;
        //console.log("page " + this.currentPage);
        this.moveDirection = true;
        this.breaker = 0;
        this.nextPage = this.currentPage + 1;
        var pmSettings = {x:(this.w - 200) / 2, y:this.h - 50, w:200, h:10, context:ctrctx, currentPage:this.nextPage, totalPages:this.totalPages};
        this.CurX = 0;
        this.NextX = this.w;
        this.redraw();
        this.slideMotion = true;
        this.doSlide();
    };
    OU.activity.Planner.prototype.prevSlide = function () {
        this.slidecount++;
        console.log("slideCount: " + this.slidecount);
        if (this.currentPage==1) return null;
        //console.log("page " + this.currentPage);
        this.moveDirection = false;
        this.nextPage = this.currentPage - 1;
        this.CurX = 0;
        this.NextX = 0 - this.w;
        this.redraw();
        this.slideMotion = true;
        this.doSlide();
    };
    OU.activity.Planner.prototype.preSlide = function () {
    };
    OU.activity.Planner.prototype.doSlide = function () {

//        console.log("slide");
        console.log("this.dormant:" + this.dormant);
        var events = this.controlLayer.events;
        if (this.dormant < 1 && !events.pressed && !events.touched) {
            setTimeout('OU.obj.' + instance + '.doSlide()', this.config.fps);
            return;
        }
        //console.log("this.currentPage:" + this.currentPage);
        var self = this, bH = OU.controlHeight, xOffset = 0, speed = 0, targetFocusOffset = 0 - (this.w * this.focus), // X val of the centre of the focus image
        // events = this.imageLayer.events,
            ctx = this.graphicLayer.context,
            j, x, y, w, h, closestSlide = 0, captionAlpha = 1, slide, closestCaption;
        var CurX, NextX, CurXstop, NextXstop, nextPage;
        this.breaker++;
        if (this.breaker > 5000) {
            console.warn("Breaking at 5000");
            return;
        }
        CurX = this.CurX;
        NextX = this.NextX;
        if (this.moveDirection) {
            CurXstop = 0 - this.w;
            NextXstop = 0;
            speed = -(CurX - CurXstop) / this.config.sliderSpeed;
        }
        else {
            CurXstop = this.w;
            NextXstop = 0;
            speed = -(CurX - CurXstop) / this.config.sliderSpeed;
        }
        if (this.inertia > 1) {
            this.inertia = this.inertia / 2; // reduce inertia on each render cycle
        }
        else {
            this.inertia = 1;
        }
        speed = speed / this.inertia; // apply inertia to slow initial movement of animation
        if (Math.abs(speed) < 1 && speed > 0)
            speed = 1;
        this.CurX += speed;
        if (this.moveDirection) {
            this.NextX = this.CurX + this.w;
        }
        else {
            this.NextX = this.CurX - this.w;
        }
        //console.log(this.CurX + " :: " + this.NextX + " :: " + this.w);
        //ctx.x = this.CurX;
        //this.graphicLayer.move({x: this.CurX});
        //
        // this.graphicLayer.canvas.setAttribute( "style", 'left:'+this.CurX+'px;');
        // this.graphicLayer.canvas.offsetLeft = -1;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h); // clear layer
        ctx.translate(this.CurX, 0);
        if (this.currentPage==1) {
            this.populatePageOne(ctx);
        }
        else {
            this.populatePageN(this.currentPage, ctx);
        }
        ctx.translate(-this.CurX, 0);
//        ctx.translate(0,0);
        ctx.translate(this.NextX, 0);
        ctx.fillStyle = "#ff0000";
        //       ctx.fillRect(0,0,this.w, this.h);
        if (this.nextPage==1) {
            this.populatePageOne(ctx);
        }
        else {
            this.populatePageN(this.nextPage, ctx);
        }
        ctx.translate(-this.NextX, 0);
        //     this.countdown--;
        if (this.countdown < 1) {
            this.slideMotion = false;
        }
        ctx.restore();
        if (Math.round(this.CurX)==CurXstop && this.slideMotion) {
            //this.dormant--;
            this.slideMotion = false;
            this.currentPage = this.nextPage;
            this.renderStatusV2();
        }
        else {
            // cycle render
            if (this.slideMotion) {
                setTimeout(function () {
                    self.doSlide();
                }, this.config.fps);
            }
        }
    };
    OU.activity.Planner.prototype.populateTotalPercent = function ( context ) {
        var ctx = context;
        var w = this.w * 0.6;
        var x = (this.w - w ) / 2;
        var y = this.h - 100;
        var panelW = (this.w / 2) * 0.9;
        var panelRos = (this.w / 2) + ((this.w / 2) * 0.05);
        var panelH = 0;
        var panelXos = ((this.w / 2) * 0.05);
        var step = 0;
        var score = 0, runningscore = 0, totalavail = 0;
        var totals = [], ntotals = [];
        var ticks, nticks;
        for (var i in data.sections) {
            ////console.log(data.sections[i]);
            totalavail += data.sections[i].sectionpoints;
        }
        ticks = 100 / totalavail;
//        //console.log('total points avail: ' + totalavail);
        for (var i in data.sections) {
            ////console.log(data.sections[i]);
            step++;
            runningscore = 0;
            for (var t in data.sections[i].items) {
                score = this.getScore(data.sections[i].items[t].id);
                runningscore += score;
            }
            nticks = 100 / data.sections[i].sectionpoints;
            totals[totals.length] = runningscore * ticks;
            ntotals[ntotals.length] = nticks * runningscore;
        }
        var sectionH = (this.h - 200) / step;
        panelH = sectionH * 0.9;
        var panelHos = sectionH * 0.05;
        var params = {context:ctx, x:x, y:y, w:w, h:20, stops:totals, title:{text:'Total Progress', height:12}, showpercent:true};
        this.percentBar(params);
    };
    OU.activity.Planner.prototype.populatePageN = function ( n, context ) {
        //console.log("populatePageN:" + n);
        if (n==3) {

            //console.log("breakpoint");
        }
        var ctx = context;
        var w = this.w * 0.6;
        var x = (this.w - w ) / 2;
        var y = this.h - 100;
        var panelW = (this.w / 2) * 0.9;
        var panelRos = (this.w / 2) + ((this.w / 2) * 0.05);
        var panelH = 0;
        var panelXos = ((this.w / 2) * 0.05);
        var step = 0;
        var score = 0, runningscore = 0, totalavail = 0, stops = 0;
        var totals = [], ntotals = [];
        var ticks, nticks;
        var total = 0;
        var block = n - 2;
        var i = 0;
        var section = data.sections[block];
        totalavail += section.sectionpoints;
        ticks = 100 / totalavail;
        step = 1 + section.items.length;
        var sectionH = (this.h - 300) / step;
        panelH = sectionH * 0.9;
        var panelHos = sectionH * 0.05;
        //y = 50 + (i * sectionH) + panelHos;
        y = 50 + (parseInt(i) * sectionH) + panelHos;
        // ctx.fillText(data.sections[i].title,10,y);
        //        ctx.fillRect(panelXos,y,panelW,panelH);
        new OU.util.DynText({
            txt:section.title,
            x:panelXos,
            y:y,
            w:panelW,
            h:panelH,
            context:ctx,
            propTextHeight:0.5,
            fontWeight:'bold',
            align:'left',
            padding:0

        });
        for (var i in section.items) {
            ////console.log(data.sections[i]);
            y = 50 + ((parseInt(i) + 1) * sectionH) + panelHos;
            score = this.getScore(section.items[i].id);
            runningscore += score;
            new OU.util.DynText({
                txt:'- ' + section.items[i].txt,
                x:panelXos,
                y:y,
                w:panelW,
                h:panelH,
                context:ctx,
                propTextHeight:0.5,
                align:'left',
                padding:0

            });
            if (section.items[i].totalpoints==0) {
                stops = 0;
            }
            else {
                stops = (100 / section.items[i].totalpoints) * score;
            }
            y = 50 + ((parseInt(i) + 1) * sectionH) + panelHos + ((panelH - 20) / 2);
            totals = [stops];
            var params = {cO:-1, context:ctx, x:panelRos, y:y, w:panelW, h:20, stops:totals, title:{text:'', height:12}, showpercent:true};
            // ctx.fillRect(panelRos,y,panelW,panelH);
            this.percentBar(params);
        }
        stops = ticks * runningscore;
        y = 50 + panelHos + ((panelH - 20) / 2);
        totals = [stops];
        var params = {cO:block, context:ctx, x:panelRos, y:y, w:panelW, h:20, stops:totals, title:{text:'', height:12}, showpercent:true};
        // ctx.fillRect(panelRos,y,panelW,panelH);
        this.percentBar(params);
    };
    OU.activity.Planner.prototype.populatePageOne = function ( context ) {
        var ctx = context;
        var w = this.w * 0.6;
        var x = (this.w - w ) / 2;
        var y = this.h - 100;
        var panelW = (this.w / 2) * 0.9;
        var panelRos = (this.w / 2) + ((this.w / 2) * 0.05);
        var panelH = 0;
        var panelXos = ((this.w / 2) * 0.05);
        var step = 0;
        var score = 0, runningscore = 0, totalavail = 0;
        var totals = [], ntotals = [];
        var ticks, nticks;
        for (var i in data.sections) {
            ////console.log(data.sections[i]);
            totalavail += data.sections[i].sectionpoints;
        }
        ticks = 100 / totalavail;
//        //console.log('total points avail: ' + totalavail);
        for (var i in data.sections) {
            ////console.log(data.sections[i]);
            step++;
            runningscore = 0;
            for (var t in data.sections[i].items) {
                score = this.getScore(data.sections[i].items[t].id);
                runningscore += score;
            }
            nticks = 100 / data.sections[i].sectionpoints;
            totals[totals.length] = runningscore * ticks;
            ntotals[ntotals.length] = nticks * runningscore;
        }
        var sectionH = (this.h - 200) / step;
        panelH = sectionH * 0.9;
        var panelHos = sectionH * 0.05;
//        var params = {context:ctx,x:x,y:y,w:w,h:20,stops:totals,title:{text:'Total Progress',height:12},showpercent:true};
//        this.percentBar(params);
        var block = [];
        for (var i in data.sections) {
            //y = 100 + (i*sectionH) + panelHos;
            y = 50 + (i * sectionH) + panelHos;
            // ctx.fillText(data.sections[i].title,10,y);
            new OU.util.DynText({
                txt:data.sections[i].title,
                x:panelXos,
                y:y,
                w:panelW,
                h:panelH,
                context:ctx,
                propTextHeight:0.5,
                fontWeight:'bold',
                align:'left',
                padding:0

            });
            block[0] = ntotals[i];
            var params = {cO:i, context:ctx, x:panelRos, y:y + (panelH / 2), w:panelW, h:20, stops:block, title:{text:'', height:12}, showpercent:true};
            this.percentBar(params);
        }
    };
    OU.activity.Planner.prototype.populate = function () {


        //0,this.titleBar.h,this.w * 0.7,this.h -this.titleBar.h
        var ctx = this.graphicLayer.context;
        var x = 0, y = this.titleBar.h, w = this.w * 0.7, h = this.h - this.titleBar.h;
        var mS = w * 0.1;
        var wL = w * 0.7;
        var wRs = w * 0.9;
        var wR = w * 0.1;
        var hS = h / 15;
        var step = 0;
        var score = 0, runningscore = 0, totalavail = 0;
        for (var i in data.sections) {
            ////console.log(data.sections[i]);
            new OU.util.DynText({
                txt:data.sections[i].title,
                x:0,
                y:y + (hS * step),
                w:w,
                h:hS,
                context:ctx,
                propTextHeight:0.5,
                fontWeight:'bold',
                align:"left"
            });
            step++;
            for (var t in data.sections[i].items) {
                ctx.fillStyle = "#ff0000";
                ctx.roundRect(x, y + (hS * step), wRs, hS, 3);
                new OU.util.DynText({
                    txt:data.sections[i].items[t].visualid,
                    x:0,
                    y:y + (hS * step),
                    w:mS,
                    h:hS,
                    context:ctx,
                    propTextHeight:0.5,
                    fontWeight:'bold'
                });
                new OU.util.DynText({
                    txt:data.sections[i].items[t].txt,
                    x:mS,
                    y:y + (hS * step),
                    w:wL,
                    h:hS,
                    context:ctx,
                    propTextHeight:0.5,
                    fontWeight:'bold',
                    align:"left"
                });
                score = this.getScore(data.sections[i].items[t].id);
                runningscore += score;
                totalavail += data.sections[i].items[t].totalpoints;
                new OU.util.DynText({
                    txt:((100 / data.sections[i].items[t].totalpoints) * score) + '%',
                    x:wRs,
                    y:y + (hS * step),
                    w:wR,
                    h:hS,
                    context:ctx,
                    propTextHeight:0.5,
                    fontWeight:'bold'
                });
                step++;
            }
        }
        ////console.log("runningscore:" + runningscore);
        ////console.log("totalavail: " + totalavail);
        return (100 / totalavail) * runningscore;
    };
    OU.activity.Planner.prototype.displayMode = function () {
        /*

         // this doesn't work in a book

         var URL = decodeURI(window.document.location);

         if (URL.indexOf("?") > -1) {
         //whether the location contains a "?" or not

         var list1 = URL.split("?");
         //split at "?";
         var list2 = list1[1].split("=");
         //split at "=";

         ////console.log(list2[0].toLowerCase());
         if (list2[0].toLowerCase() == 'id') {
         this.displayStatus = false;
         this.progressID = list2[1];

         }
         }

         */
        if (this.data!=undefined) {
            if (this.data.item!=undefined) {
                this.displayStatus = false;
                this.progressID = this.data.item.id;
            }
        }
    };
    this.init();
};

