// cross-browser event attach
// from http://javascriptrules.com/2009/07/22/cross-browser-event-listener-with-design-patterns/
var addEvent = (function () {
  var setListener;
  return function (el, ev, fn) {
    if (!setListener) {
      if (el.addEventListener) {
        setListener = function (el, ev, fn) {el.addEventListener(ev, fn, false);};
      } else if (el.attachEvent) {
        setListener = function (el, ev, fn) {el.attachEvent('on' + ev, fn);};
      } else {
        setListener = function (el, ev, fn) {el['on' + ev] =  fn;};
      }
    }
    setListener(el, ev, fn);
  };
}());

// cross-browser create element
function createElement(nodeName, nodeId) {
  var node;
  try {
    node = document.createElement('<'+nodeName+' id="'+nodeId+'">'); 
  }
  catch (e) {
    node = document.createElement(nodeName);
    node.id = nodeId;
  }
  return node;
}

// make an object with all the query string params
function makeQueryStringObject() {
  var query = window.location.search.substring(1);
  var vars = query.split('&');
  var return_obj = {};
  if (vars.length > 1) {
    for (var i=0; i<vars.length; i++) {
      var pair = vars[i].split('=');
      return_obj[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1]);
    }
  }
  return return_obj;
}