/**
 * @fileOverview GraphUserClickActivity - A non-assessed exercise where user clicks points onto the graph with their line being drawn after a certain number of clicks and given feedback as to whether they are corrct or if the clicks are too high/low. Any number of fixed lines can be added. All lines will have labels.
 * This is activity type 1e for Social Sciences DD209
 * 
 * STILL IN DEVELOPMENT - W.I.P.!!!!!
 *
 * Usage:
 * <ul>
 * <li> Make a copy of this file</li>
 * <li> Rename the class (OU.activity.GraphUserClickActivity) to your new activity name</li>
 * <li> Add your code</li>
 * </ul>
 *
 * Additional functions that are not defined in this file but are available to all activities:
 * <ul>
 * <li> this.header(h) - changes current H1 and H2 tags, where parameter h is of format: { h1: 'optional H1', h2: 'optional H2' }</li>
 * <li> this.loadCSSFile(f) - loads additional CSS from the file f - which is a file path relative to the activity data folder</li>
 * <li> this.addMessengerParams(paramsArray) - See documentation for Messenger functions in OU.js</li>
 * </ul>
 *
 * @author Gareth Hudson <gareth.hudson@open.ac.uk>
 */

// Load in any util elements that are required
OU.require('OU.util.Layer');
OU.require('OU.util.Button');
OU.require('OU.util.Div');


/**
 * @class GraphUserClickActivity - A template for activities that extend the OU.util.Activity class
 * @extends OU.util.Activity
 * @param {Object} data - Holds the data content for a specific instance of the activity
 * @param {String|undefined} instance - A unique identifier name for this instance, defaults to 'a1'
 * @param {Controller Object|undefined} controller - A reference to the controller that initialised this instance, if undefined, the superclass will generate a new controller and create the reference to it as 'this.controller'
 */
OU.activity.GraphUserClickActivity = function(data,instance,controller) {

    /**
     * canvasView - this is the function that is first called when the activity is launched,
     *              assuming you are in a browser that supports canvas.
     *
     * Typical tasks for this function are:
     * <ul>
     * <li> Define and initialise and activity wide variables</li>
     * <li> Initialise Layers & Divs</li>
     * <li> Call a loading function</li>
     * <li> Initiating the activity by calling any methods that</li>
     * </ul>
     */
    OU.activity.GraphUserClickActivity.prototype.canvasView = function() {
        // Most activities should have a background layer
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw default background
        // feedback text
        this.feedbackText = new OU.util.Div({
            container:this,
            x:20,
            y:this.h-40,
            w:this.w-30,
            h:40
        });


        this.textInfoLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        OU.util.Layer.prototype.dashedLine = function(x, y, x2, y2, da) {
            //console.log('x='+x+', y='+y+', x2='+x2+', y2='+y2);
            if (!da) {
                da = [10,5];
            }
            this.context.save();
            var dx = (x2-x), dy = (y2-y);
            var len = Math.sqrt(dx*dx + dy*dy);
            var rot = Math.atan2(dy, dx);
            this.context.translate(x, y);
            this.context.moveTo(0, 0);
            this.context.rotate(rot);       
            var dc = da.length;
            var di = 0, draw = true;
            x = 0;
            while (len > x) {
                x += da[di++ % dc];
                if (x > len) x = len;
                draw ? this.context.lineTo(x, 0): this.context.moveTo(x, 0);
                draw = !draw;
            }       
            this.context.restore();
        }
        
        this.pointsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.labelsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // layer for the main graph and fixed items
        this.graphLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        //
        this.dottedLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        //
        this.curvedLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.curvedLayerPoints = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // layer for the user moveable line
        this.lineMoveLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.buttonsLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:this.w-this.data.submitbutton.w,
            y:this.h-40,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        // Submit button
        var btnActionLevel = this;
        if (!this.data.coordinatesonlytask){
            this.buttonSubmit = new OU.util.Button({
                layer:this.buttonsLayer,
                txt:this.data.submitbutton.label,
                verticalPadding:2,
                disabled:true,
                onClick:function () {
                    //btnActionLevel.renderLineFromUserClickPoints();
                    this.disable();
                    btnActionLevel.resetCanvasAndVals();
                },
                x:0,
                y:0,
                w:this.data.submitbutton.w,
                h:this.data.submitbutton.h
            });
        }
        
        this.lineMoveLayer.events.clickable.push(this);
        // *Your code starts here*
        this.graphData = function() {
        }
        this.graphData.xMove = 0;
        this.graphData.yMove = 0;
        this.graphData.userClickPositionsXY = [];
        this.activityIsActive = true;
        this.graphData.drawPointsPositions = [];
        
        if (this.data.startuserlinefromlocation.yes) {
            this.graphData.userClickPositionsXY[0] = [this.data.startuserlinefromlocation.x,this.data.startuserlinefromlocation.y];
        }
        this.graphData.startx = 0;
        this.graphData.starty = 0;
        if (this.data.xyvalsforequation.startx) {
            this.graphData.startx += this.data.xyvalsforequation.startx;
        }
        if (this.data.xyvalsforequation.starty) {
            this.graphData.starty += this.data.xyvalsforequation.starty;
        }
        //console.log(this.graphData.userClickPositionsXY);
        this.fractionForCalculatingCorrectClick = (this.data.xyvalsforequation.x - this.graphData.startx) / (this.data.xyvalsforequation.y - this.graphData.starty);
        this.graphData.numberUserAttemptsMade = 0;
        this.graphData.xyvalsforlinenotusingequation = [];
        this.graphData.xyvalsforlinenotusingequation = this.data.xyvalsforlinenotusingequation.clone();
        //console.log('data.xyvalsforlinenotusingequation = '+JSON.stringify(this.data.xyvalsforlinenotusingequation));
        //console.log('graphData.xyvalsforlinenotusingequation = '+JSON.stringify(this.graphData.xyvalsforlinenotusingequation));
        //
        /*
        if (this.data.snapcursorxypostonearest <= 0) {
            this.data.snapcursorxypostonearest = 1;
        }
        */
       this.correctAnswerDisplayed = false;
       this.graphData.numberIncorrectClicks = 0;
       this.graphData.withinDoubleClick = false;
       this.pts=[];
       //this.redrawTimeout;
       this.resize();
    };

    
    Object.prototype.clone = function() {
    var newObj = (this instanceof Array) ? [] : {};
    for (i in this) {
        if (i == 'clone') continue;
            if (this[i] && typeof this[i] == "object") {
                newObj[i] = this[i].clone();
            } else newObj[i] = this[i];
        } return newObj;
    };
    
    /** Rest to defaults */
    OU.activity.GraphUserClickActivity.prototype.resetCanvasAndVals = function(){
        this.pointsLayer.context.clearRect(0, 0, this.w, this.h);
        this.lineMoveLayer.context.clearRect(0, 0, this.w, this.h);
        // Set boolean activityIsActive to true so that the user can do the exercise again if they wish
        this.activityIsActive = true;
        this.feedbackText.div.innerHTML = '';
        this.correctAnswerDisplayed = false;
        this.renderLineFromUserClickPoints();
        this.graphData.numberIncorrectClicks = 0;
        this.dottedLayer.context.clearRect(0,0,this.w,this.h);
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Show',onClick:function () {
            }
        });
        this.buttonSubmit.disable();
        this.buttonSubmit.render();
        this.render();
    }
    
    /** Called when user rolles over layers with events
     *  If user is clicking, it will call function to see if correct clicks.
     *  It will calculate position of cursor in relation to graph axis */
    
    OU.activity.GraphUserClickActivity.prototype.isHit = function ( x, y, evState ) {
        //console.log('isHit');
        var gd = this.graphData, dX, dY, edX, edY, bH = OU.controlHeight;
        var ctx = this.lineMoveLayer.context;
        // find the X,Y position of the cursor and show to user
        var xPos=0;
        var yPos=0;
        //
        xPos = ((x-this.lineMoveLayer.w*0.13)/this.scaleFactorX) + this.data.xaxis.start;
        //
        if (this.data.yaxis.start < 0){
            yPos = (-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1)/this.scaleFactorY)+this.data.yaxis.start-(this.lineMoveLayer.h*0.1);
        } else {
            yPos = (-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1)/this.scaleFactorY); 
        }
        /* Rounding up the cursor position on the x axis */
        if (this.data.snapcursorxpostonearest < 1) {
            /* Round to 1 decimal place if necessary */
            xPos = Math.round(xPos*10)/10;
        } else {
            /* Round to nearest number specified in the data file if necessary*/
            xPos = Math.round(xPos/this.data.snapcursorxpostonearest)*this.data.snapcursorxpostonearest;
        }
        /* Rounding up the cursor position on the y axis */
        if (this.data.snapcursorypostonearest < 1) {
            /* Round to 1 decimal place if necessary */
            yPos = Math.round(yPos*10)/10;
        } else {
            /* Round to nearest number specified in the data file if necessary*/
            yPos = Math.round(yPos/this.data.snapcursorypostonearest)*this.data.snapcursorypostonearest;
        }
        //
        if (evState && !this.data.coordinatesonlytask) {
            if (!this.inDrag && this.activityIsActive) {
                this.dragStartX = x;
                this.dragStartY = y;
                this.inDrag = true;
                var ctxPoints = this.pointsLayer.context;
                
                /** Are there multiple click locations? */
                if (this.data.multipleclicklocations) {
                    console.log('yes there are multiple click locations');
                    console.log('xPos:'+xPos+', yPos:'+yPos);
                    /** check user click location against all locations specified in data */
                    var userHasHitLocation = false;
                    for (var i in this.data.clicklocationmultiple) {
                        console.log('location '+i+' x:'+this.data.clicklocationmultiple[i].x+',y:'+this.data.clicklocationmultiple[i].y);
                        if(xPos>=(this.data.clicklocationmultiple[i].x - this.data.clicklocationallowedpadding.x) && xPos<=(this.data.clicklocationmultiple[i].x + this.data.clicklocationallowedpadding.x) && yPos>=(this.data.clicklocationmultiple[i].y - this.data.clicklocationallowedpadding.y) && yPos<=(this.data.clicklocationmultiple[i].y + this.data.clicklocationallowedpadding.y)) {
                            if (this.data.clicklocationmultiple[i].correct) {
                                /** user had clicked on one of the specified locations and it is correct */
                                this.feedbackText.div.innerHTML = this.data.clicklocationmultiple[i].feedback;
                                this.correctAnswerDisplayed = true;
                                this.clearFeedbackTimeout();
                                this.activityIsActive=false;
                                this.renderLineFromUserClickPoints()
                                this.showResetButton();
                                userHasHitLocation = true;
                            } else {
                                /** user had clicked on one of the specified locations and it NOT correct */
                                this.feedbackText.div.innerHTML = this.data.clicklocationmultiple[i].feedback;
                                this.clearFeedbackTimeout();
                                this.recordIncorrectClicks();
                                userHasHitLocation = true;
                            }
                        } 
                        if (!userHasHitLocation) {
                            /** user hasn't clicked on any of the specified locations, so gets standard incorrect message */
                            console.log('user hasn\'t clicked on any of the specified locations, so gets standard incorrect message');
                            this.feedbackText.div.innerHTML = this.data.feedbacktext.incorrect;
                            this.clearFeedbackTimeout();
                            this.recordIncorrectClicks();
                        }
                    }
                } else {
                    // Has the user clicked in the correct (clicklocation) location +/- the allowed (clicklocationallowedpadding) amounts?
                    if(xPos>(this.data.clicklocation.x - this.data.clicklocationallowedpadding.x) && xPos<(this.data.clicklocation.x + this.data.clicklocationallowedpadding.x) && yPos>(this.data.clicklocation.y - this.data.clicklocationallowedpadding.y) && yPos<(this.data.clicklocation.y + this.data.clicklocationallowedpadding.y)) {
                        //console.log('correct');
                        this.feedbackText.div.innerHTML = this.data.feedbacktext.correct;
                        this.correctAnswerDisplayed = true;
                        this.clearFeedbackTimeout();
                        this.activityIsActive=false;
                        this.renderLineFromUserClickPoints()
                        this.showResetButton();
                    } else {
                        this.feedbackText.div.innerHTML = this.data.feedbacktext.incorrect;
                        this.clearFeedbackTimeout();
                        this.recordIncorrectClicks();
                    }
                }
            }
        } else {
            this.inDrag = false;
        }
        if(this.data.showcursorposition || this.data.showcursorpositionlines) {
            this.renderTextInfoLayer(xPos,yPos,x,y);
        }
    };
    
    /** This will remove the feedback text on display (after the number of seconds set in data.js) */
    OU.activity.GraphUserClickActivity.prototype.clearFeedbackTimeout = function(){
        var self = this;
        clearTimeout(this.feedbackTimeout);
        this.feedbackTimeout = setTimeout(function () {
            self.clearFeedback();
        }, this.data.feedbacktext.incorrectsecstimeout*1000);
    }
    /** This will remove the feedback text on display (after the number of seconds set in data.js) */
    OU.activity.GraphUserClickActivity.prototype.clearFeedback = function(){
        this.feedbackText.div.innerHTML = '';
    }
    
    /** Recording the number of incorrect clicks by the user */
    OU.activity.GraphUserClickActivity.prototype.recordIncorrectClicks = function(){
        /** If user is double-clicking, only record as 1 incorrect click */
        if (!this.graphData.withinDoubleClick) {
            /** Increment the number of incorrect clicks */
            this.graphData.numberIncorrectClicks++;
            /** Set boolean to indicate they're within double click time of 0.5 sec */
            this.graphData.withinDoubleClick = true;
            var self = this;
            /** Have a timeout and then clear it after 0.5 secs and set the boolean back to false */
            this.clearDoubleClickCheck = setTimeout(function() {
                self.graphData.withinDoubleClick = false;
                clearTimeout(self.clearDoubleClickCheck);
            }, 500); 
        }
        /** If the user has exceeded a certain number of incorrect clicks, give them the option to see the correct answer */
        if (this.graphData.numberIncorrectClicks == this.data.numberofattempts) {
            this.showShowMeButton();
        }
    }
    /** Change the Rest button to Show button which the user can use to see the correct answer */
    OU.activity.GraphUserClickActivity.prototype.showShowMeButton = function() {
        //this.buttonSubmit.enable();
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Show',onClick:function () {
                //console.log(btnActionLevel);
                btnActionLevel.correctAnswerDisplayed = true;
                btnActionLevel.renderLineFromUserClickPoints(true);
                btnActionLevel.feedbackText.div.innerHTML = btnActionLevel.data.feedbacktext.showcorrect;
                btnActionLevel.showResetButton();
            }
        });
        this.buttonSubmit.enable();
        this.buttonSubmit.render();
        /** Tell them what the button can be used for */
        this.feedbackText.div.innerHTML += ' '+this.data.feedbacktext.showmetext;
    };
    
    OU.activity.GraphUserClickActivity.prototype.showResetButton = function() {
        //this.buttonSubmit.enable();
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Reset',onClick:function () {
                //console.log(btnActionLevel);
                btnActionLevel.resetCanvasAndVals();
            }
        });
        this.buttonSubmit.enable();
        this.buttonSubmit.render();
    };
    
    
    OU.activity.GraphUserClickActivity.prototype.renderLineFromUserClickPoints = function(showMe) {
        if (!this.activityIsActive || showMe) {
            this.activityIsActive = false;
            // the layer for the dotted line
            var lyr = this.dottedLayer;
            // the context of that layer
            var lyrctx = lyr.context;
            lyrctx.save();
            // set 0,0 to that of the graph bottom left etc.
            lyrctx.translate(this.dottedLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
            // the colour for the dotted line
            lyrctx.strokeStyle=this.data.linemovecolour;
            // the width of the dotted line
            lyrctx.lineWidth=2;
            var xFrom, yFrom, xTo, yTo;
            lyrctx.beginPath();
            //lyrctx.moveTo(0,0);
            //lyrctx.lineTo(70*this.scaleFactorX,-70*this.scaleFactorY);
            for (i=0; i<this.data.correctlines.length; i++) {
                // start the process of drawing the dotted line
                xFrom = this.data.correctlines[i].xFrom;
                yFrom = this.data.correctlines[i].yFrom;
                xTo = this.data.correctlines[i].xTo;
                yTo = this.data.correctlines[i].yTo;
                // draw a dashed/dotter line
                lyr.dashedLine(xFrom*this.scaleFactorX,-yFrom*this.scaleFactorY,xTo*this.scaleFactorX,-yTo*this.scaleFactorY,[3,5]);
            }
            // Draw the blobs onto the ends of the correct line
            lyrctx.textAlign = 'left';
            lyrctx.font='12px Arial';
            for (var i=0; i<this.data.linemovelabels.oncorrect.length; i++) {
               lyrctx.fillText(this.data.linemovelabels.oncorrect[i].text,this.data.linemovelabels.oncorrect[i].x*this.scaleFactorX,-this.data.linemovelabels.oncorrect[i].y*this.scaleFactorY);
            }
            // call stroke to display the dotted line
            lyrctx.stroke();
            lyrctx.restore();  
        }
    }
    
    /** Display the x,y locations of cursor to user (in relation to axis values, as calulated in the isHit function) */
    OU.activity.GraphUserClickActivity.prototype.renderTextInfoLayer = function(xPos,yPos,x,y) {
        //console.log(x+', '+y);
        var ctx = this.textInfoLayer.context;
        var message="";
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        var xPosMinus = 90;
        if (this.data.coordinatesxposminus) {
            xPosMinus += this.data.coordinatesxposminus;
        }
        //console.log((x-this.graphLayer.w*0.13)+', '+(this.data.xaxis.end*this.scaleFactorX));
        if (xPos>=this.data.xaxis.start && xPos<=this.data.xaxis.end && yPos>=this.data.yaxis.start && yPos<=this.data.yaxis.end && this.activityIsActive){
            if(this.data.showcursorposition) {
                if ((x-this.graphLayer.w*0.13) >= (this.data.xaxis.end*this.scaleFactorX)-50) {
                    message = xPos + ", " + yPos;
                    ctx.fillText(message, this.graphLayer.w*0.13 + (this.data.xaxis.end*this.scaleFactorX)-50, y-5);
                } else {
                    message = xPos + ", " + yPos;
                    ctx.fillText(message,x+8,y-10);
                }
            }
            if(this.data.showcursorpositionlines) {
                // reference to layer, not its context
                var lyr = this.textInfoLayer;
                ctx.translate(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
                //
                ctx.strokeStyle='#BBBBBB';
                ctx.lineWidth=2;
                //*
                ctx.beginPath();
                //ctx.moveTo(this.data.xaxis.start*this.scaleFactorX, y-this.graphLayer.h*0.88);
                //ctx.lineTo(x-this.graphLayer.w*0.13, y-this.graphLayer.h*0.88);
                // draw a dashed/dotter line
                lyr.dashedLine(this.data.xaxis.start*this.scaleFactorX, y-this.graphLayer.h*0.88,x-this.graphLayer.w*0.13, y-this.graphLayer.h*0.88,[4,5]);
                ctx.stroke();
                //*/
                ctx.beginPath();
                //ctx.moveTo(x-this.graphLayer.w*0.13, - this.data.yaxis.start*this.scaleFactorY);
                //ctx.lineTo(x-this.graphLayer.w*0.13, y-this.graphLayer.h*0.88);
                // draw a dashed/dotter line
                lyr.dashedLine(x-this.graphLayer.w*0.13, - this.data.yaxis.start*this.scaleFactorY,x-this.graphLayer.w*0.13, y-this.graphLayer.h*0.88,[3,5]);
                ctx.stroke();
            }
        }
        ctx.restore();
    };
    
    /** The main function called to draw and position everything */
    OU.activity.GraphUserClickActivity.prototype.render = function() {
        //console.log('render');
        var ctx = this.graphLayer.context;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.translate(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
        this.renderAxis();
        ctx.textAlign = 'center';
        ctx.font='14px Arial';
        if (!this.data.xaxis.labelplusminuspos) {
            this.data.xaxis.labelplusminuspos = 0;
        }
        ctx.fillText(this.data.xaxis.label,(this.data.xaxis.end/2)*this.scaleFactorX,40+this.data.xaxis.labelplusminuspos);
        ctx.rotate(-0.5*Math.PI);
        if (!this.data.yaxis.labelplusminuspos) {
            this.data.yaxis.labelplusminuspos = 0;
        }
        ctx.fillText(this.data.yaxis.label ,(this.data.yaxis.end/2)*this.scaleFactorY,-50+this.data.yaxis.labelplusminuspos);
        ctx.restore();
        if (!this.data.coordinatesonlytask){
            this.buttonSubmit.render();
        }
        this.renderLineFromUserClickPoints();
    };
    
    /** Draw both axis, markers, labels and titles */
    OU.activity.GraphUserClickActivity.prototype.renderAxis = function() {
        var ctx = this.graphLayer.context;
        var gd = this.graphData;
        ctx.strokeStyle='#000000';
        ctx.lineWidth=2;
        // draw the y axis
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(0, - this.data.yaxis.end*this.scaleFactorY);
        ctx.stroke();
        // draw the y axis
        ctx.beginPath();
        ctx.moveTo(0, 0);
        ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, 0);
        ctx.stroke();
        // draw the y axis markers and text labels
        ctx.textAlign = 'right';
        ctx.font='12px Arial';
        var labelOddEven = 0;
        var i=0;
        for(i= this.data.yaxis.start; i<=this.data.yaxis.end; i+= this.data.yaxis.interval){
            // the y axis markers
            labelOddEven++;
            if (!this.data.hideaxismarkers) {
                ctx.beginPath();
                ctx.moveTo(0, -i*this.scaleFactorY);
                ctx.strokeStyle='#000000';
                ctx.lineWidth=2;
                ctx.lineTo(-10, -i*this.scaleFactorY);
                ctx.stroke();
                // the yaxis labels
                //ctx.fillText(i,-12,-i*this.scaleFactorY);

                switch(this.data.yaxis.markerlabels) {
                    case 'all':
                        //console.log(labelOddEven%2 == 1);
                        ctx.fillText(i,-12,-i*this.scaleFactorY);
                        break;
                    case 'odd':
                        if (labelOddEven%2 == 1) {
                            ctx.fillText(i,-12,-i*this.scaleFactorY);
                        }
                        break;
                    case 'even':
                        if (labelOddEven%2 == 0) {
                            ctx.fillText(i,-12,-i*this.scaleFactorY);
                        }
                        break;
                }
            }
            // draw the horizontal grid lines
            if (!this.data.hidegridlines) {
                if (i>0){
                    ctx.beginPath();
                    ctx.moveTo(0, -i*this.scaleFactorY);
                    ctx.strokeStyle='#DDDDDD';
                    ctx.lineWidth=0.5;
                    ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -i*this.scaleFactorY);
                    // in between vertical gris lines
                    ctx.moveTo(0, -i*this.scaleFactorY + (this.data.yaxis.interval/2)*this.scaleFactorY);
                    ctx.strokeStyle='#DDDDDD';
                    ctx.lineWidth=0.5;
                    ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -i*this.scaleFactorY + (this.data.yaxis.interval/2)*this.scaleFactorY);
                    ctx.stroke();
                }
            }
        }
        // draw the x axis markers and text labels
        ctx.textAlign = 'center';
        labelOddEven = 0;
        for(i= this.data.xaxis.start; i<=this.data.xaxis.end; i+= this.data.xaxis.interval){
            labelOddEven++;
            // the x axis markers
            if (!this.data.hideaxismarkers) {
                ctx.beginPath();
                ctx.moveTo(i*this.scaleFactorX, 0);
                ctx.strokeStyle='#000000';
                ctx.lineWidth=2;
                ctx.lineTo(i*this.scaleFactorX, 10);
                ctx.stroke();
                // the x axis labels
                //ctx.fillText(i,i*this.scaleFactorX,20);
                switch(this.data.xaxis.markerlabels) {
                    case 'all':
                        //console.log(labelOddEven%2 == 1);
                        ctx.fillText(i,i*this.scaleFactorX,20);
                        break;
                    case 'odd':
                        if (labelOddEven%2 == 1) {
                            ctx.fillText(i,i*this.scaleFactorX,20);
                        }
                        break;
                    case 'even':
                        if (labelOddEven%2 == 0) {
                            ctx.fillText(i,i*this.scaleFactorX,20);
                        }
                        break;
                }
            }
            // draw the vertical grid lines
            if (!this.data.hidegridlines) {
                if (i>0){
                    ctx.beginPath();
                    ctx.moveTo(i*this.scaleFactorX, 0);
                    ctx.strokeStyle='#DDDDDD';
                    ctx.lineWidth=0.5;
                    ctx.lineTo(i*this.scaleFactorX, -this.data.yaxis.end*this.scaleFactorY);
                    // in between vertical gris lines
                    ctx.moveTo(i*this.scaleFactorX - (this.data.xaxis.interval/2)*this.scaleFactorX, 0);
                    ctx.strokeStyle='#DDDDDD';
                    ctx.lineWidth=0.5;
                    ctx.lineTo(i*this.scaleFactorX - (this.data.xaxis.interval/2)*this.scaleFactorX, -this.data.yaxis.end*this.scaleFactorY);
                    ctx.stroke();
                }
            }
        }
        // draw all the fixed lines
        for (var y=0; y<this.data.lines.length; y++) {
            if (this.data.linesinfo[y] && this.data.linesinfo[y].type == 'curved') {
                this.drawCurves(this.data.lines[y],this.data.linecolours[y],this.data.linesinfo[y].pointmarkers);
            } else {
                // draw the straight line dotted if required
                if (this.data.linesinfo[y].dotted){
                    // the layer for the dotted line
                    var lyr = this.dottedLayer;
                    // the context of that layer
                    var lyrctx = lyr.context;
                    lyrctx.save();
                    // set 0,0 to that of the graph bottom left etc.
                    lyrctx.translate(this.graphLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
                    // the colour for the dotted line
                    lyrctx.strokeStyle=this.data.linecolours[y];
                    // the width of the dotted line
                    lyrctx.lineWidth=2;
                    // start the process of drawing the dotted line
                    lyrctx.beginPath()
                    // loop through to draw lines between all locations specified
                    for (i=0; i<this.data.lines[y].length-1; i++) {
                        // draw dotted line by calling the function which has been added to layers
                        //lyr.dashedLine(this.data.lines[y][i].x*this.scaleFactorX,this.data.lines[y][i].y*this.scaleFactorY -this.graphLayer.h*0.88,this.data.lines[y][i+1].x*this.scaleFactorX,this.data.lines[y][i+1].y*this.scaleFactorY -this.graphLayer.h*0.88,[3,5]);
                        lyr.dashedLine(this.data.lines[y][i].x*this.scaleFactorX,-this.data.lines[y][i].y*this.scaleFactorY,this.data.lines[y][i+1].x*this.scaleFactorX,-this.data.lines[y][i+1].y*this.scaleFactorY,[3,5]);
                    }
                    // call stroke to display the dotted line
                    lyrctx.stroke();
                    lyrctx.restore();
                } else {
                    // just draw the line solid
                    // the colour for the solid line
                    ctx.strokeStyle=this.data.linecolours[y];
                    // the width of the solid line
                    ctx.lineWidth=2;
                    // start the process of drawing the solid line
                    ctx.beginPath();
                    // move to the first point location of the line
                    ctx.moveTo(this.data.lines[y][0].x*this.scaleFactorX,-this.data.lines[y][0].y*this.scaleFactorY);
                    // loop through to draw lines between all locations specified
                    for(i=1; i<this.data.lines[y].length; i++) {
                        // draw line to this location from last
                        ctx.lineTo(this.data.lines[y][i].x*this.scaleFactorX,-this.data.lines[y][i].y*this.scaleFactorY);
                    }
                    // call stroke to display the solid line
                    ctx.stroke();
                }
                // draw point markers is required
                if (this.data.linesinfo[y].pointmarkers) {
                    for (i=0; i<this.data.lines[y].length; i++) {
                        ctx.beginPath();
                        ctx.arc(this.data.lines[y][i].x*this.scaleFactorX, -this.data.lines[y][i].y*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
                        ctx.fillStyle = "#000000";
                        ctx.fill();
                        ctx.lineWidth = 1;
                        ctx.strokeStyle = "black";
                    }
                }
            }
        }
        // add any desired labels to the graph
        ctx.textAlign = 'left';
        //console.log(this.data.graphlabels.length);
        for (i=0; i<this.data.graphlabels.length; i++) {
            ctx.fillText(this.data.graphlabels[i].text,this.data.graphlabels[i].x*this.scaleFactorX,-this.data.graphlabels[i].y*this.scaleFactorY);            
        }
    };
    
    // Create quadratic curved lines using series of x,y points 
    //var points = [{x:100,y:650},{x:200,y:500},{x:300,y:400},{x:400,y:380},{x:500,y:440},{x:600,y:500},{x:700,y:590}];
    OU.activity.GraphUserClickActivity.prototype.drawCurves = function(points, lineColour, showPointMarkers) {
        //console.log('drawCurves');
        /* ========================================================*/
        var ctx = this.curvedLayer.context;
        ctx.save();
        //ctx.clearRect(0, 0, this.w, this.h);
        // set 0,0 to that of the graph bottom left etc.
        ctx.translate(this.curvedLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
        ctx.strokeStyle=lineColour;
        ctx.lineWidth=2;
        /* ========================================================*/
        var ctxPoints = this.curvedLayerPoints.context;
        ctxPoints.save();
        ctxPoints.clearRect(0, 0, this.w, this.h);
        // set 0,0 to that of the graph bottom left etc.
        ctxPoints.translate(this.curvedLayerPoints.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1);
        ctxPoints.strokeStyle='#000000';
        ctxPoints.fillStyle='#000000'
        ctxPoints.lineWidth=2;
        /* ========================================================*/
        
        var myPoints = []; //minimum two points
        for (var t=0; t<points.length; t++) {
            myPoints.push(points[t].x*this.scaleFactorX);
            myPoints.push(-points[t].y*this.scaleFactorY);
            this.pts.push(points[t].x*this.scaleFactorX);
            this.pts.push(-points[t].y*this.scaleFactorY);
        }
        //console.log('points = '+points);
        //console.log('myPoints = '+myPoints);
        var tension = 0.2;
        //drawCurve(ctx, myPoints); //default tension=0.5
        ctx.beginPath();
        this.drawCurve(ctx, myPoints, tension, false, 10, true, lineColour);
        //ctx.stroke();
        ctx.restore();
        // show marker 'blob' points
        if (showPointMarkers) {
            for(var i=0;i<myPoints.length-1;i+=2) {
                //ctxPoints.rect(myPoints[i] - 3, myPoints[i+1] - 3, 6, 6);
                ctxPoints.beginPath();
                ctxPoints.arc(myPoints[i], myPoints[i+1], 3, 0, 2 * Math.PI, false);
                ctxPoints.fillStyle = "#000000";
                ctxPoints.fill();
                ctxPoints.lineWidth = 1;
                ctxPoints.strokeStyle = "black";
            }
        }
        //ctxPoints.stroke();
        ctxPoints.restore();
    }
    
    /* ======================================================================================================================
     * The following (slightly edited to work with this) functions from a thread on stackoverflow. 
     * Slightly smoother and more accurate curve that the original one in the drawCurves function above (bit commented out)
     * ====================================================================================================================== */
    OU.activity.GraphUserClickActivity.prototype.drawCurve = function(ctx, ptsa, tension, isClosed, numOfSegments, showPoints, lineColour) {
        //console.log('drawCurve');
        var ctx = this.curvedLayer.context;
        
        showPoints  = showPoints ? showPoints : false;
        this.drawLines(ctx, this.getCurvePoints(ptsa, tension, isClosed, numOfSegments));
        ctx.stroke();
    }
    
    OU.activity.GraphUserClickActivity.prototype.getCurvePoints = function(ptsa, tension, isClosed, numOfSegments) {
        //console.log('getCurvePoints');
        // use input value if provided, or use a default value   
        tension = (typeof tension != 'undefined') ? tension : 0.5;
        isClosed = isClosed ? isClosed : false;
        numOfSegments = numOfSegments ? numOfSegments : 16;
        var _pts = [], res = [],    // clone array
        x, y,           // our x,y coords
        t1x, t2x, t1y, t2y, // tension vectors
        c1, c2, c3, c4,     // cardinal points
        st, t, i;       // steps based on num. of segments
        // clone array so we don't change the original
        _pts = ptsa.slice(0);
        // The algorithm require a previous and next point to the actual point array.
        // Check if we will draw closed or open curve.
        // If closed, copy end points to beginning and first points to end
        // If open, duplicate first points to befinning, end points to end
        if (isClosed) {
            _pts.unshift(this.pts[this.pts.length - 1]);
            _pts.unshift(this.pts[this.pts.length - 2]);
            _pts.unshift(this.pts[this.pts.length - 1]);
            _pts.unshift(this.pts[this.pts.length - 2]);
            _pts.push(this.pts[0]);
            _pts.push(this.pts[1]);
        }
        else {
            _pts.unshift(this.pts[1]);   //copy 1. point and insert at beginning
            _pts.unshift(this.pts[0]);
            _pts.push(this.pts[this.pts.length - 2]); //copy last point and append
            _pts.push(this.pts[this.pts.length - 1]);
        }
        // ok, lets start..
        // 1. loop goes through point array
        // 2. loop goes through each segment between the 2 pts + 1e point before and after
        for (i=2; i < (_pts.length - 4); i+=2) {
            for (t=0; t <= numOfSegments; t++) {
                // calc tension vectors
                t1x = (_pts[i+2] - _pts[i-2]) * tension;
                t2x = (_pts[i+4] - _pts[i]) * tension;
                t1y = (_pts[i+3] - _pts[i-1]) * tension;
                t2y = (_pts[i+5] - _pts[i+1]) * tension;
                // calc step
                st = t / numOfSegments;
                // calc cardinals
                c1 =   2 * Math.pow(st, 3)  - 3 * Math.pow(st, 2) + 1; 
                c2 = -(2 * Math.pow(st, 3)) + 3 * Math.pow(st, 2); 
                c3 =       Math.pow(st, 3)  - 2 * Math.pow(st, 2) + st; 
                c4 =       Math.pow(st, 3)  -     Math.pow(st, 2);
                // calc x and y cords with common control vectors
                x = c1 * _pts[i]    + c2 * _pts[i+2] + c3 * t1x + c4 * t2x;
                y = c1 * _pts[i+1]  + c2 * _pts[i+3] + c3 * t1y + c4 * t2y;
                //store points in array
                res.push(x);
                res.push(y);
            }
        }
        //console.log('res = '+res);
        return res;
    }

    OU.activity.GraphUserClickActivity.prototype.drawLines = function(ctx, pts) {
        var ctx = this.curvedLayer.context;
        //console.log('drawLines '+ctx);
        ctx.moveTo(pts[0], pts[1]);
        for(i=2;i<pts.length-1;i+=2){
            ctx.lineTo(pts[i], pts[i+1]);
            //console.log(pts[i]+', '+pts[i+1]);
        }
    }
    /* ======================================================================================================================
     * ====================================================================================================================== */
    
    
    
    
    /**
     * accessibleView - this function is called instead of canvasView if the browser does not support HTML5 canvas
     */
    OU.activity.GraphUserClickActivity.prototype.accessibleView = function() {
        OU.activity.GraphUserClickActivity.superClass_.accessibleView.call(this); // call the superclass method is you want to extend it, remove this line to override the method instead

    // Note this function can be removed or commented out if you want to use the default accessibleView method

    // *Your code starts here*
    };
    /**
     * resize - called whenever the outer bounds of the activity change, ie when the browser window is resized, or a mobile device is rotated.
     *
     * This function should do the following:
     * <ul>
     * <li>Resize all visible elements</li>
     * <li>Re-layout all visible elements</li>
     * <li>Actually re-render the current view of the activity</li>
     * </ul>
     */
    OU.activity.GraphUserClickActivity.prototype.resize = function() {
        //console.log('resize');
        OU.activity.GraphUserClickActivity.superClass_.resize.call(this); // call the superclass resize

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        if (this.h > this.w){
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
            this.dottedLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
            this.curvedLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
            
            this.curvedLayerPoints.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
        } else {
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
            this.dottedLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
            this.curvedLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
            this.curvedLayerPoints.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
        }
        //this.graphLayer.resize({x:0,y:0,w:this.w,h:this.h});
        // this.lineMoveLayer.resize({x:0,y:0,w:this.w,h:this.h});
        this.textInfoLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.pointsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.labelsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        // work out the scaleFactor for sizing and rendering everything
        /*
        var yscale = (this.graphLayer.h * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        var xscale = (this.graphLayer.w * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
        if (yscale > xscale) {
            this.scaleFactor = xscale;
        } else {
            this.scaleFactor = yscale;
        }
        */
        // work out the scaleFactor for sizing and rendering everything
        /** //////////////////////////////////////////////////////////////////////////////////////////////////////////
         *  Different scaleFactors for X and Y so that axis can have different max values,
         *  such as Y 0 - 1500, X 0 - 1.2 */
        if (this.graphLayer.h > this.graphLayer.w) {
            this.scaleFactorX = (this.graphLayer.w * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
            this.scaleFactorY = (this.graphLayer.w * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        } else {
            this.scaleFactorX = (this.graphLayer.h * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
            this.scaleFactorY = (this.graphLayer.h * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        }
        /** //////////////////////////////////////////////////////////////////////////////////////////////////////////*/
        
        // reposition the button layer
        this.buttonsLayer.resize({
            x:this.data.xaxis.end*this.scaleFactorX,
            y:(this.data.yaxis.end*this.scaleFactorY)+(this.data.yaxis.end*this.scaleFactorY*0.2)-10,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        this.feedbackText.resize({
            x:30,
            y:(this.data.yaxis.end*this.scaleFactorY)+(this.data.yaxis.end*this.scaleFactorY*0.2)+this.data.submitbutton.h,
            w:this.w-60,
            h:40
        });
        this.render();
        //this.curvedLayer.context.canvas.width = this.curvedLayer.context.canvas.width;
    //
    };

    /**
     * remove - called when the activity is being removed by a controller.
     *
     * This function should do the following:
     * <ul>
     * <li> Remove any elements that may remain in memory</li>
     * <li> Stop any animation loops, including killing any Intervals </li>
     * </ul>
     * You do not need to remove most library elements, such as Layers, Divs, etc. as they are removed automatically
     */
    OU.activity.GraphUserClickActivity.prototype.remove = function() {
        OU.activity.GraphUserClickActivity.superClass_.remove.call(this); // call the superclass remove

    // *Your removal code here*
    // If you have nothing to remove, then this function can be deleted or commented out
    };

    // call the superclass's constructor
    OU.base(this,data,instance,controller);
};
// Call our inherits function to implement the class inheritance
OU.inherits(OU.activity.GraphUserClickActivity,OU.util.Activity);
