/**
 * @fileOverview Menu - Loads a Menu object
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Menu');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.Menu = function(data,instance,controller) {
    OU.activity.Menu.prototype.canvasView = function() {

        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw background on backdrop layer

        this.menus=new OU.util.Menu({
            container: this,
            menus:this.data,
            showHighlight: this.data.showHighlight,
            x: this.x,
            y: this.y,
            w: this.w,
            h: this.h
        });
    };
    OU.activity.Menu.prototype.remove = function() {
        OU.activity.Menu.superClass_.remove.call(this); // call the superclass method
        this.menus.remove();
    };
    OU.activity.Menu.prototype.resize = function() {
        OU.activity.Menu.superClass_.resize.call(this); // call the parent class resize

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        this.menus.resize({
            x: this.x,
            y: this.y,
            w: this.w,
            h: this.h
        });
    };

    OU.base(this,data,instance,controller);
};
OU.inherits(OU.activity.Menu,OU.util.Activity);
