/**
 * @fileOverview TableUserComplete - 
 * 
 * 
 * STILL IN DEVELOPMENT - W.I.P.!!!!
 *
 * Usage:
 * <ul>
 * <li> Make a copy of this file</li>
 * <li> Rename the class (OU.activity.TableUserComplete) to your new activity name</li>
 * <li> Add your code</li>
 * </ul>
 *
 * Additional functions that are not defined in this file but are available to all activities:
 * <ul>
 * <li> this.header(h) - changes current H1 and H2 tags, where parameter h is of format: { h1: 'optional H1', h2: 'optional H2' }</li>
 * <li> this.loadCSSFile(f) - loads additional CSS from the file f - which is a file path relative to the activity data folder</li>
 * <li> this.addMessengerParams(paramsArray) - See documentation for Messenger functions in OU.js</li>
 * </ul>
 *
 * @author Gareth Hudson <gareth.hudson@open.ac.uk>
 */

// Load in any util elements that are required
OU.require('OU.util.Layer');
OU.require('OU.util.Button');
OU.require('OU.util.Div');
/**
 * @class TableUserComplete - A template for activities that extend the OU.util.Activity class
 * @extends OU.util.Activity
 * @param {Object} data - Holds the data content for a specific instance of the activity
 * @param {String|undefined} instance - A unique identifier name for this instance, defaults to 'a1'
 * @param {Controller Object|undefined} controller - A reference to the controller that initialised this instance, if undefined, the superclass will generate a new controller and create the reference to it as 'this.controller'
 */
OU.activity.TableUserComplete = function(data,instance,controller) {

    /**
     * canvasView - this is the function that is first called when the activity is launched,
     *              assuming you are in a browser that supports canvas.
     *
     * Typical tasks for this function are:
     * <ul>
     * <li> Define and initialise and activity wide variables</li>
     * <li> Initialise Layers & Divs</li>
     * <li> Call a loading function</li>
     * <li> Initiating the activity by calling any methods that</li>
     * </ul>
     */
    OU.activity.TableUserComplete.prototype.canvasView = function() {
        var self=this;
        // Most activities should have a background layer
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw default background
        //
        // Create the text info layer
        this.textInfoLayer = new OU.util.Div({
            container:this,
            innerHTML:'<p id="textInfo"></p>',
            x:10,
            y:10,
            w:this.w - 20,
            h:500
        });
        // ====================================================================================
        // Create the table for users to enter their values for the projects
        // ====================================================================================
        this.userInputsDiv = new OU.util.Div({
            container:this,
            innerHTML:'<table style="margin:0px 0px 0px 0px" id="userInputsTable"></table>',
            x:10,
            y:10,
            w:this.w-20,
            h:400
        });
        // layer for the buttons
        this.buttonsLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:420,
            y:10,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        // Submit button
        var btnActionLevel = this;
        this.buttonSubmit = new OU.util.Button({
            layer:this.buttonsLayer,
            txt:this.data.submitbutton.label,
            verticalPadding:2,
            disabled:false,
            onClick:function () {
                btnActionLevel.submitAction();
            },
            x:0,
            y:0,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        
        this.inputsToCheck=[];
        this.inputsToCheckRows=[];
        this.userEntries=[];
        this.numberToCheck=0;
        this.numberCorrect=0;
        this.numOfAttempts=0;
        OU.obj[instance] = this; // push this into object array, so we can call it back from the page
        // ====================================================================================
        this.activityIsActive = true;
        this.render();
        this.resize();
    };
    // ====================================================================================
    /* Function to restrict text entry to floating numbers */
    // ====================================================================================
    OU.activity.TableUserComplete.prototype.isNumberKey = function(evt) {
        var theCodes = OU.obj[instance].data.keycodes;
        var allowedKeyCode = false;
        try {
            var charCode = (evt.which) ? evt.which : event.keyCode;
            // Loop through the permitted keycodes to see if it matches
            for (var i in theCodes) {
                //console.log(i);
                if (charCode == theCodes[i]) {
                    allowedKeyCode = true;
                }
            }
            if (!allowedKeyCode) {
                // the keycode for the pressed key was not in the allowed list so drop out
                return false;
            }

            /*
            if (charCode != 46 && charCode != 44 && charCode > 31 && (charCode < 48 || charCode > 57)) {
               return false;
            }
            */
            return true;
        }
        catch(ex) {
        }
     }
    
    // ====================================================================================
    // Called by user clicking the submit button
    // ====================================================================================
    OU.activity.TableUserComplete.prototype.submitAction = function(){
        this.numberCorrect = 0;
        this.numOfAttempts++;
        var userEmpty = false, btnActionLevel = this,rowCorrectFeedbackNums=[];
        //this.getUserEntries();
        //console.log('submit pressed');
        for (var x in this.inputsToCheck) {
            if (this.inputsToCheck[x] == document.getElementById(x).value) {
                this.numberCorrect++;
                document.getElementById(x).style.fontWeight = 'normal';
                document.getElementById(x).style.color = '#000000';
                rowCorrectFeedbackNums[this.inputsToCheckRows[x]] = 'correct';
            } else {
                rowCorrectFeedbackNums[this.inputsToCheckRows[x]] = 'incorrect';
                //console.log(this.inputsToCheckRows[x]);
                if (document.getElementById(x).value.length == 0 && this.numOfAttempts != this.data.numberofattempts) {
                    userEmpty = true;
                }
                if (this.numOfAttempts == this.data.numberofattempts) {
                    document.getElementById(x).style.fontWeight = 'bold';
                    document.getElementById(x).style.color = '#000000'
                    document.getElementById(x).value = this.inputsToCheck[x];
                    document.getElementById(x).disabled = true;
                } else {
                    document.getElementById(x).style.fontWeight = 'bold';
                    document.getElementById(x).style.color = '#FF0000'
                }
            }
        }
        if (this.numberCorrect != this.numberToCheck) {
            var feedbackToGive = '';
            // First check to see whether there is general feedback or feedback per row if incorrect.
            if (this.data.feedbacktext.feedbackperrow) {
                // Show feedback per row if nessessary
                for (var i=0; i<rowCorrectFeedbackNums.length; i++) {
                    if (rowCorrectFeedbackNums[i]=='incorrect') {   
                        if (this.numOfAttempts < this.data.numberofattempts) {
                            feedbackToGive += this.data.feedbacktext.rowsfeedbacktext['incorrectfirst'+i];
                        } else {
                            feedbackToGive += this.data.feedbacktext.rowsfeedbacktext['incorrectfinal'+i];
                        }
                        feedbackToGive += '<br/>'
                    } else if (rowCorrectFeedbackNums[i]=='correct') {
                        feedbackToGive += this.data.feedbacktext.rowsfeedbacktext['correct'+i];
                        feedbackToGive += '<br/>'
                    }
                }
                if (userEmpty) {
                    feedbackToGive += ' '+this.data.feedbacktext.emptyanswers;
                }
                if (this.numOfAttempts == this.data.numberofattempts) {
                    if (this.data.feedbacktext.extrafinalstatement) {
                        feedbackToGive += this.data.feedbacktext.extrafinalstatement;
                    }
                    this.buttonSubmit.modify({
                        txt:'Reset',
                        onClick:function () {
                            //console.log(btnActionLevel);
                            //window.OU.activity.GraphDragLineActivity.prototype.resetActivity();
                            btnActionLevel.resetActivity();
                        }
                    });
                    this.buttonSubmit.enable();
                    this.buttonSubmit.render();
                }
            } else {
                // Not feedback per row, just one lot
                feedbackToGive = this.data.feedbacktext.incorrect;
                if (userEmpty) {
                    feedbackToGive += ' '+this.data.feedbacktext.emptyanswers;
                }
                if (this.numOfAttempts < this.data.numberofattempts) {
                    feedbackToGive += ' '+this.data.feedbacktext.resubmit;
                } else {
                    feedbackToGive = this.data.feedbacktext.showcorrect;
                    // now show reset
                    //var btnActionLevel = this;
                    this.buttonSubmit.modify({
                        txt:'Reset',
                        onClick:function () {
                            //console.log(btnActionLevel);
                            //window.OU.activity.GraphDragLineActivity.prototype.resetActivity();
                            btnActionLevel.resetActivity();
                        }
                    });
                    this.buttonSubmit.enable();
                    this.buttonSubmit.render();
                }
            }
        } else {
            feedbackToGive = this.data.feedbacktext.correct;
            if (this.data.feedbacktext.extrafinalstatement) {
                feedbackToGive += '<br/>'+this.data.feedbacktext.extrafinalstatement;
            }
            //var btnActionLevel = this;
            this.buttonSubmit.modify({
                txt:'Reset',
                onClick:function () {
                    //console.log(btnActionLevel);
                    //window.OU.activity.GraphDragLineActivity.prototype.resetActivity();
                    btnActionLevel.resetActivity();
                }
            });
            this.buttonSubmit.enable();
            this.buttonSubmit.render();
        }
        document.getElementById('textInfo').innerHTML = feedbackToGive;
        //correct,incorrect,resubmit,emptyanswers,showcorrect
    };
    
    OU.activity.TableUserComplete.prototype.resetActivity = function() {
        //console.log(this.buttonSubmit);
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Submit',
            onClick:function () {
                btnActionLevel.submitAction();
            }
        });
        //this.inputsToCheck=[];
        this.userEntries=[];
        //this.numberToCheck=0;
        this.numberCorrect=0;
        this.numOfAttempts=0;
        for (var x in this.inputsToCheck) {
            document.getElementById(x).disabled = false;
            document.getElementById(x).value = '';
            document.getElementById(x).style.fontWeight = 'normal';
            document.getElementById(x).style.color = '#000000'
            //document.getElementById(x).innerHTML = '';
            
        }
        document.getElementById('textInfo').innerHTML = '';
        //console.log(this.userEntries);
    };
    // ====================================================================================
    /* Start the render of everything to the canvas */
    // ====================================================================================
    OU.activity.TableUserComplete.prototype.render = function() {
        //this.getUserEntries();
        /*
        //console.log(document.getElementById("userInputsTable").rows.length);
        if (document.getElementById("userInputsTable").rows.length>0) {
            for(var i = document.getElementById("userInputsTable").rows.length; i > 0;i--){
                document.getElementById("userInputsTable").deleteRow(i -1);
            }
        }
        */
        var i,t,row,cell,userTable=document.getElementById('userInputsTable'),tabinput;
        for (i=0; i<this.data.tablecontents.length; i++) {
            row = document.createElement('tr');
            userTable.appendChild(row);
            for (t=0; t<this.data.tablecontents[i].length; t++) {
                if (i==0) {
                    cell = document.createElement('th');
                } else {
                    cell = document.createElement('td');
                }
                switch(this.data.tablecontents[i][t].type) {
                    case 'static':
                        cell.innerHTML = this.data.tablecontents[i][t].value;
                        
                        break;
                    case 'input':
                        this.numberToCheck++;
                        tabinput = document.createElement('input');
                        tabinput.id = 'input_'+i+'_'+t;
                        if (this.data.tablecontents[i][t].onlyallownumbers){
                           tabinput.onkeypress = this.isNumberKey; 
                        }
                        /*
                        if (this.userEntries['input_'+i+'_'+t]) {
                            tabinput.value = this.userEntries['input_'+i+'_'+t];
                        } else {
                            tabinput.value = this.data.tablecontents[i][t].value;
                        }
                        */
                        tabinput.value = this.data.tablecontents[i][t].value;
                        tabinput.maxlength = this.data.tablecontents[i][t].length;
                        tabinput.size = this.data.tablecontents[i][t].length;
                        // ====================================================================================
                        //console.log(this.data.tablecontents[i][t].align);
                        if (this.data.tablecontents[i][t].align) {
                            tabinput.style.textAlign = this.data.tablecontents[i][t].align;
                        } else {
                            tabinput.style.textAlign = 'center';
                        }
                        // ====================================================================================
                        this.inputsToCheck['input_'+i+'_'+t] = this.data.tablecontents[i][t].answer;
                        cell.appendChild(tabinput);
                        //
                        this.inputsToCheckRows['input_'+i+'_'+t] = i;
                        //
                        break;
                    case 'dropdown':
                        this.numberToCheck++;
                        break;
                }
                
                if (this.data.tablecontents[i][t].align) {
                    cell.style.textAlign = this.data.tablecontents[i][t].align;
                } else {
                   cell.style.textAlign = 'center'; 
                }
                if (this.data.tablecontents[i][t].valign) {
                    cell.style.verticalAlign = this.data.tablecontents[i][t].valign;
                } else {
                   cell.style.verticalAlign = 'middle'; 
                }
                row.appendChild(cell);
            }
        }
        /*
        for (var x in this.inputsToCheckRows) {
            console.log(x+': '+this.inputsToCheckRows[x]);
        }
        */
    };
    // ====================================================================================
    /** Grab user entries from the table */
    OU.activity.TableUserComplete.prototype.getUserEntries = function() {
        for (var x in this.inputsToCheck) {
            this.userEntries[x] = document.getElementById(x).value;
        }
    }
    // ====================================================================================
    
    /**
     * accessibleView - this function is called instead of canvasView if the browser does not support HTML5 canvas
     */
    OU.activity.TableUserComplete.prototype.accessibleView = function() {
        OU.activity.TableUserComplete.superClass_.accessibleView.call(this); // call the superclass method is you want to extend it, remove this line to override the method instead

    // Note this function can be removed or commented out if you want to use the default accessibleView method

    // *Your code starts here*
    };
    // ====================================================================================
    /**
     * resize - called whenever the outer bounds of the activity change, ie when the browser window is resized, or a mobile device is rotated.
     *
     * This function should do the following:
     * <ul>
     * <li>Resize all visible elements</li>
     * <li>Re-layout all visible elements</li>
     * <li>Actually re-render the current view of the activity</li>
     * </ul>
     */
    // ====================================================================================
    OU.activity.TableUserComplete.prototype.resize = function() {
        OU.activity.TableUserComplete.superClass_.resize.call(this); // call the superclass resize
        // Resize the table div
        this.userInputsDiv.resize({
            x:10,
            y:10,
            w:this.w-20,
            h:400
        });
        // Call render() to recreate the table contents
        //this.render();
        // reposition the button layer
        // /*this.w - this.data.submitbutton.w*/
        this.buttonsLayer.resize({
            x:this.userInputsDiv.x + document.getElementById('userInputsTable').offsetWidth - this.data.submitbutton.w,
            y:this.userInputsDiv.y + document.getElementById('userInputsTable').offsetHeight,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        this.buttonSubmit.render();
        
        this.textInfoLayer.resize({
            x:10,
            y:this.buttonsLayer.y + this.buttonsLayer.h,
            w:this.w-20,
            h:50
        });
        //console.log('x:'+this.buttonsLayer.x);
        //console.log('y:'+this.buttonsLayer.y);
        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        ///////////////////////////////////////////////////////////////////////////////
        
        
    //
    };

    /**
     * remove - called when the activity is being removed by a controller.
     *
     * This function should do the following:
     * <ul>
     * <li> Remove any elements that may remain in memory</li>
     * <li> Stop any animation loops, including killing any Intervals </li>
     * </ul>
     * You do not need to remove most library elements, such as Layers, Divs, etc. as they are removed automatically
     */
    OU.activity.TableUserComplete.prototype.remove = function() {
        OU.activity.TableUserComplete.superClass_.remove.call(this); // call the superclass remove

    // *Your removal code here*
    // If you have nothing to remove, then this function can be deleted or commented out
    };

    // call the superclass's constructor
    OU.base(this,data,instance,controller);
};
// Call our inherits function to implement the class inheritance
OU.inherits(OU.activity.TableUserComplete,OU.util.Activity);
