/**
 * @fileOverview Cafe wall illusion
 *
 * @author Greg Black
 */

OU.require('OU.util.Button');
OU.require('OU.util.DynText');
OU.require('OU.util.Layer');
OU.require('OU.util.PopUpInfo');
OU.require('OU.util.Slider');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.Cafewall = function ( data, instance, controller ) { //data and instance are passed in from index.html
    OU.activity.Cafewall.prototype.canvasView = function () {
        //var self = this;
        var bH = OU.controlHeight;
        // create Canvas Layers & Contexts
        this.square = true;
        this.initialSliderPos = [0.75, 0.2, 0.5, 0.1, 0.2];

        this.bgLayer = new OU.util.Layer({
            container:this, //container is the whole area and can contain other stuff
            id:'bg'
        });
        //set colour of container layer (if specified in data.js) or use a default
        if (this.data.backgroundColour !== undefined)
            this.bgLayer.context.gradRect({
                col1:this.data.backgroundColour,
                col2:this.data.backgroundColour
            }); // use specified background colour
        else
            this.bgLayer.context.gradRect(); // use default background

        this.slidersLayer = new OU.util.Layer({ //slidersLayer to hold the sliders
            container:this,
            id:'slidersLayer',
            x:this.w*.1,
            y:this.h*.65+bH,
            h:this.h*.4,
            w:this.w*.8,
            hasEvents:true,
            pinch:this.pinch,
            pinchMe:this
        });
        this.slidersLayer.context.gradRect(); // use default background

        this.wallLayer = new OU.util.Layer({
            container:this,
            id:'wallLayer',
            x:this.w*.1,
            y:this.h*.1+bH,
            w:this.w*.8,
            h:this.h*0.5,
            hasEvents:true,
            pinch:this.pinch,
            pinchMe:this
        });

        var ctx = this.wallLayer.context;
        if (this.data.wallLayer!==undefined){
            ctx.stroke();
            ctx.fillStyle = this.baseColour;
            ctx.fillRect(0, 0, this.wallLayer.w, this.wallLayer.h);
        }
        else{
            ctx.stroke();
            ctx.fillStyle = this.data.baseColour;
            ctx.fillRect(0, 0, this.wallLayer.w, this.wallLayer.h);
        }

        this.initControls();
        this.render();
    };

    OU.activity.Cafewall.prototype.initControls = function () {
        var s, ctx = this.slidersLayer.context, bH = OU.controlHeight, self = this,
        clickable = this.slidersLayer.events.clickable, slH = this.slidersLayer.h, slW = this.slidersLayer.w;
        this.sliders = new Array(3);
        this.sliderLabels = ["Row offset","Tile width","Mortar grey","Mortar width","Tile height"];
        this.sliderIDs = ["roSlider","twSlider","mgSlider","mwSlider","thSlider"];
        for (var i = 0; i < 5; i++) {
            this.sliders[i] = new OU.util.Slider({
                container:this.slidersLayer,
                instance:'',
                x:i<3?slW*.05:slW*.5,
                y:i<3?i*slH*.25+slH*.06:(i-3)*slH*.25+slH*.06,
                w:slW*.4,
                h:slH*.15,
                sliderHeight:bH / 2,
                sliderPos:this.initialSliderPos[i],
                drawContainer:false,
                title:this.sliderLabels[i]+"",
                titlePosition:"above",
                showValue:false,
                callback:self.setSliders,
                callbackParam:{i:this.sliderIDs[i],self:this}, //identifies which button was clicked
                background:{
                    clear:true
                },
                context:ctx
            });
            clickable.push(this.sliders[i]);
        }
        self.roSlider=this.sliders[0];
        self.twSlider=this.sliders[1];
        self.mgSlider=this.sliders[2];
        self.mwSlider=this.sliders[3];
        self.thSlider=this.sliders[4];

        //add the chechbox button bottom right
        this.squareBtn = new OU.util.CheckBoxButton({
            txt:'Square',
            x:slW*.525,
            y:slH*.525,
            w:slW*.2,
            h:slH*.2,
            layer:this.slidersLayer,
            state:true,
            onClick:function () {
                self.toggleSquare();       //calls a function below
            }
        });
        this.resetBtn = new OU.util.Button({
            txt:"Reset",
            padding:0,
            verticalPadding:0,
            layer:this.slidersLayer,
            x:slW*.7,
            y:slH*.8,
            w:slW*.15,
            h:slH*.18,
            onClick:function () {
                self.resetParameters();
            }
        });
        this.helpBtn = new OU.util.Button({
            txt:"Help",
            padding:0,
            verticalPadding:0,
            layer:this.slidersLayer,
            x:slW*.85,
            y:slH*.8,
            w:slW*.15,
            h:slH*.18,
            onClick:function () {
                if (!self.helpDisp) {
                    self.helpDisp = true;
                    self.showHelp();
                }
            }
        });
        this.renderSlider();
    };

    OU.activity.Cafewall.prototype.showHelp = function () {
        var self = this;
        new OU.util.PopUpInfo({
            container:this,
            txt:this.data.help,
            x:this.w*.25,
            y:this.h*.25,
            w:this.w*.5,
            h:this.h*.5,
            onClose:function () {
                self.helpDisp = false;
            }
        });
    };

    /**
     * The main renderer.
     */
    OU.activity.Cafewall.prototype.render = function () {
        var self = this;
        this.drawWall();
    };

    OU.activity.Cafewall.prototype.resize = function () {
        OU.activity.Cafewall.superClass_.resize.call(this); // call the parent class resize
        var bH = OU.controlHeight, i, ctxS = this.slidersLayer.context, slH = this.slidersLayer.h,
        slW = this.slidersLayer.w, ctxW = this.wallLayer.context;
        this.bgLayer.resize();
        if (this.data.backgroundColour!==undefined)
            this.bgLayer.context.gradRect({
                col1:this.data.backgroundColour,
                col2:this.data.backgroundColour
            }); // use specified background colour
        else
            this.bgLayer.context.gradRect(); // use default background

        this.wallLayer.resize({
            x:this.w*.1,
            y:this.h*.1+bH,
            w:this.w*.8,
            h:this.h*0.5
        });
        this.slidersLayer.resize({
            x:this.w*.1,
            y:this.h*.65+bH,
            h:this.h*.4,
            w:this.w*.8
        });

        if (this.data.panelColour!==undefined)
            ctxS.gradRect({
                col1:this.data.panelColour,
                col2:this.data.panelColour
            }); // use specified background colour
        else
            ctxS.gradRect(); // use default background

        ctxW.stroke();
        ctxW.fillStyle = this.baseColour;
        ctxW.fillRect(0, 0, this.wallLayer.w, this.wallLayer.h);

        for (i=this.sliders.length; i--;) {
            this.sliders[i].resize({
                x:i<3?slW*.05:slW*.5,
                y:i<3?i*slH*.25+slH*.06:(i-3)*slH*.25+slH*.06,
                w:slW*.4,
                h:slH*.15,
                sliderHeight:slH*.15
            });
        }

        ctxS.font = '18px ' + OU.theme.font;
        ctxS.lineWidth = 2;
        ctxS.strokeStyle = '#c00';
        ctxS.fillStyle = '#c00';
        ctxS.textAlign = 'center';

        this.resetBtn.resize({
            y:slH*.75,
            h:slH*.15,
            w:slW*.15,
            x:slW*.7
        });
        this.helpBtn.resize({
            y:slH*.75,
            h:slH*.15,
            w:slW*.15,
            x:slW*.85
        });
        this.squareBtn.resize({
            x:slW*.525,
            y:slH*.525,
            w:slW*.2,
            h:slH*.2
        });
        this.render();
        this.resetBtn.render();
        this.helpBtn.render();
    };

    OU.activity.Cafewall.prototype.drawWall = function () {
        var rowHeight, rows, cols, r, c, x, y, dx;
        var ctx = this.wallLayer.context;
        var w = this.wallLayer.w;
        var h = this.wallLayer.h;
        var black = "#000000";
        var lightGrey = "#FFFFFF";
        var darkGrey = "#000000";
        var minGrey = 0;
        var maxGrey = 255;
        var mortarGrey = mortarGrey = Math.floor(minGrey+this.mgSlider.sliderPos*maxGrey);
        var mortarGreyRGB = "rgb("+mortarGrey+","+mortarGrey+","+mortarGrey+")";
        var minBlockWidth = w/50;
        var maxBlockWidth = w/5;
        var minBlockHeight = w/50;
        var maxBlockHeight = w/5;

        var blockWidth = minBlockWidth+this.twSlider.sliderPos*(maxBlockWidth-minBlockWidth);
        var blockHeight = minBlockHeight+this.thSlider.sliderPos*(maxBlockHeight-minBlockHeight);
        var mortarWidth = 1;
        var offset = 0.5;
        offset = (this.roSlider.sliderPos*200-100)/100;
        mortarWidth = this.mwSlider.sliderPos*15;
        // Draw background in light colour
        ctx.fillStyle = lightGrey;
        ctx.fillRect(0, 0, w-1, h-1);

        // Determine number of rows and columns
        rowHeight = blockHeight + mortarWidth;
        rows = (h/rowHeight) + 1;
        cols = (w/blockWidth) + ((offset < 0) ? 2 : 1);

        // Draw dark blocks row by row
        ctx.fillStyle = darkGrey;
        dx = offset * blockWidth;
        y = h - blockHeight;
        for(r = 0; r < rows; r++){
            // Draw this row, with horizontal offset if it's an odd row
            x = ((r % 2) == 1) ? dx : 0;
            for(c = 0; c < cols; c += 2){
                // Draw a block here
                ctx.fillRect(x, y, blockWidth, blockHeight);
                x += blockWidth + blockWidth;
            }
            y -= rowHeight;
        }
        // Draw mortar if necessary
        if(mortarWidth == 1){
            ctx.fillStyle = mortarGreyRGB;
            x = w - 1;
            y = h - rowHeight;
            for(r = 0; r < rows; r++){
                //ctx.drawLine( 0, y, x, y );
                y -= rowHeight;
            }
        }
        else if(mortarWidth > 1){
            ctx.fillStyle = mortarGreyRGB;
            x = w - 1;
            y = h - rowHeight;
            for(r = 0; r < rows; r++){
                ctx.fillRect(0, y, x, mortarWidth);
                y -= rowHeight;
            }
        }

        // Draw a black border
        ctx.strokeStyle = black;
        ctx.strokeRect(0, 0, w - 1, h - 1);
    };


    OU.activity.Cafewall.prototype.resetParameters = function () {
        for (i = 0; i < this.sliders.length; i++) {
            this.sliders[i].sliderPos = this.initialSliderPos[i]
        }
        this.square = true;
        this.squareBtn.state(this.square);
        this.drawWall();
    };

    OU.activity.Cafewall.prototype.renderSlider = function () {
        //render the slider
        var self = this;

        this.slidersLayer.clear(0,0,this.slidersLayer.w,this.slidersLayer.h);
        for(i=this.sliders.length; i--;){
            this.sliders[i].render();
        }
        setTimeout(function () {
            self.renderSlider();
        }, 40);
        self.squareBtn.render();
        self.resetBtn.render();
        self.helpBtn.render();
    };

    OU.activity.Cafewall.prototype.toggleSquare = function () {
        this.square = !this.square;
        this.squareBtn.state(this.square);
        if(this.square){
            this.twSlider.sliderPos = this.thSlider.sliderPos;
        }
        this.drawWall();
    };

    OU.activity.Cafewall.prototype.setSliders = function ( p, v ) { // Called when slider is moved
        var id = v.i;
        //the tile width and tile height sliders are linked if the 'square' checkbox is selected
        if(v.self.square){
            switch(id){
                case "twSlider":
                    v.self.thSlider.sliderPos = v.self.twSlider.sliderPos;
                    break;
                case "thSlider":
                    v.self.twSlider.sliderPos = v.self.thSlider.sliderPos;
                    break;
                default:
                    break;
            }
        }
        v.self.drawWall();
    };

    /*OU.activity.Cafewall.prototype.pinch = function ( e, s, x, y, dx, dy, me ) { // called when pinch event detected
        var ns = ((e - s) / me.h) + me.tileView.s;
        ns = ns > 1 ? 1 : (ns < 0 ? 0 : ns);
        me.tileView.scale(ns, {
            x:x,
            y:y
        });
        me.zoomSlider.sliderPos = ns;
        me.zoomSlider.render();
    };//*/

    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.Cafewall, OU.util.Activity);
