/**
 * @fileOverview Quiz Activity - multiple choice
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */
OU.require('OU.util.DynText');
OU.require('OU.util.Button');
OU.require('OU.util.Layer');
OU.require('OU.util.ImageLoader');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.Quiz = function ( data, instance, controller ) {
    OU.activity.Quiz.prototype.canvasView = function () {
        this.clickable = new OU.util.TypedArray();
        this.tabbables=[];
        this.score = 0;
        this.totalScore = 0;
        this.questionNum = -1;
        this.staticClicked = [];
        this.hasImages = false;
        this.summaryMode = false;
        this.multiFeedback = false;
        this.randomise = this.data.randomise;
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw background on backdrop layer
        this.imageLayer = new OU.util.Layer({
            container:this,
            hasEvents:true
        });
        this.imageCheck();
        if (!this.data.waitForCue)
            this.load();
        else
            this.state = OU.PAUSED;
    };
    OU.activity.Quiz.prototype.load = function () {
        var self = this;
        this.imageLoader = new OU.util.ImageLoader({
            container:this,
            data:this.data,
            onLoad:function () {
                self.state = OU.RUNNING;
                self.scaleImages();
                self.backdrop(self.data);
                self.start(self);
            }
        });
    };
    OU.activity.Quiz.prototype.defineAreas = function () {
        var i, question = this.data.round[this.roundNum].question[this.questionNum],
        ctx = this.imageLayer.context,
        multi = (question.type=='multi'),
        q, o, f1, f2, sF = 1, y, maxOptionWidth = 0, x, w,
        totalHeight , optionsHeight = 0, feedbackHeight = 0,
        minFont = 100* OU.dpr, maxFont = OU.theme.fontSize * OU.dpr,
        numCols = question.optionColumns || 1,
        _tn = 10 * OU.dpr, _tw = 20 * OU.dpr, _et = 80 * OU.dpr, _ft = 40 * OU.dpr;

        if (this.hasImages) {
            w = this.w / 2 - _tw;
            x = _tn + this.w / 2;
        }
        else {
            x = _tn;
            w = this.w - _tw;
        }
        if (this.data.title!==undefined)
            y = this.h * 0.05 + _tn;
        else
            y = _tn;
        q = new OU.util.DynText({
            txt:question.q,
            x:0,
            y:0,
            w:w,
            h:this.h,
            context:ctx,
            align:'left',
            fontSize:maxFont,
            measureOnly:true
        });
        totalHeight = q.h;
        if (q.font.size < minFont)
            minFont = q.font.size;
        for (i = 0; i < question.a.length; i++) {
            o = new OU.util.DynText({
                txt:question.a[i].option,
                x:0,
                y:0,
                w:w,
                h:this.h,
                context:ctx,
                fontSize:maxFont,
                fontWeight:'bold',
                measureOnly:true
            });
            if (o.font.size < minFont)
                minFont = o.font.size;
            optionsHeight = optionsHeight + o.h + _tw;
            maxOptionWidth = o.w > maxOptionWidth ? o.w : maxOptionWidth;
        }
        maxOptionWidth = (maxOptionWidth + _et) * numCols; // Add on space for the icon padding and multiply by columns
        maxOptionWidth = maxOptionWidth > w ? w : maxOptionWidth; // ensure options stay within the activity area
        optionsHeight = optionsHeight / numCols + _tw;
        totalHeight += optionsHeight;
        if (multi) {
            f1 = new OU.util.DynText({
                txt:question.incorrectFeedback,
                x:0,
                y:0,
                w:w,
                fontSize:maxFont,
                h:this.h,
                context:ctx,
                measureOnly:true
            });
            if (f1.font.size < minFont)
                minFont = f1.font.size;
            f2 = new OU.util.DynText({
                txt:question.correctFeedback,
                x:0,
                y:0,
                w:w,
                fontSize:maxFont,
                h:this.h,
                context:ctx,
                measureOnly:true
            });
            if (f2.font.size < minFont)
                minFont = f2.font.size;
            feedbackHeight = f1.h > f2.h ? f1.h : f2.h;
        }
        else {
            for (i = question.a.length; i--;) {
                f1 = new OU.util.DynText({
                    txt:question.a[i].feedback,
                    x:0,
                    y:0,
                    w:w,
                    h:this.h,
                    fontSize:maxFont,
                    context:ctx,
                    measureOnly:true
                });
                if (f1.font.size < minFont)
                    minFont = f1.font.size;
                if (f1.h > feedbackHeight)
                    feedbackHeight = f1.h;
            }
        }
        totalHeight += feedbackHeight;
        if (totalHeight > this.h - OU.controlHeight - _ft - y)
            sF = (this.h - OU.controlHeight - _tw - y) / totalHeight;
        if (this.w < this.h * 3 || this.data.forcePortrait) { // portrait
            this.areas = {
                font:minFont,
                title:{
                    x:x,
                    y:0,
                    w:w,
                    h:y
                },
                question:{
                    x:x,
                    y:y,
                    w:w,
                    h:q.h * sF
                },
                options:{
                    x:x,
                    y:y + q.h * sF,
                    w:maxOptionWidth,
                    h:optionsHeight * sF
                },
                feedback:{
                    x:x,
                    y:y + q.h * sF + optionsHeight * sF + _tw,
                    w:w,
                    h:feedbackHeight * sF
                },
                summary:{
                    x:x,
                    y:y,
                    w:w,
                    h:(q.h + optionsHeight + feedbackHeight) * sF
                }
            };
        }
        else { // landscape
            this.areas = {
                font:minFont,
                question:{
                    x:x,
                    y:0,
                    w:w * 0.3,
                    h:this.h
                },
                options:{
                    x:x + w * .3,
                    y:0,
                    w:maxOptionWidth, //w * .4,
                    h:this.h
                },
                feedback:{
                    x:x + w * .7,
                    y:0,
                    w:w * .3,
                    h:this.h
                },
                summary:{
                    x:x,
                    y:0,
                    w:w,
                    h:this.h
                }
            };
        }
    };
    OU.activity.Quiz.prototype.resize = function () {
        OU.activity.Quiz.superClass_.resize.call(this); // call the parent class resize
        this.bgLayer.resize();
        this.bgLayer.context.gradRect(); // draw background on backdrop layer
        this.imageLayer.resize();
        if (this.state==OU.RUNNING) {
            this.defineAreas();
            this.scaleImages();
            if (this.questionNum < 0) {
                this.renderWelcome();
            }
            else if (this.inFeedback) {
                if (this.summaryMode) {
                    this.roundSummary();
                }
                else {
                    this.loadQuestion({
                        noDelay:true
                    });
                    this.renderFeedback();
                }
            }
            else {
                this.loadQuestion({
                    noDelay:true
                });
            }
        }
    };
    /* Step function is only used as a trigger to start  - you can not currently step directly to a specific question */
    OU.activity.Quiz.prototype.step = function ( n ) {
        if (n==this.stepN) return;
        this.stepN = n;
        if (n==0) {
            this.imageLayer.clear();
        }
        else {
            this.load();
        }
    };
    OU.activity.Quiz.prototype.scaleImage = function ( obj ) {
        var iar, car;
        if (obj.img!==undefined && obj.img!='') {
            iar = obj.image.width / obj.image.height, car = this.w / this.h;
            if (iar > car) {
                obj.h = this.h;
                obj.w = this.h * iar;
                obj.x = (this.w - obj.w) / 2;
                obj.y = 0;
            }
            else {
                obj.w = this.w;
                obj.h = this.w / iar;
                obj.x = 0;
                obj.y = (this.h - obj.h) / 2;
            }
        }
    };
    OU.activity.Quiz.prototype.scaleImages = function () {
        var r, qi, round;
        this.scaleImage(this.data);
        for (r = this.data.round.length; r--;) {
            round = this.data.round[r];
            this.scaleImage(round);
            for (qi = round.question.length; qi--;) {
                this.scaleImage(round.question[qi]);
            }
        }
    };
    OU.activity.Quiz.prototype.backdrop = function ( obj ) {
        var d = 0;
        if (obj.img!==undefined) {
            if (obj.img=='') {
                this.bgLayer.context.gradRect();
            }
            else {
                this.bgLayer.context.drawImage(obj.image, 0, 0, obj.image.width, obj.image.height, obj.x, obj.y, obj.w, obj.h);
                d = obj.imageDelay || 3;
            }
        }
        return d;
    };
    OU.activity.Quiz.prototype.randomiseQuestion = function () {
        var question = this.data.round[this.roundNum].question[this.questionNum];
        if (this.randomise) {
            question.a.sort(function () {
                return (Math.round(Math.random()) - 0.5);
            });
        }
    };
    OU.activity.Quiz.prototype.start = function ( me ) {
        var i, j, k, r, q;
        me.imageLayer.events.flush();
        me.roundNum = 0;
        me.answer = undefined;
        me.questionNum = 0;
        me.multiFeedback = null;
        if (me.randomise)
            me.randomiseQuestion();
        me.score = [];
        me.roundScore = [];
        for (i = me.data.round.length; i--;) {
            r = me.data.round[i];
            for (j = r.question.length; j--;) {
                q = r.question[j];
                for (k = q.a.length; k--;)
                    q.a[k].on = undefined;
            }
        }
        me.loadQuestion();
    };
    OU.activity.Quiz.prototype.nextRound = function () {
        var events = this.imageLayer.events;
        events.flush();
        events.clickable.length = 0;
        this.clearTabbables();
        this.answer = null;
        this.roundNum++;
        this.questionNum = 0;
        if (this.randomise)
            this.randomiseQuestion();
        this.score = [];
        this.loadQuestion();
    };
    OU.activity.Quiz.prototype.loadQuestion = function ( p ) {
        var self = this,
        question = this.data.round[this.roundNum].question[this.questionNum],
        delay;
        p = p || {};
        this.summaryMode = false;
        this.imageLayer.clear();
        this.inFeedback = false;
        delay = this.backdrop(question);
        if (delay > 0 && p.noDelay===undefined) {
            setTimeout(function () {
                self.renderQuestion();
            }, delay * 1000);
        }
        else {
            this.renderQuestion();
        }
    };
    OU.activity.Quiz.prototype.renderQuestion = function () {
        var ctx = this.imageLayer.context,
        a, fontSize, question = this.data.round[this.roundNum].question[this.questionNum];
        ctx.clearRect(0, 0, this.w, this.h); // clear layer
        this.defineAreas(); // re-define the areas for each question
        a = this.areas;
        fontSize = a.font;
        if (this.data.title) {
            new OU.util.pageTitle({
                txt:this.data.title,
                context:ctx,
                fontSize:fontSize
            });
        }
        ctx.fillStyle = 'rgba(255,255,255,0.75)';
        ctx.roundRect(a.question.x, a.question.y, a.feedback.x + a.feedback.w - a.question.x, a.feedback.y + a.feedback.h - a.question.y + OU.controlHeight + 20, 10);
        ctx.fill();
        // The Question
        new OU.util.DynText({
            txt:question.q,
            x:a.question.x,
            y:a.question.y,
            w:a.question.w,
            h:a.question.h,
            context:ctx,
            align:'left',
            fontSize:fontSize
        });
        this.renderOptions();
    };
    OU.activity.Quiz.prototype.clearTabbables = function () {
        var i;
        if(this.tabbables) {
            for(i=this.tabbables.length;i--;)
                this.tabbables[i].remove();
        }
        if(this.doneButton)
            this.doneButton.remove();
        this.doneButton=undefined;
        if(this.nextButton)
            this.nextButton.remove();
        this.nextButton=undefined;
        this.tabbables.length=0;
        this.tabbables=[];
        this.imageLayer.events.clickable.length = 0;
    };
    OU.activity.Quiz.prototype.renderOptions = function () {
        var i, j, o,self=this,
        goBH, question = this.data.round[this.roundNum].question[this.questionNum],
        multi = (question.type=='multi'),
        nButtons = question.a.length, answer = this.answer,
        a = this.areas, numCols = question.optionColumns || 1, id = 0, state = OU.UNSELECTED,
        fontSize = a.font,
        _tn = 10 * OU.dpr, _ft = 40 * OU.dpr,
        optionsArea = a.options,
        bX = optionsArea.x + _tn,
        bY = optionsArea.y + _tn,
        bW = (optionsArea.w - _tn) / numCols,
        bH = optionsArea.h / ((nButtons / numCols | 0) + 1); // 38; // 28px high + 10px padding

        if(this.nextButton)
            this.nextButton.remove();

        for (i = 0; i < numCols; i++) {
            for (j = 0; j < nButtons / numCols; j++) {
                o = question.a[id];
                if (o) {
                    if (multi) {
                        if (o.on) {
                            if (this.multiFeedback) {
                                if (o.points > 0)
                                    state = OU.CORRECT;
                                else
                                    state = OU.INCORRECT;
                            }
                            else {
                                state = OU.SELECTED;
                            }
                        }
                        else {
                            state = OU.UNSELECTED;
                        }
                    }
                    else {
                        if (answer==id) {
                            if (o.points > 0)
                                state = OU.CORRECT;
                            else
                                state = OU.INCORRECT;
                        }
                        else {
                            state = OU.UNSELECTED;
                        }
                    }
                    if(this.tabbables[id]) {
                        this.tabbables[id].state(state);
                        this.tabbables[id].render();
                    }
                    else {
                        this.tabbables[id] = new OU.util.CheckBoxButton({
                            layer:this.imageLayer,
                            txt:o.option,
                            x:bX + i * bW,
                            y:bY + j * bH,
                            w:bW - _tn,
                            h:bH - _tn,
                            onClick: function(c) {
                                self.answered(c);
                            },
                            onClickParam:id,
                            fontSize:fontSize,
                            state:state
                        });
                    }
                    id++;
                }
            }
        }
        if (multi && !this.multiFeedback) { // Add 'Done' button for multi input questions
            goBH = (optionsArea.h / question.a.length) - _tn;
            if(this.doneButton) {
                this.doneButton.render();
            }
            else {
                this.doneButton = new OU.util.Button({
                    layer:this.imageLayer,
                    txt:'Check your answer',
                    x:a.feedback.x,
                    y:a.feedback.y + (a.feedback.h - _ft),
                    w:200 * OU.dpr,
                    h:_ft,
                    autoWidth:true,
                    padding:goBH / 6,
                    onClick: function() {
                        self.answered(-1);
                    },
                    fontSize:fontSize
                });
            }
        }
    };
    OU.activity.Quiz.prototype.answered = function ( choice ) {
        var question = this.data.round[this.roundNum].question[this.questionNum],
        answer = question.a[choice],
        i, q, multi = (question.type!==undefined && question.type=='multi');
        if (multi) {
            if (choice==-1) { // done button
                this.fail = false;
                for (i = question.a.length; i--;) {
                    q = question.a[i];
                    if (q.on===undefined || !q.on) {
                        if (q.points > 0) this.fail = true;
                    }
                    else {
                        if (q.points < 1) this.fail = true;
                    }
                }
                if (this.fail) this.score[this.questionNum] = 0;
                else this.score[this.questionNum] = 1;
                this.renderFeedback();
            }
            else {
                answer.on = answer.on===undefined?true:(!answer.on);
                this.renderQuestion();
            }
        }
        else {
            this.answer = choice;
            this.score[this.questionNum] = answer.points;
            this.fail = answer.points <= 0;
            this.renderOptions();
            if (!this.fail && answer.controller!==undefined) {
                this.controller.overrideSection(answer.controller);
            }
            else {
                this.renderFeedback();
            }
        }
    };
    OU.activity.Quiz.prototype.renderFeedback = function () {
        var ctx = this.imageLayer.context,
        f, butX, butY, butW, butH, feedX, feedY, feedW, feedH, events, question = this.data.round[this.roundNum].question[this.questionNum],
        multi = (question.type!==undefined && question.type=='multi'),
        a = this.areas, fontSize = a.font;
        this.multiFeedback = true;
        if (this.w < this.h * 3 || this.data.forcePortrait) { // portrait
            butW = a.feedback.w - 10;
            butH = OU.controlHeight;
            butX = a.feedback.x + a.feedback.w - butW - 10;
            butY = a.feedback.y + a.feedback.h + 5;
            feedX = a.feedback.x;
            feedY = a.feedback.y;
            feedW = a.feedback.w;
            feedH = a.feedback.h;
        }
        else {
            butW = 100;
            if (a.feedback.h > 120) {
                butH = 40;
            }
            else {
                butH = a.feedback.h / 3;
            }
            if (a.feedback.w < 300) {
                butW = a.feedback.w / 3;
            }
            butX = a.feedback.x + ((a.feedback.w - (butW + 10)) / 2);
            butY = a.feedback.y + ((a.feedback.h - (butH + 5)) );
            feedX = a.feedback.x;
            feedY = a.feedback.y + (butH / 4);
            feedW = a.feedback.w;
            feedH = a.feedback.h - (butH + (butH / 2));
        }
        this.inFeedback = true;
        this.staticClicked[this.answer] = this.fail;
        this.renderQuestion();
        if (multi) {
            if (this.fail) f = question.incorrectFeedback;
            else f = question.correctFeedback;
            new OU.util.DynText({
                txt:f,
                x:feedX,
                y:feedY,
                w:feedW,
                h:feedH,
                align:'left',
                context:ctx,
                fontSize:fontSize
            });
        }
        else {
            new OU.util.DynText({
                txt:question.a[this.answer].feedback,
                x:feedX,
                y:feedY,
                w:feedW,
                h:feedH,
                context:ctx,
                align:'left',
                fontSize:fontSize
            });
        }
        events = this.imageLayer.events;
        events.pressed = events.touched = false;
        events.clickable.length = 0;
        this.clearTabbables();
        if(this.nextButton)
            this.nextButton.remove();
        if (question.forceCorrect===true && this.fail) {
            this.nextButton=new OU.util.NextButton({
                layer:this.imageLayer,
                txt:'Retry',
                x:butX,
                y:butY,
                w:butW,
                h:butH,
                onClick:this.sameQuestion,
                onClickParam:this
            });
        }
        else if (this.data.round.length==1 && this.data.round[0].question.length==1) {
            this.nextButton=new OU.util.NextButton({
                layer:this.imageLayer,
                txt:'Restart Quiz',
                x:butX,
                y:butY,
                w:butW,
                h:butH,
                onClick:this.start,
                onClickParam:this
            });
        }
        else {
            this.nextButton=new OU.util.NextButton({
                layer:this.imageLayer,
                txt:'Next',
                x:butX,
                y:butY,
                w:butW,
                h:butH,
                onClick:this.nextQuestion,
                onClickParam:this
            });
        }
    };
    OU.activity.Quiz.prototype.roundSummary = function () {
        var self=this,ctx = this.imageLayer.context, yo, butX, butY, butW, butH, feedX, feedY, feedW, feedH, iH = 16,
        rIdx, qNum, optNum, a = this.areas;
        ctx.clearRect(0, 0, this.w, this.h); // clear layer
        this.summaryMode = true;
        if (this.w < this.h * 3 || this.data.forcePortrait) { // portrait
            butX = a.summary.x + (a.summary.w - 110*OU.dpr);
            butY = a.summary.y + ((a.summary.h - 40*OU.dpr) / 2);
            butW = 100*OU.dpr;
            butH = 40*OU.dpr;
            feedX = a.summary.x + (butW + 20);
            feedY = a.summary.y;
            feedW = a.summary.w - (2 * (butW + 20));
            feedH = a.summary.h;
        }
        else {
            butW = 100*OU.dpr;
            if (a.summary.h > 120) {
                butH = 40*OU.dpr;
            }
            else {
                butH = a.summary.h / 3;
            }
            if (a.summary.w < 300) {
                butW = a.summary.w / 3;
            }
            if (butH < 20) {
                iH = butH - 4;
            }
            else {
                iH = 16;
            }
            butX = a.summary.x + ((a.summary.w - (butW + 10)) / 2);
            butY = a.summary.y + ((a.summary.h - (butH + 5)) );
            feedX = a.summary.x + 20;
            feedY = a.summary.y + (butH / 4);
            feedW = a.summary.w - 40;
            feedH = a.summary.h - (butH + (butH / 2));
        }
        ctx.save();
        ctx.fillStyle = '#ffffff';
        var highest = [];
        var totalHighest = 0;
        for (rIdx = this.data.round.length; rIdx--;) {
            highest[rIdx] = 0;
            for (qNum = this.data.round[rIdx].question.length; qNum--;) {
                var qHighest = 0;
                var question = this.data.round[rIdx].question[qNum];
                for (optNum = question.a.length; optNum--;) {
                    var option = question.a[optNum];
                    if (option.points > qHighest)
                        qHighest = option.points;
                }
                highest[rIdx] += qHighest;
                totalHighest += qHighest;
            }
        }
        var score = 0;
        for (var i = 0; i < this.score.length; i++)
            score += this.score[i];
        var scoreText = score + ' out of ' + highest[this.roundNum];
        this.roundScore[this.roundNum] = score;
        ctx.save();
        ctx.fillStyle = "#EBF4FB";
        ctx.fillRect(feedX, feedY, feedW, feedH);
        if (this.roundNum < this.data.round.length - 1) {
            yo = (feedH / 2) - 5;
        }
        else {
            yo = (feedH / 3) - 5;
        }
        ctx.fillStyle = "#ff0000";
        new OU.util.DynText({
            txt:this.data.round[this.roundNum].endText || '',
            x:feedX,
            y:feedY + yo + 10,
            w:feedW,
            h:yo,
            context:ctx
        });
        new OU.util.DynText({
            txt:scoreText,
            x:feedX,
            y:feedY,
            w:feedW,
            h:yo,
            fontWeight:'bold',
            context:ctx
        });
        var events = this.imageLayer.events;
        if(this.nextButton)
            this.nextButton.remove();
        if (this.roundNum < this.data.round.length - 1) { // End of Round
            events.clickable.length = 0;
            this.clearTabbables();
            this.nextButton=new OU.util.Button({
                layer:this.imageLayer,
                txt:'Next Round',
                x:butX,
                y:butY,
                w:butW,
                h:butH,
                onClick: function() {
                    self.nextRound();
                },
                glyph:{
                    type:'rightArrow',
                    align:'right',
                    w:iH,
                    h:iH,
                    fore:'#1A1A1A',
                    back:'#ffffff'
                }
            });
        }
        else { // End of Quiz
            var totalScore = 0;
            for (i = 0; i < this.roundScore.length; i++)
                totalScore += this.roundScore[i];
            scoreText = 'Total Quiz Score: ' + totalScore + ' out of ' + totalHighest;
            new OU.util.DynText({
                txt:scoreText,
                x:feedX,
                y:feedY + (yo * 2) + 10,
                w:feedW,
                h:yo,
                context:ctx,
                propTextHeight:0.5
            });
            events.clickable.length = 0;
            this.clearTabbables();
            this.nextButton=new OU.util.Button({
                layer:this.imageLayer,
                txt:'Restart Quiz',
                x:butX,
                y:butY,
                w:butW,
                h:butH,
                onClick:this.start,
                onClickParam:this
            });
        }
    };
    OU.activity.Quiz.prototype.sameQuestion = function ( me ) {
        var events = me.imageLayer.events;
        events.pressed = false;
        events.touched = false;
        me.multiFeedback = false;
        events.clickable.length = 0;
        me.clearTabbables();
        me.loadQuestion(); // me.transitions.fade(me.loadQuestion);
    };
    OU.activity.Quiz.prototype.nextQuestion = function ( me ) {
        var events = me.imageLayer.events,
        q = me.data.round[me.roundNum].question;
        events.pressed = false;
        events.touched = false;
        me.multiFeedback = false;
        events.clickable.length = 0;
        me.clearTabbables();
        me.staticClicked = [];
        me.answer = null;
        me.clearTabbables();
        if (me.questionNum < q.length - 1) {
            me.questionNum++;
            if (me.randomise)
                me.randomiseQuestion();
            me.loadQuestion();
        }
        else {
            me.roundSummary();
        }
    };
    OU.activity.Quiz.prototype.prevQuestion = function () {
    };
    OU.activity.Quiz.prototype.accessibleView = function () {
        var h = "<div id='quizFallback'>";
        if (this.data.description!==undefined) {
            h += '<h1>Quiz activity</h1>';
            h += '<p>' + this.data.description + '</p>';
        }
        else {
            OU._quiz_totalRoundScore = [];
            OU._quiz_totalAvailRoundScore = [];
            OU._quiz_totalQuizScore = 0;
            OU._quiz_totalAvailQuizScore = 0;
            var roundIdx, qIdx, aIdx,
            questionNum = 1;
            for (roundIdx = 0; roundIdx < this.data.round.length; roundIdx++) {
                OU._quiz_totalAvailRoundScore[roundIdx] = 0;
                OU._quiz_totalRoundScore[roundIdx] = 0;
                var round = this.data.round[roundIdx];
                if (round.title!==undefined) h += '<h1>' + round.title + '</h1>';
                else h += '<h1>Round ' + (roundIdx + 1) + '</h1>';
                for (qIdx = 0; qIdx < round.question.length; qIdx++) {
                    var question = round.question[qIdx];
                    h += '<h2>' + question.q + '</h2><ul id="opts' + roundIdx + '-' + qIdx + '">';
                    var maxQuestionScore = 0;
                    round.question[qIdx].a.sort(function () {
                        return (Math.round(Math.random()) - 0.5);
                    });
                    for (aIdx = 0; aIdx < round.question[qIdx].a.length; aIdx++) {
                        var option = round.question[qIdx].a[aIdx];
                        h += "<li id='opt" + roundIdx + '-' + qIdx + '-' + aIdx + '\'><a href="javascript:OU.obj[\'' + instance + '\'].accessAnswer(' + roundIdx + ',' + qIdx + ',' + aIdx + ')">' + option.option + "</a></li>";
                        if (option.points > maxQuestionScore) maxQuestionScore = option.points;
                    }
                    h += '</ul>';
                    questionNum++;
                    OU._quiz_totalAvailRoundScore[roundIdx] += maxQuestionScore;
                    OU._quiz_totalAvailQuizScore += maxQuestionScore;
                }
                h += '<div id="totalRoundScore' + roundIdx + '" class="Scores"></div>';
            }
            h += '<div id="totalQuizScore" class="Scores"></div>';
        }
        h += '</div>';
        document.body.innerHTML = '';
        var accessible = document.createElement('div');
        accessible.innerHTML = h;
        document.body.appendChild(accessible);
    };
    OU.activity.Quiz.prototype.accessAnswer = function ( r, q, a ) {
        var option = this.data.round[r].question[q].a[a];
        OU._quiz_totalRoundScore[r] += option.points;
        OU._quiz_totalQuizScore += option.points;
        var feedback = '';
        var tDiv;
        // empty all options
        for (var i = 0; i < this.data.round[r].question[q].a.length; i++) {
            tDiv = document.getElementById('opt' + r + '-' + q + '-' + i);
            tDiv.innerHTML = '';
        }
        // insert feedback in the same place as their answer, so that voiceOver/pageReader reads it OU.
        tDiv = document.getElementById('opt' + r + '-' + q + '-' + a);
        tDiv.innerHTML = feedback + option.feedback;
        if (this.data.hideScores===undefined) {
            tDiv = document.getElementById('totalRoundScore' + r);
            tDiv.innerHTML = 'Round Score: ' + OU._quiz_totalRoundScore[r] + ' of ' + OU._quiz_totalAvailRoundScore[r];
            tDiv = document.getElementById('totalQuizScore');
            tDiv.innerHTML = 'Total Quiz Score: ' + OU._quiz_totalQuizScore + ' of ' + OU._quiz_totalAvailQuizScore;
        }
    };
    OU.activity.Quiz.prototype.imageCheck = function () {
        var i, j, rs = this.data.round, r, q;
        this.hasImages = false;
        for (i = rs.length; i--;) {
            r = rs[i];
            for (j = r.question.length; j--;) {
                q = r.question[j];
                if (q.img!=undefined && q.img!="") {
                    this.hasImages = true;
                    return;
                }
            }
        }
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.Quiz, OU.util.Activity);

