/**
 * ElectronE - Displays a timeline / electron energy levels
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 * @author Will Rawes
 */

OU.require('OU.util.Button');
OU.require('OU.util.Layer');
/** 
 * @class
 * @extends OU.util.Activity
 */
OU.activity.ElectronE = function(data, instance,controller){

    OU.activity.ElectronE.prototype.canvasView = function(){
        if(!this.data.energies)return;
        if(!OU.obj)OU.obj=[];
        OU.obj[this.instance]=this;
        
        var self = this, act;
        this.eLayer = new OU.util.Layer({
            container: this, 
            hasEvents: true, 
            zIndex: OU.OVERLAY_CONTROLLER_LEVEL
        });

        this.divBackground="#fcfcfc";
        this.bBack={
            col:'#444',
            radius:3,
            borderCol:'#888'
        };
        
        this.eLayer.events.clickable.push(this);
        this.click = false;
        this.evState = false;
        this.zinp = false;
        this.zotp = false;
        this.offs = this.h - 70;
        this.initTimeline();
        this.firstLevel=-1;
        this.secondLevel=-1;
        this.ipi = 1;
        this.zInB = new OU.util.Button({
            txt: "+", 
            padding:0,
            verticalPadding:0,
            layer: self.eLayer, 
            background:this.bBack,
            onClick: function(){
                self.zinp = true;
                if (self.scale > 10) return;
                self.scale *= 1.1;
                self.render();
            }
        });
        this.zOutB = new OU.util.Button(            {
            txt: "–", 
            padding:0,
            verticalPadding:0,
            layer: self.eLayer, 
            background:this.bBack,
            onClick: function(){
                self.zotp = true;
                if (self.point(self.data.min) < self.h*0.8) return;
                self.scale *= 1 / 1.1;
                self.render();
            }
        });
            
        act = this.instance;
        this.pageNum=act.substring(4,act.indexOf("_",4));
        this.cloudP = OU.obj["_act"+this.pageNum+"_3"];
        if(this.pageNum!=="1")this.cloudPH = OU.obj["_act1_3"];
        this.extraH=(this.instance.indexOf("_5")>0);
        this.extraB = new OU.util.Button({
            txt: (self.extraH ? "Hide H": "Show H"), 
            padding:0,
            verticalPadding:0,
            layer: self.eLayer, 
            background:this.bBack,
            onClick: function(){
                if(!self.rExtraB)return;
                if (self.extraH){
                    OU.obj["_act1_2"].hide();
                    OU.obj["_act"+self.pageNum+"_3"].moveEP(false);
                }else{
                    OU.obj["_act1_2"].show();
                    OU.obj["_act"+self.pageNum+"_3"].moveEP(true);
                }
            }
        });
            
        this.rExtraB=false;
        OU.obj["_act1_2"]=OU.obj["_act"+this.pageNum+"_"+(this.pageNum<9?"2":"5")];
        if(this.pageNum!=="1" && this.pageNum>8){
            this.rExtraB=true;
            OU.obj["_act1_2"].rExtraB=true;
            OU.obj["_act1_2"].render();
        }
        if(this.pageNum!=="1")OU.obj["_act1_2"].hide();

        this.resize();
    };
    OU.activity.ElectronE.prototype.hide = function(){
        this.visible=false;
        this.eLayer.events.pressed = false;
        this.click = false;
        this.eLayer.resize({
            x: -400
        });
        this.render();
    };
    OU.activity.ElectronE.prototype.show = function(){
        this.visible=true;
        this.click = false;
        if (OU.obj["_act1_3"]) OU.obj["_act1_3"].hide();
        if (OU.obj["_act1_1"]) OU.obj["_act1_1"].hide();
        this.eLayer.resize({
            x: this.w*1.1
        });
        this.render();
    };
    OU.activity.ElectronE.prototype.resize = function(){
        if(!this.eLayer)return;
        var bs,by;
        OU.activity.ElectronE.superClass_.resize.call(this);
        this.eLayer.resize();
        bs=this.w/4;
        by=this.h-bs-4;
        if (OU.obj["_act1_2"] && this.rExtraB) OU.obj["_act1_2"].hide();
        this.offs = this.h - 70; 
        bs*=1.1;
        this.zInB.resize({
            x:bs*0.2,
            y:by-bs*0.95,
            w:bs*1.3,
            h:bs
        });
        this.zOutB.resize({
            x:bs*1.6,
            y:by-bs*0.95,
            w:bs*1.3,
            h:bs
        });
        bs/=1.1;
        this.extraB.resize({
            x:0.01,
            y:by,
            w:bs*4,
            h:bs
        });
        this.render();
    };
    OU.activity.ElectronE.prototype.initTimeline = function(){
        var i, d = this.data, ctx = this.eLayer.context;
        this.fontSize = this.data.fontSize || 12;
        ctx.font = 'bold ' + this.fontSize + 'px helvetica,ariel,sans';
        ctx.textAlign = 'left';
        this.scale = 4;
        d.energies.sort(function(a, b){
            return a.E - b.E;
        });
        this.energies =[];
        for (i = d.energies.length;i--;) this.energies[i] = {
            E: d.EMult * d.energies[i].E, 
            n: d.energies[i].n
        };
        this.eLayer.resize();
    };
    OU.activity.ElectronE.prototype.checkZoom = function(){
        var self=this;
        if (this.zinp === true) this.zInB.onClick();
        if (this.zotp === true) this.zOutB.onClick();
        if (this.evState) setTimeout(function(){
            self.checkZoom();
        }, 100);
    };
    OU.activity.ElectronE.prototype.point = function(v){
        var r = this.data.max - this.data.min, vf = 1 / (r) * (this.h - 90) * this.scale;
        return this.h - this.offs - v * vf;
    };
    OU.activity.ElectronE.prototype.render = function(){
        var i, evs = this.energies, ev, ctx = this.eLayer.context
        , y = this.y, y0, ye, y2, v, dv, dv0
        ,dvs =[0.02, 0.05, 0.1, 0.2, 0.5, 1, 2, 5, 10, 50], p1, p2
        ,chg
        , fs=''+(this.w/19)|0
        ,w = this.w-fs*6
        , x0 = fs*5, x2
        ;
        if(w<30)w=30;
        this.eLayer.clear();
        ctx.fillStyle=this.divBackground;
        ctx.fillRect(0,0,this.eLayer.w,this.eLayer.h);
        ctx.strokeStyle='#ddd';
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(0,this.eLayer.h);
        ctx.lineTo(this.eLayer.w,this.eLayer.h);
        ctx.lineTo(this.eLayer.w,0);
        ctx.lineTo(0,0);
        ctx.stroke();
        
        y0 = this.point(this.data.min);
        ye = this.point(this.data.max);
        ctx.fillStyle = this.data.timelineColour;
        ctx.fillRect(x0, y0, w-fs*2, ye - y0);
        ctx.beginPath();
        ctx.lineWidth = 1;
        ctx.fill();
        ctx.stroke();
        ctx.beginPath();
        ctx.fillStyle = '#000';
        ctx.strokeStyle = '#000';
        ctx.stroke();
        ctx.fillStyle = '#000';
        ctx.lineWidth = 1;
        ctx.textAlign = 'right';
        ctx.font = fs+'pt Arial';
        ctx.beginPath();
        ctx.moveTo(x0, 0);
        ctx.lineTo(x0, this.h);
        dv = 0;
        for (i = 0;i < dvs.length;i++){
            if (dv < fs*4){
                dv = this.point( - dvs[i]) - this.point(0);
                dv0 = dvs[i];
            }
        }
        for (v = this.data.min;v <= this.data.max;v += dv0){
            y = this.point(v);
            ctx.moveTo(x0, y);
            ctx.lineTo(x0 - 5, y);
            ctx.fillText("" + ((v * 100 - 0.5) | 0) / 100, x0 - 6, y);
        }
        ctx.stroke();
        ctx.beginPath();
        for (i = evs.length;i--;){
            ev = evs[i];
            y = this.point(ev.E);
            ctx.beginPath();
            ctx.moveTo(x0, y);
            ctx.lineTo(x0 + w - 12, y);
            ctx.stroke();
            ctx.fillText("" + ev.n, x0 + w - 2, y);
            p1 = (i === this.firstLevel && this.ipi === 0);
            p2 = (i === this.secondLevel && this.ipi === 1);
            if (p1 || p2){
                ctx.beginPath();
                ctx.fillStyle = '#55f';
                ctx.arc(fs*8, y, fs/1.5, 0, Math.PI * 2, false);
                ctx.fill();
                ctx.stroke();
                ctx.fillStyle = '#000';
            }
            if (p2 && this.firstLevel >= 0)                {
                ctx.beginPath();
                x2=fs*6;
                y2 = this.point(evs[this.firstLevel].E);
                ctx.moveTo(x2, y2);
                ctx.lineTo(x2, y);
                ctx.lineTo(x2+fs/1.4, y + 1*(y2 > y ? fs: -fs));
                ctx.lineTo(x2, y);
                ctx.lineTo(x2-fs/1.4, y + 1*(y2 > y ? fs: -fs));
                ctx.stroke();
            }
        }
        ctx.stroke();
        ctx.beginPath();
        ctx.fillStyle=this.divBackground;
        ctx.fillRect(0, 0, this.w, 28);
        var yo=this.h-2.2*this.w/4.4-33;
        ctx.fillRect(0, yo-fs*1.5, this.w, yo+fs*1.5);
        ctx.beginPath();
        ctx.fillStyle = '#000';
        ctx.strokeStyle = '#000';
        ctx.moveTo(x0,41);
        ctx.lineTo(x0,21);
        ctx.lineTo(x0+4,28);
        ctx.moveTo(x0,21);
        ctx.lineTo(x0-4,28);
        ctx.textAlign = 'left';
        ctx.font = 'normal '+fs+'pt Arial';
        ctx.fillText("       / eV", x0, 11);
        ctx.font = 'italic '+fs+'pt Arial';
        ctx.fillText("E", x0, 11);
        ctx.fillText("   n", x0, 14);
        ctx.stroke();
        ctx.beginPath();
        ctx.font = 'normal '+fs+'pt Arial';
        ctx.fillStyle = '#c00';
        if (this.ipi === 1 && this.secondLevel >= 0){
            ctx.fillText("Change = ", x0 + 5, yo-fs/3);
            chg=(evs[this.secondLevel].E - evs[this.firstLevel].E);
            ctx.fillText("" + ((chg * 100 + (chg<0?-0.5:0.5)) | 0) / 100 + " eV", x0+5, yo+fs*1.55);
        }
        else if (this.firstLevel >= 0){
            ctx.fillText("Energy = ", x0 + 5, yo-fs/3);
            ctx.fillText("" + (((evs[this.firstLevel].E) * 100 + (evs[this.firstLevel].E<0?-0.5:0.5)) | 0) / 100 + " eV", x0 + 5, yo+fs*1.55);
        }
        ctx.strokeStyle='#ddd';
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(0,this.eLayer.h-1);
        ctx.lineTo(this.eLayer.w-1,this.eLayer.h-1);
        ctx.lineTo(this.eLayer.w-1,0);
        ctx.lineTo(0,0);
        ctx.stroke();
        
        ctx.restore();
        this.zInB.render();
        this.zOutB.render();
        if(this.rExtraB)this.extraB.render();
        this.doRender = false;
    };
    OU.activity.ElectronE.prototype.isHit = function(x, y, evState){
        var dY, i, evs = this.energies;
        if ( ! this.click){
            if (evState) this.click = this.eLayer.events.pressed;
        }
        if (evState === true && ! this.evState){
            this.evState = true;
            this.checkZoom();
        }
        if (evState === false){
            this.evState = false;
            this.zinp = false;
            this.zotp = false;
        }
        if(!this.cloudP)this.cloudP=OU.obj["_act"+this.pageNum+"_3"];
        if ( ! this.inDrag && evState){
            for (i = evs.length;i--;){
                if (Math.abs(y - this.point(evs[i].E)) < this.eLayer.w/18){
                    this.ipi = (this.ipi + 1) % 2;
                    if (this.ipi) this.secondLevel = i;
                    else this.firstLevel = i;
                    this.inDrag = false;
                    this.render();
                    this.cloudP.n = i;
                    this.cloudP.render();
                    if(this.cloudPH){
                        this.cloudPH.n = i;
                        this.cloudPH.render();
                    }
                    return;
                }
            }
        }
        if (evState && y > 20){
            if (this.inDrag){
                dY = y - this.dragStartY;
                if (dY > 0 && (this.point(this.data.min) < this.h - 50 || this.point(this.data.max) < 70)) this.offs -= 
                    dY;
                else if (dY < 0 && (this.point(this.data.min) > this.h - 50 || this.point(this.data.max) > 70)) this.offs -= 
                    dY;
                this.dragStartY = y;
                this.render();
            }
            else {
                this.dragStartY = y;
                this.inDrag = true;
            }
        }
        else {
            this.inDrag = false;
        }
    };
    OU.base(this,data,instance,controller);
};
OU.inherits(OU.activity.ElectronE,OU.util.Activity);
