/**
 * @fileOverview MenuController - load and traverse multiple activities using Menus
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */
OU.require('OU.util.Controller');
OU.require('OU.util.Menu');

/** 
 * @class
 * @extends OU.util.Controller
 */
OU.activity.MenuController = function(MenuControllerData,instance,controller) {

    OU.activity.MenuController.prototype.canvasView = function() {
        OU.activity.MenuController.superClass_.canvasView.call(this); // call the parent class canvasView
        var bH=OU.controlHeight;

        if (this.data.menus) {
            this.newMenus = new OU.util.Menu({
                container: {
                    controller:this,
                    instance:this.instance,
                    x:this.x,
                    y:this.y,
                    w:this.w,
                    h:this.h
                }, 
                menus:this.data.menus,
                dontRegister:this.baseController,
                x: this.x,
                y: this.y+this.headerHeight,
                w:this.w,
                h:this.data.menus.levels * bH,
                zIndex:this.zOffset + 100
            });
            this.menuHeight = this.newMenus.h;
        }
    };
    OU.activity.MenuController.prototype.header = function(h) {
        OU.activity.MenuController.superClass_.header.call(this,h); // call the parent class resize
        if(this.newMenus) {
            this.newMenus.resize({
                x:this.x,
                y:this.y+this.headerHeight,
                w:this.w,
                h:this.h-this.headerHeight
            });
        }
    this.resize();
    };
    OU.activity.MenuController.prototype.resize = function() {
        OU.activity.MenuController.superClass_.resize.call(this); // call the parent class resize 
        if (this.newMenus)
            this.newMenus.resize({
                x:this.x,
                y:this.y+this.headerHeight,
                w:this.w,
                h:this.h-this.headerHeight                
            }); 
    };
    OU.activity.MenuController.prototype.remove = function() {
        OU.activity.MenuController.superClass_.remove.call(this); // call the parent class resize 
        if (this.newMenus)
            this.newMenus.menuDiv.remove(); 
    };

    OU.base(this,MenuControllerData,instance,controller);
};

if(OU.util.Controller) {
    OU.inherits(OU.activity.MenuController, OU.util.Controller);
}
else {
    OU.preOnLoad.push(function () {
        OU.inherits(OU.activity.MenuController, OU.util.Controller);
    });
}