/**
 * Created with JetBrains WebStorm.
 * User: martin
 * Date: 28/05/2012
 * Time: 16:17
 * To change this template use File | Settings | File Templates.
 */
/**
 * @fileOverview Menu - Loads a Menu object
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

OU.require('OU.util.Layer');
OU.require('OU.util.TiledMenu');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.TiledMenu = function ( data, instance, controller ) {
    OU.activity.TiledMenu.prototype.canvasView = function () {
        OU.activity.TiledMenu.superClass_.canvasView.call(this); // call the parent class canvasView
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw background on backdrop layer
        this.menus = new OU.util.TiledMenu({
            container:this,
            menus:this.data,
            showHighlight:this.data.showHighlight,
            x:this.x,
            y:this.y,
            w:this.w,
            h:this.h
        });
    };
    OU.activity.TiledMenu.prototype.resize = function () {
        OU.activity.TiledMenu.superClass_.resize.call(this); // call the parent class resize
        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        console.log('tiledmenu resize');
        this.menus.resize({
            x:this.x,
            y:this.y,
            w:this.w,
            h:this.h
        });
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.TiledMenu, OU.util.Activity);
