/**
 * @fileOverview Video - Simple video activity
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

OU.require('OU.util.Instruction');
OU.require('OU.util.Div');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.Video = function ( data, instance, controller ) {
    OU.activity.Video.prototype.canvasView = function () {
        var i, v = this.data.video, vY,
        videoElement;
        v._w=v.width *OU.dpr;
        v._h=v.height *OU.dpr;
        if (this.data.html && this.data.html!='') {
            this.htmlDiv = new OU.util.Div({
                container:this
            });
            this.htmlDiv.div.innerHTML = this.data.html;
        }
        if (this.htmlDiv)
            vY = this.y + this.htmlDiv.div.clientHeight + 10;
        else
            vY = this.y + (this.h - v._h) / 2;
        
        this.videoDiv = new OU.util.Div({
            x:this.x + (this.w - v._w) / 2,
            y:vY,
            w:v._w,
            h:v._h,
            container:this
        });
        videoElement = document.createElement("video");
        videoElement.id = "_vid_" + this.instance;
        videoElement.width = v._w;
        videoElement.height = v._h;
        videoElement.controls = "controls";
        videoElement.autoplay = "autoplay";
        if (v.thumbnail!==undefined && v.thumbnail!="")
            videoElement.poster = v.thumbnail;
        for (i = v.sources.length; i--;) {
            var source = document.createElement('source');
            //  if(videoElement.canPlayType(v.sources[i].type)) {
            source.type = v.sources[i].type;
            source.src = this.dataDir + v.sources[i].src;
            videoElement.appendChild(source);
        //}
        }
        videoElement.load();
        this.videoDiv.div.appendChild(videoElement);
        this.video = videoElement;
        this.video.play();
        this.resize();
    };
    OU.activity.Video.prototype.resize = function () {
        OU.activity.Video.superClass_.resize.call(this); // call the parent class resize
        var video = document.getElementById("_vid_" + this.instance),
        v = this.data.video, vY,
        vW=v._w,
        vH=v._h;
        if (this.htmlDiv)
            this.htmlDiv.resize({
                x:this.x + 10,
                y:this.y + 10,
                w:this.w - 20,
                h:'auto'
            });

        if (v._w > this.w) {
            vH = v._h * (this.w / v._w);
            vW = this.w;
        }
        if (v._h > this.h) {
            vW = v._w * (this.h / v._h);
            vH = this.h;
        }
        if (this.htmlDiv)
            vY = this.y + this.htmlDiv.div.clientHeight + 10;
        else
            vY = this.y + (this.h - vH) / 2;
        this.videoDiv.resize({
            x:this.x + (this.w - vW) / 2,
            y:vY,
            w:vW,
            h:vH
        });
        if (video!=null) {
            video.setAttribute("width", vW);
            video.setAttribute("height", vH);
        }
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.Video, OU.util.Activity);
