/**
 * VTelescope
 *
 * @author Will Rawes
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Button');
OU.require('OU.util.Messagebox');
OU.activity.VTelescope = function ( data, instance, controller ) {
    OU.loadCSS("style.css");
    OU.obj[instance] = this;
    OU.activity.VTelescope.prototype.canvasView = function () {
        var self = this;
        this.pageNum = 0;
        var i, j, v;
        this.layer = new OU.util.Layer({
            container:this,
            hasEvents:true
        });
        this.layer.resize();
        this.bBack = {
            col:'#dddddd',
            radius:3,
            borderCol:'#888'
        };
        this.tBack = {
            col:'transparent',
            radius:3,
            borderCol:'#888'
        };
        this.galLs = false;
        this.spec = false;
        this.phot = false;
        this.qNum = 1;
        this.numTries = 0;
        this.setHeader = function ( h ) {
            self.header({
                h1:h.h1,
                h2:h.h2 + '<p style="position:relative;text-align:right;top:-32px;"> <a class="infoButton" style="text-decoration:none;" href="#" onclick="javascript:OU.obj[\'_act0_0\'].help();" >&#160;&#160;&#160;</a>&#160;&#160;&#160;&#160;&#160;</p>'
            });
        };
        this.setHeader({h1:"Virtual telescope", h2:"All sky map"});
        this.help = function ( b ) {
            if (b===false) {
                self.helpDiv.visible = false;
            }
            else {
                self.helpDiv.visible = true;
                var p = self.audio.src.indexOf("VTAF")
                    , p2 = self.audio.src.indexOf(".", p)
                    , s = self.audio.src.substring(p, p2)
                    , p3 = self.data.script.indexOf(s.toLowerCase())
                    , p4 = self.data.script.indexOf("[vtaf", p3 + 4)
                    , p5 = self.data.script.indexOf("]", p3) + 1
                    , s = self.data.script.substring(p5, p4);
                s = s.replace(/\./g, ".<br/><br/>").replace(/<br\/><br\/> /g, " ")
                    .replace(/Click/g, "Press").replace(/click/g, "press");
                self.helpDiv.div.innerHTML = s + "<br/><br/><p style='text-align:right;'><a style='text-decoration:none;' href='#' onclick='OU.obj[\"_act0_0\"].help(false);'>OK</a>&#160;<br/></p>";
                self.helpDiv.div.style.display = 'block';
            }
            self.resize();
        };
        // Functions from S104 Virtual telescope .as files (dated after 10/2007)
        // in smoot archive \S104\2009\DVD00635\Sources\virtualTelescope\source\learningobject\classes
        this.noiseLevel = function ( i, j ) {
            j--;
            var clusterFluxFactor = 1;
            var fluxBand;
            if ((i==0) || (i==1)) clusterFluxFactor = 5;
            if ((i==2) || (i==3)) clusterFluxFactor = 2;
            switch(self.data.fluxOrder[i][j]) {
                case 1:
                    fluxBand = 5;
                    break;
                case 2:
                case 3:
                case 4:
                case 5:
                    fluxBand = 4;
                    break;
                case 6:
                case 7:
                case 8:
                case 9:
                case 10:
                case 11:
                case 12:
                case 13:
                case 14:
                    fluxBand = 2;
                    break;
                case 15:
                case 16:
                case 17:
                case 18:
                case 19:
                case 20:
                    fluxBand = 1;
                    break;
            }
            fluxBand = fluxBand * clusterFluxFactor;
            return 0.1 / fluxBand;
        };
        this.numberString = function ( number ) {
            number = parseFloat(number);
            if (isNaN(number))return " ";
            if (number==0)return "0";
            var minus = "";
            if (number < 0) {
                number = -number;
                minus = "-";
            }
            var logN = Math.log(number) / Math.LN10;
            var power = Math.floor(logN);
            var number0 = Math.pow(10, logN - power);
            var powerString = String(power);
            return minus + this.decPlace(number0, 1) + "×10<sup>" + powerString + "</sup>";
        };
        this.decPlace = function ( x, dp ) {
            if (x==0)return "0";
            var p = Math.pow(10, dp);
            var numberS = "" + Math.floor(x * p + 0.5) / p;
            var nZeros = 0;
            var nPoint = numberS.indexOf(".");
            if (nPoint < 0) {
                numberS += ".";
                nZeros = dp;
            } else if (numberS.length - 1 - nPoint < dp) {
                nZeros = dp - (numberS.length - 1 - nPoint);
            }
            for (var i = 0; i < nZeros; i++)numberS += "0";
            return numberS;
        };
        this.rand = new Array(new Array(600), new Array(600), new Array(600), new Array(600));
        for (var i = 0; i < 4; i++) {
            for (var j = 600; j--;) {
                this.rand[i][j] = (Math.random() * 0.8 * (j / 600.) + 0.2) * 2 - 1;
                if (Math.random() < 0.1)this.rand[i][j] += Math.random();
            }
        }
        this.rand2 = new Array(new Array(200), new Array(200), new Array(200), new Array(200));
        for (var i = 0; i < 4; i++) {
            for (var j = 200; j--;) {
                if (Math.random() < 0.2)this.rand2[i][j] = Math.random() * 20;
                else this.rand2[i][j] = 0;
            }
        }
        this.xpt = function ( v ) {
            return (v * 0.0013 + 0.07) * self.scale;
        };
        this.ypt = function ( v ) {
            return (v * 0.0011 + 0.05) * self.scale;
        };
        this.moveTo = function ( x, y ) {
            self.ctx.moveTo(self.xpt(x), self.ypt(y));
        };
        this.lineTo = function ( x, y ) {
            self.ctx.lineTo(self.xpt(x), self.ypt(y));
        };
        this.drawSpec = function ( ref ) {
            var i, i1, xi, y, refCoords = [], lambda, lambda0;
            if (ref) {
                self.moveTo(0, 320 - 70 - self.data.refSpec[1] * 2);
                for (i = 0; i < 600; i++) {
                    xi = (i) * 2 + 1;
                    y = self.data.refSpec[xi] * 2;
                    self.lineTo(0 + i * .5, 320 - 70 - y);
                    refCoords[i] = 70 + y;
                }
            }
            else {
                self.moveTo(0, 320 - 0);
                for (i = 0; i < 600; i++) {
                    lambda = 350 + i * 0.5;
                    lambda0 = lambda / (self.data.clusterRedshift[self.clusterId] + 1);
                    i1 = Math.floor(2 * (lambda0 - 350));
                    if (i1 >= 0 && i1 < 600) {
                        xi = (i1) * 2 + 1;
                        y = self.data.refSpec[xi] * 2
                            + self.rand[self.galId % 4][i] * 500 * self.noiseLevel(self.clusterId, self.galId);
                    }
                    else {
                        y = self.rand[self.galId % 4][i] * 500 * self.noiseLevel(self.clusterId, self.galId);
                        y += self.rand2[self.galId % 4][i + self.clusterId * 4];
                    }
                    if (y < 0)y = 0;
                    self.lineTo(0 + i * .5, 320 - y);
                }
            }
        };
        this.setStyles = function ( os ) {
            os.borderStyle = 'solid';
            os.borderColor = '#aaa';
            os.borderWidth = '1px';
            os.background = '#fcfcfc';
            os.display = "none";
        };
        this.getNum = function ( a, id ) {
            var ds = ("" + a).split(",");
            var r = null;
            for (i = ds.length; i--;) {
                if (ds[i].indexOf("" + id + ":") >= 0) {
                    r = ds[i].substring(ds[i].indexOf(":") + 1);
                }
            }
            return r;
        };
        this.xpt2 = function ( v, xf, x0 ) {
            return (v * xf + x0) * self.scale;
        };
        this.ypt2 = function ( v, yf, y0 ) {
            return (0.5 - (v - y0) * yf) * self.scale;
        };
        this.calcTics = function ( mn, mx ) {
            ///  ticInterval calculation thanks to M.A.Brown
            var dif = mx - mn, n = Math.floor(Math.log(dif) / Math.log(10.0)),
                a = dif * Math.pow(10.0, -n), ticInterval, dt = 5;
            if (a < 2.0) {
                ticInterval = 0.2;
                dt = 2;
            } else if (a < 5.0) ticInterval = 0.5;
            else ticInterval = 1.0;
            ticInterval = ticInterval * Math.pow(10.0, n);
            return {
                interval:ticInterval,
                min:Math.floor(mn / ticInterval) * ticInterval,
                max:Math.ceil(mx / ticInterval) * ticInterval,
                subInterval:ticInterval / dt
            }
        };
        this.getResults = function () {
            var res = [];
            for (var i = 0; i < 8; i++) {
                var cn = self.data.cluster[i]
                    , vl = parseFloat(OU.LocalStorage.load("OUVTMeanVel" + i))
                    , ds = parseFloat(self.getNum(OU.LocalStorage.load("OUVTDistances"), i));
                if (!isNaN(vl) && !isNaN(ds))res.push({
                    c:cn,
                    v:vl,
                    d:ds
                });
            }
            var txt = "<br/><b>Final results table</b><br/>"
                    + "<table cellpadding='0'><tr style='background:#ddf;'>"
                    + "<td><b>Cluster</b></td><td><b>Speed / km s<sup>-1</sup></b></td><td><b>Distance / Mpc</b></td>"
                    + "</tr>"
                ;
            for (var i = 0; i < res.length; i++)txt += "<tr><td>" + res[i].c + "</td><td>" + self.numberString(res[i].v) + "</td><td>" + self.numberString(res[i].d) + "</td></tr>";
            txt += "</table>";
            OU.LocalStorage.save("OUVTFinalResults", txt);
            return res;
        };
        this.getPos = function ( x, y ) {
            if (x > 0.47 && !this.horiz && this.pageNum > 0 && this.pageNum < 4)
                return{
                    x:(x - 0.47) * self.scale,
                    y:(y + 0.5) * self.scale
                };
            else
                return {
                    x:(x) * self.scale,
                    y:(y) * self.scale
                };
        };
        this.graphB = new OU.util.HtmlBox({
            html:"",
            unclosable:true
        });
        this.graphB.div.style.display = 'none';
        this.setXP = function ( ev, aud ) {
            var xp = (((ev.touches ? ev.touches[0].clientX : ev.clientX) / self.scale/1.12 - .07) / 0.39 * 300) | 0;
            if (xp < 0)xp = 0;
            if (xp > 300)xp = 300;
            if (self.measure < 3) {
                if (self.measure===1) {
                    self.lGal = 350 + xp;
                    self.lGalS = "λ ≈ " + Math.floor(self.lGal) + " nm";
                    if (aud)self.setAudio("VTAF038");
                }
                if (self.measure===2) {
                    self.lRef = 350 + xp;
                    self.lRefS = "<br/><br/>reference: λ<sub>0</sub> ≈ "
                        + Math.floor(self.lRef) + " nm";
                    self.bis["Calculate"].params.disabled = false;
                    if (aud)self.setAudio("VTAF033");
                }
            }
            self.pageText
                = "<br/><br/>" + self.data.cluster[self.clusterId] + " "
                + (self.galId) + ": " + (self.lGal > 0 ? self.lGalS : "") + (self.lRef > 0 ? self.lRefS : "");
            self.render();
        };
        OU.nobbleDoneBar(this.graphB.div);
        //            this.graphB.div.ontouchstart
        //            =this.graphB.div.onmousedown
        var md = function ( ev ) {
            if (!self.bis["Reference spectrum"].params.disabled)return;
            self.measure++;
            self.setXP(ev, false);
        };
        this.tm = 0;
        //            this.graphB.div.ontouchmove
        var mm = function ( ev ) {
            if (!self.bis["Reference spectrum"].params.disabled)return;
            if (self.tm===1)self.setXP(ev, false);
            self.tm = (self.tm + 1) % 5;
        };
        //            this.graphB.div.ontouchend
        //            =this.graphB.div.onmouseup
        var mu = function ( ev ) {
            if (!self.bis["Reference spectrum"].params.disabled) {
                if (self.oldPage===self.pageNum)self.setAudio("VTAF037", true);
                self.oldPage = self.pageNum;
                return;
            }
            self.bis["Start again"].params.disabled = false;
            self.setXP(ev, true);
        };
        this.graphB.div.addEventListener("mousedown", md, false);
        this.graphB.div.addEventListener("touchstart", md, false);
        this.graphB.div.addEventListener("mousemove", mm, false);
        this.graphB.div.addEventListener("touchmove", mm, false);
        this.graphB.div.addEventListener("mouseup", mu, false);
        this.graphB.div.addEventListener("touchend", mu, false);
        this.htmlBox = new OU.util.HtmlBox({
            html:"",
            unclosable:true,
            handleScrolling:false,
            style:'overflow:visible'
        });
        this.setStyles(this.htmlBox.div.style);
        this.htmlBox.setSmall = function ( sm ) {
            self.htmlBox.small = sm;
            self.htmlBox.div.style.fontSize = '' + self.scale / (sm ? 85 : 60) + 'px';
        };
        this.htmlBox2 = new OU.util.HtmlBox({
            html:"",
            unclosable:true,
            handleScrolling:false,
            style:'overflow:visible'
        });
        this.setStyles(this.htmlBox2.div.style);
        this.calcV = function () {
            var i
                , c = 0, v = 0
                , vels = (OU.LocalStorage.load("OUVTVels" + self.clusterId) || "").split(",");
            for (i = vels.length; i--;) {
                var itm = document.getElementById("velCB" + i);
                if (itm) {
                    if (itm.checked===true) {
                        vels[i] = vels[i].replace("_N", "_Y");
                        v = v + self.velVals[i];
                        c++;
                    }
                    else vels[i] = vels[i].replace("_Y", "_N");
                }
            }
            OU.LocalStorage.save("OUVTVels" + self.clusterId, "" + vels);
            if (c > 0) {
                self.meanV = v / c;
                OU.LocalStorage.save("OUVTMeanVel" + self.clusterId, "" + self.meanV);
            }
            else self.meanV = null;
            document.getElementById("OUVTMeanS").innerHTML = (this.meanV ? this.numberString(this.meanV) + " km s<sup>-1</sup>" : " ... ");
        };
        this.images = [];
        this.bx = 0;
        this.setIm = function ( id, im, x, y, w, h ) {
            id = "imid" + id;
            self.images[id] = {};
            self.images[id].img = new Image();
            self.images[id].id = id;
            self.images[id].x = x || im.x;
            self.images[id].y = (y || im.y);
            self.images[id].w = w || im.w;
            self.images[id].h = h || im.h;
            self.images[id].img.src = im.src;
        };
        for (i = this.data.images.length; i--;)
            this.setIm(this.data.images[i].id, this.data.images[i]);
        this.buttons = [];
        this.bis = [];
        for (i = this.data.buttons.length; i--;) {
            this.buttons[i] = new OU.util.Button({
                txt:this.data.buttons[i].txt,
                verticalPadding:2,
                x:0.011,
                y:0.01,
                w:200,
                h:50,
                disabled:this.data.buttons[i].disabled,
                layer:this.layer,
                background:this.bBack,
                ii:i,
                //             renderStyle:0,
                onClick:this.data.buttons[i].action,
                onClickParam:this//self
            });
            //                this.buttons[i].keepPos=(this.data.buttons[i].txt=="Add to final results");
            ///            this.buttons[i].params.renderStyle=0;
            this.buttons[i].dontShow = false;
            this.bis[this.data.buttons[i].txt] = this.buttons[i];
            this.buttons[i].id = this.data.buttons[i].txt;
////            this.buttons[i].btn.id = this.data.buttons[i].txt;
            ///this.buttons[i].params.onClickParam=this.data.buttons[i];
            if (("" + this.buttons[i].params.onClick).indexOf("function setC")==0) {
                this.buttons[i]._x = this.data.buttons[i].x * 1.15;
                this.buttons[i]._y = this.data.buttons[i].y * 1.24;
            }
            else {
                this.buttons[i]._x = this.data.buttons[i].x;
                this.buttons[i]._y = this.data.buttons[i].y;
            }
            this.buttons[i].pageNum = this.data.buttons[i].pageNum;
        }
        this.labels = [];
        for (i = this.data.clusters.length; i--;)this.setIm(this.data.clusters[i].name, this.data.clusters[i].img
            , 0.03, 0.05, 0.38, 0.38);
        for (j = 20; j--;) {
            this.labels[j] = new OU.util.Button({
                txt:"",
                layer:self.layer,
                unclosable:true,
                verticalPadding:0,
                padding:0,
                handleScrolling:false,
                background:this.tBack,
                w:10,
                h:10,
                colour:"#f00",
                onClick:function ( th ) {
                    if (th.spec) {
                        th.galId = this.id;
                        th.pageText =
                            "<br/><br/>" + th.cImg + " " + (th.galId) + ":";
                        th.htmlBox.div.style.display = "block";
                        showCBs(true, th);
                        th.measure = 0;
                        th.lGal = -1;
                        th.lRef = -1;
                        th.z = -1;
                        th.v = -1;
                        th.drawRef = false;
                        th.bis["Reference spectrum"].params.disabled = false;
                        th.bis["Imager"].params.disabled = false;
                        th.bis["Start again"].params.disabled = true;
                        th.bis["Calculate"].params.disabled = true;
                        th.bis["Add to results"].params.disabled = true;
                        th.oldPage = th.pageNum;
                        th.pageNum = 2;
                        th.render();
                        th.setAudio("VTAF030");
                    }
                },
                onClickParam:self
            });
            this.labels[j].render = function () {
            };
        }
        this.messagebox = new OU.util.Messagebox({
            container:this.container,
            dims:{
                x:0.25,
                y:0.2,
                w:0.5,
                h:0.25
            }
        });
        //        this.messagebox.setVisible(false);
        this.helpDiv = new OU.util.HtmlBox({
            unclosable:true,
            handleScrolling:false,
            style:'overflow:auto;background:#fcfcfc;border:solid 2px #ddd;border-radius:6px;padding:14px;'
        });
        this.helpDiv.visible = false;
        this.audioDiv = new OU.util.Div({
            container:self
        });
        this.time = 0;
        this.played = [];
        var h = "<audio id='_aud' controls='controls' width='200px' height='30px'><source id='src1' src='' type='audio/mp3' />"
            + "<source id='src2' src='' type='audio/ogg' /></audio>";
        this.audioDiv.div.innerHTML = h;
        this.audio = document.getElementById('_aud');
        this.setAudio = function ( src, b ) {
            self.audio.pause();
            self.audio.setAttribute("src", "data/audio/" + src + (navigator.userAgent.indexOf("Firefox") >= 0 || navigator.userAgent.indexOf("Opera") >= 0 ? ".ogg" : ".mp3"));
            if (!self.played[src] || b) {
                self.played[src] = true;
                setTimeout(function () {
                    if (self.audio.currentTime)self.audio.currentTime = 0;
                    self.audio.play();
                }, 800);
            }
        };
        this.setAudio("VTAF003");//*/
        this.resize();
        for (i = 3; i--;)setTimeout(function () {
            self.render();
        }, 50 + i * 800);
    };
    OU.activity.VTelescope.prototype.resizeText = function () {
        var pos, itms = document.getElementsByTagName("i"), i;
        for (i = itms.length; i--;)if (itms[i].style)itms[i].style.fontSize = "100%";
        itms = document.getElementsByTagName("b");
        for (i = itms.length; i--;)if (itms[i].style)itms[i].style.fontSize = "100%";
        itms = document.getElementsByTagName("input");
        for (i = itms.length; i--;)if (itms[i].style)itms[i].style.fontSize = "100%";
        itms = document.getElementsByTagName("td");
        for (i = itms.length; i--;)if (itms[i].style)itms[i].style.fontSize = "100%";
        itms = document.getElementsByTagName("span");
        for (i = itms.length; i--;)if (itms[i].style) {
            itms[i].style.fontSize = "100%";
            itms[i].style.height = "2px";
            itms[i].style.padding = "0px";
        }
        this.htmlBox.div.style.fontSize = "80%";
        var yo = 3 * 20;
        if (this.htmlBox.div.style.display!='none') {
            this.htmlBox.setSmall(this.htmlBox.small);
            switch(this.pageNum) {
                case 1:
                case 2:
                    pos = this.getPos(0.55, 0.07);
                    this.htmlBox.resize({
                        x:pos.x + 20,
                        y:pos.y + yo,
                        w:this.scale * 0.34,
                        h:this.scale * 0.4 * 1.10
                    });
                    break;
                case 3:
                    pos = this.getPos(0.55, 0.07);
                    this.htmlBox.resize({
                        x:pos.x,
                        y:pos.y + yo,
                        w:this.scale * 0.34,
                        h:this.scale * 0.3100 * 1.10
                    });
                    break;
                case 4:
                    pos = this.getPos(0.05, 0.07);
                    this.htmlBox.resize({
                        x:pos.x,
                        y:pos.y + yo,
                        w:this.scale * 0.9,
                        h:this.scale * 0.48 * 1.0
                    });
                    break;
                case 5:
                    pos = this.getPos(0.07, 0.07);
                    this.htmlBox.resize({
                        x:pos.x,
                        y:pos.y + yo,
                        w:this.scale * 0.89,
                        h:this.scale * 0.034
                    });
                    break;
            }
        }
        if (this.htmlBox2.div.style.display!='none') {
            this.htmlBox2.div.style.fontSize = //"100%";//
                '' + this.scale / (60) + 'px';
            pos = this.getPos(0.02, 0.07);
            this.htmlBox2.resize({
                x:pos.x,
                y:pos.y + yo,
                w:this.scale * 0.39,
                h:this.scale * 0.4 * 1.10
            });
        }
        if (this.helpDiv.visible) {
            this.helpDiv.resize({
                x:this.w * 0.04,
                y:75, //this.h*0.13,
                w:this.w * 0.9,
                h:this.h * 0.9
            });
            this.helpDiv.div.style.fontSize = ((this.w / 59) | 0) + "px";
        }
        else this.helpDiv.div.style.display = "none";
    };
    OU.activity.VTelescope.prototype.resize = function () {
        OU.activity.VTelescope.superClass_.resize.call(this);
        this.layer.resize();
        this.horiz = (this.h < this.w);
        var tools = this.pageNum > 0 && this.pageNum < 4;
        if (this.horiz) {
            this.scale = this.w * 0.95;//*(tools?1.:0.95);
            if(this.h<this.w*0.45)this.scale=this.h/0.45;
        }
        else {
            this.scale = this.h * (tools ? 1 : 0.8);
        }
        this.layer.resize({
            y:this.y + 4,
            w:this.w * (this.horiz ? 1 : 1.4),
            h:this.h * 1.4
        });
        this.audioDiv.resize({
            x:0,
            y:(this.horiz ? this.h * 1.54 : this.h * 1),
            h:20,
            w:200,
            h:10
        });
        this.resizeText();
        this.graphB.resize({
            x:this.scale * 0.02,
            y:this.scale * 0.07 + 50,
            w:this.scale * 0.42,
            h:this.scale * 0.4
        });
        this.render();
        this.doRender = true;
    };
    OU.activity.VTelescope.prototype.point = function ( v, o ) {
        return 15 + v * this.scale - o;
    };
    OU.activity.VTelescope.prototype.drawIm = function ( ctx, i, s ) {
        var im = this.images["imid" + i];
        ctx.drawImage(im.img, s * im.x, s * im.y, s * im.w, s * im.h);
    };
    OU.activity.VTelescope.prototype.plotGraph = function ( ctx, xmn, xmx, ymn, ymx, yTics, xTics, line, pts ) {
        var i, j, xx, yy, val, xf, x0, yf, y0, gxn, gxx, gyn, gyx, fs = parseInt(this.scale * .014);
        xf = 0.7 / (xmx - xmn);
        yf = 0.35 / (ymx - ymn);
        x0 = 0.2;
        y0 = ymn;
        gxn = this.xpt2(xmn, xf, x0);
        gxx = this.xpt2(xmx, xf, x0);
        gyn = this.ypt2(ymn, yf, y0);
        gyx = this.ypt2(ymx, yf, y0);
        gxn = this.xpt2(xTics.min, xf, x0);
        gxx = this.xpt2(xTics.max, xf, x0);
        gyn = this.ypt2(yTics.min, yf, y0);
        gyx = this.ypt2(yTics.max, yf, y0);
        ctx.fillStyle = '#fff';
        ctx.strokeStyle = '#000';
        ctx.fillRect(gxn, gyn, gxx - gxn, gyx - gyn);
        ctx.fillStyle = "#000";
        ctx.font = fs + "pt " + OU.theme.font;
        ctx.textAlign = 'right';
        for (i = yTics.min; i <= yTics.max; i += yTics.interval) {
            yy = this.ypt2(i, yf, y0);
            ctx.beginPath();
            ctx.strokeStyle = "#000";
            ctx.moveTo(gxn - 3, yy);
            ctx.lineTo(gxn, yy);
            ctx.closePath();
            ctx.stroke();
            ctx.lineWidth = 0.7;
            ctx.strokeStyle = (i===0 ? "#000" : "#777");
            ctx.beginPath();
            ctx.moveTo(gxn, yy);
            ctx.lineTo(gxx, yy);
            ctx.closePath();
            ctx.stroke();
            val = ((i * 100) | 0) / 100;
            ctx.fillText(val, this.xpt2(xmn, xf, x0) - 6, yy + 2);
            if (i < yTics.max) {
                for (j = i + yTics.subInterval; j < i + yTics.interval; j += yTics.subInterval) {
                    yy = this.ypt2(j, yf, y0);
                    ctx.strokeStyle = "#aaa";
                    ctx.lineWidth = 0.3;
                    ctx.beginPath();
                    ctx.moveTo(gxn, yy);
                    ctx.lineTo(gxx, yy);
                    ctx.closePath();
                    ctx.stroke();
                }
            }
        }
        ctx.textAlign = 'center';
        for (i = xTics.min; i <= xTics.max; i += xTics.interval) {
            xx = this.xpt2(i, xf, x0);
            ctx.beginPath();
            ctx.strokeStyle = "#000";
            ctx.moveTo(xx, gyn);
            ctx.lineTo(xx, gyn + 3);
            ctx.closePath();
            ctx.stroke();
            ctx.lineWidth = 0.7;
            ctx.strokeStyle = (i===0 ? "#000" : "#777");
            ctx.beginPath();
            ctx.moveTo(xx, gyn);
            ctx.lineTo(xx, gyx);
            ctx.closePath();
            ctx.stroke();
            val = i;
            ctx.fillStyle = "#000";
            ctx.fillText(val, xx, gyn + fs * 1.3);
            if (i < xTics.max) {
                for (j = i + xTics.subInterval; j < i + xTics.interval; j += xTics.subInterval) {
                    xx = this.xpt2(j, xf, x0);
                    ctx.lineWidth = 0.3;
                    ctx.strokeStyle = "#aaa";
                    ctx.beginPath();
                    ctx.moveTo(xx, gyn);
                    ctx.lineTo(xx, gyx);
                    ctx.closePath();
                    ctx.stroke();
                }
            }
        }
        ctx.fillText("distance / Mpc", (gxn + gxx) / 2, gyn + fs * 3.5);
        ctx.textAlign = 'right';
        ctx.fillText("speed /  ", (gxn - fs * 7), (gyn + gyx) / 2);
        ctx.fillText("km s    ", (gxn - fs * 7), (gyn + gyx) / 2 + fs * 1.8);
        ctx.fillText("-1", (gxn - fs * 7), (gyn + gyx) / 2 + fs * 1.4);
        ctx.strokeStyle = '#f00';
        ctx.beginPath();
        ctx.moveTo(this.xpt2(line[0][0], xf, x0), this.ypt2(line[0][1], yf, y0));
        ctx.lineTo(this.xpt2(line[1][0], xf, x0), this.ypt2(line[1][1], yf, y0));
        ctx.closePath();
        ctx.stroke();
        ctx.fillStyle = '#000';
        for (i = pts.length; i--;)ctx.fillRect(this.xpt2(pts[i][0], xf, x0), this.ypt2(pts[i][1], yf, y0), 3, 3);
    };
    OU.activity.VTelescope.prototype.render = function () {
        this.ctx = this.layer.context;
        var ctx = this.ctx, i, j, k, s = this.scale, bpn
            , yInterval, pos
            , fr = OU.LocalStorage.load("OUVTFinalResults")
            ;
        ctx.font = 'bold ' + ((s / 65) | 0) + 'px ' + OU.theme.font;
        ctx.textAlign = 'left';
        this.layer.clear();
        this.graphB.div.style.display = 'none';
        this.htmlBox2.div.style.display = "none";
        this.bis["Final results"].dontShow = (fr ? (fr.indexOf("×10") < 0) : true);
        switch(this.pageNum) {
            case 0:
                this.htmlBox.div.style.display = "none";
                this.drawIm(ctx, "sky", this.scale * 1.15);
                break;
            case 1:
                this.htmlBox.div.innerHTML = this.pageText;
                //                ctx.fillStyle = '#000';
                //                ctx.fillText("Target: " + this.cImg, s * 0.144, s * 0.015);
                var ts1 = ((s / 60) | 0), ts2 = ((s / 50) | 0);
                if (this.bis["Sort list"]._y < 0 && this.bis["Calculate"]._y < 0) {//this.phot){
                    s *= 1.7;
//console.log(this.cImg);                    
                    this.images["imid" + this.cImg].y = 0.001;
                    this.drawIm(ctx, this.cImg, s);
                    ctx.fillStyle = '#f00';
                    for (i = this.labels.length; i--;) {
                        if (this.galLs && i < this.data.clusters[this.clusterId].labels.length) {
                            ctx.font = 'bold ' + ((ts1)|0) + "px " + OU.theme.font;
                            ctx.fillText(this.labels[i].drawTxt, this.labels[i]._x / 10 * s, (this.labels[i]._y / 10 - 0.055) * s);
                            ctx.font = 'normal ' + ((ts2*1.4)|0) + "px " + OU.theme.font;
                            ctx.fillText(this.labels[i].drawBox, this.labels[i]._x / 10 * s, (this.labels[i]._y / 10 - 0.055) * s);
                        }
                        this.labels[i].resize({
                            x:(this.labels[i]._x / 10 - 0.01) * s,
                            y:(this.labels[i]._y / 10 - 0.07) * s,
                            h:s / 45,
                            w:s / 25
                        });
                        this.labels[i].render();
                    }
                    s /= 1.7;
                }
                ctx.font = 'bold ' + ((s / 65) | 0) + 'px ' + OU.theme.font;
                ctx.fillStyle = '#000';
                break;
            case 2:
                this.scale*=1.12;
                s=this.scale;
                this.htmlBox.div.innerHTML = this.pageText;
                this.htmlBox.setSmall(false);
                this.htmlBox.div.style.display = 'block';
                this.graphB.div.style.display = 'block';
                this.htmlBox2.div.style.display = "none";
                //                this.header({h1:"Virtual telescope",h2:"Imager&#160;&#160;&#160;&#160;Target: "+this.cImg});
                //                ctx.fillText("Target: " + this.cImg + " " + (this.galId), s * 0.144, s * 0.015);
                ctx.font = 'normal ' + s / 60 + 'px ' + OU.theme.font;
                ctx.fillStyle = '#fff';
                ctx.strokeStyle = '#000';
                ctx.fillRect(this.xpt(0), this.ypt(0), s * 0.39, s * 0.352);
                ctx.strokeRect(this.xpt(0), this.ypt(0), s * 0.39, s * 0.352);
                ctx.fillStyle = '#000';
                ctx.save();
                ctx.translate(s * 0.02, s * 0.05);
                ctx.rotate(-Math.PI / 2);
                ctx.textAlign = "center";
                ctx.fillText("relative intensity", s * -0.23, s * 0.01);
                ctx.restore();
                ctx.beginPath();
                //	From S104 VT classes/screens/Spectrometer.as
                //	public function drawGraph(){ 
                yInterval = 1. / this.noiseLevel(this.clusterId, this.galId);
                for (i = 8; i--;) {
                    this.moveTo(0, 320 - i * 45.7);
                    this.lineTo(5, 320 - i * 45.7);
                    ctx.textAlign = 'right';
                    ctx.fillText("" + Math.floor(i / 2 * yInterval), this.xpt(-4), this.ypt(320 - i / 7 * 320));
                    ctx.textAlign = 'center';
                    if (i < 7) {
                        this.moveTo(i * 50, 320);
                        this.lineTo(i * 50, 315);
                        ctx.fillText("" + (350 + i * 50), this.xpt(300 * i / 6), this.ypt(335));
                    }
                }
                ctx.fillText("wavelength / nm", this.xpt(150), this.ypt(355));
                ctx.stroke();
                ctx.beginPath();
                ctx.strokeStyle = '#a0a';
                this.drawSpec(false);
                ctx.stroke();
                if (this.drawRef) {
                    ctx.beginPath();
                    ctx.strokeStyle = '#888';
                    this.drawSpec(true);
                    ctx.stroke();
                }
                if (this.measure > 0) {
                    ctx.strokeStyle = '#a0a';
                    ctx.beginPath();
                    this.moveTo(this.lGal - 350, 0);
                    this.lineTo(this.lGal - 350, 320);
                    ctx.stroke();
                }
                if (this.measure > 1) {
                    ctx.strokeStyle = '#888';
                    ctx.beginPath();
                    this.moveTo(this.lRef - 350, 0);
                    this.lineTo(this.lRef - 350, 320);
                    ctx.stroke();
                    this.bis["Calculate"].params.disabled = false;
                }
                this.scale/=1.12;
                break;
            case 3:
                var dist = this.getNum(OU.LocalStorage.load("OUVTDistances"), this.clusterId)
                    , vels = (OU.LocalStorage.load("OUVTVels" + this.clusterId) || "").split(",")
                    , txt = "<br/><b>Recession speed (from spectrometer)</b><br/>"
                        + "<b>Name              Include       "
                        + "<i>v</i> / km s<sup>-1</sup></b><br/>"
                    , p, p2, p3, cid, gid, show, v;
                this.velVals = [];
                this.vels = vels;
                this.htmlBox.setSmall(false);
                this.htmlBox.div.innerHTML = "<br/><b>Distance (from photometer)</b><br/><br/><br/>"
                    + "<br/><b>Distance</b>, <i>d</i> ≈ " + (dist ? this.numberString(dist) + " Mpc" : "...");
                this.htmlBox.div.style.display = "block";
                for (i = 0; i < vels.length - 1; i++) {
                    p = vels[i].indexOf(".");
                    p2 = vels[i].indexOf("_");
                    p3 = vels[i].indexOf(":");
                    cid = parseInt(vels[i].substring(0, p));
                    gid = parseInt(vels[i].substring(p + 1, p2));
                    show = (vels[i].indexOf("_Y") > 0);
                    v = parseFloat(vels[i].substring(p3 + 1));
                    this.velVals[i] = v;
                    if (cid==this.clusterId) {
                        txt = txt + this.data.cluster[cid] + " " + (gid);
                        for (k = 14 - this.data.cluster[cid].length; k--;)txt = txt + " ";
                        txt = txt + "     "
                            + "<input id='velCB" + i + "' type='checkbox'" + (show===true ? " checked='true'" : " ") + " onclick='self.calcV()'/>            " + this.numberString(v) + "<br/>";
                    }
                }
                txt = txt + "<br/><b>Mean speed</b>, <i>v</i> = <span id='OUVTMeanS'></span>"
                    + (vels.length > 9 ? "<br/><br/>You now have enough speed measurements for this cluster." : "");
                this.htmlBox2.div.innerHTML = txt;
                this.calcV();
                this.htmlBox2.div.style.display = "block";
                if (this.htmlBox.div.innerHTML.indexOf("...") < 0 && this.htmlBox2.div.innerHTML.indexOf("...") < 0) {
                    this.bis["Add to final results"].params.disabled = false;
                    this.setAudio("VTAF044");
                }
                else {
                    this.bis["Add to final results"].params.disabled = true;
                    if (this.justDone==='s')this.setAudio("VTAF041");
                    //                if(meanV==0 && _root.d[_root.clusterIndex]==0){
                    //                      this.setAudio("VTAF042");
                    //            }
                    if (this.justDone==='p')this.setAudio("VTAF043");
                }
                break;
            case 4:
                this.pageText = OU.LocalStorage.load("OUVTFinalResults");
                this.htmlBox.div.innerHTML = this.pageText;
                this.htmlBox.div.style.display = "block";
                this.setAudio("VTAF051");
                break;
            case 5:
                this.htmlBox.div.style.display = "none";
                var xmn = 0, xmx = -1e20, ymn = 1e20, ymx = -1e20
                    , sx = 0, sy = 0, sx2 = 0, sy2 = 0, sxy = 0
                    , r = this.getResults()
                    , n = r.length
                    , hubbleC, intercept, div
                    , hubbleText = ""
                    , pts = [];
                for (var i = n; i--;) {
                    sx += r[i].d;
                    sy += r[i].v;
                    sx2 += r[i].d * r[i].d;
                    sy2 += r[i].v * r[i].v;
                    sxy += r[i].d * r[i].v;
                    if (r[i].d > xmx)xmx = r[i].d;
                    if (r[i].v > ymx)ymx = r[i].v;
                    if (r[i].v < ymn)ymn = r[i].v;
                    pts.push([r[i].d, r[i].v]);
                }
                div = (n * sx2 - sx * sx);
                if (div!=0) {
                    hubbleC = (n * sxy - sx * sy) / div;
                    intercept = (sy * sx2 - sx * sxy) / div;
                    var line = [
                        [0, intercept],
                        [xmx, intercept + hubbleC * xmx]
                    ];
                    if (intercept < ymn)ymn = intercept;
                    if (intercept > ymx)ymx = intercept;
                    ymx *= 1.05;
                    ymn *= (ymn < 0 ? 1.05 : 0.95);
                    this.plotGraph(ctx, xmn, xmx, ymn, ymx, this.calcTics(ymn, ymx), this.calcTics(xmn, xmx), line, pts);
                    hubbleText = ("Hubble constant ≈ <b>"
                        + Math.floor(hubbleC) + "</b> km s<sup>-1</sup> Mpc<sup>-1</sup>");
                    //				speakS="Hubble constant is approximately "+Math.floor(hubbleC)+" kilometers per second per megaparsec. ";
                    if (hubbleC >= 50 && hubbleC <= 80) {
                        this.setAudio("VTAF060");
                    }
                    if (hubbleC < 50) {
                        this.setAudio("VTAF061");
                    }
                    if (hubbleC > 80) {
                        this.setAudio("VTAF062");
                    }
                }
                else {
                    hubbleText = (n < 2 ? "Please collect more results." : "Your results do not give a valid value for the Hubble constant. ");
                }
                this.htmlBox.div.innerHTML = "<center>" + hubbleText + "</center>";
                this.htmlBox.div.style.display = "block";
                break;
        }
        this.resizeText();
        for (i = this.buttons.length; i--;) {
            bpn = false;
            for (j = this.buttons[i].pageNum.length; j--;)
                if (this.pageNum===this.buttons[i].pageNum[j])bpn = true;
            if (this.buttons[i].dontShow===true)bpn = false;
            if (bpn) {
                pos = this.getPos(this.buttons[i]._x, this.buttons[i]._y);
                this.buttons[i].resize({
                    x:pos.x,
                    y:pos.y,
                    h:s / 31,
                    w:s / 10 * this.buttons[i].id.length / 10 + 18
                });
            }
            else {
                this.buttons[i].resize({
                    x:1,
                    y:-500, //this.buttons[i]._y * s,
                    h:s / 31,
                    w:s / 10 * this.buttons[i].id.length / 1 + 18
                });
            }
            this.buttons[i].render();
        }
        this.doRender = false;
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.VTelescope, OU.util.Activity);
