var max_attempts = 2;
var cur_attempt = 1;
var is_correct = false;

var qusetion_ele = document.getElementById('question');
var response_ele = document.getElementById('response');
var correct_ele = document.getElementById('correct');
var wrong_ele = document.getElementById('wrong');
var feedback_ele = document.getElementById('feedback');
var answer_ele = document.getElementById('answer');
var buttons_ele = document.getElementById('buttons');

var chk_ans_btn = null;
var try_agn_btn = null;
var rpt_qst_btn = null;

function addButtons() {
  // check answer button
  chk_ans_btn = createElement('a', 'chk_ans');
  chk_ans_btn.innerHTML = 'check answer';
  chk_ans_btn.className = 'btn';
  chk_ans_btn.href = '#';
  buttons_ele.appendChild(chk_ans_btn);
  addEvent(chk_ans_btn, 'click', checkAnswer);
  // try again button
  try_agn_btn = createElement('a', 'try_agn');
  try_agn_btn.innerHTML = 'try again';
  try_agn_btn.className = 'btn';
  try_agn_btn.href = '#';
  try_agn_btn.style.display = 'none';
  buttons_ele.appendChild(try_agn_btn);
  addEvent(try_agn_btn, 'click', tryAgain);
  // repeat question button
  rpt_qst_btn = createElement('a', 'rpt_qst');
  rpt_qst_btn.innerHTML = 'repeat question';
  rpt_qst_btn.className = 'btn';
  rpt_qst_btn.href = '#';
  rpt_qst_btn.style.display = 'none';
  buttons_ele.appendChild(rpt_qst_btn);
  addEvent(rpt_qst_btn, 'click', repeatQuestion);
}

function initQuestion() {
  // set response display
  response_ele.style.display = 'none';
  correct_ele.style.display = 'none';
  wrong_ele.style.display = 'none';
  feedback_ele.style.display = 'none';
  answer_ele.style.display = 'none';
  // set ui buttons
  addButtons();
  // update styles (chameleon)
  var all_query_params = makeQueryStringObject();
  if (all_query_params._a) {makeChameleon(all_query_params._a);}
  // set default text
  correct_ele.innerHTML = '<p>Your answer is correct.</p>';
  wrong_ele.innerHTML = '<p>Your answer is wrong.</p>';
}

function inputChecker() {
  is_correct = false;
  // define correct answers
  var ans = [];
  ans.push(['2750','2,750','2.750']);
  // define triggers for targeted feedback
  var fb = [];
  fb.push([
    {'id':'fb_1','ans':['1400','1,400','1.400']},
    {'id':'fb_2','ans':['14000','14,000','14.000']},
    {'id':'fb_3','ans':['1555','1,555','1.555','1556','1,556','1.556']}
  ]);
  // get inputs from user
  var ans_user = [];
  ans_user.push(''+document.getElementById('in_1').value.toLowerCase());
  for (var i=0; i<ans_user.length; i++) {
    // dump spaces and correct minus signs from em and en dashes
    ans_user[i] = ans_user[i].replace(' ','');
    //ans_user[i] = ans_user[i].replace('–','-');
    //ans_user[i] = ans_user[i].replace('—','-');
    for (var j=0; j<ans[i].length; j++) {
      is_correct = is_correct || (ans_user[i] == ans[i][j]);
    }
    // trigger feedback
    if (fb[i]) {
      var hide_generic_fb = false;
      for (var j=0; j<fb[i].length; j++) {
        //alert(fb[i][j].id);
        var show_fb = false;
        for (var k=0; k<fb[i][j].ans.length; k++) {
          show_fb = show_fb || (ans_user[i] == fb[i][j].ans[k])
        }
        document.getElementById(fb[i][j].id).style.display = show_fb ? 'block':'none';
        hide_generic_fb = hide_generic_fb || show_fb;
      }
      if (document.getElementById('generic')) {document.getElementById('generic').style.display = hide_generic_fb ? 'none':'block';}
    }
  }
}

function checkAnswer(event) {
  inputChecker();
  // set response display
  response_ele.style.display = 'block';
  correct_ele.style.display = is_correct ? 'block':'none';
  wrong_ele.style.display = !is_correct ? 'block':'none';
  feedback_ele.style.display = !is_correct && (cur_attempt < max_attempts) ? 'block':'none';
  answer_ele.style.display = is_correct || (cur_attempt >= max_attempts) ? 'block':'none';
  // set buttons display
  chk_ans_btn.style.display = 'none';
  try_agn_btn.style.display = !is_correct && (cur_attempt < max_attempts) ? 'inline':'none';
  rpt_qst_btn.style.display = is_correct || (cur_attempt >= max_attempts) ? 'inline':'none';
  cur_attempt++;
  if (event.preventDefault) {
    event.preventDefault();
    event.stopPropagation();
  }
  return false;
}

function tryAgain(event) {
  // set response display
  response_ele.style.display = 'none';
  correct_ele.style.display = 'none';
  wrong_ele.style.display = 'none';
  feedback_ele.style.display = 'none';
  answer_ele.style.display = 'none';
  // set buttons display
  chk_ans_btn.style.display = 'inline';
  try_agn_btn.style.display = 'none';
  if (event.preventDefault) {
    event.preventDefault();
    event.stopPropagation();
  }
  return false;
}

function repeatQuestion(event) {
  // set response display
  response_ele.style.display = 'none';
  correct_ele.style.display = 'none';
  wrong_ele.style.display = 'none';
  feedback_ele.style.display = 'none';
  answer_ele.style.display = 'none';
  // set buttons display
  chk_ans_btn.style.display = 'inline';
  rpt_qst_btn.style.display ='none';
  // clear inputs
  var input_elements = document.getElementsByTagName('input');
  for (var i=0; i<input_elements.length; i++) {
    var input_ele = input_elements[i];
    if (input_ele.type == 'text') {
      input_ele.value = '';
    }
  }
  cur_attempt = 1;
  if (event.preventDefault) {
    event.preventDefault();
    event.stopPropagation();
  }
  return false;
}

initQuestion();