 if(!console)var console={log:function(){}};
 
(function($) {
  $.randomize = function(arr) {
     for(var j, x, i = arr.length; i; j = parseInt(Math.random() * i), x = arr[--i], arr[i] = arr[j], arr[j] = x);
     return arr;
  };
})($);

var hook, hooks;
hooks=function(name){
	if(this[name])return this[name];else return this[name]={};
}
hook=function(){
	for (var f in this[arguments[0]]){
		this[arguments[0]][f](arguments)
	}
}
 
 $(document).ready(function(){
 
	// Properties of each choice
	
	// Get choices using data from data.js
	var choices=[];
	if($.isArray(data.choices))
	{
		$.each(data.choices, function(key, item) {
		choice_num = key + 1;
		choices.push("<a id=\"choice"+choice_num+"\" href=\"javascript:void(0)\" class=\"choice\"><span>"+ item.text+"</span></a>");	
		});
	}
	
	//do a quick shuffle
	$.randomize(choices);
	// Display choices using data from data.js
	for (var choice in choices){
		$(".choices").append(choices[choice]);
	}
		
		
	$('.choice').draggable( {
		containment: '#content',
		cursor: 'move',
		stack: '.choice',
		revert: true,
		start:function(event,ui){
			hook("dragstart",event,ui)
		}
	} );
	
	// Write background image from data.js at the top of targets div	
	if(data.backgroundimage){
	$(".targets").prepend(" <img src=\"" + data.backgroundimage + "\">");
	}
	
	
	// Display labels and set css from data.js
	if($.isArray(data.labels))
	{
		$.each(data.labels, function(key, item) {
		label_num = key + 1;
		var div=$(document.createElement("div")).attr("id","labeltext"+label_num).addClass("label");
		console.log(item);
		if(item.html)div.html(item.html);
		if(item.className)div.addClass(item.className);
		$(".targets").append(div);
		//$(".targets").append("<div id=\"labeltext"+label_num+"\" class=\"label\"><span>"+ item.text+"</span></div>");
		for (var i in item){
			if(i=="html")continue;
			if(i=="className")continue;
			$("#labeltext"+label_num).css(i,item[i]);
			}		
		});
	}		
	
	
	// Apply locations of droppable areas from data.js (in css)
	if($.isArray(data.droppableareas))
	{
		$.each(data.droppableareas, function(key, item) {
		droppable_num = key + 1;
		$(".targets").append("<div id=\"droppable-area"+droppable_num+"\" class=\"choice"+droppable_num+" droppable\"><a href=\"javascript:void(0)\"></a></div>");
		$("#droppable-area"+droppable_num).css("top",item.top);
		$("#droppable-area"+droppable_num).css("left",item.left);		
        });
		
	}
	
	$(".choice").css("font-size",data.choicefontsize);
	$(".choice").css("color",data.choicetextcolour);
	$(".label").css("font-size",data.labelfontsize);
	$(".label").css("color",data.labeltextcolour);
	
	
	//target	
	// if class of droppable, then make droppable	  
	$(".droppable").droppable({
		 // Event triggered when an accepted draggable(choice) is dropped on the droppable	
		 drop:function(event, ui){
			ui.draggable.css({top:"0px",left:"0px"});//lock in place
			// Return choice back to choices div if in current target (droppable)
			$(".choices").append($(this).find(".choice").css({left:"",top:""}).removeClass("selected"));//chuck out any choices that were already there and put back into top list
			// Add draggable html to droppable
			$(this).html(ui.draggable);//add to target
			hook("choicedropped",this,ui.draggable);
		 },
	}); 
	
	// If target is clicked (tapped)
	$(".targets div").click(function(){
		// Is a choice selected from the choices at the top
		if($(".choices a.selected").length){
			// Is there already a choice in the target?
			$(".choices").append($(this).find(".choice").css({left:"",top:""}).removeClass("selected"));//chuck out
			// Add html of the 'selected' choice in the list at the top
			$(this).html($(".choices a.selected"));//append
		// If target is selected
		}else if($(this).hasClass("selected")){
			$(".choices").append($(this).find(".choice").css({left:"",top:""}).removeClass("selected"));//chuck out
			// select first of the items from the choices
			$(this).html($(".choices a").eq(0));//append
		}
		$(".targets div").removeClass("selected");
		$(this).addClass("selected");
		$(this).find("a").focus();
	});
	// Add 'selected' to choice selected
	$(".choices a").click(function(){
		if($(this).parents(".targets").length)return;
		if($(this).hasClass("selected")){
			$(".choices a").removeClass("selected");
		}else{
			$(".choices a").removeClass("selected");
			$(this).addClass("selected");
			$(this).focus();
		}
	});
	
	//$(".droppable").draggable();
	hooks("dragstart").unrotateall=function(event,ui){
		$("a.choice").css({transform:"none"});
	};
});

var attempts=0;
$(document).ready(function(){
	$("#submit").click(function(){
		attempts++;
		var countofcorrect=0;
		$(".droppable").each(function(){
			var choice=$(this).find(".choice").attr("id");
			if($(this).hasClass(choice)){
				countofcorrect++;
			}else{
				//chuck out
				$(".choices").append($(this).find(".choice"));
			}

		});

		
		if(countofcorrect==5){
			$("#labeltext2").css({display:"block"});
			$("#submit").css({display:"none"});
		}
		
		if(attempts==2){
			//second attempt
			$(".choice").each(function(){
				//do not put answers into correct slots
				//var id=$(this).attr("id");
				//$("."+id).html(this);
			});
			if(countofcorrect==5){
				$("#labeltext2").css({display:"block"});
			}else{
				$("#labeltext1").css({display:"block"});
			}
			$("#submit").css({display:"none"});
		}
		
		var hint="\n\nCheck you have labelled the axes correctly.  \nThe vertical axis represents the cost per day, \nthe horizontal axis represents the quantity of output per day. \n\nThe figure shows three lines which represent three different cost curves.  \nThe fixed and variable cost video showed that average cost is the sum \nof average variable cost and average fixed cost.  \nThis means average cost curve is always higher than the average \nvariable cost or average fixed cost curve.";
		switch(countofcorrect){
			case 0:
				alert("You have matched 0/5 labels correctly -\ntry reviewing the screencast [Fixed and variable cost] \nand see if you can spot your mistakes."+hint);
			break;
			case 1:
				alert("You have matched 1/5 labels correctly -\ntry reviewing the video [Fixed and variable cost] and see if you can spot your mistakes."+hint);
			break;
			case 2:
				alert("You have matched 2/5 labels correctly -\ntry reviewing the video and see if you can spot your mistakes."+hint);
			break;
			case 3:
				alert("You have matched 3/5 labels correctly -\nhave another go and see if you can spot the two misplaced labels.");
			break;
			case 4:
				alert("You have matched 4/5 labels correctly -\nhave another go and see if you can spot your error.");
			break;
			case 5:
				alert("You have matched all labels correctly -\nwell done.");
			break;
		}

	});
});

