/**
 * @fileOverview GraphDragLineEndPointsActivity - A non-assessed exercise where user drags end points of a line into position and given feedback as to whether it intersects a fixed line in the correct location. It will also be able to work out the direction of incline. Any number of fixed lines can be added. All lines will have labels.
 * This is activity type 2d for Social Sciences DD209
 * 
 * STILL IN DEVELOPMENT - W.I.P.!!!!
 *
 * Usage:
 * <ul>
 * <li> Make a copy of this file</li>
 * <li> Rename the class (OU.activity.GraphDragLineEndPointsActivity) to your new activity name</li>
 * <li> Add your code</li>
 * </ul>
 *
 * Additional functions that are not defined in this file but are available to all activities:
 * <ul>
 * <li> this.header(h) - changes current H1 and H2 tags, where parameter h is of format: { h1: 'optional H1', h2: 'optional H2' }</li>
 * <li> this.loadCSSFile(f) - loads additional CSS from the file f - which is a file path relative to the activity data folder</li>
 * <li> this.addMessengerParams(paramsArray) - See documentation for Messenger functions in OU.js</li>
 * </ul>
 *
 * @author Gareth Hudson <gareth.hudson@open.ac.uk>
 */

// Load in any util elements that are required
OU.require('OU.util.Layer');
OU.require('OU.util.Button');
OU.require('OU.util.Div');


/**
 * @class GraphDragLineEndPointsActivity - A template for activities that extend the OU.util.Activity class
 * @extends OU.util.Activity
 * @param {Object} data - Holds the data content for a specific instance of the activity
 * @param {String|undefined} instance - A unique identifier name for this instance, defaults to 'a1'
 * @param {Controller Object|undefined} controller - A reference to the controller that initialised this instance, if undefined, the superclass will generate a new controller and create the reference to it as 'this.controller'
 */
OU.activity.GraphDragLineEndPointsActivity = function(data,instance,controller) {

    /**
     * canvasView - this is the function that is first called when the activity is launched,
     *              assuming you are in a browser that supports canvas.
     *
     * Typical tasks for this function are:
     * <ul>
     * <li> Define and initialise and activity wide variables</li>
     * <li> Initialise Layers & Divs</li>
     * <li> Call a loading function</li>
     * <li> Initiating the activity by calling any methods that</li>
     * </ul>
     */
    OU.activity.GraphDragLineEndPointsActivity.prototype.canvasView = function() {
        // Most activities should have a background layer
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw default background
        //
        // Create the feedback text div
        this.feedbackText = new OU.util.Div({
            container:this,
            x:20,
            y:this.h-40,
            w:this.w-30,
            h:40
        });
        // add dashed line ability to layers
        OU.util.Layer.prototype.dashedLine = function(x, y, x2, y2, da) {
            //console.log('x='+x+', y='+y+', x2='+x2+', y2='+y2);
            if (!da) {
                da = [10,5];
            }
            this.context.save();
            var dx = (x2-x), dy = (y2-y);
            var len = Math.sqrt(dx*dx + dy*dy);
            var rot = Math.atan2(dy, dx);
            this.context.translate(x, y);
            this.context.moveTo(0, 0);
            this.context.rotate(rot);       
            var dc = da.length;
            var di = 0, draw = true;
            x = 0;
            while (len > x) {
                x += da[di++ % dc];
                if (x > len) x = len;
                draw ? this.context.lineTo(x, 0): this.context.moveTo(x, 0);
                draw = !draw;
            }       
            this.context.restore();
        }
        
        // Create the points layer
        this.pointsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // Create the labels layer
        this.labelsLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // layer for the main graph and fixed items
        this.graphLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // layer for the user moveable line label
        this.lineMoveLabelLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        // Create the text info layer
        this.textInfoLayer = new OU.util.Layer({
            container:this,
            x:0,
            y:0,
            w:500,
            h:500
        });
        
        // layer for the user moveable line
        this.lineMoveLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:0,
            y:0,
            w:500,
            h:500
        });
        this.buttonsLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            x:this.w-this.data.submitbutton.w,
            y:this.h-40,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        // Submit button
        var btnActionLevel = this;
        this.buttonSubmit = new OU.util.Button({
            layer:this.buttonsLayer,
            txt:this.data.submitbutton.label,
            verticalPadding:2,
            disabled:false,
            onClick:function () {
                btnActionLevel.submitAction();
            },
            x:0,
            y:0,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        
        this.lineMoveLayer.events.clickable.push(this);
        // *Your code starts here*
        /** create graphData to hold changing values for the graph */
        this.graphData = function() {
        }
        this.graphData.xMove = 0;
        this.graphData.yMove = 0;
        this.graphData.userClickPositionsXY = [];
        this.graphData.numberUserAttemptsMade = 0;
        this.graphData.originalIntersectX=0;
        this.graphData.originalIntersectY=0;
        this.activityIsActive = true;
        this.userCorrect = true;
        this.resize();
        var orig_intersectPoint = this.checkIntersect(this.data.lines[0][0].x,this.data.lines[0][0].y,this.data.lines[0][1].x,this.data.lines[0][1].y,this.data.linemove[0].x,this.data.linemove[0].y,this.data.linemove[1].x,this.data.linemove[1].y);
        this.graphData.originalIntersectX=orig_intersectPoint[0];
        this.graphData.originalIntersectY=orig_intersectPoint[1];
        this.graphData.linemoveOriginal_x0 = this.data.linemove[0].x;
        this.graphData.linemoveOriginal_y0 = this.data.linemove[0].y;
        this.graphData.linemoveOriginal_x1 = this.data.linemove[1].x;
        this.graphData.linemoveOriginal_y1 = this.data.linemove[1].y;
        //
        this.draggingPoint = 0;
    };
    
    // Called by user clicking the submit button
    OU.activity.GraphDragLineEndPointsActivity.prototype.submitAction = function(){
        // Record an additional attempt made by the user.
        this.graphData.numberUserAttemptsMade++;
        // set userCorrect to start with, then it will be set to false if they are incorrect on any necessary checks
        this.userCorrect = true;
        var endCheckCorrect=true;
        var intersectPoint = this.checkIntersect(this.data.lines[0][0].x,this.data.lines[0][0].y,this.data.lines[0][1].x,this.data.lines[0][1].y,this.data.linemove[0].x,this.data.linemove[0].y,this.data.linemove[1].x,this.data.linemove[1].y);
        var slopeType = this.calcSlope(this.data.linemove[0].x, this.data.linemove[0].y, this.data.linemove[1].x, this.data.linemove[1].y, 'direction');
        var slopeValue = this.calcSlope(this.data.linemove[0].x, this.data.linemove[0].y, this.data.linemove[1].x, this.data.linemove[1].y, 'value');
        //console.log('intersectpoint type = '+this.data.intersectpoint.type);
        //console.log('data intersectpoint = '+this.data.intersectpoint.x+','+this.data.intersectpoint.y);
        //console.log('user intersectPoint = '+intersectPoint);
        switch(this.data.intersectpoint.type) {
            case 'exact':
                if ((intersectPoint[0] == this.data.intersectpoint.x) && (intersectPoint[1] == this.data.intersectpoint.y)) {
                } else {
                    this.userCorrect = false;
                }
                break;
            case 'xincrease':
                if (intersectPoint[0] <= this.graphData.originalIntersectX) {
                    this.userCorrect = false;
                } else {
                }
                break;
            case 'yincrease':
                if (intersectPoint[1] <= this.graphData.originalIntersectY) {
                    this.userCorrect = false;
                } else {
                }
                break;
            case 'xdecrease':
                if (intersectPoint[0] >= this.graphData.originalIntersectX) {
                    this.userCorrect = false;
                } else {
                }
                break;
            case 'ydecrease':
                if (intersectPoint[1] >= this.graphData.originalIntersectY) {
                    this.userCorrect = false;
                } else {
                }
                break;
            case 'positionends':
                if ((this.data.linemove[0].x == this.data.correctline[0].x && this.data.linemove[0].y == this.data.correctline[0].y && this.data.linemove[1].x == this.data.correctline[1].x && this.data.linemove[1].y == this.data.correctline[1].y) || (this.data.linemove[0].x == this.data.correctline[1].x && this.data.linemove[0].y == this.data.correctline[1].y && this.data.linemove[1].x == this.data.correctline[2].x && this.data.linemove[1].y == this.data.correctline[2].y)) {
                    
                } else {
                    this.userCorrect = false;
                }
            case 'slopevalue':
                break;
            case 'abovex_abovey':
                if ((intersectPoint[0] < this.data.intersectpoint.x) || (intersectPoint[1] < this.data.intersectpoint.y)) {
                    this.userCorrect = false;
                }
                break;
            case 'abovex_belowy':
                if ((intersectPoint[0] < this.data.intersectpoint.x) || (intersectPoint[1] > this.data.intersectpoint.y)) {
                    this.userCorrect = false;
                }
                break;
            case 'belowx_abovey':
                if ((intersectPoint[0] > this.data.intersectpoint.x) || (intersectPoint[1] < this.data.intersectpoint.y)) {
                    this.userCorrect = false;
                    //console.log('intersect wrong');
                } else {
                    //console.log('intersect right');
                }
                break;
            case 'belowx_belowy':
                if ((intersectPoint[0] > this.data.intersectpoint.x) || (intersectPoint[1] > this.data.intersectpoint.y)) {
                    this.userCorrect = false;
                }
                break;
        }
        if (this.data.slopetype.check) {
            //console.log('               slopeValue = '+slopeValue);
            //console.log('this.data.slopetype.value = '+this.data.slopetype.value);
            if (this.data.slopetype.type == 'value') {
                    if (slopeValue != this.data.slopetype.value) {
                        //console.log('checking the numeric value of the slope');
                        this.userCorrect = false;
                    }
            } else if (slopeType != this.data.slopetype.type) {
                //console.log('checking the direction of the slope');
                this.userCorrect = false;
            }
            if (this.data.slopetype.checkoneendposition) {
                if ((this.data.linemove[0].x == this.data.correctline[this.data.slopetype.end].x && this.data.linemove[0].y == this.data.correctline[this.data.slopetype.end].y) || (this.data.linemove[1].x == this.data.correctline[this.data.slopetype.end].x && this.data.linemove[1].y == this.data.correctline[this.data.slopetype.end].y)) {                    
                } else {
                    this.userCorrect = false;
                    endCheckCorrect = false;
                }
            }
        }
        //console.log('this.userCorrect = '+this.userCorrect);
        if (this.userCorrect) {
            // User is correct
            clearTimeout(this.feedbackTimeout);
            this.feedbackText.div.innerHTML = this.data.feedbacktext.correct;
            //disable the submit button
            this.buttonSubmit.disable();
            this.activityIsActive = false;
            // change Submit button to Reset button
            var btnActionLevel = this;
            this.buttonSubmit.modify({
                txt:'Reset',
                onClick:function () {
                    btnActionLevel.resetActivity();
                }
            });
            this.buttonSubmit.enable();
            this.buttonSubmit.render();
            this.renderCorrectAnswer();
        } else {
            this.numberTimesIncorrect++;
            // User is incorrect
            if (this.graphData.numberUserAttemptsMade == this.data.numberofattempts) {
                // They've run out of attempts
                clearTimeout(this.feedbackTimeout);
                this.feedbackText.div.innerHTML = this.data.feedbacktext.incorrectfinal;
                this.renderCorrectAnswer();
                this.clearFeedbackTimeout();
                this.activityIsActive = false;
            } else {
                // Still incorrect
                clearTimeout(this.feedbackTimeout);
                if (this.graphData.numberUserAttemptsMade == 1) {
                    this.feedbackText.div.innerHTML = this.data.feedbacktext.incorrect;
                } else {
                    this.feedbackText.div.innerHTML = this.data.feedbacktext.incorrectmany;
                }
                if (!endCheckCorrect) {
                    this.feedbackText.div.innerHTML += ' '+this.data.slopetype.feedback;
                }
                this.clearFeedbackTimeout();
            }
        }
    }
    
    /** This will remove the feedback text on display (after the number of seconds set in data.js) */
    OU.activity.GraphDragLineEndPointsActivity.prototype.clearFeedbackTimeout = function(){
        //console.log(this.buttonSubmit.txt);
        //this.buttonSubmit.txt = 'Reset';
        //this.buttonSubmit.render();
        var self = this;
        clearTimeout(this.feedbackTimeout);
        this.feedbackTimeout = setTimeout(function () {
            self.clearFeedback();
        }, this.data.feedbacktext.incorrectsecstimeout*1000);
    }
    /** This will remove the feedback text on display (after the number of seconds set in data.js) */
    OU.activity.GraphDragLineEndPointsActivity.prototype.clearFeedback = function(){
        this.feedbackText.div.innerHTML = '';
    }
    
    OU.activity.GraphDragLineEndPointsActivity.prototype.submitAnswer = function(){
    }
    
    /** Display the correct answer to the user */
    OU.activity.GraphDragLineEndPointsActivity.prototype.renderCorrectAnswer = function(){
        //console.log('renderCorrectAnswer');
        /** draw the correct answer line(s) and display to the user, disable submit button and prevent further move of lines
         */
        var ctx = this.lineMoveLayer.context;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.translate(this.lineMoveLayer.w*0.13, this.data.yaxis.end*this.scaleFactorY*1.1);
        // draw the correct answer line
        ctx.strokeStyle=this.data.linemovecolour;
        ctx.lineWidth=2;
        ctx.beginPath();
        if (this.userCorrect) {
            ctx.moveTo((this.data.linemove[0].x)*this.scaleFactorX,-(this.data.linemove[0].y)*this.scaleFactorY);
            ctx.lineTo((this.data.linemove[1].x)*this.scaleFactorX,-(this.data.linemove[1].y)*this.scaleFactorY); 
        } else {
            ctx.moveTo((this.data.correctline[0].x)*this.scaleFactorX,-(this.data.correctline[0].y)*this.scaleFactorY);
            ctx.lineTo((this.data.correctline[1].x)*this.scaleFactorX,-(this.data.correctline[1].y)*this.scaleFactorY);
        }
        ctx.stroke();
        // Draw the blobs onto the ends of the correct line
        ctx.textAlign = 'left';
        ctx.font='12px Arial';
        var ctxPoints = this.pointsLayer.context, labelX, labelY;
        ctxPoints.save();
        ctxPoints.clearRect(0, 0, this.w, this.h);
        ctxPoints.translate(this.lineMoveLayer.w*0.13, this.data.yaxis.end*this.scaleFactorY*1.1);
        ctxPoints.beginPath();
        if (this.userCorrect) {
            ctxPoints.arc((this.data.linemove[0].x)*this.scaleFactorX, -(this.data.linemove[0].y)*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
            ctxPoints.arc((this.data.linemove[1].x)*this.scaleFactorX, -(this.data.linemove[1].y)*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
            if (this.data.linemove[0].x < this.data.linemove[1].x) {
                labelX = Math.min(this.data.linemove[1].x*this.scaleFactorX, this.data.xaxis.end*this.scaleFactorX - 20) + 6;
                //labelY = Math.min((this.data.yaxis.end - this.data.linemove[1].y)*this.scaleFactorY, this.data.yaxis.end*this.scaleFactorY - 25);
                labelY = Math.min(this.data.linemove[1].y*this.scaleFactorY, this.data.yaxis.end*this.scaleFactorY - 25);
            } else {
                labelX = Math.min(this.data.linemove[0].x*this.scaleFactorX, this.data.xaxis.end*this.scaleFactorX - 20) + 6;
                //labelY = Math.min((this.data.yaxis.end - this.data.linemove[0].y)*this.scaleFactorY, this.data.yaxis.end*this.scaleFactorY - 25);
                labelY = Math.min(this.data.linemove[0].y*this.scaleFactorY, this.data.yaxis.end*this.scaleFactorY - 25);
            }
            
            // Add the label to the end of the correct answer line
            for (var i=0; i<this.data.linemovelabels.oncorrect.length; i++) {
                /*
                if (this['labelDivOnCorrect'+i]) {
                    this['labelDivOnCorrect'+i].remove();
                }
                this['labelDivOnCorrect'+i] = new OU.util.Div ({
                    innerHTML:this.data.linemovelabels.oncorrect[i].text,
                    container:this.lineMoveLabelLayer,
                    x:labelX + this.lineMoveLabelLayer.w*0.13,
                    y:labelY + this.lineMoveLabelLayer.h*0.07,
                    w:80,
                    h:30,
                    style:'text-align:left; font-family:Arial; font-size:12px'
                });
                */
                ctx.fillText(this.data.linemovelabels.oncorrect[i].text,labelX,-labelY);
            }
            
        } else {
            ctxPoints.arc((this.data.correctline[0].x)*this.scaleFactorX, -(this.data.correctline[0].y)*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
            ctxPoints.arc((this.data.correctline[1].x)*this.scaleFactorX, -(this.data.correctline[1].y)*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
            // Add the label to the end of the correct answer line
            for (var i=0; i<this.data.linemovelabels.oncorrect.length; i++) {
                /*
                if (this['labelDivOnCorrect'+i]) {
                    this['labelDivOnCorrect'+i].remove();
                }
                this['labelDivOnCorrect'+i] = new OU.util.Div ({
                    innerHTML:this.data.linemovelabels.oncorrect[i].text,
                    container:this.lineMoveLabelLayer,
                    x:this.data.linemovelabels.oncorrect[i].x*this.scaleFactorX + this.lineMoveLabelLayer.w*0.13,
                    y:(this.data.yaxis.end - this.data.linemovelabels.oncorrect[i].y)*this.scaleFactorY + this.lineMoveLabelLayer.h*0.07,
                    w:80,
                    h:30,
                    style:'text-align:left; font-family:Arial; font-size:12px'
                });
                */
               ctx.fillText(this.data.linemovelabels.oncorrect[i].text,this.data.linemovelabels.oncorrect[i].x*this.scaleFactorX,-this.data.linemovelabels.oncorrect[i].y*this.scaleFactorY);
            }
            
        }
        ctxPoints.fillStyle = "#000000";
        ctxPoints.fill();
        ctxPoints.lineWidth = 1;
        ctxPoints.strokeStyle = "black";
        ctxPoints.restore();
        
        ctx.restore();
        //disable the submit button
        //this.buttonSubmit.disable();
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Reset',
            onClick:function () {
                btnActionLevel.resetActivity();
            }
        });
        this.buttonSubmit.enable();
        this.buttonSubmit.render();
        this.activityIsActive = false;
    };
    
    
    /** Rest to defaults */
    OU.activity.GraphDragLineEndPointsActivity.prototype.resetActivity = function() {
        var btnActionLevel = this;
        this.buttonSubmit.modify({
            txt:'Submit',
            onClick:function () {
                btnActionLevel.submitAction();
            }
        });
        this.data.linemove[0].x = this.graphData.linemoveOriginal_x0;
        this.data.linemove[0].y = this.graphData.linemoveOriginal_y0;
        this.data.linemove[1].x = this.graphData.linemoveOriginal_x1;
        this.data.linemove[1].y = this.graphData.linemoveOriginal_y1;
        
        /***********************************************
         * NOW REMOVE THE ACTIVITY COMPLETED LABELS!!! 
         **********************************************/
        for (var i=0; i<this.data.linemovelabels.oncorrect.length; i++) {
            if (this['labelDivOnCorrect'+i]) {
                this['labelDivOnCorrect'+i].remove();
            }
        }
        /**********************************************/
        
        this.graphData.xMove = 0;
        this.graphData.yMove = 0;
        this.graphData.userClickPositionsXY = [];
        this.graphData.numberUserAttemptsMade = 0;
        this.activityIsActive = true;
        this.feedbackText.div.innerHTML = '';
        this.resize();
    };
    
    /** Called when user rolles over layers with events
     *  If user is clicking, it will call function to see if correct clicks.
     *  It will calculate position of cursor in relation to graph axis */
    OU.activity.GraphDragLineEndPointsActivity.prototype.isHit = function ( x, y, evState ) {
        
        
        
        
        var gd = this.graphData, dX, dY, edX, edY, bH = OU.controlHeight;
        var ctx = this.lineMoveLayer.context;
        // find the X,Y position of the cursor and show to user
        var xPos, yPos;
        
        xPos = ((x-this.lineMoveLayer.w*0.13)/this.scaleFactorX) + this.data.xaxis.start;
            
        if (this.data.yaxis.start < 0){
            yPos = (-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1)/this.scaleFactorY)+this.data.yaxis.start-(this.lineMoveLayer.h*0.1);
        } else {
            yPos = (-(y-(this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1)/this.scaleFactorY); 
        }
        /* Rounding up the cursor position on the x axis */
        if (this.data.snapcursorxpostonearest < 1) {
            /* Round to 1 decimal place if necessary */
            xPos = Math.round(xPos*10)/10;
        } else {
            /* Round to nearest number specified in the data file if necessary*/
            xPos = Math.round(xPos/this.data.snapcursorxpostonearest)*this.data.snapcursorxpostonearest;
        }
        /* Rounding up the cursor position on the y axis */
        if (this.data.snapcursorypostonearest < 1) {
            /* Round to 1 decimal place if necessary */
            yPos = Math.round(yPos*10)/10;
        } else {
            /* Round to nearest number specified in the data file if necessary*/
            yPos = Math.round(yPos/this.data.snapcursorypostonearest)*this.data.snapcursorypostonearest;
        }
        
        /* **********************************************************************************
         * Break out of the function if the user rolls out of the active area of the graph */
        if (xPos<this.data.xaxis.start || xPos>this.data.xaxis.end || yPos<this.data.yaxis.start || yPos>this.data.yaxis.end) {
            this.textInfoLayer.context.clearRect(0, 0, this.w, this.h);
            return false;
        }
        /* **********************************************************************************/
        //
        if (evState && this.activityIsActive) {
            //console.log(x+', '+y);
            if (this.inDrag) {
                dX = x - this.dragStartX;
                dY = y - this.dragStartY;
                this.dragStartX = x;
                this.dragStartY = y;
                if (this.draggingPoint==1) {
                    //this.data.linemove[0].x += dX/this.scaleFactorX;
                    //this.data.linemove[0].y -= dY/this.scaleFactorY;
                    this.data.linemove[0].x = xPos;
                    this.data.linemove[0].y = yPos;
                } else if (this.draggingPoint==2) {
                    //this.data.linemove[1].x += dX/this.scaleFactorX;
                    //this.data.linemove[1].y -= dY/this.scaleFactorY;
                    this.data.linemove[1].x = xPos;
                    this.data.linemove[1].y = yPos;
                } else if (xPos<=this.data.linemove[0].x+(40/this.scaleFactorX) && xPos>=this.data.linemove[0].x-(40/this.scaleFactorX) && yPos<=this.data.linemove[0].y+(40/this.scaleFactorY) && yPos>=this.data.linemove[0].y-(40/this.scaleFactorY) && this.data.preventpointsmove!='1') {
                    this.draggingPoint = 1;
                    //this.data.linemove[0].x += dX/this.scaleFactorX;
                    //this.data.linemove[0].y -= dY/this.scaleFactorY;
                    this.data.linemove[0].x = xPos;
                    this.data.linemove[0].y = yPos;
                } else if (xPos<=this.data.linemove[1].x+(40/this.scaleFactorX) && xPos>=this.data.linemove[1].x-(40/this.scaleFactorX) && yPos<=this.data.linemove[1].y+(40/this.scaleFactorY) && yPos>=this.data.linemove[1].y-(40/this.scaleFactorY) && this.data.preventpointsmove!='2') {
                    this.draggingPoint = 2;
                    //this.data.linemove[1].x += dX/this.scaleFactorX;
                    //this.data.linemove[1].y -= dY/this.scaleFactorY;
                    this.data.linemove[1].x = xPos;
                    this.data.linemove[1].y = yPos;
                } else {
                }
            } else {
                this.dragStartX = x;
                this.dragStartY = y;
                this.inDrag = true;
                var ctxPoints = this.pointsLayer.context;
                //
                this.graphData.userClickPositionsXY[this.graphData.userClickPositionsXY.length] = [xPos,yPos];
            }
        } else {
            this.inDrag = false;
            this.draggingPoint = 0;
        }
        // ****************************
        if (this.draggingPoint!=0) {
            this.renderMovingLinesWithInfo();
        }
        // ****************************
        if(this.data.showcursorposition && this.activityIsActive) {
            this.renderTextInfoLayer(xPos,yPos,x,y);
        }
    };
    
    OU.activity.GraphDragLineEndPointsActivity.prototype.renderTextInfoLayer = function(xPos,yPos,x,y) {
        var ctx = this.textInfoLayer.context, message;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        //ctx.fillStyle = '#f00';
        message = xPos + ", " + yPos;
        var msgLength = (message.length-1) * 7;
        if (xPos>=this.data.xaxis.start && xPos<=this.data.xaxis.end && yPos>=this.data.yaxis.start && yPos<=this.data.yaxis.end){
            if ((x-this.graphLayer.w*0.13) >= (this.data.xaxis.end*this.scaleFactorX)-75) {
                ctx.beginPath();
                ctx.rect(this.graphLayer.w*0.13 + (this.data.xaxis.end*this.scaleFactorX)-75, y-30, msgLength, 18);
                ctx.fillStyle = 'white';
                ctx.fill();
                ctx.lineWidth = 0.5;
                ctx.strokeStyle = 'black';
                ctx.stroke();
                ctx.fillStyle = '#000000';
                ctx.fillText(message, this.graphLayer.w*0.13 + (this.data.xaxis.end*this.scaleFactorX)-70, y-21);
            } else {
                ctx.beginPath();
                ctx.rect(x-5, y-30, msgLength, 18);
                ctx.fillStyle = 'white';
                ctx.fill();
                ctx.lineWidth = 0.5;
                ctx.strokeStyle = 'black';
                ctx.stroke();
                ctx.fillStyle = '#000000';
                ctx.fillText(message,x,y-21);
            }
        }
        ctx.restore();
    };
    
    /** The main function called to draw and position everything */
    OU.activity.GraphDragLineEndPointsActivity.prototype.render = function() {
        var ctx = this.graphLayer.context,xTrans,yTrans,xLabelMove=0,yLabelMove=0;
        ctx.save();
        ctx.clearRect(0, 0, this.w, this.h);
        /** This if statement will set zero x,y to the correct position if the axis have negative values */
        if (this.data.xaxis.start < 0) {
            xTrans = this.graphLayer.w*0.13 + (0-this.data.xaxis.start)*this.scaleFactorX;
        } else {
            xTrans = this.graphLayer.w*0.13;
            xLabelMove = 50;
        }
        if (this.data.yaxis.start < 0) {
            yTrans = (this.data.yaxis.end-this.data.yaxis.start-(0-this.data.yaxis.start))*this.scaleFactorY*1.1
        } else {
            yTrans = (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1;
            yLabelMove = 60;
        }
        ctx.translate(xTrans, yTrans);
        this.renderAxis();
        ctx.textAlign = 'center';
        ctx.font='14px Arial';
        //ctx.fillText(this.data.xaxis.label,((this.data.xaxis.end+this.data.xaxis.start)/2)*this.scaleFactorX,-(this.data.yaxis.start-70-xLabelMove)*this.scaleFactorY);
        ctx.fillText(this.data.xaxis.label,((this.data.xaxis.end-this.data.xaxis.start)/2)*this.scaleFactorX,40+this.data.xaxis.labelplusminuspos);
        ctx.rotate(-0.5*Math.PI);
        //ctx.fillText(this.data.yaxis.label ,((this.data.yaxis.end+this.data.yaxis.start)/2)*this.scaleFactorX,(this.data.xaxis.start-110-yLabelMove)*this.scaleFactorY);
        ctx.fillText(this.data.yaxis.label ,((this.data.yaxis.end-this.data.yaxis.start)/2)*this.scaleFactorY,-50+this.data.yaxis.labelplusminuspos);
        ctx.restore();
        this.buttonSubmit.render();
    };
    
    /** Draw both axis, markers, labels and titles */
    OU.activity.GraphDragLineEndPointsActivity.prototype.renderAxis = function() {
        var ctx = this.graphLayer.context;
        var gd = this.graphData;
        ctx.strokeStyle='#000000';
        ctx.lineWidth=2;
        // draw the y axis
        ctx.beginPath();
        ctx.moveTo(0,-this.data.yaxis.start*this.scaleFactorY);
        ctx.lineTo(0, -this.data.yaxis.end*this.scaleFactorY);
        ctx.stroke();
        // draw the x axis
        ctx.beginPath();
        ctx.moveTo(this.data.xaxis.start*this.scaleFactorX, 0);
        ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, 0);
        ctx.stroke();
        // draw the y axis markers and text labels
        ctx.textAlign = 'right';
        ctx.font='12px Arial';
        var labelOddEven = 0;
        var i;
        for(i=this.data.yaxis.start; i<=this.data.yaxis.end; i+=this.data.yaxis.interval){
            labelOddEven++;
            // the y axis markers
            if (!this.data.hideaxismarkers) {
                ctx.beginPath();
                ctx.moveTo(0, -i*this.scaleFactorY);
                ctx.strokeStyle='#000000';
                ctx.lineWidth=2;
                ctx.lineTo(-10, -i*this.scaleFactorY);
                ctx.stroke();
                // the yaxis labels
                var roundedLabel='';
                switch(this.data.yaxis.roundlabels) {
                    case 'millions':
                        roundedLabel = i/1000000 + 'm';
                        break;
                    case 'thousands':
                        roundedLabel = i/1000 + 'k';
                        break;
                    case 'none':
                        roundedLabel = i;
                        break;
                }
                switch(this.data.yaxis.markerlabels) {
                    case 'all':
                        //ctx.fillText(i,-12,-i*this.scaleFactorY);
                        ctx.fillText(roundedLabel,-12,-i*this.scaleFactorY);
                        break;
                    case 'odd':
                        if (labelOddEven%2 == 1) {
                            //ctx.fillText(i,-12,-i*this.scaleFactorY);
                            ctx.fillText(roundedLabel,-12,-i*this.scaleFactorY);
                        }
                        break;
                    case 'even':
                        if (labelOddEven%2 == 0) {
                            //ctx.fillText(i,-12,-i*this.scaleFactorY);
                            ctx.fillText(roundedLabel,-12,-i*this.scaleFactorY);
                        }
                        break;
                }
            }
            // draw the horizontal grid lines
            if (!this.data.hidegridlines) {
                ctx.beginPath();
                ctx.moveTo(this.data.xaxis.start*this.scaleFactorX, -i*this.scaleFactorY);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -i*this.scaleFactorY);
                ctx.stroke();
                // in between vertical gris lines
                if (i>this.data.yaxis.start) {    
                    ctx.beginPath();
                    ctx.moveTo(this.data.xaxis.start*this.scaleFactorX, -i*this.scaleFactorY + (this.data.yaxis.interval/2)*this.scaleFactorY);
                    ctx.strokeStyle='#DDDDDD';
                    ctx.lineWidth=0.5;
                    ctx.lineTo(this.data.xaxis.end*this.scaleFactorX, -i*this.scaleFactorY + (this.data.yaxis.interval/2)*this.scaleFactorY);
                    ctx.stroke();
                }
            }
        }
        // draw the x axis markers and text labels
        ctx.textAlign = 'center';
        labelOddEven = 0;
        //var markerText = this.data.xaxis.start;
        for(i=this.data.xaxis.start; i<=this.data.xaxis.end; i+=this.data.xaxis.interval){
            labelOddEven++;
            // the x axis markers
            if (!this.data.hideaxismarkers) {
                ctx.beginPath();
                ctx.moveTo(i*this.scaleFactorX, 0);
                ctx.strokeStyle='#000000';
                ctx.lineWidth=2;
                ctx.lineTo(i*this.scaleFactorX, 10);
                ctx.stroke();
                // the x axis labels
                roundedLabel='';
                switch(this.data.xaxis.roundlabels) {
                    case 'millions':
                        roundedLabel = i/1000000 + 'm';
                        break;
                    case 'thousands':
                        roundedLabel = i/1000 + 'k';
                        break;
                    case 'none':
                        roundedLabel = i;
                        break;
                }
                switch(this.data.xaxis.markerlabels) {
                    case 'all':
                        //ctx.fillText(i,i*this.scaleFactorX,20);
                        ctx.fillText(roundedLabel,i*this.scaleFactorX,20);
                        break;
                    case 'odd':
                        if (labelOddEven%2 == 1) {
                            //ctx.fillText(i,i*this.scaleFactorX,20);
                            ctx.fillText(roundedLabel,i*this.scaleFactorX,20);
                        }
                        break;
                    case 'even':
                        if (labelOddEven%2 == 0) {
                            //ctx.fillText(i,i*this.scaleFactorX,20);
                            ctx.fillText(roundedLabel,i*this.scaleFactorX,20);
                        }
                        break;
                }
            }
            // draw the vertical grid lines
                if (!this.data.hidegridlines) {
                ctx.beginPath();
                ctx.moveTo(i*this.scaleFactorX, -this.data.yaxis.start*this.scaleFactorY);
                ctx.strokeStyle='#DDDDDD';
                ctx.lineWidth=0.5;
                ctx.lineTo(i*this.scaleFactorX, -this.data.yaxis.end*this.scaleFactorY);
                ctx.stroke();
                // in between vertical gris lines
                if (i>this.data.xaxis.start) {
                    ctx.beginPath();
                    ctx.moveTo(i*this.scaleFactorX - (this.data.xaxis.interval/2)*this.scaleFactorX, -this.data.yaxis.start*this.scaleFactorY);
                    ctx.strokeStyle='#DDDDDD';
                    ctx.lineWidth=0.5;
                    ctx.lineTo(i*this.scaleFactorX - (this.data.xaxis.interval/2)*this.scaleFactorX, -this.data.yaxis.end*this.scaleFactorY);
                    ctx.stroke();
                }
            }
        }
        // draw all the fixed lines
        for (var y=0; y<this.data.lines.length; y++) {
            ctx.strokeStyle=this.data.linecolours[y];
            ctx.lineWidth=2;
            ctx.beginPath();
            if (this.data.linesinfo[y].dotted) {
                for (i=0; i<this.data.lines[y].length-1; i++) {
                    // draw dotted line by calling the function which has been added to layers
                    this.graphLayer.dashedLine(this.data.lines[y][i].x*this.scaleFactorX,-this.data.lines[y][i].y*this.scaleFactorY,this.data.lines[y][i+1].x*this.scaleFactorX,-this.data.lines[y][i+1].y*this.scaleFactorY,[3,5]);
                }
            } else {
                ctx.moveTo(this.data.lines[y][0].x*this.scaleFactorX,-this.data.lines[y][0].y*this.scaleFactorY);
                for(i=1; i<this.data.lines[y].length; i++) {
                    ctx.lineTo(this.data.lines[y][i].x*this.scaleFactorX,-this.data.lines[y][i].y*this.scaleFactorY);
                }
            }
            ctx.stroke();
        }
        // add any desired labels to the graph
        ctx.textAlign = 'left';
        for (i=0; i<this.data.graphlabels.length; i++) {
            if (this['labelDivFixed'+i]) {
                this['labelDivFixed'+i].remove();
            }
            /*
            this['labelDivFixed'+i] = new OU.util.Div ({
                innerHTML:this.data.graphlabels[i].text,
                container:this.graphLayer,
                x:(this.data.graphlabels[i].x + this.graphLayer.w*0.13+170)*this.scaleFactorX,
                y:(this.data.yaxis.end - this.data.graphlabels[i].y + this.graphLayer.h*0.1 + 50)*this.scaleFactorY,
                w:80,
                h:30,
                style:'text-align:left; font-family:Arial; font-size:12px'
            });
            */
           /*
           this['labelDivFixed'+i] = new OU.util.Div ({
                innerHTML:this.data.graphlabels[i].text,
                container:this.graphLayer,
                x:this.data.graphlabels[i].x*this.scaleFactorX + this.graphLayer.w*0.13,
                y:(this.data.yaxis.end - this.data.graphlabels[i].y)*this.scaleFactorY + this.graphLayer.h*0.07,
                w:80,
                h:30,
                style:'text-align:left; font-family:Arial; font-size:12px'
            });
            */
            ctx.fillText(this.data.graphlabels[i].text,this.data.graphlabels[i].x*this.scaleFactorX,-this.data.graphlabels[i].y*this.scaleFactorY);
        }
        
        // call function to draw the user moveable lines
        this.renderMovingLinesWithInfo();
    };
    
    OU.activity.GraphDragLineEndPointsActivity.prototype.renderMovingLinesWithInfo = function(startOrEnd) {
        var ctx = this.lineMoveLayer.context,gd = this.graphData,xTrans,yTrans;
        var ctxPoints = this.pointsLayer.context;
        ctx.save();
        ctxPoints.save();
        ctx.clearRect(0, 0, this.w, this.h);
        ctxPoints.clearRect(0, 0, this.w, this.h);
        ctx.beginPath();
        //ctx.rect(left, top, right, bottom);
        ctx.rect(this.lineMoveLayer.w*0.13, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*0.1, (this.data.xaxis.end-this.data.xaxis.start)*this.scaleFactorX, (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY);
        ctx.clip();
        /** This if statement will set zero x,y to the correct position if the axis have negative values */
        if (this.data.xaxis.start < 0) {
            xTrans = this.lineMoveLayer.w*0.13 + (0-this.data.xaxis.start)*this.scaleFactorX;
        } else {
            xTrans = this.lineMoveLayer.w*0.13;
        }
        if (this.data.yaxis.start < 0) {
            yTrans = (this.data.yaxis.end-this.data.yaxis.start-(0-this.data.yaxis.start))*this.scaleFactorY*1.1
        } else {
            yTrans = (this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY*1.1;
        }
        ctx.translate(xTrans, yTrans);
        ctxPoints.translate(xTrans, yTrans);
        // draw the moveable line
        ctx.strokeStyle=this.data.linemovecolour;
        ctx.lineWidth=2;
        ctx.textAlign = 'left';
        ctx.font='12px Arial';
        ctx.beginPath();
        ctx.moveTo((this.data.linemove[0].x)*this.scaleFactorX,-(this.data.linemove[0].y)*this.scaleFactorY);
        ctx.lineTo((this.data.linemove[1].x)*this.scaleFactorX,-(this.data.linemove[1].y)*this.scaleFactorY);
        ctx.stroke();
        ctxPoints.beginPath();
        ctxPoints.arc((this.data.linemove[0].x)*this.scaleFactorX, -(this.data.linemove[0].y)*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
        ctxPoints.arc((this.data.linemove[1].x)*this.scaleFactorX, -(this.data.linemove[1].y)*this.scaleFactorY, 3, 0, 2 * Math.PI, false);
        ctxPoints.fillStyle = "#000000";
        ctxPoints.fill();
        ctxPoints.lineWidth = 1;
        ctxPoints.strokeStyle = "black";
        // add text lables for the lines, which move with the lines as they're dragged
        // if it already exists, move it
        /*
        if (this['labelDiv'+0]) {
            if ((this.data.yaxis.end - this.data.linemove[1].y + this.graphLayer.h*0.1)*this.scaleFactorY > (this.graphLayer.w*0.1)*this.scaleFactorX) {
                this['labelDiv'+0].resize({
                    x:(this.data.linemove[1].x-20 + this.graphLayer.w*0.13 -80)*this.scaleFactorX,
                    y:(this.data.yaxis.end - this.data.linemove[1].y + this.graphLayer.h*0.1)*this.scaleFactorY
                    });
            }
        } else {
            this['labelDiv'+0] = new OU.util.Div ({
                innerHTML:this.data.linemovelabels.initial[0].text,
                container:this.lineMoveLabelLayer,
                x:this.data.linemove[1].x*this.scaleFactorX + this.graphLayer.w*0.13,
                y:(this.data.yaxis.end - this.data.linemove[1].y)*this.scaleFactorY + this.graphLayer.h*0.07,
                w:80,
                h:20,
                style:'text-align:right; font-family:Arial; font-size:12px'
            });
        }
        */
        ctx.fillText(this.data.linemovelabels.initial[0].text,this.data.linemove[1].x*this.scaleFactorX + 6,-this.data.linemove[1].y*this.scaleFactorY);
        ctx.restore();
        ctxPoints.restore();
    };
    
    /** Calculate the intersect point of the user moved line and the fixed line */
    OU.activity.GraphDragLineEndPointsActivity.prototype.checkIntersect = function(line1x1,line1y1,line1x2,line1y2,line2x1,line2y1,line2x2,line2y2) {
        /**
        * This function get passed x,y of one end of first line, followed by x,y of its other end, followed by x,y of one end of second line,
        * followed by x,y of its other end. It will return the x,y point at which they intersect. Calculating the intersect point of two 2D lines
        * for use in DD209 HTML5 graph templates.
        * calcIntersect(line1x1,line1y1,line1x2,line1y2,line2x1,line2y1,line2x2,line2y2);
        * Doesn't matter what order the ends are of the lines as long as they are together, ie don't have line1 start, then line2 start, then line1 end...
        * x,y--------------x,y followed by x,y--------------x,y 
        */
        // Denominator for ua and ub are the same, so store this calculation
        var d = (line2y2 - line2y1) * (line1x2 - line1x1) - (line2x2 - line2x1) * (line1y2 - line1y1);
        //n_a and n_b are calculated as seperate values for readability
        var n_a = (line2x2 - line2x1) * (line1y1 - line2y1) - (line2y2 - line2y1) * (line1x1 - line2x1);
        var n_b = (line1x2 - line1x1) * (line1y1 - line2y1) - (line1y2 - line1y1) * (line1x1 - line2x1);
        // Make sure there is not a division by zero - this also indicates that the lines are parallel. If n_a and n_b were both equal to zero 
        // the lines would be on top of each other (coincidental).  This check is not done because it is not necessary for this implementation 
        // (the parallel check accounts for this).
        if (d == 0) {
            if (window.console) {
                //console.log('lines are parallel, so don\'t cross');
            }
            return false;
        }
        // Calculate the intermediate fractional point that the lines potentially intersect.
        var ua = n_a / d;
        var ub = n_b / d;
        // The fractional point will be between 0 and 1 inclusive if the lines
        // intersect.  If the fractional calculation is larger than 1 or smaller
        // than 0 the lines would need to be longer to intersect.
        var ptIntersectionX = line1x1 + (ua * (line1x2 - line1x1));
        var ptIntersectionY = line1y1 + (ua * (line1y2 - line1y1));
        if (this.data.intersectpoint.roundnearest && this.data.intersectpoint.roundnearest>1) {
            return([Math.round(ptIntersectionX/this.data.intersectpoint.roundnearest)*this.data.intersectpoint.roundnearest,Math.round(ptIntersectionY/this.data.intersectpoint.roundnearest)*this.data.intersectpoint.roundnearest]);
        } else {
            return([Math.round(ptIntersectionX),Math.round(ptIntersectionY)]);
        }
        //return true;
    }
    
    /** Calculate and return the slope direction of the line left by user */
    OU.activity.GraphDragLineEndPointsActivity.prototype.calcSlope = function(x1,y1,x2,y2, valueOrDirection) {
        var slope = 0;
        var directionOfSlope = '';
        // Make sure you use the lowest x value as x1 and its corresponding y as y1
        if (x1 >= x2) {
            slope = (y2-y1) / (x2-x1);
        } else {
            slope = (y1-y2) / (x1-x2);
        }
        // Use the value of the line's slope to determine its direction
        if ((slope>0) && (slope!=Number.POSITIVE_INFINITY)){
            // upward slope has value greater than 0 but not infinity
            directionOfSlope = 'upward';
        } else if ((slope<0) && (slope!=Number.NEGATIVE_INFINITY)){
            // downward slope has value less than 0 but not minus infinity
            directionOfSlope = 'downward';
        } else if (slope == 0) {
            // flat horizontal slope has vale of 0
            directionOfSlope = 'horizontal';
        } else {
            // straight upright vertical will have value of infinity or minus infinity
            directionOfSlope = 'vertical';
        }
        //console.log('slope = '+slope);
        //return slope;
        if (valueOrDirection == 'direction') {
            return directionOfSlope;
        } else if (valueOrDirection == 'value') {
            return Math.round(slope*100)/100;
        }
    }
    
    
    /**
     * accessibleView - this function is called instead of canvasView if the browser does not support HTML5 canvas
     */
    OU.activity.GraphDragLineEndPointsActivity.prototype.accessibleView = function() {
        OU.activity.GraphDragLineEndPointsActivity.superClass_.accessibleView.call(this); // call the superclass method is you want to extend it, remove this line to override the method instead

    // Note this function can be removed or commented out if you want to use the default accessibleView method

    // *Your code starts here*
    };
    /**
     * resize - called whenever the outer bounds of the activity change, ie when the browser window is resized, or a mobile device is rotated.
     *
     * This function should do the following:
     * <ul>
     * <li>Resize all visible elements</li>
     * <li>Re-layout all visible elements</li>
     * <li>Actually re-render the current view of the activity</li>
     * </ul>
     */
    OU.activity.GraphDragLineEndPointsActivity.prototype.resize = function() {
        OU.activity.GraphDragLineEndPointsActivity.superClass_.resize.call(this); // call the superclass resize

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        if (this.h > this.w){
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
            this.lineMoveLabelLayer.resize({
                x:0,
                y:0,
                w:this.w,
                h:this.w
            });
        } else {
            this.graphLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
            this.lineMoveLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
            this.lineMoveLabelLayer.resize({
                x:0,
                y:0,
                w:this.h,
                h:this.h
            });
        }
        //this.graphLayer.resize({x:0,y:0,w:this.w,h:this.h});
        // this.lineMoveLayer.resize({x:0,y:0,w:this.w,h:this.h});
        this.textInfoLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.pointsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        this.labelsLayer.resize({
            x:0,
            y:0,
            w:this.w,
            h:this.h
        });
        // work out the scaleFactor for sizing and rendering everything
        
        if (this.graphLayer.h > this.graphLayer.w) {
            this.scaleFactorX = (this.graphLayer.w * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
            this.scaleFactorY = (this.graphLayer.w * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        } else {
            this.scaleFactorX = (this.graphLayer.h * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
            this.scaleFactorY = (this.graphLayer.h * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        }
        /*
        var yscale = (this.graphLayer.h * 0.8) / (this.data.yaxis.end - this.data.yaxis.start);
        var xscale = (this.graphLayer.w * 0.8) / (this.data.xaxis.end - this.data.xaxis.start);
        if (yscale > xscale) {
            this.scaleFactor = xscale;
        } else {
            this.scaleFactor = yscale;
        }
        */
        // reposition the button layer
        this.buttonsLayer.resize({
            x:(this.data.xaxis.end+(-this.data.xaxis.start))*this.scaleFactorX,
            y:((this.data.yaxis.end-this.data.yaxis.start)*this.scaleFactorY)+(this.data.yaxis.end*this.scaleFactorY*0.2)-10,
            w:this.data.submitbutton.w,
            h:this.data.submitbutton.h
        });
        this.feedbackText.resize({
            x:30,
            y:(this.data.yaxis.end*this.scaleFactorY)+(this.data.yaxis.end*this.scaleFactorY*0.2)+this.data.submitbutton.h,
            w:this.w-60,
            h:40
        });
        this.render();
        
        if (!this.activityIsActive) {
            this.renderCorrectAnswer();
        }
    //
    };

    /**
     * remove - called when the activity is being removed by a controller.
     *
     * This function should do the following:
     * <ul>
     * <li> Remove any elements that may remain in memory</li>
     * <li> Stop any animation loops, including killing any Intervals </li>
     * </ul>
     * You do not need to remove most library elements, such as Layers, Divs, etc. as they are removed automatically
     */
    OU.activity.GraphDragLineEndPointsActivity.prototype.remove = function() {
        OU.activity.GraphDragLineEndPointsActivity.superClass_.remove.call(this); // call the superclass remove

    // *Your removal code here*
    // If you have nothing to remove, then this function can be deleted or commented out
    };

    // call the superclass's constructor
    OU.base(this,data,instance,controller);
};
// Call our inherits function to implement the class inheritance
OU.inherits(OU.activity.GraphDragLineEndPointsActivity,OU.util.Activity);
