/**
 * OU.activity.ChemicalBalancerMenu Object
 * @fileOverview Chemical Equation Balancer Activity
 * @param {JSON array} data Data as included in the data/data.js file
 *
 * @author Martin Donnelly
 * @modified Nigel Clarke <nigel.clarke@pentahedra.com>
 */
OU.require('OU.util.DynText', '../library/js/util/dynText.js');
OU.require('OU.util.Button', '../library/js/util/button.js');
OU.require('OU.util.Layer', '../library/js/util/layer.js');
/**
 * @constructor
 * @param data
 * @param instance
 * @param controller
 * @extends OU.util.Activity
 */
OU.activity.ChemicalBalancerMenu=function ( data, instance, controller ){
    OU.activity.ChemicalBalancerMenu.prototype.canvasView=function (){
        this.clickable=new OU.util.TypedArray();
        this.totalScore=0;
        this.doRender=true;
        this.hitBoxes=[];
        this.fontSize=60;
        this.font=null;
        this.charged=false;
        this.tbh=40 * OU.dpr;
        this.displayLayer=new OU.util.Layer({
            container:this,
            hasEvents:true,
            id:'b_front'
        });
        this.fontface="league,san-serif";
        this.defineAreas();
        this.currentLevel=0;
        this.checkSaveData();
        this.processLoadedData();
    };
    /**
     *
     */
    OU.activity.ChemicalBalancerMenu.prototype.processLoadedData=function (){
        var unlocked=1, i;
        for (i=0; i<OU.saveData.completedLevels.length; i++) {
            if (OU.saveData.completedLevels[i]==OU.saveData.completedSections[i].length)
                unlocked=i + 2;
        }
        OU.saveData.unlocked=unlocked;
        OU.util.exportSaveData();
    };
    /**
     *
     */
    OU.activity.ChemicalBalancerMenu.prototype.fixBackground=function (){
        this.controller.bgLayer.context.drawImage(OU.preLoadImg[1], 0, 0, this.controller.bgLayer.w, this.controller.bgLayer.h);
    };
    /**
     *
     */
    OU.activity.ChemicalBalancerMenu.prototype.buildSaveData=function (){
        var saveData=this.data.save;
        OU.LocalStorage.save('ou.chembal.app', JSON.stringify(saveData));
        OU.saveData=saveData;
    };
    /**
     *
     * @return {*}
     */
    OU.activity.ChemicalBalancerMenu.prototype.checkSaveData=function (){
        var i, c, j,saveData=OU.LocalStorage.load('ou.chembal.app')||null;
        if (OU.saveData!=undefined&&OU.saveData!=null)
            return;
        if (saveData==undefined){
            this.buildSaveData();
        }
        else {
            OU.saveData=JSON.parse(saveData);
        }
        if (!OU.util.exportSaveData){
            OU.util.exportSaveData=function (){

                // quick rebuild of the completed levels..
                for (i=0; i<OU.saveData.completedLevels.length; i++) {
                    c=0;
                    for (j=0; j<OU.saveData.completedSections[i].length; j++) {
                        if (typeof OU.saveData.completedSections[i][j]=='object') c++;
                    }
                    OU.saveData.completedLevels[i]=c;
                }
                OU.LocalStorage.save('ou.chembal.app', JSON.stringify(OU.saveData));
            };
        }
        if (!OU.util.loadSaveData){
            OU.util.loadSaveData=function (){
                saveData=OU.LocalStorage.load('ou.chembal.app')||null;
                if (saveData!==undefined) OU.saveData=JSON.parse(saveData);
            };
        }
    };
    /**
     *
     */
    OU.activity.ChemicalBalancerMenu.prototype.remove=function (){
        OU.activity.ChemicalBalancerMenu.superClass_.remove.call(this); // call the superclass method
        this.displayLayer.remove();
        delete this.displayLayer;
        delete this.clickable;
        delete this.data;
    };
    /**
     * Defines the layout depending on the rotation of the device
     */
    OU.activity.ChemicalBalancerMenu.prototype.defineAreas=function (){
        this.areas={
            menu:{
                x:0,
                y:0,
                w:this.w,
                h:this.h
            }
        };
    };
    /**
     * Handles the touch event
     * @param {object} p Contains {x,y,context,w,h,execute,item}
     */
    OU.activity.ChemicalBalancerMenu.prototype.Marker=function ( p ){
        this.mX=p.x;
        this.mY=p.y;
        this.ctx=p.context;
        this.mW=p.w;
        this.mH=p.h;
        this.execute=p.execute;
        this.item=p.item;
        this.clickable=this.ctx.canvas.events.clickable;
        /**
         * Checks the location of the hit on the screen
         * @param x
         * @param y
         * @param pressed
         * @param events
         */
        if (OU.activity.ChemicalBalancerMenu.prototype.Marker.prototype.isHit==undefined){
            OU.activity.ChemicalBalancerMenu.prototype.Marker.prototype.isHit=function ( x, y, pressed, events ){
                var self=this;
                if ((pressed )&&((x>=self.mX)&&(x<=self.mX + self.mW) )&&((y>=self.mY)&&( y<=self.mY + self.mH))){
                    events.flush();
                    self.execute(self.item);
                }
            };
        }
    };
    /**
     * Called automatically when window is resized / rotated..
     */
    OU.activity.ChemicalBalancerMenu.prototype.resize=function (){
        OU.activity.ChemicalBalancerMenu.superClass_.resize.call(this); // call the parent class resize
        this.displayLayer.resize();
        this.redraw();
    };
    /**
     *
     */
    OU.activity.ChemicalBalancerMenu.prototype.redraw=function (){
        this.defineAreas();
        this.fixBackground();
        this.displayTopBar();
        if(OU._chemAppIntroTextDone) {
            // we need to select a level
            this.levelSelect();
        }
        else {
            this.introText();
        }
    };
    /**
     *
     */
    OU.activity.ChemicalBalancerMenu.prototype.introText=function (){
        var pad=60*OU.dpr,self=this,
        bW=this.w*0.2, bH=OU.controlHeight*2;

        if(this.introTextDiv) {
            this.introTextDiv.resize({
                x: this.x+pad,
                y: this.y+pad+this.tbh,
                w: this.w-pad*2,
                h: this.h-pad*2-this.tbh
            });
        }
        else {
            this.introTextDiv = new OU.util.Div({
                container: this,
                innerHTML: this.data.introHtml,
                style:'text-align:left',
                x: this.x+pad,
                y: this.y+pad+this.tbh,
                w: this.w-pad*2,
                h: this.h-pad*2-this.tbh
            });
        }

        if(this.introLayer) {
            this.introLayer.resize({
                x:this.x,
                y:this.y,
                w:this.w,
                h:this.h
            });
        }
        else {
            this.introLayer = new OU.util.Layer({
                container:this,
                x:this.x,
                y:this.y,
                w:this.w,
                h:this.h,
                hasEvents:true
            });
        }

        if(this._introStartButton) {
            this._introStartButton.render({
                x:this.w-bW-pad,
                y:this.h-pad*2-bH,
                w:bW,
                h:bH
            });
        }
        else {
            this._introStartButton = new OU.util.ControlButton({
                txt:"START",
                x:this.w-bW-pad,
                y:this.h-pad*2-bH,
                w:bW,
                h:bH,
                layer:this.introLayer,
                onClick:function ( ) {
                    self.removeIntro();
                    self.redraw();
                },
                fontSize:bH/2,
                fontFamily: this.fontface,
                fontWeight:'bold',
                colour:'#222',
                background: {
                    img: OU.preLoadImg[6]
                }
            });
        }
    };
    OU.activity.ChemicalBalancerMenu.prototype.removeIntro=function (){
        this._introStartButton.remove();
        this.introLayer.remove();
        this.introTextDiv.remove();
        this.introTextDiv=this.introLayer=this._introStartButton=null;
        OU._chemAppIntroTextDone=true;
    };
    /**
     *
     * @param i
     */
    OU.activity.ChemicalBalancerMenu.prototype.setLevel=function ( i ){
        this.currentLevel=i;
        this.controller.chgSection(i);
    };
    /**
     *
     * @param lvl
     * @param x
     * @param y
     * @param w
     * @param h
     */
    OU.activity.ChemicalBalancerMenu.prototype.levelMarker=function ( lvl, x, y, w, h ){
        var self=this, l=this.displayLayer, ctx=l.context, clickable=l.events.clickable, fontface=this.fontface;
        var pd=3, px=x + (w / pd), py=y - (((w / pd) * 0.45) / 2), pw=w / pd, ph=(w / pd) * 0.45, Eh;
        var st, unlocked=5;
        if (lvl<=OU.saveData.unlocked) unlocked=0;
        Eh=w * 0.466;
        if (lvl==6)
            unlocked=0;
        else {
            st=OU.saveData.completedLevels[lvl - 1] + " / " + OU.saveData.completedSections[lvl - 1].length;
        }
        unlocked=0; // override locks, so they don't show
        if (unlocked===0){
            ctx.drawImage(OU.preLoadImg[6 + lvl + unlocked], x, y, w, Eh);
            if (lvl!=6){
                ctx.drawImage(OU.preLoadImg[21], px, py, pw, ph);
                new OU.util.DynText({
                    txt:st,
                    x:px,
                    y:py - (OU.dpr),
                    w:pw,
                    h:ph,
                    fontSize:ph * 0.6,
                    context:ctx,
                    colour:"rgba(0,0,0,0.5)",
                    align:'center',
                    measureOnly:false,
                    noBreak:true,
                    fontFamily:fontface
                });
                new OU.util.DynText({
                    txt:st,
                    x:px,
                    y:py,
                    w:pw,
                    h:ph,
                    fontSize:ph * 0.6,
                    context:ctx,
                    colour:'#fff',
                    align:'center',
                    measureOnly:false,
                    noBreak:true,
                    fontFamily:fontface
                });
            }
            clickable.push(new this.Marker({
                x:x,
                y:y,
                w:w,
                h:h,
                context:ctx,
                isclicked:false,
                execute:function (){
                    self.setLevel(lvl);
                }
            }));
        }
        else {
            ctx.drawImage(OU.preLoadImg[6 + lvl], x, y, w, Eh);
            ctx.drawImage(OU.preLoadImg[20], x + ((w - Eh) / 2), y, Eh, Eh);
        }
    };
    /**
     *
     */
    OU.activity.ChemicalBalancerMenu.prototype.levelSelect=function (){
        var l=this.displayLayer, ctx=l.context, fontface=this.fontface,
        bw=this.w * 0.9, bh=(this.h - this.tbh) * 0.9, bx=(this.w - bw) / 2, by=this.tbh + ((this.h - this.tbh - bh) / 2), hh=bh / 2,
        zH=(hh / 2) * 0.70, os=(((hh / 2) - zH)) / 2, y1=by + (hh / 2) + os, y2=by + hh + os, zW=zH / 0.466, zW2=zW / 2,
        zx2=(this.w / 2) - (zW2),self=this,
        zx1=zx2 - (zW + (10 * OU.dpr)), zx3=zx2 + (zW + (10 * OU.dpr)),
        zx4=(this.w / 2) - (zW + (5 * OU.dpr)), zx5=(this.w / 2) + (5 * OU.dpr);
        new OU.util.DynText({
            txt:'SELECT YOUR LEVEL',
            x:bx,
            y:by - OU.dpr,
            w:bw,
            h:bh * 0.2,
            fontSize:bh * 0.2,
            context:ctx,
            colour:'rgba(0,0,0,0.5)',
            align:'center',
            measureOnly:false,
            noBreak:true,
            fontFamily:fontface
        });
        new OU.util.DynText({
            txt:'SELECT YOUR LEVEL',
            x:bx,
            y:by + OU.dpr,
            w:bw,
            h:bh * 0.2,
            fontSize:bh * 0.2,
            context:ctx,
            colour:'rgba(255,255,255,0.5)',
            align:'center',
            measureOnly:false,
            noBreak:true,
            fontFamily:fontface
        });
        new OU.util.DynText({
            txt:'SELECT YOUR LEVEL',
            x:bx,
            y:by,
            w:bw,
            h:bh * 0.2,
            fontSize:bh * 0.2,
            context:ctx,
            colour:'#fff',
            align:'center',
            measureOnly:false,
            noBreak:true,
            fontFamily:fontface
        });
        this.levelMarker(1, zx1, y1, zW, zH);
        this.levelMarker(2, zx2, y1, zW, zH);
        this.levelMarker(3, zx3, y1, zW, zH);
        this.levelMarker(4, zx4, y2, zW, zH);
        this.levelMarker(5, zx5, y2, zW, zH);
    };
    /**
     *
     */
    OU.activity.ChemicalBalancerMenu.prototype.displayTopBar=function (){
        var ctx=this.displayLayer.context, area=this.areas.menu,
        vpos3=(this.tbh - (32 * OU.dpr)) / 2,self=this;
        ctx.drawImage(OU.preLoadImg[29], area.x, area.y, area.w, this.tbh);
//        ctx.drawImage(OU.preLoadImg[26], this.w - (35 * OU.dpr), (2 * OU.dpr), 29 * OU.dpr, 35 * OU.dpr);

        if(OU._chemAppIntroTextDone) {
            ctx.drawImage(OU.preLoadImg[39], 10 * OU.dpr, vpos3, 68.5 * (OU.dpr), 32 * (OU.dpr));
            this.displayLayer.events.clickable.push(new this.Marker({
                x:10 * OU.dpr,
                y:vpos3,
                w:68.5 * (OU.dpr),
                h:32 * (OU.dpr),
                context:ctx,
                isclicked:false,
                execute:function (){
                    OU._chemAppIntroTextDone=false;
                    self.resize();
                }
            }));
        }
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.ChemicalBalancerMenu, OU.util.Activity);


