/**
 * @fileoverview  Controller Activity
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */
OU.require('OU.util.Controller');
OU.require('OU.util.Button');
OU.require('OU.util.DynText');
OU.require('OU.util.Layer');
OU.require('OU.util.Div');
OU.require('OU.util.Menu');
OU.require('OU.util.Instruction');
/**
 * The original sequential style controller extends the base OU.util.Controller class
 *
 * @class
 * @extends OU.util.Controller
 */
OU.activity.Controller = function ( controllerData, instance, controller ) { //NOTE: controllerData is intentionally not called data, so as not to be confused with the global variable data, that we use to load activity data.
    OU.activity.Controller.prototype.canvasView = function () {
        OU.activity.Controller.superClass_.canvasView.call(this); // call the parent class canvasView
        var bH = OU.controlHeight;
        this.useControlBar = this.data.controlBar===false ? false : true;
        if (!this.useControlBar)
            this.useNextPrev = false;
        else
            this.useNextPrev = this.data.sequentialButtons===false ? false : true;
        if (this.useControlBar) {
            this.controlLayer = new OU.util.Layer({
                dontRegister:this.baseController,
                x:this.x,
                y:this.y + this.h - bH,
                w:this.w,
                h:bH,
                zIndex:OU.CONTROLLER_LEVEL - 1,
                container:this,
                hasEvents:true,
                themeClass:"OUcontrolBar"
            });
            this.footerHeight = bH;
        }
    };
    /**
     *
     */
    OU.activity.Controller.prototype.resize = function () {
        OU.activity.Controller.superClass_.resize.call(this); // call the parent class resize
        var bH = OU.controlHeight;
        if (this.useControlBar) {
            this.controlLayer.resize({
                x:this.x,
                y:this.y + this.h - bH,
                w:this.w,
                h:bH
            });
            this.render();
        }
    };
    /**
     *
     */
    OU.activity.Controller.prototype.remove = function () {
        OU.activity.Controller.superClass_.remove.call(this); // call the parent class remove
        if (this.controller!==undefined) {
            if (this.useControlBar) {
                this.controlLayer.remove();
            }
        }
    };
    /** Renders the controller's bottom bar if required
     */
    OU.activity.Controller.prototype.render = function () {
        var ctx, bH = OU.controlHeight,
        self = this;
        if (!this.useControlBar)
            return;
        ctx = this.controlLayer.context;
        ctx.clearRect(0, 0, this.w, this.h);
        ctx.globalAlpha = 1;
        if (this.useNextPrev) {
            new OU.util.DynText({
                context:this.controlLayer.context,
                txt:(this.sectionNum + 1) + ' of ' + this.numSections,
                visiblePadding:.1,
                renderStyle:1,
                fontSize:20*OU.dpr,
                x:this.w - bH * 4,
                y:bH * .1,
                w:bH * 3,
                h:bH * .8,
                background:{
                    col:OU.theme.buttonBgCol, // - #ddd,
                    radius:3,
                    borderCol:OU.theme.buttonBorderCol
                },
                colour:'#fff'
            });
            if (this.sectionNum < 1)
                ctx.globalAlpha = 0.3;
            else
                ctx.globalAlpha = 1;
            if (this.leftButton) {
                this.leftButton.render({
                    x:this.w - bH * 4.9,
                    y:bH * .1,
                    w:bH * .8,
                    h:bH * .8
                });
            }
            else {
                this.leftButton = new OU.util.Button({
                    layer:this.controlLayer,
                    x:this.w - bH * 4.9,
                    y:bH * .1,
                    w:bH * .8,
                    h:bH * .8,
                    txt:'',
                    background:{
                        col:'#000',
                        radius:bH / 5,
                        borderCol:'#ccc'
                    },
                    glyph:{
                        type:'leftPlay',
                        align:'center',
                        w:bH * 0.5,
                        h:bH * 0.5,
                        x:this.w - (bH ),
                        y:bH * .1,
                        fore:'#ffffff',
                        back:'transparent'
                    },
                    colour:'#fff',
                    onClick:function () {
                        self.prevSection();
                    }
                });
            }
            if (this.sectionNum < this.numSections - 1)
                ctx.globalAlpha = 1;
            else
                ctx.globalAlpha = 0.3;
            if (this.rightButton) {
                this.rightButton.render({
                    x:this.w - bH * .9,
                    y:bH * .1,
                    w:bH * .8,
                    h:bH * .8
                });
            }
            else {
                this.rightButton = new OU.util.Button({
                    layer:this.controlLayer,
                    x:this.w - bH * .9,
                    y:bH * .1,
                    w:bH * .8,
                    h:bH * .8,
                    txt:'',
                    background:{
                        col:'#000',
                        radius:bH / 5,
                        borderCol:'#ccc'
                    },
                    glyph:{
                        type:'rightPlay',
                        align:'center',
                        w:bH * 0.5,
                        h:bH * 0.5,
                        x:this.w - bH * .9,
                        y:bH * .1,
                        fore:'#ffffff',
                        back:'transparent'
                    },
                    colour:'#fff',
                    onClick:function () {
                        self.nextSection();
                    }
                });
            }
        }
    };
    OU.base(this, controllerData, instance, controller);
};
if (OU.util.Controller) {
    OU.inherits(OU.activity.Controller, OU.util.Controller);
}
else {
    OU.preOnLoad.push(function () {
        OU.inherits(OU.activity.Controller, OU.util.Controller);
    });
}