/**
 * ElectronCloud - 2d display of H atom electron clouds
 *
 * @author Will Rawes
 */

OU.require('OU.util.Button');
OU.require('OU.util.Layer');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.ElectronCloud = function ( data, instance, controller ) {
    OU.activity.ElectronCloud.prototype.canvasView = function () {
        if (!OU.obj)OU.obj = [];
        OU.obj[this.instance] = this;
        this.n = 0;
        // Set up functions, RFns[], for drawing atomic shells  
        var i, j, c, aC = [], bC = [], cC = [], fC = [], sC = []
            , pCls = [
                // peak and trough parameters for atomic shells, n=2 to 7 see \\graphs in smoot\Archive\courses\sm358 HAtom
                [
                    [-0.3, 0.1, 1, 1],
                    [0.1, 1, 10, 1]
                ]
                ,
                [
                    [-0.3, 0.1, 1, 1],
                    [0.1, 0.37, 3.8, 0.24],
                    [0.37, 1.4, 6, 0.4]
                ]
                ,
                [
                    [-0.3, 0.1, 1, 4],
                    [0.1, 0.37, 3.8, 0.95],
                    [0.37, 0.8, 2, 0.45],
                    [0.8, 8, 2.5, 3]
                ]
                ,
                [
                    [-0.3, 0.1, 1, 4],
                    [0.1, 0.37, 3.8, 0.95],
                    [0.37, 0.8, 2, 0.45],
                    [0.8, 1.45, 1, 0.3],
                    [1.45, 6, 1.9, 1.1]
                ]
                ,
                [
                    [-0.3, 0.1, 1, 4],
                    [0.1, 0.37, 3.8, 0.95],
                    [0.37, 0.8, 2, 0.45],
                    [0.8, 1.45, 1, 0.3],
                    [1.45, 2.2, 1, 0.23],
                    [2.2, 8, 1.2, 0.85]
                ]
                ,
                [
                    [-0.3, 0.1, 1, 4],
                    [0.1, 0.37, 3.8, 0.95],
                    [0.37, 0.8, 2, 0.45],
                    [0.8, 1.45, 1, 0.3],
                    [1.45, 2.2, 1, 0.23],
                    [2.2, 3.3, 1, 0.2],
                    [3.3, 8, 1.1, 0.45]
                ]
            ]
            , cols = [], RFn
            , pk = function ( i, j, x ) {
                return (x < aC[i][j] ? 0 : (x > bC[i][j] ? 0 : sC[i][j] * Math.exp(-fC[i][j] * (x - aC[i][j])) * Math.sin((x - aC[i][j]) * cC[i][j])));
            }
            ;
        for (i = pCls.length; i--;) {
            aC[i] = [];
            bC[i] = [];
            cC[i] = [];
            fC[i] = [];
            sC[i] = [];
            for (j = pCls[i].length; j--;) {
                aC[i][j] = pCls[i][j][0];
                bC[i][j] = pCls[i][j][1];
                fC[i][j] = pCls[i][j][2];
                cC[i][j] = Math.PI / (pCls[i][j][1] - pCls[i][j][0]);
                sC[i][j] = pCls[i][j][3];
            }
        }
        this.RFns = [
            function ( x ) {
                return Math.exp(-17 * x);
            },
            function ( x ) {
                return pk(0, 0, x) - pk(0, 1, x);
            },
            function ( x ) {
                return pk(1, 0, x) - pk(1, 1, x) + pk(1, 2, x);
            },
            function ( x ) {
                return pk(2, 0, x) - pk(2, 1, x) + pk(2, 2, x) - pk(2, 3, x);
            },
            function ( x ) {
                return pk(3, 0, x) - pk(3, 1, x) + pk(3, 2, x) - pk(3, 3, x) + pk(3, 4, x);
            },
            function ( x ) {
                return pk(4, 0, x) - pk(4, 1, x) + pk(4, 2, x) - pk(4, 3, x) + pk(4, 4, x) - pk(4, 5, x);
            },
            function ( x ) {
                return pk(5, 0, x) - pk(5, 1, x) + pk(5, 2, x) - pk(5, 3, x) + pk(5, 4, x) - pk(5, 5, x) + pk(5, 6, x);
            }
        ];
        this.rGrads = [];
        for (i = 100; i--;) {
            c = (250 - i * 2.5) | 0;
            cols[i] = 'rgb(' + c + ',' + c + ',' + c + ')';
        }
        for (j = 7; j--;) {
            this.rGrads[j] = [];
            this.rGrads[j][0] = [0, cols[99]];
            RFn = this.RFns[j];
            var dr = 7.0 / 400
                , r = 0, v
                , rfx = Math.pow(RFn(0), 1) / (j===0 ? 170 : 17) / (j + 1);
            for (i = 400; i--;) {
                r += dr;
                v = (Math.pow(RFn(r) / rfx, 2)) | 0;
                if (v > 99)v = 99;
                this.rGrads[j].push([r / 7, cols[v]]);
            }
        }
        this.bBack = {col:'#444', radius:3, borderCol:'#888'};
        this.layer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            zIndex:OU.OVERLAY_CONTROLLER_LEVEL
        });
        this.layer.events.clickable.push(this);
        this.tlOffset = 0;
        this.zinp = false;
        this.zotp = false;
        this.initTimeline();
        var self = this;
        this.zInB = new OU.util.Button({
            txt:"+",
            layer:self.layer,
            padding:0,
            background:this.bBack,
            verticalPadding:0,
            onClick:function () {
                self.zinp = true;
                if (self.scale > 60)return;
                self.scale *= 1.1;
                self.render();
            }
        });
        this.zOutB = new OU.util.Button({
            txt:"–",
            padding:0,
            background:this.bBack,
            verticalPadding:0,
            layer:self.layer,
            onClick:function () {
                self.zotp = true;
                if (self.scale < 0.08)return;
                self.scale *= 1 / 1.1;
                self.render();
            }
        });
        this.extraH = (this.instance.indexOf("_6") > 0);
        this.extraB = new OU.util.Button({
            txt:(self.extraH ? "Hide H" : "Show H"),
            padding:0,
            verticalPadding:0,
            background:this.bBack,
            layer:self.layer,
            onClick:function () {
                if (!self.rExtraB)return;
                if (self.extraH) {
                    OU.obj["_act1_3"].hide();
                    self.moveEP(false);
                }
                else {
                    OU.obj["_act1_3"].show();
                    self.moveEP(true);
                }
            }
        });
        this.rExtraB = false;
        var act = this.instance;
        this.pageNum = act.substring(4, act.indexOf("_", 4));
        
        OU.obj["_act1_3"]=OU.obj["_act"+this.pageNum+"_"+(this.pageNum<9?"3":"6")];
        if (this.pageNum!=="1" && OU.obj["_act1_3"] && this.pageNum>8) {
            this.rExtraB = true;
            OU.obj["_act1_3"].rExtraB = true;
            OU.obj["_act1_3"].render();
            OU.obj["_act1_3"].hide();
        }
        this.resize();
    };
    OU.activity.ElectronCloud.prototype.moveEP = function ( mv ) {
        var n = OU.EPNum;//this.EPNum;
        if (n!=="1") {
            OU.obj["_act" + n + "_0"].moved = mv || false;
            OU.obj["_act" + n + "_0"].resize();
        }
    };
    OU.activity.ElectronCloud.prototype.hide = function () {
        this.visible = false;
        this.layer.events.pressed = false;
        this.click = false;
        this.layer.resize({
            x:-this.w
        });
        this.render();
    };
    OU.activity.ElectronCloud.prototype.show = function () {
        this.visible = true;
        this.click = false;
        if (OU.obj["_act1_1"]) OU.obj["_act1_1"].hide();
        if (OU.obj["_act1_2"]) OU.obj["_act1_2"].hide();
        this.layer.resize({
            x:this.w * 1.3
        });
        this.render();
    };
    OU.activity.ElectronCloud.prototype.resize = function () {
        var bs, by;
        OU.activity.ElectronCloud.superClass_.resize.call(this);
        this.layer.resize();
        bs = this.w / 7;
        by = this.h - bs - 4;
        if (OU.obj["_act1_3"] && this.rExtraB) OU.obj["_act1_3"].hide();
        this.zInB.resize({
            x:4,
            y:by,
            w:bs * 1.1,
            h:bs
        });
        this.zOutB.resize({
            x:bs * 1.3,
            y:by,
            w:bs,
            h:bs
        });
        this.extraB.resize({
            x:bs * 2.5,
            y:by,
            w:bs * 2.5,
            h:bs
        });
        this.render();
    };
    OU.activity.ElectronCloud.prototype.initTimeline = function () {
        var ctx = this.layer.context;
        ctx.textAlign = 'left';
        this.scale = 1.3;
        this.layer.resize();
        ctx.font = 'bold ' + this.fontSize + 'px ' + OU.theme.font;
    };
    this.c = 0;
    OU.activity.ElectronCloud.prototype.checkZoom = function () {
        var self = this;
        if (this.zinp===true) {
            this.zInB.onClick();
            setTimeout(function () {
                self.checkZoom()
            }, 100);
        }
        if (this.zotp===true) {
            this.zOutB.onClick();
            setTimeout(function () {
                self.checkZoom()
            }, 100);
        }
    };
    OU.activity.ElectronCloud.prototype.render = function () {
        var i, r, v, p, s, l,
            ctx = this.layer.context
            , w2 = this.w / 2, h2 = this.h / 2
            , w15 = w2 * 3
            , fs = (this.w / 30) | 0;
        this.layer.clear();
        ctx.lineWidth = 1;
        ctx.textAlign = 'center';
        ctx.font = '' + fs + 'pt ' + OU.theme.font;
        ctx.strokeStyle = '#000';
        ctx.moveTo(0, 150);
        ctx.beginPath();
        var cols = ctx.createRadialGradient(w2, h2, 0.01, w2, h2, w15);
        for (i = 0; i < this.rGrads[this.n].length; i++) {
            r = this.rGrads[this.n][i][0] * this.scale;
            if (r <= 1)cols.addColorStop(r, this.rGrads[this.n][i][1]);
        }
        ctx.stroke();
        ctx.fillStyle = cols;
        ctx.fillRect(0, 0, this.w, this.h);
        ctx.fillStyle = '#fff';
        ctx.fillRect(0, 0, this.w, this.h * 0.13);
        ctx.beginPath();
        ctx.strokeStyle = '#000';
        ctx.fillStyle = '#000';
        ctx.fillRect(w2 - 1, h2 - 1, 2, 2);
        ctx.lineWidth = 1;
        ctx.moveTo(this.w * 0.1, this.h * 0.09);
        ctx.lineTo(this.w * 0.9, this.h * 0.09);
        ctx.moveTo(this.w * 0.1, this.h * 0.06);
        ctx.lineTo(this.w * 0.1, this.h * 0.12);
        ctx.moveTo(this.w * 0.9, this.h * 0.06);
        ctx.lineTo(this.w * 0.9, this.h * 0.12);
        v = 4e-10 / this.scale * this.data.mult;
        p = (Math.log(v) / Math.log(10)) | 0;
        s = "" + ((((v * 100 / Math.pow(10, p))) | 0) / 10) + " x 10";
        ctx.font = 'normal ' + fs + 'pt ' + OU.theme.font;
        ctx.textAlign = 'right';
        var xp = this.w * 0.6;
        ctx.fillText(s, xp, this.h * 0.06);
        ctx.textAlign = 'left';
        ctx.font = 'normal ' + (fs * 0.8) + 'pt ' + OU.theme.font;
        ctx.fillText("" + p, xp, this.h * 0.06 - fs / 2);
        ctx.font = 'normal ' + (fs) + 'pt ' + OU.theme.font;
        ctx.fillText("     m", xp, this.h * 0.06);
        ctx.fillText("   = " + (this.n + 1), this.w * 0.12, this.h * 0.06);
        ctx.font = 'italic ' + fs + 'pt ' + OU.theme.font;
        ctx.fillText("n", this.w * 0.12, this.h * 0.06);
        ctx.stroke();
        ctx.strokeStyle = '#ddd';
        ctx.beginPath();
        ctx.moveTo(0, 0);
        ctx.lineTo(0, this.layer.h - 1);
        ctx.lineTo(this.layer.w - 1, this.layer.h - 1);
        ctx.lineTo(this.layer.w - 1, 0);
        ctx.lineTo(0, 0);
        ctx.stroke();
        ctx.restore();
        this.zInB.render();
        this.zOutB.render();
        if (this.rExtraB)this.extraB.render();
        this.doRender = false;
    };
    OU.activity.ElectronCloud.prototype.shw = function () {
        var self = this;
        setTimeout(function () {
            self.shw()
        }, 500);
    };
    OU.activity.ElectronCloud.prototype.isHit = function ( x, y, evState ) {
        if (!this.click) {
            if (evState)this.click = this.layer.events.pressed;
        }
        if (evState===false) {
            this.zinp = false;
            this.zotp = false;
        }
        else this.checkZoom();
        this.render();
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.ElectronCloud, OU.util.Activity);
