/**
 * ElectronSpec - Displays a timeline / spectrum diagram
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 * @author Will Rawes
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Button');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.ElectronSpec = function ( data, instance, controller ) {
    OU.activity.ElectronSpec.prototype.canvasView = function () {
        if (!this.data.energies)return;
        if (!OU.obj)OU.obj = [];
        OU.obj[this.instance] = this;
        var i, self = this;
        this.specLayer = new OU.util.Layer({
            container:this,
            hasEvents:true,
            zIndex:OU.OVERLAY_CONTROLLER_LEVEL
        });
        this.energies = [];
        this.divBackground = '#fcfcfc';
        for (i = this.data.energies.length; i--;)this.energies[i] = this.data.energies[i] * this.data.EMult;
        this.tlOffset = 0;
        this.specLayer.events.clickable.push(this);
        this.initTimeline();
        this.bBack = {
            col:'#444',
            radius:3,
            borderCol:'#888'
        };
        this.click = false;
        this.zinp = false;
        this.zinp = false;
        this.zInB = new OU.util.Button({
            txt:"+",
            padding:0,
            visiblePadding:0,
            layer:self.specLayer,
            background:{
                col:this.bBack.col,
                radius:3,
                borderCol:'#888'
            },
            onClick:function () {
                self.zinp = true;
                if (self.scale > 1000)return;
                self.scale *= 1.1;
                self.render();
            }//*/
        });
        /*
         //        this.zInB.layer.events.touchUp=function(){console.log("U");};
         //this.zInB.layer.events.trigger=function(){};
         this.zInB.onClick=function(ev){
         console.log(""+self.zinp);
         if(self.zinp)setTimeout("OU.rep.onClick("+ev+")",500);
         self.zinp=true;
         if(self.scale>1000)return;
         self.scale*=1.1;
         self.render();
         OU.rep=this;
         }*/
        this.sMin = this.w / 600 * 9 / (this.data.endScale / 60);
        this.zOutB = new OU.util.Button({
            txt:"–",
            padding:0,
            verticalPadding:0,
            layer:self.specLayer,
            background:{
                col:this.bBack.col,
                radius:3,
                borderCol:'#888'
            },
            onClick:function () {
                self.zotp = true;
                if (self.scale < self.sMin)return;
                self.scale *= 1 / 1.1;
                self.render();
            }
        });
        this.emsn = true;
        this.emnB = new OU.util.Button({
            txt:"Emission",
            padding:0,
            verticalPadding:0,
            onOffIndicator:true,
            layer:self.specLayer,
            background:{
                col:this.bBack.col,
                radius:3,
                borderCol:'#888'
            },
            onClick:function () {
                if (self.emnB.params.onOff)return;
                self.emnB.params.onOff = !self.emnB.params.onOff;
                self.absB.params.onOff = !self.emnB.params.onOff;
                self.emsn = self.emnB.params.onOff;
                self.render();
            }
        });
        this.emnB.params.onOff = true;
        this.absB = new OU.util.Button({
            txt:"Absorption",
            padding:0,
            verticalPadding:0,
            onOffIndicator:true,
            layer:self.specLayer,
            background:{
                col:this.bBack.col,
                radius:3,
                borderCol:'#888'
            },
            onClick:function () {
                if (self.absB.params.onOff)return;
                self.absB.params.onOff = !self.absB.params.onOff;
                self.emnB.params.onOff = !self.absB.params.onOff;
                self.emsn = self.emnB.params.onOff;
                self.render();
            }
        });
        this.extraH = (this.instance.indexOf("_4") > 0);
        this.extraB = new OU.util.Button({
            txt:(self.extraH ? "Hide H" : "Show H"),
            padding:0,
            verticalPadding:0,
            layer:self.specLayer,
            background:{
                col:this.bBack.col,
                radius:3,
                borderCol:'#888'
            },
            onClick:function () {
                if (!self.rExtraB)return;
                else if (self.extraH) {
                    OU.obj["_act1_1"].hide();
                    OU.obj["_act" + self.pageNum + "_3"].moveEP(false);
                }
                else {
                    OU.obj["_act1_1"].show();
                    OU.obj["_act" + self.pageNum + "_3"].moveEP(true);
                }
            }
        });
        this.rExtraB = false;
        var act = this.instance;
        this.pageNum = act.substring(4, act.indexOf("_", 4));
//if(!OU.obj["_act1_1"])
        OU.obj["_act1_1"]=OU.obj["_act"+this.pageNum+"_"+(this.pageNum<9?"1":"4")];
        if (this.pageNum!=="1" && this.pageNum>8) {
            this.rExtraB = true;
            OU.obj["_act1_1"].rExtraB = true;
            OU.obj["_act1_1"].render();
            OU.obj["_act1_1"].hide();
        }
        ///if (this.pageNum!=="1")
        this.resize();
    };
    OU.activity.ElectronSpec.prototype.hide = function () {
        this.visible = false;
        this.specLayer.events.pressed = false;
        this.click = false;
        this.specLayer.resize({
            y:-this.h
        });
        this.render();
    };
    OU.activity.ElectronSpec.prototype.show = function () {
        this.visible = true;
        this.click = false;
        if (OU.obj["_act1_2"]) OU.obj["_act1_2"].hide();
        if (OU.obj["_act1_3"]) OU.obj["_act1_3"].hide();
        this.specLayer.resize({
            y:OU.obj["_act1_2"].y + this.h//*1.55
        });
        this.render();
    };
    OU.activity.ElectronSpec.prototype.checkZoom = function () {
        var self = this;
        if (this.zinp===true)this.zInB.onClick();
        if (this.zotp===true)this.zOutB.onClick();
        if (this.evState)setTimeout(function () {
            self.checkZoom()
        }, 100);
    };
    OU.activity.ElectronSpec.prototype.resize = function () {
        if (!this.specLayer)return;
        var bs, by;
        OU.activity.ElectronSpec.superClass_.resize.call(this);
        this.specLayer.resize();
        if (OU.obj["_act1_1"] && this.rExtraB) OU.obj["_act1_1"].hide();
        this.sMin = this.w / 600 * 9 / (this.data.endScale / 60);
        bs = this.h / 4;
        by = this.h - bs - 4;
        this.zInB.resize({
            x:4,
            y:by + bs * 0.1,
            w:bs * 1.2,
            h:bs * 0.8
        });
        this.zOutB.resize({
            x:bs * 1.3,
            y:by,
            w:bs * 1.2,
            h:bs
        });
        this.emnB.resize({
            x:bs * 2.5,
            y:by,
            w:bs * 3,
            h:bs
        });
        this.absB.resize({
            x:bs * 5.7,
            y:by,
            w:bs * 3,
            h:bs
        });
        this.extraB.resize({
            x:bs * 9,
            y:by,
            w:bs * 2.5,
            h:bs
        });
        this.render();
    };
    OU.activity.ElectronSpec.prototype.initTimeline = function () {
        var d = this.data,
            ctx = this.specLayer.context;
        ctx.font = 'bold ' + this.fontSize + 'px helvetica,ariel,sans';
        ctx.textAlign = 'left';
        this.scale = 40;
        this.specLayer.resize();
    };
    OU.activity.ElectronSpec.prototype.point = function ( v ) {
        return 15 + v * this.scale - this.tlOffset;
    };
    OU.activity.ElectronSpec.prototype.render = function () {
        var i, E,
            Es = this.energies,
            ctx = this.specLayer.context,
            cols,
            x = this.x + 25, xe, s0, se, ox, x0,
            hh = this.specLayer.h / 3, hh2 = hh / 2,
            y=hh,
            v, dv, dv0, l,
            s,
            dvs = [0.02, 0.05, 0.1, 0.2, 0.5, 1, 2, 5, 10, 50],
            fontS=(hh/5)|0
            ;
        this.specLayer.clear();
        ctx.fillStyle = this.divBackground;
        ctx.fillRect(0, 0, this.specLayer.w, this.specLayer.h);
        ctx.strokeStyle = '#ddd';
        ctx.beginPath();
        ctx.moveTo(0, 0);
        ctx.lineTo(0, this.specLayer.h - 1);
        ctx.lineTo(this.specLayer.w - 1, this.specLayer.h - 1);
        ctx.lineTo(this.specLayer.w - 1, 0);
        ctx.lineTo(0, 0);
        ctx.stroke();
        x0 = this.point(this.data.startScale);
        xe = this.point(this.data.endScale);
        ctx.save();
        ctx.fillStyle = this.data.bgCol;
        ctx.fillRect(x0, y, xe - x0, hh);
        ctx.beginPath();
        s0 = this.point(1.7);
        se = this.point(3.2);
        cols = ctx.createLinearGradient(s0, 50, se, 50);
        cols.addColorStop(0, this.data.bgCol);
        cols.addColorStop((1.8 - 1.7) / 1.5, '#f00');
        cols.addColorStop((2.15 - 1.7) / 1.5, '#ff0');
        cols.addColorStop((2.3 - 1.7) / 1.5, '#0f0');
        cols.addColorStop((2.6 - 1.7) / 1.5, '#00f');
        cols.addColorStop((3.1 - 1.7) / 1.5, '#a0a');
        cols.addColorStop(1, this.data.bgCol);
        ctx.fillStyle = cols;
        ctx.fillRect(s0, y, se - s0, hh);
        ctx.strokeStyle = '#000';
        ctx.fillStyle = '#000';
        ctx.lineWidth = 1;
        ctx.textAlign = 'center';
        ctx.font = ''+fontS+'pt Arial';
        ctx.beginPath();
        ctx.moveTo(x0, y);
        ctx.lineTo(xe, y);
        dv = 0;
        for (i = 0; i < dvs.length; i++) {
            if (dv < fontS*4) {
                dv = this.point(dvs[i]) - this.point(0);
                dv0 = dvs[i];
            }
        }
        for (v = this.data.startScale; v <= this.data.endScale; v += dv0) {
            x = this.point(v);
            ctx.moveTo(x, y);
            ctx.lineTo(x, y - 5);
            ctx.fillText("" + ((v * 100 + 0.5) | 0) / 100, x, y - fontS);
        }
        ctx.stroke();
        ctx.fillStyle = '#f00';
        ctx.strokeStyle = '#000';
        ox = this.point(this.data.endScale) + 3;
        x0 = this.point(0);
        ctx.moveTo(x0, y + hh2);
        ctx.lineTo(ox, y + hh2);
        ctx.stroke();
        l = fontS/2;
        for (i = Es.length; i--;) {
            E = Es[i];
            x = this.point(E);
            if (this.emnB.params.onOff) {
                ctx.fillStyle = '#000';
                ctx.fillRect(x, y + 1, ox - x - 3, hh2);
                ox = x + 1;
                if (i==0)ctx.fillRect(x0, y + 1, ox - x0 - 3, hh2);
            }
            else {
                ctx.beginPath();
                ctx.strokeStyle = '#000';
                ctx.moveTo(x, y);
                ctx.lineTo(x, y + hh2);
                ctx.stroke();
            }
            if (i===this.line) {
                ctx.beginPath();
                ctx.strokeStyle = '#f00';
                ctx.fillStyle = '#f00';
                ctx.moveTo(x, y - 20);
                ctx.lineTo(x - 8, y - 28);
                ctx.lineTo(x + 8, y - 28);
                ctx.stroke();
                ctx.fill();
                ctx.beginPath();
                ctx.fillStyle = '#000';
                ctx.strokeStyle = '#ddd';
                ctx.moveTo(x, y - 20);
                ctx.lineTo(x, y - 0);
                ctx.stroke();
                ctx.font = 'normal '+fontS+'pt Arial';
                s = "= " + ((E * 100 + 0.5) | 0) / 100 + " eV";
                x += (x > this.specLayer.w / 2 ? -l*18 : 40);
                ctx.fillText(s, x + l*8, y - l*6);
                ctx.font = 'italic '+fontS+'pt Arial';
                ctx.fillText("E", x - 4*l , y - l*6);
                ctx.fillText("ph", x - 1*l , y - l*6+5);
            }
        }
        ctx.fillStyle = '#000';
        ctx.font = 'italic '+fontS+'pt Arial';
        ctx.fillText("E", this.w - l*17, l*3);
        ctx.font = 'normal '+fontS+'pt Arial';
        ctx.fillText("ph", this.w - l*14, l*3+5);
        ctx.fillText("/ eV", this.w - l*9, l*3);
        ctx.stroke();
        ctx.restore();
        if (this.rExtraB)this.extraB.render();
        this.emnB.background.col = (this.emnB.params.onOff===true ? "#8cf" : this.bBack.col);
        this.emnB.render();
        this.absB.background.col = (this.absB.params.onOff===true ? "#8cf" : this.bBack.col);
        this.absB.render();
        this.zInB.render();
        this.zOutB.render();
        this.doRender = false;
    };
    OU.activity.ElectronSpec.prototype.isHit = function ( x, y, evState ) {
        if (!this.click) {
            if (evState)this.click = this.specLayer.events.pressed;
        }
        if (evState===true && !this.evState) {
            this.evState = true;
            this.checkZoom();
        }
        if (evState===false) {
            this.evState = false;
            this.zinp = false;
            this.zotp = false;
        }
        if (y > this.specLayer.h * 0.6)return;
        var dX, Es = this.energies, i;
        if (!this.inDrag && evState) {
            for (i = Es.length; i--;) {
                if (Math.abs(x - this.point(Es[i])) < this.specLayer.h/20) {
                    this.line = i;
                    this.inDrag = false;
                    this.render();
                    return;
                }
            }
        }
        if (evState) {
            if (this.inDrag) {
                dX = x - this.dragStartX;
                this.tlOffset = this.tlOffset - dX;
                if (this.tlOffset < 0)
                    this.tlOffset = 0;
                if (this.tlOffset > this.maxOffset * 120)
                    this.tlOffset = this.maxOffset * 120;
                this.dragStartX = x;
                this.render();
            }
            else {
                this.dragStartX = x;
                this.inDrag = true;
            }
        }
        else {
            this.inDrag = false;
        }
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.ElectronSpec, OU.util.Activity);
