/**
 * @fileOverview Video with Cue points
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

OU.require('OU.util.Button');
OU.require('OU.util.DynText');
OU.require('OU.util.Div');
OU.require('OU.util.Layer');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.VideoCues = function(data,instance,controller) {

    OU.activity.VideoCues.prototype.canvasView = function() {
        /*this.bgLayer = new OU.util.Layer({
            container:this,
            hasEvents: true
        });
        this.bgLayer.context.gradRect(); // draw background on backdrop layer
        */
        this.subtitleson_ = OU.LocalStorage.load("OU.control.subtitlesOn")=='true' || false;

        this.cues = this.data.video.cues;
        if(this.cues) {
            this.cues.sort(function(a,b) {
                return b.start-a.start;
            });
        }
        this.initVideo();
    };
    OU.activity.VideoCues.prototype.resize = function() {
        OU.activity.VideoCues.superClass_.resize.call(this); // call the parent class resize

        /*this.bgLayer.resize();
        this.bgLayer.context.gradRect();
         */
        if(this.htmlDiv)
            this.htmlDiv.resize({
                x: this.x,
                y:this.y,
                w:this.w,
                h:this.h
            });

        if(this.subtitleDiv) {
            this.subtitleDiv.resize({
                x: OU.baseController.x+20,
                y: OU.baseController.y+OU.baseController.h*.8,
                w: OU.baseController.w-40,
                h: 'auto'
            });
        }
        if(this.transcriptDiv) {
            this.transcriptDiv.remove();
        }
    };
    OU.activity.VideoCues.prototype.remove = function() {
        OU.activity.VideoCues.superClass_.remove.call(this); // call the superclass method
        this.cues=null;
    };
    OU.activity.VideoCues.prototype.initVideo = function() {
        var i,v = this.data.video,self=this,videoElement,tHandle;
        v._w = (v.width || 640) * OU.dpr;
        v._h = (v.height || 360) * OU.dpr;

        if(this.htmlDiv) {
            this.htmlDiv.div.innerHTML="";
        }
        else {
            this.htmlDiv = new OU.util.Div({
                x: this.x,
                y:this.y,
                w:this.w,
                h:this.h,
                overflow:'auto',
                style:'padding:'+(10*OU.dpr)+'px',
                container:this
            });
        }
        if (this.data.html && this.data.html!='') {
            this.htmlDiv.div.innerHTML = this.data.html;
        }

        this.time=0;

        videoElement = document.createElement("video");
        videoElement.id = "_vid_" + this.instance;
        videoElement.width = v._w;
        videoElement.height = v._h;
        videoElement.controls = "controls";
        videoElement.autoplay = "autoplay";
        if (v.thumbnail!==undefined && v.thumbnail!="")
            videoElement.poster = v.thumbnail;
        for (i = v.sources.length; i--;) {
            var source = document.createElement('source');
            source.type = v.sources[i].type;
            source.src = this.dataDir + v.sources[i].src;
            videoElement.appendChild(source);
        }
        videoElement.load();
        this.htmlDiv.div.appendChild(videoElement);
        this.video = videoElement;
        this.video.play();

        this.video = videoElement;
        this.video.addEventListener("timeupdate", function() {
            self.timeUpdate();
        }, false);


        var clearLeftDiv = document.createElement('div');
        clearLeftDiv.setAttribute("style", "clear:left");
        this.htmlDiv.div.appendChild(clearLeftDiv);

        if(v.hasSubTitles) {
            var subButton = document.createElement('span');
            tHandle = function(ev) {
                var e=OU.combineMouseTouch(ev);
                if(e.pageX>0 && e.pageY>0) {
                    self.toggleSubtitles();
                }
            };
            subButton.setAttribute("id", "subtitleButton_");
            if(this.subtitleson_)
                subButton.setAttribute("class", "subtitleButton subtitlesOn");
            else
                subButton.setAttribute("class", "subtitleButton");
            subButton.setAttribute("title", "Toggle Subtitles");
            subButton.innerHTML="Subs";
            subButton.addEventListener("mousedown",tHandle , false);
            subButton.addEventListener("touchEnd",tHandle , false);
            clearLeftDiv.appendChild(subButton);
        }
        if(v.hasTranscript) {
            var transButton = document.createElement('span');
            tHandle = function() {
                self.toggleTranscript();
            };
            transButton.setAttribute("id", "transcriptButton_");
            transButton.setAttribute("class", "subtitleButton");
            transButton.setAttribute("title", "Open Transcript");
            transButton.innerHTML="Transcript";
            transButton.addEventListener("mousedown",tHandle , false);
            transButton.addEventListener("touchstart",tHandle , false);
            clearLeftDiv.appendChild(transButton);
        }

        this.watch();
    };
    OU.activity.VideoCues.prototype.toggleSubtitles = function (onoff) {
        var subButton = document.getElementById("subtitleButton_");
        this.subtitleson_=onoff===undefined?!this.subtitleson_:onoff;
        OU.LocalStorage.save("OU.control.subtitlesOn",this.subtitleson_);
        if(subButton) {
            if(this.subtitleson_)
                subButton.setAttribute("class", "subtitleButton subtitlesOn");
            else
                subButton.setAttribute("class", "subtitleButton");
        }
    };
    OU.activity.VideoCues.prototype.toggleTranscript = function () {
        var c,i,h="",self=this,tHandle,transButton;
        if(this.video==null) {
            this.initVideo();
        }
        else {
            if(this.cues) {
                for(i=this.cues.length; i--;) {
                    c=this.cues[i];
                    if(c.subtitle)
                        h = h + "<p>"+c.subtitle+"</p>";
                }
                if(h!="") {
                    this.htmlDiv.div.removeChild(this.video);
                    this.video=null;
                    this.htmlDiv.div.innerHTML="<h1>Transcript</h1><div style='padding-right: 20px;'>"+h+"</div>";

                    transButton = document.createElement('span');
                    tHandle = function() {
                        self.toggleTranscript();
                    };
                    transButton.setAttribute("id", "transcriptButton_");
                    transButton.setAttribute("class", "subtitleButton");
                    transButton.setAttribute("title", "Return to video");
                    transButton.setAttribute("style", "margin-bottom:20px;");
                    transButton.innerHTML="Return to video";
                    transButton.addEventListener("mousedown",tHandle , false);
                    transButton.addEventListener("touchstart",tHandle , false);
                    this.htmlDiv.div.appendChild(transButton);
                }
            }
        }
    };
    OU.activity.VideoCues.prototype.jumpTo = function(t) {
        this.video.currentTime = t;
    };
    OU.activity.VideoCues.prototype.watch = function() {
        var i,cues=this.cues,c,rc=null,t=this.time,self=this;
        if(!cues)
            return;
        for(i=cues.length; i--;) {
            c=cues[i];
            if(c.start<t) {
                rc=null;
                if (c.end===undefined || c.end>t)
                    rc = c;
            }
            if(c.start>t)
                i=0;
        }
        if(this.data.video.hasSubTitles && rc!=null) {
            if(this.subtitleson_ && rc.subtitle) {
                if(!this.subtitleDiv) {
                    this.subtitleDiv = new OU.util.Div({
                        container:this,
                        x: OU.baseController.x+20,
                        y: OU.baseController.y+OU.baseController.h*.8,
                        w: OU.baseController.w-40,
                        h: 'auto',
                        zIndex:OU.ABSOLUTE_TOP,
                        htmlClass:"OUSubtitles",
                        showScroll:false
                    });
                }
                this.subtitleDiv.div.innerHTML=rc.subtitle;
            }
            else if(this.subtitleDiv) {
                this.subtitleDiv.remove();
                this.subtitleDiv=undefined;
            }
        }
        setTimeout(function() {
            self.watch();
        },40);

    };
    OU.activity.VideoCues.prototype.timeUpdate = function() {
        this.time = this.video.currentTime;
    };
    OU.base(this,data,instance,controller);
};
OU.inherits(OU.activity.VideoCues,OU.util.Activity);