/*
 Highcharts JS v7.1.1 (2019-04-09)

 Accessibility module

 (c) 2010-2019 Highsoft AS
 Author: Oystein Moseng

 License: www.highcharts.com/license
*/
(function(g){"object"===typeof module&&module.exports?(g["default"]=g,module.exports=g):"function"===typeof define&&define.amd?define("highcharts/modules/accessibility",["highcharts"],function(m){g(m);g.Highcharts=m;return g}):g("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(g){function m(d,g,l,k){d.hasOwnProperty(g)||(d[g]=k.apply(null,l))}g=g?g._modules:{};m(g,"modules/accessibility/KeyboardNavigationHandler.js",[g["parts/Globals.js"]],function(d){function g(d,b){this.chart=d;this.keyCodeMap=
b.keyCodeMap||[];this.validate=b.validate;this.init=b.init;this.terminate=b.terminate;this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}var l=d.find;g.prototype={run:function(d){var b=d.which||d.keyCode,a=this.response.noHandler,c=l(this.keyCodeMap,function(a){return-1<a[0].indexOf(b)});c?a=c[1].call(this,b,d):9===b?a=this.response[d.shiftKey?"prev":"next"]:27===b&&(this.chart&&this.chart.tooltip&&this.chart.tooltip.hide(0),a=this.response.success);return a}};return g});m(g,"modules/accessibility/AccessibilityComponent.js",
[g["parts/Globals.js"]],function(d){function g(){}var l=d.win,k=l.document,b=d.merge,a=d.addEvent;g.prototype={initBase:function(a){this.chart=a;this.eventRemovers=[];this.domElements=[];this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9};this.hiddenStyle={position:"absolute",width:"1px",height:"1px",overflow:"hidden"}},addEvent:function(){var a=d.addEvent.apply(d,arguments);this.eventRemovers.push(a);return a},createElement:function(){var a=d.win.document.createElement.apply(d.win.document,
arguments);this.domElements.push(a);return a},cloneMouseEvent:function(a){if("function"===typeof l.MouseEvent)return new l.MouseEvent(a.type,a);if(k.createEvent){var b=k.createEvent("MouseEvent");if(b.initMouseEvent)return b.initMouseEvent(a.type,a.canBubble,a.cancelable,a.view,a.detail,a.screenX,a.screenY,a.clientX,a.clientY,a.ctrlKey,a.altKey,a.shiftKey,a.metaKey,a.button,a.relatedTarget),b;b=k.createEvent("Event");if(b.initEvent)return b.initEvent(a.type,!0,!0),b}},fakeClickEvent:function(a){if(a&&
a.onclick&&k.createEvent){var b=k.createEvent("Event");b.initEvent("click",!0,!1);a.onclick(b)}},createProxyButton:function(c,e,h,f,n){var p=c.element,d=this,k=this.createElement("button"),g=b({"aria-label":p.getAttribute("aria-label")},h);if(c=this.getElementPosition(f||c))return Object.keys(g).forEach(function(a){null!==g[a]&&k.setAttribute(a,g[a])}),b(!0,k.style,{"border-width":0,"background-color":"transparent",position:"absolute",width:(c.width||1)+"px",height:(c.height||1)+"px",display:"block",
cursor:"pointer",overflow:"hidden",outline:"none",opacity:.001,filter:"alpha(opacity\x3d1)","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity\x3d1)",zIndex:999,padding:0,margin:0,left:c.x+"px",top:c.y-this.chart.containerHeight+"px"}),n&&a(k,"click",n),["click","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(f){a(k,f,function(a){var b=d.cloneMouseEvent(a);if(p)if(b)p.fireEvent?p.fireEvent(b):p.dispatchEvent&&p.dispatchEvent(b);else if(p["on"+f])p["on"+f](a)})}),e.appendChild(k),
g["aria-hidden"]||this.unhideElementFromScreenReaders(k),k},getElementPosition:function(a){var b=a.element;if((a=this.chart.renderTo)&&b&&b.getBoundingClientRect)return b=b.getBoundingClientRect(),a=a.getBoundingClientRect(),{x:b.x-a.x,y:b.y-a.y,width:b.width,height:b.height}},addProxyGroup:function(a){var b=this.chart;b.a11yProxyContainer||(b.a11yProxyContainer=k.createElement("div"),b.a11yProxyContainer.style.position="relative");b.container.nextSibling!==b.a11yProxyContainer&&b.renderTo.insertBefore(b.a11yProxyContainer,
b.container.nextSibling);var c=this.createElement("div");Object.keys(a||{}).forEach(function(f){null!==a[f]&&c.setAttribute(f,a[f])});b.a11yProxyContainer.appendChild(c);return c},removeElement:function(a){a&&a.parentNode&&a.parentNode.removeChild(a)},unhideElementFromScreenReaders:function(a){a.setAttribute("aria-hidden",!1);a!==this.chart.renderTo&&a.parentNode&&(Array.prototype.forEach.call(a.parentNode.childNodes,function(a){a.hasAttribute("aria-hidden")||a.setAttribute("aria-hidden",!0)}),this.unhideElementFromScreenReaders(a.parentNode))},
destroyBase:function(){var a=this;this.removeElement((this.chart||{}).a11yProxyContainer);this.eventRemovers.forEach(function(a){a()});this.domElements.forEach(function(b){a.removeElement(b)});this.eventRemovers=[];this.domElements=[]},stripTags:function(a){return"string"===typeof a?a.replace(/<\/?[^>]+(>|$)/g,""):a},htmlencode:function(a){return a.replace(/&/g,"\x26amp;").replace(/</g,"\x26lt;").replace(/>/g,"\x26gt;").replace(/"/g,"\x26quot;").replace(/'/g,"\x26#x27;").replace(/\//g,"\x26#x2F;")},
init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){this.destroyBase()}};return g});m(g,"modules/accessibility/KeyboardNavigation.js",[g["parts/Globals.js"],g["modules/accessibility/KeyboardNavigationHandler.js"]],function(d,g){function l(a,b,f){this.init(a,b,f)}var k=d.merge,b=d.addEvent,a=d.win,c=a.document;l.prototype={init:function(a,h){var f=this;this.chart=a;this.components=h;this.modules=[];this.currentModuleIx=0;a.container.hasAttribute("tabIndex")||
a.container.setAttribute("tabindex","0");this.addExitAnchor();this.unbindKeydownHandler=b(a.renderTo,"keydown",function(a){f.onKeydown(a)});this.unbindMouseUpHandler=b(c,"mouseup",function(){f.onMouseUp()});this.update();this.modules.length&&this.modules[0].init(1)},update:function(a){var b=this.chart.options.accessibility,b=b&&b.keyboardNavigation,f=this.components;b&&b.enabled&&a&&a.length?this.modules=a.reduce(function(a,b){b=f[b].getKeyboardNavigation();return b.length?a.concat(b):(a.push(b),
a)},[new g(this.chart,{})]):(this.modules=[],this.currentModuleIx=0)},onMouseUp:function(){if(!(this.keyboardReset||this.chart.pointer&&this.chart.pointer.chartPosition)){var a=this.chart,b=this.modules&&this.modules[this.currentModuleIx||0];b&&b.terminate&&b.terminate();a.focusElement&&a.focusElement.removeFocusBorder();this.currentModuleIx=0;this.keyboardReset=!0}},onKeydown:function(b){b=b||a.event;var c,f=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];this.keyboardReset=
!1;if(f){var n=f.run(b);n===f.response.success?c=!0:n===f.response.prev?c=this.prev():n===f.response.next&&(c=this.next());c&&b.preventDefault()}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(a){var b=this.modules&&this.modules[this.currentModuleIx];b&&b.terminate&&b.terminate(a);this.chart.focusElement&&this.chart.focusElement.removeFocusBorder();this.currentModuleIx+=a;if(b=this.modules&&this.modules[this.currentModuleIx]){if(b.validate&&!b.validate())return this.move(a);
if(b.init)return b.init(a),!0}this.currentModuleIx=0;0<a?(this.exiting=!0,this.exitAnchor.focus()):this.chart.renderTo.focus();return!1},addExitAnchor:function(){var e=this.chart,h=this.exitAnchor=c.createElement("h6"),f=this,n=e.langFormat("accessibility.svgContainerEnd",{chart:e});h.setAttribute("tabindex","0");h.setAttribute("aria-label",n);h.setAttribute("aria-hidden",!1);k(!0,h.style,{position:"absolute",width:"1px",height:"1px",zIndex:0,overflow:"hidden",outline:"none"});e.renderTo.appendChild(h);
this.unbindExitAnchorUpdate=b(e,"render",function(){this.renderTo.appendChild(h)});this.unbindExitAnchorFocus=b(h,"focus",function(b){b=b||a.event;f.exiting?f.exiting=!1:(e.renderTo.focus(),b.preventDefault(),f.modules&&f.modules.length&&(f.currentModuleIx=f.modules.length-1,(b=f.modules[f.currentModuleIx])&&b.validate&&!b.validate()?f.prev():b&&b.init(-1)))})},destroy:function(){this.unbindExitAnchorFocus&&(this.unbindExitAnchorFocus(),delete this.unbindExitAnchorFocus);this.unbindExitAnchorUpdate&&
(this.unbindExitAnchorUpdate(),delete this.unbindExitAnchorUpdate);this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor);this.unbindKeydownHandler&&this.unbindKeydownHandler();this.unbindMouseUpHandler&&this.unbindMouseUpHandler()}};return l});m(g,"modules/accessibility/components/LegendComponent.js",[g["parts/Globals.js"],g["modules/accessibility/AccessibilityComponent.js"],g["modules/accessibility/KeyboardNavigationHandler.js"]],
function(d,g,l){d.Chart.prototype.highlightLegendItem=function(b){var a=this.legend.allItems,c=this.highlightedLegendItemIx;return a[b]?(a[c]&&d.fireEvent(a[c].legendGroup.element,"mouseout"),void 0!==a[b].pageIx&&a[b].pageIx+1!==this.legend.currentPage&&this.legend.scroll(1+a[b].pageIx-this.legend.currentPage),this.setFocusToElement(a[b].legendItem,a[b].a11yProxyElement),d.fireEvent(a[b].legendGroup.element,"mouseover"),!0):!1};d.addEvent(d.Legend,"afterColorizeItem",function(b){var a=b.item;this.chart.options.accessibility.enabled&&
a&&a.a11yProxyElement&&a.a11yProxyElement.setAttribute("aria-pressed",b.visible?"false":"true")});var k=function(b){this.initBase(b)};k.prototype=new g;d.extend(k.prototype,{onChartRender:function(){var b=this.chart,a=b.options.accessibility,c=b.legend&&b.legend.allItems,e=this;e.legendProxyButtonClicked?delete e.legendProxyButtonClicked:(this.removeElement(this.legendProxyGroup),!c||!c.length||b.colorAxis&&b.colorAxis.length||!b.options.legend.accessibility.enabled||(this.legendProxyGroup=this.addProxyGroup({"aria-label":b.langFormat("accessibility.legendLabel"),
role:"all"===a.landmarkVerbosity?"region":null}),c.forEach(function(a){a.legendItem&&a.legendItem.element&&(a.a11yProxyElement=e.createProxyButton(a.legendItem,e.legendProxyGroup,{tabindex:-1,"aria-pressed":!a.visible,"aria-label":b.langFormat("accessibility.legendItem",{chart:b,itemName:e.stripTags(a.name)})},a.legendGroup.div?a.legendItem:a.legendGroup,function(){e.legendProxyButtonClicked=!0}))})))},getKeyboardNavigation:function(){var b=this.keyCodes,a=this,c=this.chart,e=c.options.accessibility;
return new l(c,{keyCodeMap:[[[b.left,b.right,b.up,b.down],function(h){h=h===b.left||h===b.up?-1:1;return c.highlightLegendItem(a.highlightedLegendItemIx+h)?(a.highlightedLegendItemIx+=h,this.response.success):1<c.legend.allItems.length&&e.keyboardNavigation.wrapAround?(this.init(h),this.response.success):this.response[0<h?"next":"prev"]}],[[b.enter,b.space],function(){var b=c.legend.allItems[a.highlightedLegendItemIx];b&&b.a11yProxyElement&&d.fireEvent(b.a11yProxyElement,"click");return this.response.success}]],
validate:function(){var a=c.options.legend;return c.legend&&c.legend.allItems&&c.legend.display&&!(c.colorAxis&&c.colorAxis.length)&&a&&a.accessibility&&a.accessibility.enabled&&a.accessibility.keyboardNavigation&&a.accessibility.keyboardNavigation.enabled},init:function(b){b=0<b?0:c.legend.allItems.length-1;c.highlightLegendItem(b);a.highlightedLegendItemIx=b}})}});return k});m(g,"modules/accessibility/components/MenuComponent.js",[g["parts/Globals.js"],g["modules/accessibility/AccessibilityComponent.js"],
g["modules/accessibility/KeyboardNavigationHandler.js"]],function(d,g,l){d.Chart.prototype.showExportMenu=function(){this.exportSVGElements&&this.exportSVGElements[0]&&(this.exportSVGElements[0].element.onclick(),this.highlightExportItem(0))};d.Chart.prototype.hideExportMenu=function(){var b=this.exportDivElements;b&&this.exportContextMenu&&(b.forEach(function(a){if("highcharts-menu-item"===a.className&&a.onmouseout)a.onmouseout()}),this.highlightedExportItemIx=0,this.exportContextMenu.hideMenu(),
this.container.focus())};d.Chart.prototype.highlightExportItem=function(b){var a=this.exportDivElements&&this.exportDivElements[b],c=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],e;if(a&&"DIV"===a.tagName&&(!a.children||!a.children.length)){e=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus;a.focus&&e&&a.focus();if(c&&c.onmouseout)c.onmouseout();if(a.onmouseover)a.onmouseover();this.highlightedExportItemIx=b;return!0}};d.Chart.prototype.highlightLastExportItem=
function(){var b;if(this.exportDivElements)for(b=this.exportDivElements.length;b--;)if(this.highlightExportItem(b))return!0;return!1};var k=function(b){this.initBase(b);this.init()};k.prototype=new g;d.extend(k.prototype,{init:function(){this.addEvent(this.chart,"exportMenuHidden",function(){var b=this.exportContextMenu;b&&b.setAttribute("aria-hidden",!0)})},onChartRender:function(){var b=this,a=this.chart,c=a.options.accessibility;this.removeElement(this.exportProxyGroup);if(a.options.exporting&&
!1!==a.options.exporting.enabled&&a.options.exporting.accessibility&&a.options.exporting.accessibility.enabled&&a.exportSVGElements&&a.exportSVGElements[0]&&a.exportSVGElements[0].element){var e=a.exportSVGElements[0],h=e.element,f=h.onclick;this.wrappedButton!==h&&(h.onclick=function(){f.apply(this,Array.prototype.slice.call(arguments));b.addAccessibleContextMenuAttribs();a.highlightExportItem(0)},this.wrappedButton=h);this.exportProxyGroup=this.addProxyGroup("all"===c.landmarkVerbosity?{"aria-label":a.langFormat("accessibility.exporting.exportRegionLabel",
{chart:a}),role:"region"}:null);this.exportButtonProxy=this.createProxyButton(e,this.exportProxyGroup,{"aria-label":a.langFormat("accessibility.exporting.menuButtonLabel",{chart:a})})}},addAccessibleContextMenuAttribs:function(){var b=this.chart,a=b.exportDivElements,c=b.exportContextMenu;a&&a.length&&(a.forEach(function(a){"DIV"!==a.tagName||a.children&&a.children.length||(a.setAttribute("role","menuitem"),a.setAttribute("tabindex",-1))}),a[0].parentNode.setAttribute("role","menu"),a[0].parentNode.setAttribute("aria-label",
b.langFormat("accessibility.exporting.chartMenuLabel",{chart:b})));c&&this.unhideElementFromScreenReaders(c)},getKeyboardNavigation:function(){var b=this.keyCodes,a=this.chart,c=a.options.accessibility,e=this;return new l(a,{keyCodeMap:[[[b.left,b.up],function(){for(var b=a.highlightedExportItemIx||0;b--;)if(a.highlightExportItem(b))return this.response.success;return c.keyboardNavigation.wrapAround?(a.highlightLastExportItem(),this.response.success):this.response.prev}],[[b.right,b.down],function(){for(var b=
(a.highlightedExportItemIx||0)+1;b<a.exportDivElements.length;++b)if(a.highlightExportItem(b))return this.response.success;return c.keyboardNavigation.wrapAround?(a.highlightExportItem(0),this.response.success):this.response.next}],[[b.enter,b.space],function(){e.fakeClickEvent(a.exportDivElements[a.highlightedExportItemIx]);return this.response.success}],[[b.esc],function(){return this.response.prev}]],validate:function(){return a.exportChart&&!1!==a.options.exporting.enabled&&!1!==a.options.exporting.accessibility.enabled},
init:function(b){a.showExportMenu();0>b&&a.highlightLastExportItem()},terminate:function(){a.hideExportMenu()}})}});return k});m(g,"modules/accessibility/components/SeriesComponent.js",[g["parts/Globals.js"],g["modules/accessibility/AccessibilityComponent.js"],g["modules/accessibility/KeyboardNavigationHandler.js"]],function(d,g,l){function k(a){var b=a.index,f=a.series.points,c=f.length;if(f[b]!==a)for(;c--;){if(f[c]===a)return c}else return b}function b(a){var b=a.chart.options.accessibility,f=
a.options.accessibility||{},c=f.keyboardNavigation;return c&&!1===c.enabled||!1===f.enabled||!1===a.options.enableMouseTracking||!a.visible||b.pointDescriptionThreshold&&b.pointDescriptionThreshold<=a.points.length}function a(a){var f=a.series.chart.options.accessibility;return a.isNull&&f.keyboardNavigation.skipNullPoints||!1===a.visible||b(a.series)}var c=d.merge,e=d.pick;d.Series.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(a){d.seriesTypes[a]&&(d.seriesTypes[a].prototype.keyboardMoveVertical=
!1)});d.Point.prototype.highlight=function(){var a=this.series.chart;if(this.isNull)a.tooltip&&a.tooltip.hide(0);else this.onMouseOver();this.graphic&&a.setFocusToElement(this.graphic);a.highlightedPoint=this;return this};d.Chart.prototype.highlightAdjacentPoint=function(f){var c=this.series,e=this.highlightedPoint,h=e&&k(e)||0,d=e&&e.series.points,g=this.series&&this.series[this.series.length-1],g=g&&g.points&&g.points[g.points.length-1];if(!c[0]||!c[0].points)return!1;if(e){if(c=c[e.series.index+
(f?1:-1)],h=d[h+(f?1:-1)],!h&&c&&(h=c.points[f?0:c.points.length-1]),!h)return!1}else h=f?c[0].points[0]:g;return a(h)?(c=h.series,b(c)?this.highlightedPoint=f?c.points[c.points.length-1]:c.points[0]:this.highlightedPoint=h,this.highlightAdjacentPoint(f)):h.highlight()};d.Series.prototype.highlightFirstValidPoint=function(){var b=this.chart.highlightedPoint,c=(b&&b.series)===this?k(b):0,b=this.points,e=b.length;if(b&&e){for(var h=c;h<e;++h)if(!a(b[h]))return b[h].highlight();for(;0<=c;--c)if(!a(b[c]))return b[c].highlight()}return!1};
d.Chart.prototype.highlightAdjacentSeries=function(a){var f,c,e=this.highlightedPoint,h=(f=this.series&&this.series[this.series.length-1])&&f.points&&f.points[f.points.length-1];if(!this.highlightedPoint)return f=a?this.series&&this.series[0]:f,(c=a?f&&f.points&&f.points[0]:h)?c.highlight():!1;f=this.series[e.series.index+(a?-1:1)];if(!f)return!1;var h=Infinity,d,k=f.points.length;if(void 0===e.plotX||void 0===e.plotY)c=void 0;else{for(;k--;)d=f.points[k],void 0!==d.plotX&&void 0!==d.plotY&&(d=(e.plotX-
d.plotX)*(e.plotX-d.plotX)*4+(e.plotY-d.plotY)*(e.plotY-d.plotY)*1,d<h&&(h=d,c=k));c=void 0!==c&&f.points[c]}if(!c)return!1;if(b(f))return c.highlight(),a=this.highlightAdjacentSeries(a),a?a:(e.highlight(),!1);c.highlight();return c.series.highlightFirstValidPoint()};d.Chart.prototype.highlightAdjacentPointVertical=function(f){var c=this.highlightedPoint,e=Infinity,h;if(void 0===c.plotX||void 0===c.plotY)return!1;this.series.forEach(function(n){n===c.series||b(n)||n.points.forEach(function(b){if(void 0!==
b.plotY&&void 0!==b.plotX&&b!==c){var d=b.plotY-c.plotY,k=Math.abs(b.plotX-c.plotX),k=Math.abs(d)*Math.abs(d)+k*k*4;n.yAxis.reversed&&(d*=-1);!(0>=d&&f||0<=d&&!f||5>k||a(b))&&k<e&&(e=k,h=b)}})});return h?h.highlight():!1};d.Point.prototype.getA11yTimeDescription=function(){var a=this.series,b=a.chart,c=b.options.accessibility;if(a.xAxis&&a.xAxis.isDatetimeAxis)return b.time.dateFormat(c.pointDateFormatter&&c.pointDateFormatter(this)||c.pointDateFormat||d.Tooltip.prototype.getXDateFormat.call({getDateFormat:d.Tooltip.prototype.getDateFormat,
chart:b},this,b.options.tooltip,a.xAxis),this.x)};var h=function(a){this.initBase(a);this.init()};h.prototype=new g;d.extend(h.prototype,{init:function(){var a=this;this.addEvent(d.Series,"destroy",function(){var b=this.chart;b===a.chart&&b.highlightedPoint&&b.highlightedPoint.series===this&&(delete b.highlightedPoint,b.focusElement&&b.focusElement.removeFocusBorder())});this.addEvent(d.Tooltip,"refresh",function(){this.chart===a.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",
!0)});this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(a){a.labelBySeries&&a.labelBySeries.attr("aria-hidden",!0)})});this.initAnnouncer()},onChartUpdate:function(){var a=this;this.chart.series.forEach(function(b){a[!1!==(b.options.accessibility&&b.options.accessibility.enabled)?"addSeriesDescription":"hideSeriesFromScreenReader"](b)})},getKeyboardNavigation:function(){var a=this.keyCodes,b=this.chart,c=b.options.accessibility,e=function(a){return b.highlightAdjacentPoint(a)?
this.response.success:c.keyboardNavigation.wrapAround?this.init(a?1:-1):this.response[a?"next":"prev"]};return new l(b,{keyCodeMap:[[[a.left,a.right],function(b){return e.call(this,b===a.right)}],[[a.up,a.down],function(f){var h=f===a.down,d=c.keyboardNavigation;if(d.mode&&"serialize"===d.mode)return e.call(this,f===a.down);b[b.highlightedPoint&&b.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries"](h);return this.response.success}],[[a.enter,a.space],
function(){b.highlightedPoint&&b.highlightedPoint.firePointEvent("click")}]],init:function(a){var c=b.series.length,f=0<a?0:c;if(0<a)for(delete b.highlightedPoint;f<c&&!(a=b.series[f].highlightFirstValidPoint());)++f;else for(;f--&&!(b.highlightedPoint=b.series[f].points[b.series[f].points.length-1],a=b.series[f].highlightFirstValidPoint()););return this.response.success},terminate:function(){b.tooltip&&b.tooltip.hide(0);delete b.highlightedPoint}})},isPointClickable:function(a){var b=a.series.options||
{},b=b.point&&b.point.events;return a&&a.graphic&&a.graphic.element&&(a.hcEvents&&a.hcEvents.click||b&&b.click||a.options&&a.options.events&&a.options.events.click)},initAnnouncer:function(){var a=this.chart,b=a.options.accessibility,e=this;this.lastAnnouncementTime=0;this.dirty={allSeries:{}};this.announceRegion=this.createElement("div");this.announceRegion.setAttribute("aria-hidden",!1);this.announceRegion.setAttribute("aria-live",b.announceNewData.interruptUser?"assertive":"polite");c(!0,this.announceRegion.style,
this.hiddenStyle);a.renderTo.insertBefore(this.announceRegion,a.renderTo.firstChild);this.addEvent(this.chart,"afterDrilldown",function(){a.highlightedPoint=null;if(a.options.accessibility.announceNewData.enabled){if(this.series&&this.series.length){var b=e.getSeriesElement(this.series[0]);b.focus&&b.getAttribute("aria-label")?b.focus():this.series[0].highlightFirstValidPoint()}e.lastAnnouncementTime=0;a.focusElement&&a.focusElement.removeFocusBorder()}});this.addEvent(d.Series,"updatedData",function(){this.chart===
a&&this.chart.options.accessibility.announceNewData.enabled&&(e.dirty.hasDirty=!0,e.dirty.allSeries[this.name+this.index]=this)});this.addEvent(a,"afterAddSeries",function(a){this.options.accessibility.announceNewData.enabled&&(a=a.series,e.dirty.hasDirty=!0,e.dirty.allSeries[a.name+a.index]=a,e.dirty.newSeries=void 0===e.dirty.newSeries?a:null)});this.addEvent(d.Series,"addPoint",function(b){this.chart===a&&this.chart.options.accessibility.announceNewData.enabled&&(e.dirty.newPoint=void 0===e.dirty.newPoint?
b.point:null)});this.addEvent(a,"redraw",function(){if(this.options.accessibility.announceNewData&&e.dirty.hasDirty){var a=e.dirty.newPoint,b;a&&(b=a.series.data.filter(function(b){return b.x===a.x&&b.y===a.y}),a=1===b.length?b[0]:a);e.announceNewData(Object.keys(e.dirty.allSeries).map(function(a){return e.dirty.allSeries[a]}),e.dirty.newSeries,a);e.dirty={allSeries:{}}}})},announceNewData:function(a,b,c){var f=this.chart.options.accessibility.announceNewData;if(f.enabled){var e=this,h=+new Date,
f=Math.max(0,f.minAnnounceInterval-(h-this.lastAnnouncementTime));if(this.queuedAnnouncement){var d=(this.queuedAnnouncement.series||[]).concat(a).reduce(function(a,b){a[b.name+b.index]=b;return a},{});a=Object.keys(d).map(function(a){return d[a]})}else a=[].concat(a);if(b=this.buildAnnouncementMessage(a,b,c))this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:h,message:b,series:a},e.queuedAnnouncementTimer=setTimeout(function(){e&&e.announceRegion&&(e.lastAnnouncementTime=
+new Date,e.announceRegion.innerHTML=e.queuedAnnouncement.message,e.clearAnnouncementContainerTimer&&clearTimeout(e.clearAnnouncementContainerTimer),e.clearAnnouncementContainerTimer=setTimeout(function(){e.announceRegion.innerHTML="";delete e.clearAnnouncementContainerTimer},1E3),delete e.queuedAnnouncement,delete e.queuedAnnouncementTimer)},f)}},buildAnnouncementMessage:function(a,b,c){var f=this.chart,e=f.options.accessibility.announceNewData;if(e.announcementFormatter&&(a=e.announcementFormatter(a,
b,c),!1!==a))return a.length?a:null;a=d.charts&&1<d.charts.length?"Multiple":"Single";return f.langFormat("accessibility.announceNewData."+(b?"newSeriesAnnounce"+a:c?"newPointAnnounce"+a:"newDataAnnounce"),{chartTitle:this.stripTags(f.options.title.text||f.langFormat("accessibility.defaultChartTitle",{chart:f})),seriesDesc:b?this.defaultSeriesDescriptionFormatter(b):null,pointDesc:c?this.defaultPointDescriptionFormatter(c):null,point:c,series:b})},reverseChildNodes:function(a){for(var b=a.childNodes.length;b--;)a.appendChild(a.childNodes[b])},
getSeriesFirstPointElement:function(a){return a.points&&a.points.length&&a.points[0].graphic&&a.points[0].graphic.element},getSeriesElement:function(a){var b=this.getSeriesFirstPointElement(a);return b&&b.parentNode||a.graph&&a.graph.element||a.group&&a.group.element},hideSeriesFromScreenReader:function(a){(a=this.getSeriesElement(a))&&a.setAttribute("aria-hidden",!0)},addSeriesDescription:function(a){var b=this,c=a.chart,e=c.options.accessibility,f=a.options.accessibility||{},h=b.getSeriesFirstPointElement(a),
d=b.getSeriesElement(a);d&&(this.unhideElementFromScreenReaders(d),d.lastChild===h&&b.reverseChildNodes(d),a.points&&(a.points.length<e.pointDescriptionThreshold||!1===e.pointDescriptionThreshold)&&!f.exposeAsGroupOnly&&a.points.forEach(function(a){var c=a.graphic&&a.graphic.element;c&&(c.setAttribute("role","img"),c.setAttribute("tabindex","-1"),c.setAttribute("aria-label",b.stripTags(f.pointDescriptionFormatter&&f.pointDescriptionFormatter(a)||e.pointDescriptionFormatter&&e.pointDescriptionFormatter(a)||
b.defaultPointDescriptionFormatter(a))))}),1<c.series.length||e.describeSingleSeries)&&(f.exposeAsGroupOnly?d.setAttribute("role","img"):"all"===e.landmarkVerbosity&&d.setAttribute("role","region"),d.setAttribute("tabindex","-1"),d.setAttribute("aria-label",b.stripTags(e.seriesDescriptionFormatter&&e.seriesDescriptionFormatter(a)||b.defaultSeriesDescriptionFormatter(a))))},defaultSeriesDescriptionFormatter:function(a){var b=a.chart,c=(a.options.accessibility||{}).description,c=c&&b.langFormat("accessibility.series.description",
{description:c,series:a}),e=b.langFormat("accessibility.series.xAxisDescription",{name:a.xAxis&&a.xAxis.getDescription(),series:a}),f=b.langFormat("accessibility.series.yAxisDescription",{name:a.yAxis&&a.yAxis.getDescription(),series:a}),h={name:a.name||"",ix:a.index+1,numSeries:b.series&&b.series.length,numPoints:a.points&&a.points.length,series:a},d=b.types&&1<b.types.length?"Combination":"";return(b.langFormat("accessibility.series.summary."+a.type+d,h)||b.langFormat("accessibility.series.summary.default"+
d,h))+(c?" "+c:"")+(b.yAxis&&1<b.yAxis.length&&this.yAxis?" "+f:"")+(b.xAxis&&1<b.xAxis.length&&this.xAxis?" "+e:"")},defaultPointDescriptionFormatter:function(a){var b=a.series,c=b.chart,f=c.options.accessibility,h=a.series.tooltipOptions||{},k=f.pointValuePrefix||h.valuePrefix||"",g=f.pointValueSuffix||h.valueSuffix||"",l=a.options&&a.options.accessibility&&a.options.accessibility.description,m=a.getA11yTimeDescription(),r=function(a){if(d.isNumber(a)){var b=d.defaultOptions.lang;return d.numberFormat(a,
f.pointValueDecimals||h.valueDecimals||-1,b.decimalPoint,b.accessibility.thousandsSep||b.thousandsSep)}return a},y=e(b.xAxis&&b.xAxis.options.accessibility&&b.xAxis.options.accessibility.enabled,!c.angular),t=b.xAxis&&b.xAxis.categories&&void 0!==a.category&&""+a.category,m=a.name||m||t&&t.replace("\x3cbr/\x3e"," ")||(a.id&&0>a.id.indexOf("highcharts-")?a.id:"x, "+a.x),t=a.series.pointArrayMap?a.series.pointArrayMap.reduce(function(b,c){return b+(b.length?", ":"")+c+": "+k+r(e(a[c],a.options[c]))+
g},""):void 0!==a.value?k+r(a.value)+g:k+r(a.y)+g;return(void 0!==a.index?a.index+1+". ":"")+(y?m+", ":"")+t+"."+(l?" "+l:"")+(1<c.series.length&&b.name?" "+b.name:"")}});return h});m(g,"modules/accessibility/components/ZoomComponent.js",[g["parts/Globals.js"],g["modules/accessibility/AccessibilityComponent.js"],g["modules/accessibility/KeyboardNavigationHandler.js"]],function(d,g,l){d.Axis.prototype.panStep=function(b,a){var c=a||3;a=this.getExtremes();var e=(a.max-a.min)/c*b,c=a.max+e,e=a.min+e,
h=c-e;0>b&&e<a.dataMin?(e=a.dataMin,c=e+h):0<b&&c>a.dataMax&&(c=a.dataMax,e=c-h);this.setExtremes(e,c)};var k=function(b){this.initBase(b);this.init()};k.prototype=new g;d.extend(k.prototype,{init:function(){var b=this,a=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(c){b.addEvent(a,c,function(){b.updateProxyOverlays()})})},onChartUpdate:function(){var b=this.chart,a=this;b.mapNavButtons&&b.mapNavButtons.forEach(function(c,e){a.unhideElementFromScreenReaders(c.element);
c.element.setAttribute("tabindex",-1);c.element.setAttribute("role","button");c.element.setAttribute("aria-label",b.langFormat("accessibility.mapZoom"+(e?"Out":"In"),{chart:b}))})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var b=this,a=this.chart,c=function(a,c,f,d){b.removeElement(b[f]);b[f]=b.addProxyGroup();b[c]=b.createProxyButton(a,b[f],{"aria-label":d,tabindex:-1})};b.removeElement(b.drillUpProxyGroup);b.removeElement(b.resetZoomProxyGroup);a.resetZoomButton&&
c(a.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",a.langFormat("accessibility.resetZoomButton",{chart:a}));a.drillUpButton&&c(a.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",a.langFormat("accessibility.drillUpButton",{chart:a,buttonText:a.getDrilldownBackText()}))},getMapZoomNavigation:function(){var b=this.keyCodes,a=this.chart,c=this;return new l(a,{keyCodeMap:[[[b.up,b.down,b.left,b.right],function(c){a[c===b.up||c===b.down?"yAxis":"xAxis"][0].panStep(c===b.left||c===b.up?
-1:1);return this.response.success}],[[b.tab],function(b,h){a.mapNavButtons[c.focusedMapNavButtonIx].setState(0);if(h.shiftKey&&!c.focusedMapNavButtonIx||!h.shiftKey&&c.focusedMapNavButtonIx)return a.mapZoom(),this.response[h.shiftKey?"prev":"next"];c.focusedMapNavButtonIx+=h.shiftKey?-1:1;b=a.mapNavButtons[c.focusedMapNavButtonIx];a.setFocusToElement(b.box,b.element);b.setState(2);return this.response.success}],[[b.space,b.enter],function(){c.fakeClickEvent(a.mapNavButtons[c.focusedMapNavButtonIx].element);
return this.response.success}]],validate:function(){return a.mapZoom&&a.mapNavButtons&&2===a.mapNavButtons.length},init:function(b){var e=a.mapNavButtons[0],f=a.mapNavButtons[1],e=0<b?e:f;a.setFocusToElement(e.box,e.element);e.setState(2);c.focusedMapNavButtonIx=0<b?0:1}})},simpleButtonNavigation:function(b,a,c){var e=this.keyCodes,d=this,f=this.chart;return new l(f,{keyCodeMap:[[[e.tab,e.up,e.down,e.left,e.right],function(a,b){return this.response[a===this.tab&&b.shiftKey||a===e.left||a===e.up?"prev":
"next"]}],[[e.space,e.enter],function(){c(f);return this.response.success}]],validate:function(){return f[b]&&f[b].box&&d[a]},init:function(){f.setFocusToElement(f[b].box,d[a])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(b){b.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(b){b.drillUp()}),this.getMapZoomNavigation()]}});return k});m(g,"modules/accessibility/components/RangeSelectorComponent.js",
[g["parts/Globals.js"],g["modules/accessibility/AccessibilityComponent.js"],g["modules/accessibility/KeyboardNavigationHandler.js"]],function(d,g,l){d.Chart.prototype.highlightRangeSelectorButton=function(b){var a=this.rangeSelector.buttons;a[this.highlightedRangeSelectorItemIx]&&a[this.highlightedRangeSelectorItemIx].setState(this.oldRangeSelectorItemState||0);this.highlightedRangeSelectorItemIx=b;return a[b]?(this.setFocusToElement(a[b].box,a[b].element),this.oldRangeSelectorItemState=a[b].state,
a[b].setState(2),!0):!1};var k=function(b){this.initBase(b)};k.prototype=new g;d.extend(k.prototype,{onChartUpdate:function(){var b=this.chart,a=this,c=b.rangeSelector;c&&(c.buttons&&c.buttons.length&&c.buttons.forEach(function(c){a.unhideElementFromScreenReaders(c.element);c.element.setAttribute("tabindex","-1");c.element.setAttribute("role","button");c.element.setAttribute("aria-label",b.langFormat("accessibility.rangeSelectorButton",{chart:b,buttonText:c.text&&c.text.textStr}))}),c.maxInput&&c.minInput&&
["minInput","maxInput"].forEach(function(e,d){c[e]&&(a.unhideElementFromScreenReaders(c[e]),c[e].setAttribute("tabindex","-1"),c[e].setAttribute("role","textbox"),c[e].setAttribute("aria-label",b.langFormat("accessibility.rangeSelector"+(d?"MaxInput":"MinInput"),{chart:b})))}))},getRangeSelectorButtonNavigation:function(){var b=this.chart,a=this.keyCodes,c=b.options.accessibility,e=this;return new l(b,{keyCodeMap:[[[a.left,a.right,a.up,a.down],function(e){e=e===a.left||e===a.up?-1:1;if(!b.highlightRangeSelectorButton(b.highlightedRangeSelectorItemIx+
e))return c.keyboardNavigation.wrapAround?(this.init(e),this.response.success):this.response[0<e?"next":"prev"]}],[[a.enter,a.space],function(){3!==b.oldRangeSelectorItemState&&e.fakeClickEvent(b.rangeSelector.buttons[b.highlightedRangeSelectorItemIx].element)}]],validate:function(){return b.rangeSelector&&b.rangeSelector.buttons&&b.rangeSelector.buttons.length},init:function(a){b.highlightRangeSelectorButton(0<a?0:b.rangeSelector.buttons.length-1)}})},getRangeSelectorInputNavigation:function(){var b=
this.chart,a=this.keyCodes;return new l(b,{keyCodeMap:[[[a.tab,a.up,a.down],function(c,e){c=c===a.tab&&e.shiftKey||c===a.up?-1:1;e=b.highlightedInputRangeIx+=c;if(1<e||0>e)return this.response[0<c?"next":"prev"];b.rangeSelector[e?"maxInput":"minInput"].focus();return this.response.success}]],validate:function(){return b.rangeSelector&&b.rangeSelector.inputGroup&&"hidden"!==b.rangeSelector.inputGroup.element.getAttribute("visibility")&&!1!==b.options.rangeSelector.inputEnabled&&b.rangeSelector.minInput&&
b.rangeSelector.maxInput},init:function(a){b.highlightedInputRangeIx=0<a?0:1;b.rangeSelector[b.highlightedInputRangeIx?"maxInput":"minInput"].focus()},terminate:function(){var a=b.rangeSelector;a&&a.maxInput&&a.minInput&&(a.hideInput("max"),a.hideInput("min"))}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]}});return k});m(g,"modules/accessibility/components/InfoRegionComponent.js",[g["parts/Globals.js"],g["modules/accessibility/AccessibilityComponent.js"]],
function(d,g){var l=d.merge,k=d.pick;d.Chart.prototype.getTypeDescription=function(a){a=a[0];var b=this.series&&this.series[0]||{},e=b.mapTitle,b={numSeries:this.series.length,numPoints:b.points&&b.points.length,chart:this,mapTitle:e};if(!a)return this.langFormat("accessibility.chartTypes.emptyChart",b);if("map"===a)return e?this.langFormat("accessibility.chartTypes.mapTypeDescription",b):this.langFormat("accessibility.chartTypes.unknownMap",b);if(1<this.types.length)return this.langFormat("accessibility.chartTypes.combinationChart",
b);var e=this.langFormat("accessibility.seriesTypeDescriptions."+a,{chart:this}),d=this.series&&1===this.series.length?"Single":"Multiple";return(this.langFormat("accessibility.chartTypes."+a+d,b)||this.langFormat("accessibility.chartTypes.default"+d,b))+(e?" "+e:"")};var b=function(a){this.initBase(a);this.init()};b.prototype=new g;d.extend(b.prototype,{init:function(){var a=this.chart,b=this;this.addEvent(a,"afterGetTable",function(c){a.options.accessibility.enabled&&(b.tableAnchor.setAttribute("aria-expanded",
!0),c.html=c.html.replace("\x3ctable ",'\x3ctable tabindex\x3d"0" summary\x3d"'+a.langFormat("accessibility.tableSummary",{chart:a})+'"'))});this.addEvent(a,"afterViewData",function(a){setTimeout(function(){var b=a&&a.getElementsByTagName("table")[0];b&&b.focus&&b.focus()},300)})},onChartUpdate:function(){var a=this.chart,b=a.options.accessibility,e="highcharts-information-region-"+a.index,d=this.screenReaderRegion=this.screenReaderRegion||this.createElement("div"),f=this.tableHeading=this.tableHeading||
this.createElement("h6"),k=this.tableAnchor=this.tableAnchor||this.createElement("a"),g=this.chartHeading=this.chartHeading||this.createElement("h6");d.setAttribute("id",e);"all"===b.landmarkVerbosity&&d.setAttribute("role","region");d.setAttribute("aria-label",a.langFormat("accessibility.screenReaderRegionLabel",{chart:a}));d.innerHTML=b.screenReaderSectionFormatter?b.screenReaderSectionFormatter(a):this.defaultScreenReaderSectionFormatter(a);a.getCSV&&a.options.accessibility.addTableShortcut&&(b=
"highcharts-data-table-"+a.index,k.innerHTML=a.langFormat("accessibility.viewAsDataTable",{chart:a}),k.href="#"+b,k.setAttribute("tabindex","-1"),k.setAttribute("role","button"),k.setAttribute("aria-expanded",!1),k.onclick=a.options.accessibility.onTableAnchorClick||function(){a.viewData()},f.appendChild(k),d.appendChild(f));g.innerHTML=a.langFormat("accessibility.chartHeading",{chart:a});g.setAttribute("aria-hidden",!1);a.renderTo.insertBefore(g,a.renderTo.firstChild);a.renderTo.insertBefore(d,a.renderTo.firstChild);
this.unhideElementFromScreenReaders(d);l(!0,g.style,this.hiddenStyle);l(!0,d.style,this.hiddenStyle)},defaultScreenReaderSectionFormatter:function(){var a=this.chart,b=a.options,e=a.types,d=this.getAxesDescription();return"\x3ch5\x3e"+(b.accessibility.typeDescription||a.getTypeDescription(e))+"\x3c/h5\x3e"+(b.subtitle&&b.subtitle.text?"\x3cdiv\x3e"+this.htmlencode(b.subtitle.text)+"\x3c/div\x3e":"")+(b.accessibility.description?"\x3cdiv\x3e"+b.accessibility.description+"\x3c/div\x3e":"")+(d.xAxis?
"\x3cdiv\x3e"+d.xAxis+"\x3c/div\x3e":"")+(d.yAxis?"\x3cdiv\x3e"+d.yAxis+"\x3c/div\x3e":"")},getAxesDescription:function(){var a=this.chart,b=this,e=a.xAxis,d=1<e.length||e[0]&&k(e[0].options.accessibility&&e[0].options.accessibility.enabled,!a.angular&&a.hasCartesianSeries&&0>a.types.indexOf("map")),f=a.yAxis,g=1<f.length||f[0]&&k(f[0].options.accessibility&&f[0].options.accessibility.enabled,a.hasCartesianSeries&&0>a.types.indexOf("map")),l={};d&&(l.xAxis=a.langFormat("accessibility.axis.xAxisDescription"+
(1<e.length?"Plural":"Singular"),{chart:a,names:a.xAxis.map(function(a){return a.getDescription()}),ranges:a.xAxis.map(function(a){return b.getAxisRangeDescription(a)}),numAxes:e.length}));g&&(l.yAxis=a.langFormat("accessibility.axis.yAxisDescription"+(1<f.length?"Plural":"Singular"),{chart:a,names:a.yAxis.map(function(a){return a.getDescription()}),ranges:a.yAxis.map(function(a){return b.getAxisRangeDescription(a)}),numAxes:f.length}));return l},getAxisRangeDescription:function(a){var b=this.chart,
e=a.options||{};if(e.accessibility&&void 0!==e.accessibility.rangeDescription)return e.accessibility.rangeDescription;if(a.categories)return b.langFormat("accessibility.axis.rangeCategories",{chart:b,axis:a,numCategories:a.dataMax-a.dataMin+1});if(a.isDatetimeAxis&&(0===a.min||0===a.dataMin)){var d={},f="Seconds";d.Seconds=(a.max-a.min)/1E3;d.Minutes=d.Seconds/60;d.Hours=d.Minutes/60;d.Days=d.Hours/24;["Minutes","Hours","Days"].forEach(function(a){2<d[a]&&(f=a)});d.value=d[f].toFixed("Seconds"!==
f&&"Minutes"!==f?1:0);return b.langFormat("accessibility.axis.timeRange"+f,{chart:b,axis:a,range:d.value.replace(".0","")})}e=b.options.accessibility;return b.langFormat("accessibility.axis.rangeFromTo",{chart:b,axis:a,rangeFrom:a.isDatetimeAxis?b.time.dateFormat(e.axisRangeDateFormat,a.min):a.min,rangeTo:a.isDatetimeAxis?b.time.dateFormat(e.axisRangeDateFormat,a.max):a.max})}});return b});m(g,"modules/accessibility/components/ContainerComponent.js",[g["parts/Globals.js"],g["modules/accessibility/AccessibilityComponent.js"]],
function(d,g){var l=d.win.document,k=function(b){this.initBase(b)};k.prototype=new g;d.extend(k.prototype,{onChartUpdate:function(){var b=this.chart,a=b.options.accessibility,c,e="highcharts-title-"+b.index,d=b.options.title.text||b.langFormat("accessibility.defaultChartTitle",{chart:b}),f=this.stripTags(b.langFormat("accessibility.svgContainerTitle",{chartTitle:d})),k=this.stripTags(b.langFormat("accessibility.svgContainerLabel",{chartTitle:d}));f.length&&(c=this.svgTitleElement=this.svgTitleElement||
l.createElementNS("http://www.w3.org/2000/svg","title"),c.textContent=f,c.id=e,b.renderTo.insertBefore(c,b.renderTo.firstChild));b.renderer.box&&k.length&&b.renderer.box.setAttribute("aria-label",k);"disabled"!==a.landmarkVerbosity?b.renderTo.setAttribute("role","region"):b.renderTo.removeAttribute("role");b.renderTo.setAttribute("aria-label",b.langFormat("accessibility.chartContainerLabel",{title:this.stripTags(d),chart:b}))},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0);
this.destroyBase()}});return k});m(g,"modules/accessibility/options.js",[],function(){return{accessibility:{enabled:!0,pointDescriptionThreshold:500,addTableShortcut:!0,axisRangeDateFormat:"%Y-%m-%d %H:%M:%S",describeSingleSeries:!1,landmarkVerbosity:"all",keyboardNavigation:{enabled:!0,skipNullPoints:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:"#335cad",lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","chartMenu","legend"],wrapAround:!0},announceNewData:{enabled:!1,
minAnnounceInterval:5E3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}}});m(g,"modules/accessibility/a11y-i18n.js",[g["parts/Globals.js"]],function(d){function g(d,b){var a=d.indexOf("#each("),c=d.indexOf("#plural("),e=d.indexOf("["),g=d.indexOf("]");if(-1<a){var e=d.slice(a).indexOf(")")+a,f=d.substring(0,a),c=d.substring(e+1),e=d.substring(a+6,e).split(","),a=Number(e[1]);d="";if(b=b[e[0]])for(a=isNaN(a)?b.length:a,a=
0>a?b.length+a:Math.min(a,b.length),e=0;e<a;++e)d+=f+b[e]+c;return d.length?d:""}if(-1<c){f=d.slice(c).indexOf(")")+c;d=d.substring(c+8,f).split(",");switch(Number(b[d[0]])){case 0:d=l(d[4],d[1]);break;case 1:d=l(d[2],d[1]);break;case 2:d=l(d[3],d[1]);break;default:d=d[1]}d?(b=d,b=b.trim&&b.trim()||b.replace(/^\s+|\s+$/g,"")):b="";return b}return-1<e?(c=d.substring(0,e),d=Number(d.substring(e+1,g)),b=b[c],!isNaN(d)&&b&&(0>d?(f=b[b.length+d],void 0===f&&(f=b[0])):(f=b[d],void 0===f&&(f=b[b.length-
1]))),void 0!==f?f:""):"{"+d+"}"}var l=d.pick;d.i18nFormat=function(k,b,a){var c=function(a,b){a=a.slice(b||0);var c=a.indexOf("{"),d=a.indexOf("}");if(-1<c&&d>c)return{statement:a.substring(c+1,d),begin:b+c+1,end:b+d}},e=[],h,f;f=0;do h=c(k,f),f=k.substring(f,h&&h.begin-1),f.length&&e.push({value:f,type:"constant"}),h&&e.push({value:h.statement,type:"statement"}),f=h&&h.end+1;while(h);e.forEach(function(a){"statement"===a.type&&(a.value=g(a.value,b))});return d.format(e.reduce(function(a,b){return a+
b.value},""),b,a)};d.Chart.prototype.langFormat=function(g,b,a){g=g.split(".");for(var c=this.options.lang,e=0;e<g.length;++e)c=c&&c[g[e]];return"string"===typeof c&&d.i18nFormat(c,b,a)};d.setOptions({lang:{accessibility:{screenReaderRegionLabel:"Chart screen reader information.",defaultChartTitle:"Chart",viewAsDataTable:"View as data table.",chartHeading:"Chart graphic.",chartContainerLabel:"{title}. Interactive chart.",svgContainerLabel:"Interactive chart",rangeSelectorMinInput:"Select start date.",
rangeSelectorMaxInput:"Select end date.",tableSummary:"Table representation of chart.",mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom",drillUpButton:"{buttonText}",rangeSelectorButton:"Select range {buttonText}",legendLabel:"Toggle series visibility",legendItem:"Toggle visibility of {itemName}",thousandsSep:",",svgContainerTitle:"",svgContainerEnd:"End of interactive chart",announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",
newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",
areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",
waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",
splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",
pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",
xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},
exporting:{chartMenuLabel:"Chart export",menuButtonLabel:"View export menu",exportRegionLabel:"Chart export menu"},series:{summary:{"default":"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",
spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",
barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",
boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",
mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},
description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}"}}}})});m(g,"modules/accessibility/accessibility.js",[g["parts/Globals.js"],g["modules/accessibility/KeyboardNavigationHandler.js"],g["modules/accessibility/AccessibilityComponent.js"],g["modules/accessibility/KeyboardNavigation.js"],g["modules/accessibility/components/LegendComponent.js"],g["modules/accessibility/components/MenuComponent.js"],g["modules/accessibility/components/SeriesComponent.js"],g["modules/accessibility/components/ZoomComponent.js"],
g["modules/accessibility/components/RangeSelectorComponent.js"],g["modules/accessibility/components/InfoRegionComponent.js"],g["modules/accessibility/components/ContainerComponent.js"],g["modules/accessibility/options.js"]],function(d,g,l,k,b,a,c,e,h,f,m,p){function n(a){this.init(a)}var q=d.addEvent,r=d.win.document,u=d.pick,v=d.merge,w=d.extend,x=d.error;v(!0,d.defaultOptions,p);d.KeyboardNavigationHandler=g;d.AccessibilityComponent=l;d.extend(d.SVGElement.prototype,{addFocusBorder:function(a,b){this.focusBorder&&
this.removeFocusBorder();var c=this.getBBox();a=u(a,3);c.x+=this.translateX?this.translateX:0;c.y+=this.translateY?this.translateY:0;this.focusBorder=this.renderer.rect(c.x-a,c.y-a,c.width+2*a,c.height+2*a,b&&b.borderRadius).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup);this.renderer.styledMode||this.focusBorder.attr({stroke:b&&b.stroke,"stroke-width":b&&b.strokeWidth})},removeFocusBorder:function(){this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});
d.Chart.prototype.setFocusToElement=function(a,b){var c=this.options.accessibility.keyboardNavigation.focusBorder;(b=b||a.element)&&b.focus&&(b.hcEvents&&b.hcEvents.focusin||q(b,"focusin",function(){}),b.focus(),c.hideBrowserFocusOutline&&(b.style.outline="none"));c.enabled&&(this.focusElement&&this.focusElement.removeFocusBorder(),a.addFocusBorder(c.margin,{stroke:c.style.color,strokeWidth:c.style.lineWidth,borderRadius:c.style.borderRadius}),this.focusElement=a)};d.Axis.prototype.getDescription=
function(){return this.userOptions&&this.userOptions.accessibility&&this.userOptions.accessibility.description||this.axisTitle&&this.axisTitle.textStr||this.options.id||this.categories&&"categories"||this.isDatetimeAxis&&"Time"||"values"};n.prototype={init:function(d){var g=d.options.accessibility;this.chart=d;if(r.addEventListener&&d.renderer.isSVG){this.copyDeprecatedOptions();var l=this.components={container:new m(d),infoRegion:new f(d),legend:new b(d),chartMenu:new a(d),rangeSelector:new h(d),
series:new c(d),zoom:new e(d)};g.customComponents&&w(this.components,g.customComponents);this.keyboardNavigation=new k(d,l);this.update()}else d.renderTo.setAttribute("aria-hidden",!0)},update:function(){var a=this.components,b=this.chart.options.accessibility;this.chart.types=this.getChartTypes();Object.keys(a).forEach(function(b){a[b].onChartUpdate()});this.keyboardNavigation.update(b.keyboardNavigation.order)},destroy:function(){var a=this.chart||{},b=this.components;Object.keys(b).forEach(function(a){b[a].destroy()});
this.keyboardNavigation.destroy();a.renderTo&&a.renderTo.setAttribute("aria-hidden",!0);a.focusElement&&a.focusElement.removeFocusBorder()},getChartTypes:function(){var a={};this.chart.series.forEach(function(b){a[b.type]=1});return Object.keys(a)},copyDeprecatedOptions:function(){var a=this.chart,b=function(b,c){x("Highcharts: Deprecated option "+b+" used. Use "+c+" instead.",!1,a)},c={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility",
"pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]},d=a.options.chart||{},e=a.options.accessibility||{};["description","typeDescription"].forEach(function(a){d[a]&&(e[a]=d[a],b("chart."+a,"accessibility."+a))});a.axes.forEach(function(a){(a=a.options)&&a.description&&(a.accessibility=a.accessibility||{},a.accessibility.description=a.description,b("axis.description","axis.accessibility.description"))});a.series&&a.series.forEach(function(a){Object.keys(c).forEach(function(d){var e=
a.options[d];if(void 0!==e){for(var e="skipKeyboardNavigation"===d?!e:e,f=c[d],g=a.options,h,k=0;k<f.length-1;++k)h=f[k],g=g[h]=u(g[h],{});g[f[f.length-1]]=e;b("series."+d,"series."+c[d].join("."))}});a.points&&a.points.forEach(function(a){a.options&&a.options.description&&(a.options.accessibility=a.options.accessibility||{},a.options.accessibility.description=a.options.description,b("point.description","point.accessibility.description"))})})}};q(d.Chart,"render",function(a){var b=this.accessibility;
if(this.a11yDirty&&this.renderTo){delete this.a11yDirty;var c=this.options.accessibility;c&&c.enabled?b?b.update():this.accessibility=b=new n(this):b?(b.destroy&&b.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)}b&&Object.keys(b.components).forEach(function(c){b.components[c].onChartRender(a)})});q(d.Chart,"update",function(a){if(a=a.options.accessibility)a.customComponents&&(this.options.accessibility.customComponents=a.customComponents,delete a.customComponents),
v(!0,this.options.accessibility,a),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility);this.a11yDirty=!0});q(d.Point,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(a){q(d.Chart,a,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(a){q(d.Series,a,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(a){q(d.Chart,
a,function(){this.accessibility&&this.accessibility.update()})});q(d.Chart,"destroy",function(){this.accessibility&&this.accessibility.destroy()})});m(g,"masters/modules/accessibility.src.js",[],function(){})});
//# sourceMappingURL=accessibility.js.map