var init=true;
var data={
    //display: string | together/seperate
    display:"together",
    //initialshow: int/boolean | number/false
    initialshow:0,
    //plaintexttoggle: boolean | true/false
    plaintexttoggle:true,
    content: [
        {
            label:"<div class=\"shadow-r\"></div>Power",
            content:"<div class=\"box\"><p class=\"n-m-t\">A common understanding of the concept of power is that of having control or influence over others, of possessing power. Some forms of power, such as authoritarian rule, do appear dominant and can endure over long periods of time. However, this is but one manifestation of power. A relational approach sees power as negotiated and contested between individuals and groups. It emerges from the social relations between people, shaping such relations while also being shaped by them. Power is dynamic and intertwined with processes of change.</p><p class=\"n-m-t n-m-b\">Such power relations are a key focus of analysis in seeking to understand any development process or situation. They play out in situations ranging from the gender relations between men and women in a household, interactions between different cultural groups in a residential area, through to the power plays between states in international trade and diplomacy.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"show-r\"></div>Agency",
            content:"<div class=\"box\"><p class=\"n-m-t\">Agency is a concept that relates to the capacity of individuals to make choices, to act independently, to identify goals, and act to achieve them. In the social sciences, agency is often discussed in relation to the concept of structure. Structure refers to the underlying social framework within which events occur. It concerns the aspects of the context within which actors operate that affect their ability to exercise agency. It includes not only formal laws and regulations but also the more informal social norms and values that govern behaviour.</p><p class=\"n-m-t n-m-b\">Agency and structure are inherently interlinked, with one influencing the other and vice versa. Social structures are created and reshaped by people’s agency, and, in turn, people’s agency is regulated and shaped by social structures. Structures can offer opportunities as well as constraints. For example, people coming together to take part in a sport such as football, will need to agree on rules and appoint an arbitrator, the referee. Doing so ensures some order and prevents the chaos that could result if each player operated according to his or her own understanding of how the game should be played. Recognising such interrelationships means that any attempt to explain a social process requires an understanding of both agency and structure, and how they interact in a given context.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div>Scale",
            content:"<div class=\"box\"><p class=\"n-m-t\">Scale is about the magnitude of processes and effects, operating and impacting at different levels such as the local, national, international and global. Getting a sense of the magnitude of processes and their impacts involves understanding the power of the forces driving them, the number of people involved in and affected by them, and the spatial extent of their operation and effects. This is an important first step in getting a sense of the boundaries of a process, deciding what responses can be devised, and how and where to focus them. It also helps to get a sense of the relative importance of different processes – in a world where it can seem like the number of development issues is increasing all the time, putting different issues into relative perspective with each other helps to work out which ones need the most urgent or largest response.</p><p class=\"n-m-t n-m-b\">Disaggregating development processes across different scalar levels is a useful analytical strategy and a means of reducing the complexity of the situation. However, it is important to recognise that different levels are very much interconnected – what happens at one level both shapes and is in turn shaped by what happens at other levels. For example, globalisation involves global flows of money, ideas and goods but is shaped by actions and processes at local and national levels.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div>History",
            content:"<div class=\"box\"><p class=\"n-m-t\">Looking at history is about recognising that what happened in the past has produced and shaped the social, economic, cultural and political structures and processes of today. It also helps us to recognise how important elements of development thinking, theory and practice emerged at particular historical moments and to reflect on the particular contexts and interests of those times, times that may now look quite different compared to our present circumstances.</p><p class=\"n-m-t n-m-b\">The origins of development theory and practice can be traced to the ideas and practices of colonial administration – indeed, today’s development agencies of European former-colonial powers often grew directly from the agencies that had overseen colonial administration. Recognising such colonial continuities highlights some of the primary tensions and conflicts that still haunt global development, such as the power of former colonial nations in shaping today’s development agenda. History – as the exploration of the past-in-the-present – can help with the process of making sense of global development, not only in terms of the processes that drive it, but also in terms of the ideas that shape our understanding of it.</p></div>"
        }
    ]
};

var labels, reveals, resize;
var prevHeight;
(function () {
    createContentView();
    setupResize();
    if(data.plaintexttoggle) {
        createPlainViewBtn("prepend");
        createPlainViewBtn("append");
    }
    labels=document.querySelectorAll(".label");
    reveals=document.querySelectorAll(".reveal");
    selectLabel(data.initialshow);
    prevHeight=document.getElementById("container").offsetHeight;
})();
function setupResize() {
    window.onresize = function () {
        clearTimeout(resize);
        resize = setTimeout(function(){
            if(prevHeight!==document.getElementById("container").offsetHeight) {
                prevHeight=document.getElementById("container").offsetHeight;
                VLE.resize_iframe();
            } else {
                clearTimeout(resize);
            }
        }, 250);
    };
}
function selectLabel(num){
    for(var i=0; i<data.content.length; i++){
        updateClass("remove",labels[i],"selected");
        updateClass("add",reveals[i],"hidden");
    }
    updateClass("add",labels[num],"selected");
    updateClass("remove",reveals[num],"hidden");
    resizeScreen();
}
function resizeScreen(){
    if(!init) {
        setTimeout(function(){VLE.resize_iframe()}, 250);
    } else {
        if(document.getElementById("container").offsetWidth<512) {
            setTimeout(function () {
                VLE.resize_iframe();
            }, 1000);
        }
        init=false;
    }
}
function createContentView(){
    var labelContainer, revealContainer;
    var content = createEl(document.querySelector("#container"),"div", null, null, {"id":"content"});
    if(data.display==="together") {
        labelContainer = createEl(content, "div", null, null, {"class": "label-container"});
        revealContainer = createEl(content, "div", null, null, {"class": "reveal-container"});
    }
    for(var i=0; i<data.content.length; i++){
        if(data.display==="seperate") {
            var seperateContainer = createEl(content,"div", null, ["seperate-container"])
            labelContainer = createEl(seperateContainer, "div", null, null, {"class": "label-container"});
            revealContainer = createEl(seperateContainer, "div", null, null, {"class": "reveal-container","aria-live":"polite"});
        }
        var label = createEl(labelContainer,"div", data.content[i].label, null, {"class":"label", "id":"label-"+i, "tabindex":"0", "role": "button", "aria-label":"test"}, null, data.content[i].label);
        label.setAttribute("aria-label", document.querySelectorAll(".label")[i].innerText)
        label.onkeyup=function(e){
            if(e.keyCode===13 || e.keyCode===32) {
                this.click();
            }
        };
        label.onclick=function() {
            selectLabel(Number(this.getAttribute("id").split("label-")[1]));
        };
        data.content[i].content="<h1 class=\"reveal-heading\">"+data.content[i].label+"</h1>"+data.content[i].content;
        var reveal = createEl(revealContainer,"div", null, null, {"class":"reveal"}, null, data.content[i].content);
        if(data.display==="together") {
            reveal.setAttribute("tabindex","0");
        }
    }
}
function createPlainViewBtn(loc){
    var parent=document.querySelector("#container")
    var btn = createEl(parent,"button", "toggle plain view", ["plainViewBtn"], {"aria-pressed":"false", "tabindex":0}, loc);
    if(loc==="append"){
        updateClass("add", btn,"hidden");
    }
    btn.onclick=function() {
        var content=document.querySelector("#content");
        var plainViewBtns = document.querySelectorAll(".plainViewBtn");
        var seperateContainer= document.querySelectorAll(".seperate-container");
        if(this.getAttribute("aria-pressed")==="true") {
            for(var i=0; i< plainViewBtns.length; i++){
                plainViewBtns[i].setAttribute("aria-pressed",false);
            }
            if(data.display==="seperate") {
                for (var j = 0; j < seperateContainer.length; j++) {
                    seperateContainer[j].removeAttribute("tabindex");
                }
            }
            content.removeAttribute("tabindex");
            updateClass("remove",content,"plain-view");
            updateClass("add", plainViewBtns[plainViewBtns.length-1],"hidden");
            document.querySelector(".plainViewBtn").focus();
        } else {
            for(var k=0; k< plainViewBtns.length; k++){
                plainViewBtns[k].setAttribute("aria-pressed",true);
            }
            if(data.display==="seperate") {
                for (var l = 0; l < seperateContainer.length; l++) {
                    seperateContainer[l].setAttribute("tabindex", "0");
                }
            }
            content.setAttribute("tabindex", "0");
            updateClass("add",content,"plain-view");
            updateClass("remove", plainViewBtns[plainViewBtns.length-1],"hidden");
            content.focus();
        }
        resizeScreen();
    };
    if(loc==="prepend"){
        btn.focus();
    }
}


/* repeats */
function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}


function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
};