var cfg;
var savedObj = {};
var savedGroupObj = {};
var savedParticipants = 0;
var activityId = null;
var documentId = null;
var courseId = null;
var resize, container, containerP;
var prevHeight = 0;
var loadedData = {
    css: false,
    js: false
};
 
(function () {
    container = document.querySelector("#pgContent")
    containerP = document.querySelector("#containAll")
    // load in css
    VLE.get_attachment("stylesheet", function (response) {
        document.getElementById("attachCSS").innerHTML = response;
        window.setTimeout(function () {
            console.log("w css")
            loadedData.css = true;
        }, 500);
    }, function () {
        if (VLE.serverversion) {
            console.log("no stylesheet attached");
            window.setTimeout(function () {
                loadedData.css = true;
                document.getElementById("attachCSS").innerHTML = request.response;
            }, 500);
        } else {
            console.log("loading local version of stylesheet for testing purposes");
            var requestURL = 'styles.css';
            var request = new XMLHttpRequest();
            request.open('GET', requestURL);
            request.responseType = 'string';
            request.send();
            request.onload = function () {
                loadedData.css = true
                document.getElementById("attachCSS").innerHTML = request.response;
            };
        }
    });
    //load in json
    VLE.get_attachment("data", function (response) {
        cfg = JSON.parse(response);
        loadedData.js = true;
        setupQuestions();
    }, function () {
        if (VLE.serverversion) {
            console.log("issue loading data.json");
        } else {
            console.log("loading local version of json for testing purposes");
            var requestURL = 'cfg.json';
            var request = new XMLHttpRequest();
            request.open('GET', requestURL);
            request.responseType = 'string';
            request.send();
            request.onload = function () {
                cfg = JSON.parse(request.response);
                loadedData.js = true
                setupQuestions();
            };
        }
    });
    window.onresize = function () {
        resizeContainer();
    };
    checkLoaded();
    document.querySelector("#submitBtn").onclick = function () {
        var questionBlocks = document.querySelectorAll(".questionBlock")
        var hasChecked = 0;
        var rangeCount = 0;
        for (var i = 0; i < questionBlocks.length; i++) {
            questionBlocks[i].querySelector(".warning").classList.remove("hidden")
            if (questionBlocks[i].querySelectorAll("input[type=\"radio\"]:checked, input[type=\"checkbox\"]:checked").length !== 0) {
                questionBlocks[i].querySelector(".warning").classList.add("hidden")
                hasChecked++;
            }
            if (questionBlocks[i].querySelectorAll("input[type=\"range\"]").length !== 0) {
                questionBlocks[i].querySelector(".warning").classList.add("hidden")
                rangeCount++
            }
        }
        if ((document.querySelectorAll(".questionBlock").length - rangeCount) === hasChecked) {
            retrieveData(true, false);
            document.getElementById("notComplete").classList.add("hidden");
        } else {
            document.getElementById("notComplete").classList.remove("hidden");
        }
        resizeContainer();
    }
})();

function checkLoaded() {
    var count = 0;
    for (var i in loadedData) {
        if (!loadedData[i]) {
            window.setTimeout(function () {
                checkLoaded();
            }, 100)
        } else {
            count++;
        }
    }
    if (count === 2) {
        resizeContainer();
    }
}
function resizeContainer() {
    if (typeof resize !== "undefined") {
        clearTimeout(resize);
    }
    resize = setTimeout(function () {
        if (prevHeight !== containerP.offsetHeight) {
            prevHeight = containerP.offsetHeight;
            VLE.resize_iframe();
        } else {
            clearTimeout(resize);
        }
    }, 250);
}

function setupQuestions() {
    for (var q in cfg.questions) {
        var qBlock = document.createElement("fieldset");
        qBlock.classList.add("questionBlock");
        qBlock.id = "block" + q
        // create warnings used when question not completed
        var qH = qBlock.appendChild(document.createElement("legend"))
        var qWarn = qH.appendChild(document.createElement("span"))
        qWarn.classList.add("hidden");
        qWarn.classList.add("warning");
        qWarn.innerHTML = "*";
        qH.classList.add("question");
        qH.appendChild(document.createTextNode(cfg.questions[q].question));
        var chartType = "bar";
        if (typeof cfg.questions[q].chart !== "undefined") {
            chartType = cfg.questions[q].chart;
        }
        qBlock.classList.add(chartType+"-chart");
        qBlock.setAttribute("data-chart", chartType);
        qBlock.setAttribute("data-qid", q);
        //create gradings
        var qGrade = qBlock.appendChild(document.createElement("div"))
        qGrade.classList.add("grade");
        if (cfg.questions[q].type !== "range") {
            for (var t in cfg.questions[q].answers) {
                var qTick = qGrade.appendChild(document.createElement("div"));
                qTick.classList.add("tick");
                var chkSpan = qTick.appendChild(document.createElement("span"));
                chkSpan.classList.add("chkSpan");
                var input = chkSpan.appendChild(document.createElement("input"));
                input.type = cfg.questions[q].type;
                input.id = q + t;
                input.name = q;
                var inputLbl = qTick.appendChild(document.createElement("label"));
                inputLbl.setAttribute("for", q + t);
                inputLbl.innerHTML = cfg.questions[q].answers[t].label;
                var chkBox = qTick.appendChild(document.createElement("span"));
                chkBox.classList.add("box");
                var chkBar = chkBox.appendChild(document.createElement("span"));
                chkBar.classList.add("bar");
                chkBar.style.width = 0;
                var pc = qTick.appendChild(document.createElement("span"));
                pc.classList.add("pc");
            }
        } else {
            var qTick = qGrade.appendChild(document.createElement("div"));
            qTick.classList.add("rng");
            var chkSpan = qTick.appendChild(document.createElement("span"));
            chkSpan.classList.add("chkSpan");
            var input = chkSpan.appendChild(document.createElement("input"));
            input.type = cfg.questions[q].type;
            input.id = q;
            input.name = q;
            input.min = cfg.questions[q].min;
            input.max = cfg.questions[q].max;
            input.value = cfg.questions[q].default || cfg.questions[q].max / 2;
            input.step = cfg.questions[q].steps;
            input.onchange = function () {
                if (Number(this.value) > cfg.questions[this.id].max) {
                    this.value = cfg.questions[this.id].max
                }
                this.parentNode.querySelector(".rangeTxt").value = this.value
            }
            var inputTxt = chkSpan.appendChild(document.createElement("input"));
            inputTxt.type = "text";
            inputTxt.classList.add("rangeTxt");
            inputTxt.value = input.value;

            inputTxt.onchange = function () {
                this.parentNode.querySelector("input[type=range]").value = this.value
            }
            inputTxt.onkeyup = function () {
                this.parentNode.querySelector("input[type=range]").value = this.value
            }
        }

        var qResults = qBlock.appendChild(document.createElement("div"))
        qResults.classList.add("results");   
        var qChart = qBlock.appendChild(document.createElement("div"))
        qChart.classList.add("chart");
        container.appendChild(qBlock)
    }
    if (VLE.serverversion) {
        activityId = VLE.get_param('activity_id') || VLE.get_param('_a');
        documentId = VLE.get_param('document_id') || VLE.get_param('_i');
        courseId = VLE.get_param('course_id') || VLE.get_param('_c');
    }
    retrieveData(false, true);
    checkAgainstSave();
}
function saveData() {
    var obj = {};
    var qs = document.querySelectorAll(".questionBlock");
    for (var i = 0; i < qs.length; i++) {
        if (qs[i].querySelector("input[type=range]")) {
            if (typeof obj[qs[i].id] === "undefined") {
                obj[qs[i].id] = qs[i].querySelector("input[type=range]").value
            }
            if (typeof savedGroupObj[qs[i].id] === "undefined") {
                savedGroupObj[qs[i].id] = []
            }
            savedGroupObj[qs[i].id].push(qs[i].querySelector("input[type=range]").value)
            //obj[qs[i].id].push(slctd.id)
        } else {
            var inputs = qs[i].querySelectorAll("input:checked")
            for (var o = 0; o < inputs.length; o++) {
                var slctd = inputs[o];
                if (slctd !== null) {
                    if (typeof obj[qs[i].id] === "undefined") {
                        obj[qs[i].id] = []
                    }
                    obj[qs[i].id].push(slctd.id)
                }
                var rads = qs[i].querySelectorAll("input[type=\"radio\"], input[type=\"checkbox\"]");
                if (typeof savedGroupObj[qs[i].id] === "undefined") {
                    savedGroupObj[qs[i].id] = {}
                }
                for (var j = 0; j < rads.length; j++) {
                    if (typeof savedGroupObj[qs[i].id][rads[j].id] === "undefined") {
                        savedGroupObj[qs[i].id][rads[j].id] = 0
                    }
                    if (slctd !== null) {
                        if (slctd.id === rads[j].id) {
                            savedGroupObj[qs[i].id][rads[j].id]++
                        }
                    }
                }
            }
        }
    }
    savedParticipants++;
    savedObj = obj;
    if (!VLE.serverversion) {
        // uncomment out when testing locally so to use local storage
        /*localStorage.setItem("savedObj", JSON.stringify(obj));
        localStorage.setItem("savedGroupObj", JSON.stringify(savedGroupObj));
        localStorage.setItem("savedParticipants", savedParticipants);
       // checkAgainstSave();
        document.getElementById("notSaved").classList.remove("hidden");*/
    } else {
        var saveIndiv = {
            pollIndiv: JSON.stringify(savedObj)
        }
        VLE.set_server_data(true, saveIndiv, function () {
            console.log("set_server_data was successful");
            var saveGroup = {
                pollGroup: JSON.stringify(savedGroupObj),
                participants: savedParticipants
            }
            VLE.set_server_data(false, saveGroup, function () {
                console.log("set_server_data was successful");
                checkAgainstSave();
            }, function (msg) {
                console.log("set_server_data has failed");
                if (msg !== null) {
                    console.log(msg);
                }
            }, undefined, null, activityId, documentId, courseId);
        }, function (msg) {
            console.log("set_server_data has failed");
            if (msg !== null) {
                console.log(msg);
            }
        }, undefined, null, activityId, documentId, courseId);
    }
}
function showResults() {
    var chartColors=["#444449","#7cb5ec","#13b1ae","#ea6222","#9d1134","#652d86","#00FF00","#FF0000"]
    for(var c=0; c<Highcharts.charts.length; c++){
        Highcharts.charts[c].destroy();
    }    
    Highcharts.charts=[]
    for (var i in savedObj) {
        extraResults = "";
        var results = document.getElementById(i).querySelector(".results");
        var charts = document.getElementById(i).querySelector(".chart")
        results.innerHTML = "";
        charts.innerHTML = "";
        var chartType = document.querySelector("#" + i).getAttribute("data-chart");
        if (chartType === "pie") {
            var pieData=[]
            var chartId;
            chartId=document.querySelector("#" + i).getAttribute("data-qid")
            var chartSeries=[{
                type:"pie",
                data: []
            }]
            
            if (document.querySelector("#" + i).querySelector("input[type=range]")) {
                var answers = cfg.questions[document.querySelector("#" + i).querySelector("input[type=range]").id].answers
                var countAnswers = {};
                var currAnswer=0;
                for (var m in answers) {
                    countAnswers[m] = 0
                    for (var o = 0; o < savedGroupObj[i].length; o++) {
                        var min = m.split("-")[0]
                        var max = m.split("-")[1]
                        var num = Number(savedGroupObj[i][o])

                        if (num <= max && num >= min) {
                            countAnswers[m]++
                        }
                    }
                    chartColors
                    percent = (100 / savedParticipants) * countAnswers[m]
                    percent=percent.toFixed(2);
                    chartSeries[0].data.push({
                        name: answers[m].label,
                        color: chartColors[currAnswer],
                        y: Number(percent)
                    })
                    pieData.push(percent)
                    currAnswer++;
                }
            } else {
                var resultsTxt = {};
                for (var j in savedGroupObj[i]) {
                    resultsTxt[j] = savedGroupObj[i][j];
                }
                for (var k in resultsTxt) {
                    var answerNum=Number(k.split(document.querySelector("#"+k).parentNode.parentNode.parentNode.parentNode.getAttribute("data-qid"))[1])
                    var answers = cfg.questions[document.querySelector("#"+k).parentNode.parentNode.parentNode.parentNode.getAttribute("data-qid")].answers[answerNum]
                    var percent = Math.round((100 / savedParticipants) * resultsTxt[k])
                    chartSeries[0].data.push({
                        name: answers.label,
                        color: chartColors[answerNum],
                        y: Number(percent)
                    })
                }
            }
            //var chartDiv=document.createElement("div");
            charts.id= chartId
           // charts.appendChild(chartDiv)
                Highcharts.chart(charts, {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        events: {
                            load: function() {
                                resizeContainer()
                            }
                        }
                    },
                    title: {
                        text: ''
                    },
                    tooltip: {
                        formatter: function () {
                            return this.key + " " + this.y + "%";
                        }
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        },
                        enabled: true
                    },
                    plotOptions: {
                        pie: {
                            dataLabels: {
                                enabled: false
                            },
                            showInLegend: true
                        }
                    },
                    series: chartSeries
                });
        } else {
            if (document.querySelector("#" + i).querySelector("input[type=range]")) {
                var answers = cfg.questions[document.querySelector("#" + i).querySelector("input[type=range]").id].answers
                var countAnswers = {};
                for (var m in answers) {
                    countAnswers[m] = 0
                    for (var o = 0; o < savedGroupObj[i].length; o++) {
                        var min = m.split("-")[0]
                        var max = m.split("-")[1]
                        var num = Number(savedGroupObj[i][o])

                        if (num <= max && num >= min) {
                            countAnswers[m]++
                        }
                    }
                    var rngResult = document.createElement("span");
                    rngResult.classList.add("rngResult");
                    rngResult.classList.add("result"+m);
                    var lbl = document.createElement("span");
                    lbl.classList.add("lbl");
                    lbl.innerHTML = answers[m].label
                    rngResult.appendChild(lbl)
                    var box = document.createElement("span");
                    box.classList.add("box");
                    rngResult.appendChild(box)
                    var bar = document.createElement("span");
                    bar.classList.add("bar");
                    box.appendChild(bar)
                    var pc = document.createElement("span");
                    pc.classList.add("pc");
                    rngResult.appendChild(pc)
                    var additionalHTML = document.createElement("span");
                    additionalHTML.classList.add("additionalHTML");
                    rngResult.appendChild(additionalHTML)
                    percent = (100 / savedParticipants) * countAnswers[m]
                    bar.style.width = percent + "%";
                    pc.innerText = percent + "%"
                    
                    document.querySelector("#" + i).querySelector(".results").insertBefore(rngResult,document.querySelector("#" + i).querySelector(".results").firstChild)
                   if(document.querySelector("#" + i).querySelector(".results").parentNode.querySelectorAll(".feedbackHTML").length===0){
                        var feedbackHTML = document.createElement("span");
                        feedbackHTML.classList.add("feedbackHTML");
                        document.querySelector("#" + i).querySelector(".results").parentNode.insertBefore(feedbackHTML,  document.querySelector("#" + i).querySelector(".results").parentNode.querySelector(".results").nextSibling);
                    }
                    for(var s in cfg.questions){
                        if(cfg.questions[s].type==="range") {
                            for(var t in cfg.questions[s].answers){
                                if(Number(t.split("-")[0])<=Number(savedObj["block"+s]) && Number(savedObj["block"+s])<=Number(t.split("-")[1])) {
                                    if(typeof cfg.questions[s].answers[t].feedbackHTML !== "undefined"){
                                        document.querySelector("#" + i).querySelector(".feedbackHTML").innerHTML=cfg.questions[s].answers[t].feedbackHTML
                                    }
                                }
                            }
                        }
                    }
                    if(typeof answers[m].additionalHTML !=="undefined"){
                        document.querySelector(".result"+m + " .additionalHTML").innerHTML=answers[m].additionalHTML
                    }
                }
            } else {
                var resultsTxt = {};
                for (var j in savedGroupObj[i]) {
                    resultsTxt[j] = savedGroupObj[i][j];
                }
                for (var k in resultsTxt) {
                    var percent = Math.round((100 / savedParticipants) * resultsTxt[k])
                    document.querySelector("#" + k).parentNode.parentNode.querySelector(".bar").style.width = percent + "%";
                    document.querySelector("#" + k).parentNode.parentNode.querySelector(".pc").innerHTML = percent + "%";
                    if(document.querySelector("#" + k).parentNode.parentNode.querySelectorAll(".additionalHTML").length===0){
                        var additionalHTML = document.createElement("span");
                        additionalHTML.classList.add("additionalHTML");
                        document.querySelector("#" + k).parentNode.parentNode.appendChild(additionalHTML)
                    }
                    var qDiv=document.querySelector("#" + k).parentNode.parentNode.parentNode.parentNode
                    if(qDiv.querySelectorAll(".feedbackHTML").length===0){
                        var feedbackHTML = document.createElement("span");
                        feedbackHTML.classList.add("feedbackHTML");
                        qDiv.insertBefore(feedbackHTML, qDiv.querySelector(".results").nextSibling);
                    }
                    document.querySelector("#" + k).parentNode.parentNode.parentNode.parentNode.querySelector(".results").innerHTML=""
                }
                for(var r=0; r<savedObj[i].length; r++){
                    var qid=document.querySelector("#"+savedObj[i]).parentNode.parentNode.parentNode.parentNode.getAttribute("data-qid")
                    
                    if(typeof cfg.questions[qid].answers[savedObj[i][r].split(qid)[1]].feedbackHTML !== "undefined"){
                        document.querySelector("#block"+qid).querySelector(".feedbackHTML").innerHTML=cfg.questions[qid].answers[savedObj[i][r].split(qid)[1]].feedbackHTML
                    }
                }
                for(var s in cfg.questions){
                    if(cfg.questions[s].type!=="range") {
                        for(var t in cfg.questions[s].answers){
                            if(typeof cfg.questions[s].answers[t].additionalHTML !=="undefined"){
                                document.querySelector("#"+s+t).parentNode.parentNode.querySelector(".additionalHTML").innerHTML=cfg.questions[s].answers[t].additionalHTML
                            }
                        }
                    }
                }                
            }
        }
        results.innerHTML += "<p><b>You have voted.</b></p>";
        results.innerHTML += "<p>Total number of participants so far is " + savedParticipants + ".</p>";
        results.innerHTML += extraResults;
        results.classList.add("showing")
    }
    
    results.setAttribute("tabindex",0); 
    resizeContainer();
}
function retrieveData(save, check) {
    if (!VLE.serverversion) {
        // uncomment out when testing locally so to use local storage
        /*savedGroupObj = JSON.parse(localStorage.getItem("savedGroupObj"));
        savedObj = JSON.parse(localStorage.getItem("savedObj"));
        savedParticipants = JSON.parse(localStorage.getItem("savedParticipants"));
        afterRetrieve(save, check);
        if(save){
            document.getElementById("notSaved").classList.remove("hidden");
            resizeContainer();
        }*/
    } else {
        VLE.get_server_data(false, ["pollGroup", "participants"], function (groupData) {
            if (groupData.pollGroup !== "") {
                savedGroupObj = JSON.parse(groupData.pollGroup)
            }
            if (groupData.participants !== "") {
                savedParticipants = JSON.parse(groupData.participants)
            }
            VLE.get_server_data(true, ["pollIndiv"], function (data) {
                if (data.pollIndiv !== "") {
                    savedObj = JSON.parse(data.pollIndiv)
                }
                afterRetrieve(save, check);
                return;
            }, function (msg) {
                console.log("Failed to get server data.");
                savedObj = null;
                //comment out when testing locally so to use local storage
                afterRetrieve(save, check);/**/
                return null;
                if (msg !== null) {
                    console.log(msg);
                }
            }, activityId, documentId, courseId);
            return;
        }, function (msg) {
            console.log("Failed to get server data.");
            return null;
            if (msg !== null) {
                console.log(msg);
            }
        }, activityId, documentId, courseId);
    }
}
function afterRetrieve(save, check) {
    if (savedObj === null) {
        savedObj = {};
    }
    if (savedGroupObj === null) {
        savedGroupObj = {};
    }
    if (savedParticipants === null) {
        savedParticipants = 0;
    }
    if (check) {
        for (var i in savedObj) {
            if (document.querySelector("#" + i).querySelector("input[type=range]") === null) {
                for (j = 0; j < savedObj[i].length; j++) {
                    document.querySelector("#" + savedObj[i][j]).setAttribute("checked", "checked");
                }
            } else {
                document.querySelector("#" + i).querySelector("input[type=range]").value = savedObj[i]
                document.querySelector("#" + i).querySelector("input[type=text]").value = savedObj[i]
            }

        }

    }
    if (save) {
        saveData();
    }
    checkAgainstSave();
}
function checkAgainstSave() {
    sameAsSave = true;
    var radios = document.querySelectorAll("input[type=\"radio\"],input[type=\"checkbox\"],input[type=\"range\"]")

    if (savedObj === null || JSON.stringify(savedObj) === "{}") {
        sameAsSave = false
    } else {

        for (var k = 0; k < radios.length; k++) {
            radios[k].setAttribute("disabled", "disabled");
            if (radios[k].type === "range") {
                radios[k].parentNode.querySelector("input[type=text]").setAttribute("disabled", "disabled");
            }
        }
        document.querySelector("#submitBtn").setAttribute("disabled", "disabled")
        showResults();   
        document.querySelector(".results").focus(); 
    }
}