var cfg;
var savedObj = {};
var savedGroupObj = {};
var savedParticipants = 0;
var activityId = null;
var documentId = null;
var courseId = null;
var resize, container, containerP;
var prevHeight = 0;
var loadedData = {
    css: false,
    js: false
};

(function () {
    container = document.querySelector("#pgContent")
    containerP = document.querySelector("#containAll")
    // load in css
    VLE.get_attachment("stylesheet", function (response) {
        document.getElementById("attachCSS").innerHTML = response;
        window.setTimeout(function () {
            console.log("w css")
            loadedData.css = true;
        }, 500);
    }, function () {
        if (VLE.serverversion) {
            console.log("no stylesheet attached");
            window.setTimeout(function () {
                loadedData.css = true;
                document.getElementById("attachCSS").innerHTML = request.response;
            }, 500);
        } else {
            console.log("loading local version of stylesheet for testing purposes");
            var requestURL = 'styles.css';
            var request = new XMLHttpRequest();
            request.open('GET', requestURL);
            request.responseType = 'string';
            request.send();
            request.onload = function () {
                loadedData.css = true
                document.getElementById("attachCSS").innerHTML = request.response;
            };
        }
    });
    //load in json
    VLE.get_attachment("data", function (response) {
        cfg = JSON.parse(response);
        loadedData.js = true;
        setupQuestions();
    }, function () {
        if (VLE.serverversion) {
            console.log("issue loading data.json");
        } else {
            console.log("loading local version of json for testing purposes");
            var requestURL = 'cfg.json';
            var request = new XMLHttpRequest();
            request.open('GET', requestURL);
            request.responseType = 'string';
            request.send();
            request.onload = function () {
                cfg = JSON.parse(request.response);
                loadedData.js = true
                setupQuestions();
            };
        }
    });
    window.onresize = function () {
        resizeContainer();
    };
    checkLoaded();
    document.querySelector("#submitBtn").onclick = function () {
        var questionBlocks = document.querySelectorAll(".questionBlock")
        var hasChecked = 0;
        var rangeCount = 0;
        for (var i = 0; i < questionBlocks.length; i++) {
            questionBlocks[i].querySelector(".warning").classList.remove("hidden")
            if (questionBlocks[i].querySelectorAll("input[type=\"radio\"]:checked, input[type=\"checkbox\"]:checked").length !== 0) {
                questionBlocks[i].querySelector(".warning").classList.add("hidden")
                hasChecked++;
            }
            if (questionBlocks[i].querySelectorAll("input[type=\"range\"]").length !== 0) {
                questionBlocks[i].querySelector(".warning").classList.add("hidden")
                rangeCount++
            }
        }
        if ((document.querySelectorAll(".questionBlock").length - rangeCount) === hasChecked) {
            retrieveData(true, false);
            document.getElementById("notComplete").classList.add("hidden");
        } else {
            document.getElementById("notComplete").classList.remove("hidden");
        }
        resizeContainer();
    }
})();

function checkLoaded() {
    var count = 0;
    for (var i in loadedData) {
        if (!loadedData[i]) {
            window.setTimeout(function () {
                checkLoaded();
            }, 100)
        } else {
            count++;
        }
    }
    if (count === 2) {
        resizeContainer();
    }
}
function resizeContainer() {
    if (typeof resize !== "undefined") {
        clearTimeout(resize);
    }
    resize = setTimeout(function () {
        if (prevHeight !== containerP.offsetHeight) {
            prevHeight = containerP.offsetHeight;
            VLE.resize_iframe();
        } else {
            clearTimeout(resize);
        }
    }, 250);
}

function setupQuestions() {
    var feedbackO = document.querySelector(".msgs").appendChild(document.createElement("div"))
        feedbackO.classList.add("fbk-all"); 
        feedbackO.classList.add("hidden")
    var feedbackT = container.appendChild(document.createElement("div"))
        feedbackT.classList.add("fbk-top"); 
        feedbackT.classList.add("hidden")
    for (var q in cfg.questions) {
        var qBlock = document.createElement("fieldset");
        qBlock.classList.add("questionBlock");
        qBlock.id = "block" + q
        // create warnings used when question not completed
        var qH = qBlock.appendChild(document.createElement("legend"))
        var qWarn = qH.appendChild(document.createElement("span"))
        qWarn.classList.add("hidden");
        qWarn.classList.add("warning");
        qWarn.innerHTML = "*";
        qH.classList.add("question");
        qH.appendChild(document.createTextNode(cfg.questions[q].question));
        var chartType = "bar";
        if (typeof cfg.questions[q].chart !== "undefined") {
            chartType = cfg.questions[q].chart;
        }
        qBlock.classList.add(chartType+"-chart");
        qBlock.setAttribute("data-chart", chartType);
        qBlock.setAttribute("data-qid", q);
        //create gradings
        var qGrade = qBlock.appendChild(document.createElement("div"))
        qGrade.classList.add("grade");
        if (cfg.questions[q].type !== "range") {
            for (var t in cfg.questions[q].answers) {
                var qTick = qGrade.appendChild(document.createElement("div"));
                qTick.classList.add("tick");
                var chkSpan = qTick.appendChild(document.createElement("span"));
                chkSpan.classList.add("chkSpan");
                var input = chkSpan.appendChild(document.createElement("input"));
                input.type = cfg.questions[q].type;
                input.id = q + t;
                input.name = q;
                var inputLbl = qTick.appendChild(document.createElement("label"));
                inputLbl.setAttribute("for", q + t);
                inputLbl.innerHTML = cfg.questions[q].answers[t].label;
                var chkBox = qTick.appendChild(document.createElement("span"));
                chkBox.classList.add("box");
                var chkBar = chkBox.appendChild(document.createElement("span"));
                chkBar.classList.add("bar");
                chkBar.style.width = 0;
                var pc = qTick.appendChild(document.createElement("span"));
                pc.classList.add("pc");
            }
        } else {
            var qTick = qGrade.appendChild(document.createElement("div"));
            qTick.classList.add("rng");
            var chkSpan = qTick.appendChild(document.createElement("span"));
            chkSpan.classList.add("chkSpan");
            var input = chkSpan.appendChild(document.createElement("input"));
            input.type = cfg.questions[q].type;
            input.id = q;
            input.name = q;
            input.min = cfg.questions[q].min;
            input.max = cfg.questions[q].max;
            input.value = cfg.questions[q].default || cfg.questions[q].max / 2;
            input.step = cfg.questions[q].steps;
            input.onchange = function () {
                if (Number(this.value) > cfg.questions[this.id].max) {
                    this.value = cfg.questions[this.id].max
                }
                this.parentNode.querySelector(".rangeTxt").value = this.value
            }
            var inputTxt = chkSpan.appendChild(document.createElement("input"));
            inputTxt.type = "text";
            inputTxt.classList.add("rangeTxt");
            inputTxt.value = input.value;

            inputTxt.onchange = function () {
                this.parentNode.querySelector("input[type=range]").value = this.value
            }
            inputTxt.onkeyup = function () {
                this.parentNode.querySelector("input[type=range]").value = this.value
            }
        }

        var qFbk = qBlock.appendChild(document.createElement("div"))
        qFbk.classList.add("qFbk");
        qFbk.id="qfbk-"+q;
        var qResults = qFbk.appendChild(document.createElement("div"))
        qResults.classList.add("results");
        var qChart = qFbk.appendChild(document.createElement("div"))
        qChart.classList.add("chart");
       
        if(cfg.feedbacktype==="overall"){
            feedbackO.appendChild(qFbk)
        }



        container.appendChild(qBlock)
    }
    
    
    containPollsFbk=document.querySelector("#containPolls").appendChild(document.createElement("div"))
    containPollsFbk.id="containPollsFbk";
    var revealFbkBtn=document.createElement("button");
    revealFbkBtn.id="revealFbkBtn";
    revealFbkBtn.classList.add("hidden");
    revealFbkBtn.innerText="Reveal feedback"
    revealFbkBtn.onclick=function(){
        if(this.innerText==="Reveal feedback") {
            this.innerText="Hide feedback"
            document.querySelector(".fbk-all").classList.remove("hidden");
            
            resizeContainer();
        } else {
            this.innerText="Reveal feedback"
            document.querySelector(".fbk-all").classList.add("hidden");
            resizeContainer();
        }
    }
    document.querySelector(".fbk-all").parentNode.insertBefore(revealFbkBtn, document.querySelector(".fbk-all"))
    if (VLE.serverversion) {
        activityId = VLE.get_param('activity_id') || VLE.get_param('_a');
        documentId = VLE.get_param('document_id') || VLE.get_param('_i');
        courseId = VLE.get_param('course_id') || VLE.get_param('_c');
    }
    retrieveData(false, true);
    checkAgainstSave();
}
function saveData() {
    var obj = {};
    var qs = document.querySelectorAll(".questionBlock");
    for (var i = 0; i < qs.length; i++) {
        if (qs[i].querySelector("input[type=range]")) {
            if (typeof obj[qs[i].id] === "undefined") {
                obj[qs[i].id] = qs[i].querySelector("input[type=range]").value
            }
            if (typeof savedGroupObj[qs[i].id] === "undefined") {
                savedGroupObj[qs[i].id] = []
            }
            savedGroupObj[qs[i].id].push(qs[i].querySelector("input[type=range]").value)
            //obj[qs[i].id].push(slctd.id)
        } else {
            var inputs = qs[i].querySelectorAll("input:checked")
            for (var o = 0; o < inputs.length; o++) {
                var slctd = inputs[o];
                if (slctd !== null) {
                    if (typeof obj[qs[i].id] === "undefined") {
                        obj[qs[i].id] = []
                    }
                    obj[qs[i].id].push(slctd.id)
                }
                var rads = qs[i].querySelectorAll("input[type=\"radio\"], input[type=\"checkbox\"]");
                if (typeof savedGroupObj[qs[i].id] === "undefined") {
                    savedGroupObj[qs[i].id] = {}
                }
                for (var j = 0; j < rads.length; j++) {
                    if (typeof savedGroupObj[qs[i].id][rads[j].id] === "undefined") {
                        savedGroupObj[qs[i].id][rads[j].id] = 0
                    }
                    if (slctd !== null) {
                        if (slctd.id === rads[j].id) {
                            savedGroupObj[qs[i].id][rads[j].id]++
                        }
                    }
                }
            }
        }
    }
    savedParticipants++;
    savedObj = obj;
    if (!VLE.serverversion) {
        //comment out when testing locally so to use local storage
       /* localStorage.setItem("savedObj", JSON.stringify(obj));
        localStorage.setItem("savedGroupObj", JSON.stringify(savedGroupObj));
        localStorage.setItem("savedParticipants", savedParticipants);
        checkAgainstSave();*/
        document.getElementById("notSaved").classList.remove("hidden");
    } else {
        var saveIndiv = {
            pollIndiv: JSON.stringify(savedObj)
        }
        VLE.set_server_data(true, saveIndiv, function () {
            console.log("set_server_data was successful");
            var saveGroup = {
                pollGroup: JSON.stringify(savedGroupObj),
                participants: savedParticipants
            }
            VLE.set_server_data(false, saveGroup, function () {
                console.log("set_server_data was successful");
                checkAgainstSave();
            }, function (msg) {
                console.log("set_server_data has failed");
                if (msg !== null) {
                    console.log(msg);
                }
            }, undefined, null, activityId, documentId, courseId);
        }, function (msg) {
            console.log("set_server_data has failed");
            if (msg !== null) {
                console.log(msg);
            }
        }, undefined, null, activityId, documentId, courseId);
    }
}
function showResults() {
    var fbkTxts=document.querySelectorAll(".txtFbk")
    for(var fbt=0; fbt<fbkTxts.length; fbt++){
        fbkTxts[fbt].parentNode.removeChild(fbkTxts[fbt])
    }
    var chartColors=["#444449","#7cb5ec","#FF00FF","#FFFF00","#0FFFF0","#0000FF","#00FF00","#FF0000"]
    for(var c=0; c<Highcharts.charts.length; c++){
        Highcharts.charts[c].destroy();
    }    
    Highcharts.charts=[]
    var countResults=0;
    var results = document.querySelector(".fbk-top");
    if(cfg.feedbacktype==="overall"){
        results= document.querySelector(".fbk-all")
        document.querySelector("#revealFbkBtn").classList.remove("hidden")
    }
    var iNum=0;
    
    for (var i in savedObj) {
        extraResults = "";
        if(countResults===0){
            results.innerHTML=""
            results.innerHTML += "<p><b>You have voted.</b></p>";
            results.innerHTML += "<p>Total number of participants so far is " + savedParticipants + ".</p>";
        }

        var addResults=document.querySelector("#"+i).querySelector(".results")
        if(cfg.feedbacktype==="overall"){
            addResults=results;
        }  else {            
            addResults.innerHTML=""
        }
        var chart=addResults.appendChild(document.createElement("div"))
        chart.classList.add("chart")
        var txtFeedback=addResults.appendChild(document.createElement("div"))
        txtFeedback.classList.add("txtFbk")
        if(typeof cfg.pieChartPosition !=="undefined"){
            if(cfg.pieChartPosition==="top"){
                if(iNum===0){
                    var chartsTop=addResults.appendChild(document.createElement("div"))
                    chartsTop.classList.add("chartsTop")
                }
                document.querySelector(".chartsTop").appendChild(chart)
            }
        }
        iNum++
        
       
        var question=document.querySelector("#"+i).getAttribute("data-qid")
        var chartTtl=cfg.questions[question].question
        var chartSubTtl="";
        if(cfg.questions[question].beforeChart) {
            chartSubTtl=cfg.questions[question].beforeChart;
        }
        
        if(cfg.questions[question].type!=="range"){
            for(var j=0; j<savedObj[i].length; j++){
                if(cfg.questions[question].type!=="range"){
                    var fbk=cfg.questions[question].answers[savedObj[i][j].split(question)[1]].feedbackHTML
                    if(typeof fbk !=="undefined"){
                        txtFeedback.innerHTML+=fbk
                    }
                }       
            }
        } else {
            for (var j in cfg.questions[question].answers){
                if((Number(j.split("-")[0])<=Number(savedObj[i])) && (Number(j.split("-")[1])>=Number(savedObj[i]))) {
                var fbk=cfg.questions[question].answers[j].feedbackHTML
                if(typeof fbk !=="undefined"){
                    txtFeedback.innerHTML+=fbk
                }
                }
            }
        }

       

        if(cfg.questions[question].chart!=="none"){
            var xAxisLbls=[]
            var seriesData=[]
            var colorNum=0;
            var rangeObj={};
            var ranges=[]
            if(cfg.questions[question].type==="range") {
                for(var y in cfg.questions[question].answers){
                    ranges.push(y)
                }
                for(var z in savedGroupObj){
                    if(question===z.split("block")[1]){   
                        for(var x = 0; x<savedGroupObj[z].length; x++) {
                            for(var w=0; w<ranges.length;w++){
                                var rangeNums=ranges[w].split("-")
                                if(Number(rangeNums[0])<=Number(savedGroupObj[z][x]) && Number(rangeNums[1])>=Number(savedGroupObj[z][x])) {
                               
                                    if(typeof rangeObj[cfg.questions[question].answers[ranges[w]].label] ==="undefined"){
                                        rangeObj[cfg.questions[question].answers[ranges[w]].label]=0;
                                    }
                                    rangeObj[cfg.questions[question].answers[ranges[w]].label]++;
                                }
                            }
                        }
                    }
                }
            }

           
            if(cfg.questions[question].chart==="pie") {
                if(cfg.questions[question].type!=="range") {
                    for(var sd in savedGroupObj["block"+question]){
                        var qTxt=cfg.questions[question].answers[sd.split(question)[1]].label
                        seriesData.push({
                                name:qTxt,
                                color: chartColors[colorNum],
                                y: Number(savedGroupObj["block"+question][sd])
                            })

                        colorNum++
                    }
                } else {
                    for(var ro in rangeObj){
                        seriesData.push({
                            name:ro,
                            color: chartColors[colorNum],
                            y: Number(rangeObj[ro])
                        })
                        colorNum++
                    }
                }
            } else {
               
                  if(cfg.questions[question].type!=="range") {
                    for(var savedData in savedGroupObj["block"+question]){
                        var qTxt=cfg.questions[question].answers[savedData.split(question)[1]].label
                        xAxisLbls.push(qTxt)
                        seriesData.push({
                            name:qTxt,
                            color: chartColors[colorNum],
                            y: Number(savedGroupObj["block"+question][savedData])
                        })
                    }
                } else {
                    for(var ro in rangeObj){
                        xAxisLbls.push(ro)
                        seriesData.push({
                            name:ro,
                            color: chartColors[colorNum],
                            y: Number(rangeObj[ro])
                        })
                    }
                }
            }
           
            if(cfg.questions[question].chart==="pie"){
                Highcharts.chart(chart, {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        events: {
                            load: function() {
                                resizeContainer()
                            }
                        }
                    },
                    title: {
                        text: chartTtl
                    },
                    subtitle: {
                        text: chartSubTtl
                    },
                    
                        credits: {
                            enabled: false
                        },
                    tooltip: {
                        formatter: function(){
                            var percentNum=this.point.percentage
                            if(typeof String(percentNum).split(".")[1] !== "undefined"){
                                percentSplit=String(percentNum).split(".")
                                if(percentSplit[1].length>1){
                                    percentNum=percentSplit[0]+"."+percentSplit[1].substr(0,2)
                                }
                            }
                            return this.key+": "+Number(percentNum)+"%";
                        }
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        },
                        enabled: true
                    },
                    plotOptions: {
                        pie: {
                            dataLabels: {
                                enabled: false
                            },
                            showInLegend: true
                        }
                    },
                    series: [{
                        type:"pie",
                        data: seriesData
                    }]
                });
            } else if(cfg.questions[question].chart==="bar"){
                Highcharts.chart(chart, {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'bar',
                        events: {
                            load: function() {
                                resizeContainer()
                            }
                        }
                    },
                    title: {
                        text: chartTtl
                    },
                    subtitle: {
                        text: chartSubTtl
                    },
                    
                        credits: {
                            enabled: false
                        },
                    tooltip: {
                        formatter: function () {
                            return this.key + ": " + this.y;
                        }
                    },
                    accessibility: {
                        enabled: true
                    },
                    xAxis: {
                        categories: xAxisLbls
                    },
                    yAxis: {
                        title: {
                            text: 'Votes'
                        }
                    },
                    plotOptions: {
                        bar: {
                            dataLabels: {
                                enabled: false
                            },
                            showInLegend: true
                        }
                    },
                    legend: {
                        enabled: false
                    },
                    series: [{
                        color:chartColors[0],
                        name: 'Number',
                        data: seriesData
                    }]
                });
            }
            
        }

        var theQ=i.split("block")[1]
        var answers=cfg.questions[theQ].answers
        var groupedAnswers={}
        if(cfg.questions[theQ].type!=="range"){
            for(var ii =0; ii<savedObj[i].length; ii++){
                groupedAnswers=answers[savedObj[i][ii].split(theQ)[1]].combineFeedback
            }
        } else {
            for(var aa in answers){
                if(Number(aa.split("-")[0])<=savedObj[i] && Number(aa.split("-")[1])>=savedObj[i]) {
                    groupedAnswers=answers[aa].combineFeedback
                   
                }
            }
        }
        for(var jj in groupedAnswers){
            if(cfg.questions[jj].type==="range"){
                for(var kk in groupedAnswers[jj]){
                    if((Number(savedObj["block"+jj])>=Number(kk.split("-")[0])) && (Number(savedObj["block"+jj])<=Number(kk.split("-")[1]))){
                        txtFeedback.innerHTML+=groupedAnswers[jj][kk].feedbackHTML
                    }
                }
            } else {
                for(var kk in groupedAnswers[jj]){
                    for(var bb=0; bb<savedObj["block"+jj].length; bb++){
                        if(savedObj["block"+jj][bb].split(jj)[1]===kk){
                            txtFeedback.innerHTML+=groupedAnswers[jj][savedObj["block"+jj][bb].split(jj)[1]].feedbackHTML
                        }                       
                    }
                    
                }
            }
           
        }
        countResults++
    }
    if(cfg.allFbk) {
        var str=""
        for(var b in savedObj){
            var rad=b.split("block")[1]
            str+=rad+":"+savedObj[b][0].split(rad)[1]+";";
        }
        for(var aFbk in cfg.allFbk){
            if(document.querySelector(aFbk)) {
                if(cfg.allFbk[aFbk][str]){
                    document.querySelector(aFbk).innerHTML+=cfg.allFbk[aFbk][str]
                }
            }
        }
    }
    if(cfg.feedbacktype==="overall"){
        document.querySelector("#revealFbkBtn").classList.remove("hidden");
    }  else {
        results.classList.remove("hidden")
    }

    
    resizeContainer();
}
function retrieveData(save, check) {
    if (!VLE.serverversion) {
        //comment out when testing locally so to use local storage
        /*savedGroupObj = JSON.parse(localStorage.getItem("savedGroupObj"));
        savedObj = JSON.parse(localStorage.getItem("savedObj"));
        savedParticipants = JSON.parse(localStorage.getItem("savedParticipants"));
        afterRetrieve(save, check);*/
        if(save){
            document.getElementById("notSaved").classList.remove("hidden");
            resizeContainer();
        }
    } else {
        VLE.get_server_data(false, ["pollGroup", "participants"], function (groupData) {
            if (groupData.pollGroup !== "") {
                savedGroupObj = JSON.parse(groupData.pollGroup)
            }
            if (groupData.participants !== "") {
                savedParticipants = JSON.parse(groupData.participants)
            }
            VLE.get_server_data(true, ["pollIndiv"], function (data) {
                if (data.pollIndiv !== "") {
                    savedObj = JSON.parse(data.pollIndiv)
                }
                afterRetrieve(save, check);
                return;
            }, function (msg) {
                console.log("Failed to get server data.");
                savedObj = null;
                //comment out when testing locally so to use local storage
                afterRetrieve(save, check);/**/
                return null;
                if (msg !== null) {
                    console.log(msg);
                }
            }, activityId, documentId, courseId);
            return;
        }, function (msg) {
            console.log("Failed to get server data.");
            return null;
            if (msg !== null) {
                console.log(msg);
            }
        }, activityId, documentId, courseId);
    }
}
function afterRetrieve(save, check) {
    if (savedObj === null) {
        savedObj = {};
    }
    if (savedGroupObj === null) {
        savedGroupObj = {};
    }
    if (savedParticipants === null) {
        savedParticipants = 0;
    }
    if (check) {
        for (var i in savedObj) {
            if (document.querySelector("#" + i).querySelector("input[type=range]") === null) {
                for (j = 0; j < savedObj[i].length; j++) {
                    document.querySelector("#" + savedObj[i][j]).setAttribute("checked", "checked");
                }
            } else {
                document.querySelector("#" + i).querySelector("input[type=range]").value = savedObj[i]
                document.querySelector("#" + i).querySelector("input[type=text]").value = savedObj[i]
            }

        }

    }
    if (save) {
        saveData();
    }
    checkAgainstSave();
}
function checkAgainstSave() {
    sameAsSave = true;
    var radios = document.querySelectorAll("input[type=\"radio\"],input[type=\"checkbox\"],input[type=\"range\"]")

    if (savedObj === null || JSON.stringify(savedObj) === "{}") {
        sameAsSave = false
    } else {

        for (var k = 0; k < radios.length; k++) {
            radios[k].setAttribute("disabled", "disabled");
            if (radios[k].type === "range") {
                radios[k].parentNode.querySelector("input[type=text]").setAttribute("disabled", "disabled");
            }
        }
        document.querySelector("#submitBtn").setAttribute("disabled", "disabled")
        showResults();
    }
}