var int = int || {};

int.layout = (function () {
    var windowHeight = null;
    var resizeWindow = null;
    var intMed=document.getElementById("interactive-media");
    var currI=0;
    var shuffle=[];
    var init = function () {
        //setupAnswers
        var aDiv=intMed.appendChild(document.createElement("div"));
        var aDivfieldset=aDiv.appendChild(document.createElement("fieldset"));
        var aDivLegend=aDivfieldset.appendChild(document.createElement("legend"));
        aDivLegend.innerHTML="Which is binding on the present court?"
        aDiv.classList.add("answers");
        for(var a=0; a<answers.length; a++){
            var lbl= aDivfieldset.appendChild(document.createElement("label"));
           var inp= lbl.appendChild(document.createElement("input"));
           inp.type="radio"
           lbl.innerHTML+=answers[a]
        }
        var count=0
        var qContain=intMed.appendChild(document.createElement("div"));
            qContain.id="qContain";
        for(var i in cfg){
            var qDiv=qContain.appendChild(document.createElement("div"));
            qDiv.id="q-"+count;
            qDiv.setAttribute("tabindex","0");
            shuffle.push(qDiv.id)
            qDiv.classList.add("qDiv");
            var tblQ=qDiv.appendChild(document.createElement("table"));
            var thead=tblQ.appendChild(document.createElement("thead"));
            var tbody=tblQ.appendChild(document.createElement("tbody"));
            var tblQRow0=thead.appendChild(document.createElement("tr"));
            var tblQRow1=tbody.appendChild(document.createElement("tr"));
            //Earlier Precedent
            var earlieTh=tblQRow0.appendChild(document.createElement("th"));
            var earlieTd=tblQRow1.appendChild(document.createElement("td"));
            earlieTh.innerHTML="Earlier Precedent";
            earlieTd.innerHTML=cfg[i].Earlier;
            //Later Precedent
            var laterTh=tblQRow0.appendChild(document.createElement("th"));
            var laterTd=tblQRow1.appendChild(document.createElement("td"));
            laterTh.innerHTML="Later Precedent";
            laterTd.innerHTML=cfg[i].Later;
            //Present Case
            var presenTh=tblQRow0.appendChild(document.createElement("th"));
            var presenTd=tblQRow1.appendChild(document.createElement("td"));
            presenTh.innerHTML="Present Case";
            presenTd.innerHTML=cfg[i].Present;
            //Answers
            var qAnswers=qDiv.appendChild(aDiv.cloneNode(true))
            for(var q =0; q<qAnswers.querySelectorAll("input").length; q++){
                qAnswers.querySelectorAll("input")[q].name=qDiv.id
            }
            count++;
        }
        aDiv.parentNode.removeChild(aDiv);
        shuffleArr(shuffle)
       

        //check button
        var checkBtn= intMed.appendChild(document.createElement("button"));
        checkBtn.innerHTML="Check your answer"
        checkBtn.id="checkBtn"
        checkBtn.onclick=function(){
            checkAnswer()
        }
        //reset button
        var revealBtn= intMed.appendChild(document.createElement("button"));
        revealBtn.innerHTML="Reveal answer"
        revealBtn.id="revealBtn"
        revealBtn.onclick=function(){
            revealAnswer()
        }
        //reset button
        var resetBtn= intMed.appendChild(document.createElement("button"));
        resetBtn.innerHTML="Reset";
        resetBtn.id="resetBtn"
        resetBtn.onclick=function(){
            resetAnswers()
        }
        //reset button
        var nextBtn= intMed.appendChild(document.createElement("button"));
        nextBtn.innerHTML="New question";
        nextBtn.id="nextBtn"
        nextBtn.onclick=function(){
            showQ();
        }
        //feedback
        var fbkDiv= intMed.appendChild(document.createElement("div"));
        fbkDiv.id="fbk"
        fbkDiv.setAttribute("aria-live","polite");
        window.onresize = function () {
            resizeInt()
        };
        showQ()
    }
        
    var showQ = function(){
        resetFbk();
        
        chkStatus(true)
        document.querySelector("#checkBtn").removeAttribute("disabled");
        if(document.querySelector("#"+shuffle[currI-1]+ " input:checked")){
            document.querySelector("#"+shuffle[currI-1]+ " input:checked").checked=false
        }
        if(currI>(shuffle.length-1)){
            shuffleArr(shuffle)
            currI=0
        }
        var qDivs=document.querySelectorAll(".qDiv");
        for(var q =0; q<qDivs.length; q++){
            qDivs[q].classList.add("hidden")
        }
        document.querySelector("#"+shuffle[currI]).classList.remove("hidden");
        document.querySelector("#"+shuffle[currI]).focus()
            currI++;
            
       
    }
    var shuffleArr = function(arr) {
        var i = arr.length, tval, rdmi;
        
        while (0 !== i) {
        
            rdmi = Math.floor(Math.random() * i);
            i -= 1;
        
            tval = arr[i];
            arr[i] = arr[rdmi];
            arr[rdmi] = tval;
        }
        for(var j=0; j<arr.length; j++){
            qContain.appendChild(document.querySelector("#"+arr[j]))
            var allInps=document.querySelectorAll("#"+arr[j]+" input")
            for(var k=0; k<allInps.length; k++){
                allInps[k].onchange=function(){
                    resetFbk();
               }
            }
           
        }
    }
    var resizeInt = function () {
        clearTimeout(resizeWindow);
        resizeWindow = setTimeout(function () {
            if (windowHeight !== document.getElementById("interactive-media").offsetHeight) {
                windowHeight = document.getElementById("interactive-media").offsetHeight;
                VLE.resize_iframe();
            } else {
                clearTimeout(resizeWindow);
            }
        }, 250);
    }

    var resetFbk = function(){
        document.querySelector("#nextBtn").classList.add("hidden");
        document.querySelector("#fbk").innerHTML=""
    }
    var resetAnswers = function(){
        resetFbk()
        document.querySelector("#revealBtn").removeAttribute("disabled")
        document.querySelector("#checkBtn").removeAttribute("disabled")
        var allChecks=document.querySelectorAll(".answers input")
        for(var i=0; i<allChecks.length; i++){
            allChecks[i].checked=false;
        }
        resizeInt()
    }
    var checkAnswer = function(){
        resetFbk();
        var answersCorrect=true;
        var correctAnswer="";
        var checked=document.querySelector(".qDiv:not(.hidden) input:checked")
        if(checked ===null) {
            answersCorrect=false
            correctAnswer=cfg[document.querySelector(".qDiv:not(.hidden)").id.split("-")[1]].Answer 
            
            document.querySelector("#fbk").innerHTML="Please select an answer."
        } else {
            if(cfg[checked.name.split("-")[1]].Answer !== checked.parentNode.innerText){
                answersCorrect=false;
                correctAnswer=cfg[checked.name.split("-")[1]].Answer 
            }
            if(answersCorrect){
                document.querySelector("#fbk").innerHTML="Your answer is correct."
                document.querySelector("#checkBtn").disabled=true;
                document.querySelector("#nextBtn").classList.remove("hidden");
            }  else {
                document.querySelector("#fbk").innerHTML="Your answer is incorrect. The correct answer is "+correctAnswer+"."
                document.querySelector("#checkBtn").disabled=true;
                document.querySelector("#nextBtn").classList.remove("hidden");
            }
            document.querySelector("#fbk").innerHTML+=cfg[checked.name.split("-")[1]].Comment 
            chkStatus(false)
        }
        resizeInt()
    }
    var chkStatus = function(enabled){
        var inps=document.querySelectorAll(".qDiv:not(.hidden) input");
        for(var i=0; i<inps.length; i++){
            if(enabled) {
                inps[i].removeAttribute("disabled");
                inps[i].parentNode.classList.remove("disabled");
            } else {
                inps[i].setAttribute("disabled",true);
                inps[i].parentNode.classList.add("disabled");
            }
        }
    }
    var revealAnswer = function(){
        resetFbk()
        document.querySelector("#revealBtn").disabled=true
        document.querySelector("#checkBtn").disabled=true
        for(var i in cfg){
            var lbls=document.querySelector("#q-"+i).querySelectorAll("label")
            for(var j =0; j<lbls.length; j++){
                if(lbls[j].innerText===cfg[i].Answer){
                    lbls[j].click();
                }
            }
        }
        resizeInt()
    }
    return {
        init: init,
        resizeInt: resizeInt,
        resetAnswers:resetAnswers,
        checkAnswer:checkAnswer,
        revealAnswer:revealAnswer
    };
})();



