var Activity = (function () {
    var _data;

    function Activity(data) {
        _data = data;

        $("body").append("<div id='content'><table><tr id='tr0'/></table></div>");
        $("#tr0").append("<th/>");

        var i;
        for (i = 0; i < data.list.length; ++i) {
            $("th").append("<div id='tr" + i + "'><h1>" + data.dates[i].text + "</h1></div>");
        }

        $("#tr0").append("<td rowspan='14'/>");

        $("td").append("<ul id='sortable'/>");

        for (i = 0; i < data.list.length; ++i) {
            $("#sortable").append("<li id='choice" + i + "' tabindex='1' class='ui-state-default'><span class='ui-icon ui-icon-arrowthick-2-n-s'></span><img src='" + data.images[i].text + "' alt='" + data.list[i].text + "'></img></li>");
        }

        var choices = shuffleArray($("li").toArray());
        $("#sortable").html = "";
        $("#sortable").append(choices);

        $("#sortable").sortable({
            items: "li:not(.unsortable)"
        });

        $("#sortable li").bind("keydown", function (event) {
            var current, id;

            if (event.which == 38) {
                event.preventDefault();
                current = $(this).html();
                id = this.id;
                if ($(this).prev().length > 0) {
                    $(this).html($(this).prev().html());
                    $(this).prop("id", $(this).prev()[0].id);
                    $(this).prev().html(current).focus();
                    $(this).prev().prop("id", id);

                    $("li").removeClass("unsortable");
                }
            } else if (event.which == 40) {
                event.preventDefault();
                if ($(this).next().length > 0) {
                    current = $(this).html();
                    id = this.id;
                    $(this).html($(this).next().html());
                    $(this).prop("id", $(this).next()[0].id);
                    $(this).next().html(current).focus();
                    $(this).next().prop("id", id);

                    $("li").removeClass("unsortable");
                }
            }
        });

        $content = $("#content");
        $content.append("<div><input id='submit' type='button' value='Submit'/><input id='reveal' type='button' value='Reveal'/></div>");

        $("#submit").button().click(function () {
            submit();
        });

        $("#reveal").button().click(function () {
            reveal();
        });

        retrieveDataFromVLE();
    }

    function submit() {
        var count = 0;

        $("li").each(function (index, element) {
            var tag = $("img", element).attr("alt");
            if (tag == data.list[index].text) {
                $(element).addClass("unsortable");
                count++;
            }
        });

        $("#feedback").remove();
        if (count < data.list.length) {
            if (count == 1) {
                $("#content").append("<div id='feedback'>" + count + data.feedback[2].text + "</div>");
            } else {
                $("#content").append("<div id='feedback'>" + count + data.feedback[1].text + "</div>");
            }
        } else if (count == data.list.length) {
            $("#content").append("<div id='feedback'>" + data.feedback[0].text + "</div>");

            $("#submit").off("click").val("Reset").click(function () {
                reset();
            });
        }

        $("#sortable").sortable({
            update: function () {
                $("li").removeClass("unsortable");
            }
        });

        saveDataToVLE();
    }

    function reset() {
        var choices = shuffleArray($("li").toArray());
        $("#sortable").html = "";
        $("#sortable").append(choices);

        $("li").removeClass("unsortable").removeAttr("style");

        $("#submit").off("click").val("Submit").click(function () {
            submit();
        });

        $("#feedback").remove();

        saveDataToVLE();
    }

    function reveal() {
        $("#sortable").remove();
        $("td").append("<ul id='sortable'/>");

        for (i = 0; i < data.list.length; ++i) {
            $("#sortable").append("<li id='choice" + i + "' style='cursor: default' class='ui-state-default unsortable'><span class='ui-icon ui-icon-arrowthick-2-n-s'></span><img src='" + data.images[i].text + "' alt='" + data.list[i].text + "'></img></li>");
        }

        $("#sortable").sortable({ cancel: ".unsortable" });

        $("#submit").off("click").val("Reset").click(function () {
            reset();
        });

        $("#feedback").remove();

        saveDataToVLE();
    }

    function shuffleArray(array) {
        var i, j, temp;
        for (i = array.length - 1; i > 0; i--) {
            j = Math.floor(Math.random() * (i + 1));
            temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    }

    function saveDataToVLE() {
        var temp = {
            data: []
        };

        $("li").each(function (index, element) {
            temp.data[index] = element.innerHTML;
        });

        temp.data = JSON.stringify(temp.data);

        VLE.set_server_data(true, temp, function () {
            console.log("set_server_data was successful");
        }, function (msg) {
            console.log("set_server_data has failed");
            if (msg !== null) {
                console.log(msg);
            }
        });
    }

    function retrieveDataFromVLE() {
        var array = [];
        array.push("data");

        VLE.get_server_data(true, array, function (savedData) {
            if (savedData.data !== "") {
                var data = JSON.parse(savedData.data);

                $("#sortable").remove();
                $("td").append("<ul id='sortable'/>");

                for (i = 0; i < data.length; ++i) {
                    $("#sortable").append("<li id='choice" + i + "' tabindex='1' class='ui-state-default'></li>");
                    $("#choice" + i).html(data[i]);
                }

                $("#sortable").sortable({
                    items: "li:not(.unsortable)"
                });

                $("#sortable li").bind("keydown", function (event) {
                    var current, id;

                    if (event.which == 38) {
                        event.preventDefault();
                        current = $(this).html();
                        id = this.id;
                        if ($(this).prev().length > 0) {
                            $(this).html($(this).prev().html());
                            $(this).prop("id", $(this).prev()[0].id);
                            $(this).prev().html(current).focus();
                            $(this).prev().prop("id", id);

                            $("li").removeClass("unsortable");
                        }
                    } else if (event.which == 40) {
                        event.preventDefault();
                        if ($(this).next().length > 0) {
                            current = $(this).html();
                            id = this.id;
                            $(this).html($(this).next().html());
                            $(this).prop("id", $(this).next()[0].id);
                            $(this).next().html(current).focus();
                            $(this).next().prop("id", id);

                            $("li").removeClass("unsortable");
                        }
                    }
                });
            }
        }, function (msg) {
            console.log("Failed to get server data.");
            if (msg !== null) {
                console.log(msg);
            }
        });
    }

    return Activity;
}());

var act = new Activity(data);