/*global $:false, data, VLE */

function changeText() {
    var i;
    for (i = 0; i < data.labels.length; ++i) {
        $("#text" + i).text(i + 1);
    }

    var id = this.id.replace("text", "");
    this.innerText = data.labels[parseInt(id)].text;
}

$(function () {
    $("body").prepend("<div id='content'/>");
    $("#content").append(" <img src='" + data.image + "'></img>");

    var i;
    for (i = 0; i < data.labels.length; ++i) {
        $("#content").append("<div id='text" + i + "' tabindex='1'>" + (i + 1) + "</div>");
    }

    for (i = 0; i < data.labels.length; ++i) {
        $("#text" + i).css("left", data.labels[i].left).css("top", data.labels[i].top);
    }

    var $text = $("div[id^='text']");
    $text.on("click", changeText);

    $("html").on("keyup", function (event) {
        var nodeName = event.target.nodeName.toLowerCase();
        if (event.which === 13) {
            if (nodeName == "div") {
                var i;
                for (i = 0; i < data.labels.length; ++i) {
                    $("#text" + i).text(i + 1);
                }

                var id = event.target.id.replace("text", "");
                event.target.innerText = data.labels[parseInt(id)].text;
            }
        }
    });
});