// quiz with numbered questions and lettered answers
// questions and answers are shuffled
// questions are only shown on correct answer
// attempt results shown at end
var settings={
    numberQuestions:false,
    letterAnswers:false,
    shuffleAnswers:false,
    type:"quiz"
};
var questions=[
    {
        "question": "<p>Taken a small item (e.g. a pen, batteries, toilet paper) home from work for personal use.</p>",
        "options":[
            {
                "label":"Yes",
                "answer":true,
                "feedback":"<p>Taking small items from work may be considered a perk of the job, but if you intended to keep them and knew that your employer did not agree, then it could be theft.</p>"
            },
            {
                "label":"No",
                "answer": true,
                "feedback": "<p>Taking small items from work may be considered a perk of the job, but if you intended to keep them and knew that your employer did not agree, then it could be theft.</p>"
            }
        ]
    }, {
        "question": "<p>Said nothing when you were undercharged or given too much change in a shop.</p>",
        "options": [
            {
                "label": "Yes",
                "answer": true,
                "feedback": "<p>Knowingly underpaying or accepting too much change is theft if other people would consider it dishonest.</p>"
            },
            {
                "label": "No",
                "answer": true,
                "feedback": "<p>Knowingly underpaying or accepting too much change is theft if other people would consider it dishonest.</p>"
            }
        ]
    }, {
        "question": "<p>Driven a vehicle above the speed limit.</p>",
        "options": [
            {
                "label": "Yes",
                "answer": true,
                "feedback": "<p>Driving above the speed limit is an offence – even if it isn’t dangerous and even if you didn’t realise how fast you were going.</p>"
            },
            {
                "label": "No",
                "answer": true,
                "feedback": "<p>Driving above the speed limit is an offence – even if it isn’t dangerous and even if you didn’t realise how fast you were going.</p>"
            }
        ]
    }, {
        "question": "<p>Opened a letter or parcel addressed to somebody else.</p>",
        "options": [
            {
                "label": "Yes",
                "answer": true,
                "feedback": "<p>Opening post addressed to someone else may be an offence if you did not have a ‘reasonable excuse’.</p>"
            },
            {
                "label": "No",
                "answer": true,
                "feedback": "<p>Opening post addressed to someone else may be an offence if you did not have a ‘reasonable excuse’.</p>"
            }
        ]
    }, {
        "question": "<p>Smoked a cigarette in a pub, café or restaurant.</p>",
        "options": [
            {
                "label": "Yes",
                "answer": true,
                "feedback": "<p>If you smoked that cigarette before 2 April 2007, you did not commit a crime. On or after that date, you did.</p>"
            },
            {
                "label": "No",
                "answer": true,
                "feedback": "<p>If you smoked that cigarette before 2 April 2007, you did not commit a crime. On or after that date, you did.</p>"
            }
        ]
    }, {
        "question": "<p>Ridden a bike on the pavement.</p>",
        "options": [
            {
                "label": "Yes",
                "answer": true,
                "feedback": "<p>Riding on footpaths is a crime. However, if you were under 10 years old at the time, you were below the age of criminal responsibility.</p>"
            },
            {
                "label": "No",
                "answer": true,
                "feedback": "<p>Riding on footpaths is a crime. However, if you were under 10 years old at the time, you were below the age of criminal responsibility.</p>"
            }
        ]
    }, {
        "question": "<p>Paid a tradesperson – or been paid – ‘cash in hand’.</p>",
        "options": [
            {
                "label": "Yes",
                "answer": true,
                "feedback": "<p>It is not a crime to pay in cash, but it is an offence for the person receiving the payment not to declare it for tax purposes.</p>"
            },
            {
                "label": "No",
                "answer": true,
                "feedback": "<p>It is not a crime to pay in cash, but it is an offence for the person receiving the payment not to declare it for tax purposes.</p>"
            }
        ]
    }, {
        "question": "<p>Received more items than you ordered online, and not told the seller.</p>",
        "options": [
            {
                "label": "Yes",
                "answer": true,
                "feedback": "<p>Accepting the extra items may be theft, if other people would consider it dishonest (that may depend upon the circumstances).</p>"
            },
            {
                "label": "No",
                "answer": true,
                "feedback": "<p>Accepting the extra items may be theft, if other people would consider it dishonest (that may depend upon the circumstances).</p>"
            }
        ]
    }, {
        "question": "<p>Found money in the street and kept it.</p>",
        "options": [
            {
                "label": "Yes",
                "answer": true,
                "feedback": "<p>Keeping the money could be theft, depending on the amount and circumstances. Could you have found the owner? Would other people consider it dishonest?</p>"
            },
            {
                "label": "No",
                "answer": true,
                "feedback": "<p>Keeping the money could be theft, depending on the amount and circumstances. Could you have found the owner? Would other people consider it dishonest?</p>"
            }
        ]
    }
]
//

var fieldsets, currFieldset;
var results = {
    totalAttempts:0,
    incorrectAttempts:0,
    correctAttempts:0,
    incorrectQuestions:{},
    answers:{},
    pointCount:0,
    groups:{},
    correctOnFirstAttempt:[]
};

var resize, questionnaire;
var prevHeight=0;
(function(){
    questionnaire =document.getElementById("questionnaire");
    buildQuestions(questionnaire);
    updateClass("add",questionnaire,settings.type);
    if(settings.type==="questionnaire" || settings.attemptResults===true){
        createEl(questionnaire,"div",null,"hidden",{"id":"displayResults"})
    }
    currFieldset=0;
    window.onresize = function(){
        resizeContainer();
    };
})();
function resizeContainer() {
    clearTimeout(resize);
    resize = setTimeout(function(){
        if(prevHeight!==questionnaire.offsetHeight) {
            prevHeight=questionnaire.offsetHeight;
            VLE.resize_iframe();
        } else {
            clearTimeout(resize);
        }
    }, 250);
}
function checkAllAnswered(){
    var allAnswered = true;
    if(settings.type==="quiz"){
        for(var i=0; i< fieldsets.length; i++){
            if(!hasClass(fieldsets[i],"correct")){
                allAnswered=false;
            }
        }
    } else if(settings.type==="questionnaire") {
        for(var j=0; j< fieldsets.length; j++){
            if(fieldsets[j].querySelectorAll("input:checked").length===0){
                allAnswered=false;
            }
        }
    }
    return allAnswered;
}
function buildQuestions(questionnaire){
    for(var i=0; i< questions.length; i++){
        var fieldset= createEl(questionnaire, "fieldset", null, null, {"id":"q-"+i});
        var question=questions[i].question;
        if(settings.numberQuestions) {
            question="<ol><li value=\""+(i+1)+"\">"+question+"</li></ol>";
        } else if(settings.letterQuestions) {
            question = "<ol><li style=\"list-style-type:lower-alpha\" type=\"a\" value=\"" + (i + 1) + "\">" + question + "</li></ol>";
        }
        var legend = createEl(fieldset, "legend", question, null, {"id":"leg-"+i});
        var answerContainer = createEl(fieldset, "div");
        createEl(legend, "div", "Please complete this question" , ["incomplete-msg"]);
        for(var j=0; j< questions[i].options.length; j++) {
            var indivAnswer = createEl(answerContainer, "div");
            indivAnswer.classList.add("indivAnswer")
            var input = createEl(indivAnswer, "input", null, null, {"type": "radio", "id": "rad-" + i+"-"+j, "name": "rad-"+i});
            var answer=questions[i].options[j].label;
            if(settings.numberAnswers) {
                answer="<ol><li value=\""+(j+1)+"\">"+answer+"</li></ol>";
            } else if(settings.letterAnswers) {
                answer = "<ol><li style=\"list-style-type:lower-alpha\" type=\"a\" value=\"" + (j + 1) + "\">" + answer + "</li></ol>";
            }
            createEl(indivAnswer, "label", null, null, {"for": "rad-" + i+"-"+j}, null,answer);
            input.onclick=function(){
                updateClass("remove", document.getElementById("q-"+this.id.split("-")[1]), "marked")
            }
        }
        if(settings.shuffleAnswers) {
            for (var l = answerContainer.children.length; l >= 0; l--) {
                answerContainer.appendChild(answerContainer.children[Math.random() * l | 0]);
            }
            if(settings.numberAnswers || settings.letterAnswers) {
                for(var m =0; m<answerContainer.children.length; m++) {
                    answerContainer.children[m].querySelector("ol li").value=m+1;
                }
            }
        }
        var nextBtn = createEl(fieldset, "button", "submit answer", "btn-chk-answer");
        nextBtn.onclick=function(){
            if(settings.type==="quiz"){
                quizClick(this.parentNode.querySelector("input:checked"),this.parentNode);
            } else if(settings.type="questionnaire") {
                questionnaireClick(this.parentNode.querySelector("input:checked"));
            }
            VLE.resize_iframe();

        }
        var fbk= createEl(fieldset, "div", null, null, {"class":"feedback"});
        fbk.setAttribute("aria-live","polite")
        if(!settings.showAllQuestions){
            updateClass("add",fieldset,"hidden");
        }
    }
    if(settings.shuffleQuestions) {
        var questionnaire = document.querySelector('#questionnaire');
        for (var l = questionnaire.children.length; l >= 0; l--) {
            questionnaire.appendChild(questionnaire.children[Math.random() * l | 0]);
        }
        if(settings.numberQuestions || settings.letterQuestions) {
            for(var m =0; m<questionnaire.children.length; m++) {
                questionnaire.children[m].querySelector("ol li").value=m+1;
            }
        }
    }
    fieldsets=document.querySelectorAll("fieldset");
    updateClass("remove",document.querySelectorAll("fieldset")[0],"hidden");
    VLE.resize_iframe();
}

//quiz specific
function quizClick(el,par){
   if(el===null){
       par.querySelector(".feedback").innerHTML="<p>Please select an answer</p>";
   } else {
    var currQ=Number(el.id.split("-")[1]);
    var currA=Number(el.id.split("-")[2]);
    
    updateClass("add", document.getElementById("q-"+currQ), "marked")
    if(questions[currQ].options[currA].answer){
        currFieldset++;
        results.answers[currQ]=currA;
        if(!results.incorrectQuestions[currQ]) {
            results.correctOnFirstAttempt.push(currQ);
        }
        if(!settings.showAllQuestions) {
            updateClass("remove", document.querySelectorAll("fieldset")[currFieldset], "hidden");
        }
        updateClass("add", el.parentNode.parentNode.parentNode,"correct");
        updateClass("add", document.getElementById("q-"+currQ).querySelector(".btn-chk-answer"),"hidden");
        document.getElementById("q-"+currQ).querySelector(".btn-chk-answer").setAttribute("disabled",true);
        if(typeof questions[currQ].options[currA].feedback!=="undefined") {
            el.parentNode.parentNode.parentNode.querySelector(".feedback").innerHTML=questions[currQ].options[currA].feedback;
        } else {
            el.parentNode.parentNode.parentNode.querySelector(".feedback").innerHTML="";
        }
        var opts=el.parentNode.parentNode.parentNode.querySelectorAll("input[type=\"radio\"]");
        for(var k=0; k<opts.length; k++){
            opts[k].setAttribute("disabled",true);
        }
    } else {
        if(typeof questions[currQ].options[currA].feedback!=="undefined") {
            el.parentNode.parentNode.parentNode.querySelector(".feedback").innerHTML=questions[currQ].options[currA].feedback;
        } else {
            el.parentNode.parentNode.parentNode.querySelector(".feedback").innerHTML="";
        }
        results.incorrectAttempts++;
        if(!results.incorrectQuestions[currQ]) {
            results.incorrectQuestions[currQ]=0;
        }
        results.incorrectQuestions[currQ]++;
    }
    results.totalAttempts++;
    if(checkAllAnswered() && settings.attemptResults){
        var displayResults="<h1>Results</h1>"
        displayResults=displayResults+"<p>You took "+results.totalAttempts+" attempts to answer "+questions.length+" questions.</p>";
        var multipleAttempts="";
        var multipleAttemptsDetail="";
        for(var o in results.incorrectQuestions){
            var correctAnswers="";
            var timesStr="time";
            var pluralStr="The correct answer to this question is ";
            if(Number(results.incorrectQuestions[o])>1){
                timesStr="times";
            }
            if(multipleAttempts===""){
                multipleAttempts="<h2>Following are the question/s answered correctly after multiple attempts</h2><p>You may want to revisit these topics.</p>";
            }

            for(var p=0; p<questions[o].options.length; p++) {
                if (questions[o].options[p].answer) {
                    if (correctAnswers !== "") {
                        correctAnswers = correctAnswers + " OR ";
                        pluralStr = "The correct answers to this question are ";
                    }
                    correctAnswers = correctAnswers + "<i>" + questions[o].options[p].label + "</i>";
                }
            }
            multipleAttemptsDetail=multipleAttemptsDetail+"<h3>"+questions[o].question+"</h3><p>You answered this question incorrectly "+results.incorrectQuestions[o]+" "+timesStr+". "+pluralStr +correctAnswers+".</p>";
        }
        displayResults=displayResults+multipleAttempts+multipleAttemptsDetail;
        document.getElementById("displayResults").innerHTML=displayResults;
        updateClass("remove",document.getElementById("displayResults"),"hidden");
    }
   }
    
}

//questionnaire specific
function questionnaireClick(){
//alert()
    if(checkAllAnswered()) {
        var displayResults="";
        var resultsNote="";
        results.groups={};
        results.pointCount = 0;
        for(var i=0; i< fieldsets.length; i++) {
            var el = fieldsets[i].querySelector("input:checked");
            var currQ = Number(el.id.split("-")[1]);
            var currA = Number(el.id.split("-")[2]);
            for(var k=0; k<fieldsets[i].querySelectorAll("input").length; k++){
                 fieldsets[i].querySelectorAll("input")[k].setAttribute("disabled",true);
            }
            if (settings.results === "points") {
                if (questions[currQ].options[currA].points) {
                    if (typeof questions[currQ].options[currA].points !== "undefined") {
                        results.pointCount = results.pointCount + questions[currQ].options[currA].points;
                    }
                }
            } else if (settings.results === "groups") {
                if(typeof questions[currQ].options[currA].group==="string") {
                    questions[currQ].options[currA].group=[questions[currQ].options[currA].group]
                }
                for(var test=0; test<questions[currQ].options[currA].group.length; test++){
                    if(typeof results.groups[questions[currQ].options[currA].group[test]] === "undefined"){
                        results.groups[questions[currQ].options[currA].group[test]]=0;
                    }
                    results.groups[questions[currQ].options[currA].group[test]]++;
                }
            }
        }
        if (settings.results === "groups") {
            var groupTotals = [];
            for (var j in results.groups) {
                groupTotals.push(results.groups[j]);
            }
            var highestTotal=Math.max.apply(null, groupTotals);
            for(var k in results.groups) {
                if(results.groups[k]===highestTotal){
                    if(displayResults!==""){
                        resultsNote="<p>You results were evenly split over more than one group</p>";
                    }
                     displayResults=displayResults+"<h2>"+k+"</h2>"+groups[k];
                }
            }
        } else if(settings.results==="points"){
            for (var l in points){
                if((results.pointCount>points[l].min && results.pointCount<points[l].max) || results.pointCount===points[l].min || results.pointCount===points[l].max){
                    displayResults=displayResults+"<h2>"+l+"</h2>"+points[l].display;
                }
            }
            resultsNote="<p>Your score was " +results.pointCount+ ".</p>";
        }
        document.getElementById("displayResults").innerHTML="<h1>Your results</h1>"+resultsNote+displayResults;
        updateClass("remove",document.getElementById("displayResults"),"hidden");
    } else {
        currFieldset++;
        if(!settings.showAllQuestions) {
            updateClass("remove", document.querySelectorAll("fieldset")[currFieldset], "hidden");
        }
    }
}


function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}

function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
};
