var resize, container;
var prevHeight = 0;

(function () {
    Highcharts.chart('chart0', {
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            events: {
                load: function() {
                    resizeContainer()
                }
            }
        },
        credits: {
            enabled: false
          },
        title: {
            text: ''
        },
        tooltip: {
            formatter: function () {
                return this.key + " " + this.y + "%";
            }
        },
        accessibility: {
            point: {
                valueSuffix: '%'
            },
            enabled: true
        },
        plotOptions: {
            pie: {
                dataLabels: {
                    enabled: false
                },
                showInLegend: true
            }
        },
        series: [{
            type:"pie",
            data: [{
                name: 'Women',
                color: '#7370b2',
                y: 32
            }, {
                name: 'Men',
                color: '#eb5f20',
                y: 68
            }]
        }]
    });
    Highcharts.chart('chart1', {
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            events: {
                load: function () {
                    resizeContainer()
                }
            }
        },
        title: {
            text: ''
        },
        credits: {
            enabled: false
          },
        tooltip: {
            formatter: function () {
                return this.key + " " + this.y + "%";
            }
            //pointFormat: '{series.name}: <b>{point.percentage:.0f}%</b>'
        },
        accessibility: {
            point: {
                valueSuffix: '%'
            },
            enabled: true
        },
        plotOptions: {
            pie: {
                dataLabels: {
                    enabled: false
                },
                showInLegend: true
            }
        },
        series: [{
            type: "pie",
            data: [{
                name: 'Black, Asian or ethnic minority',
                color: '#7370b2',
                y: 8
            }, {
                name: 'White',
                color: '#eb5f20',
                y: 92
            }]
        }]
    });
    Highcharts.chart('chart2', {
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            events: {
                load: function () {
                    resizeContainer()
                }
            }
        },
        title: {
            text: ''
        },
        credits: {
            enabled: false
          },
        tooltip: {
            formatter: function () {
                return this.key + " " + this.y + "%";
            }
            //pointFormat: '{series.name}: <b>{point.percentage:.0f}%</b>'
        },
        accessibility: {
            point: {
                valueSuffix: '%'
            },
            enabled: true
        },
        plotOptions: {
            pie: {
                dataLabels: {
                    enabled: false
                },
                showInLegend: true
            }
        },
        series: [{
            type: "pie",

            innerSize: '50%',
            data: [{
                name: '50 or over',
                color: '#7370b2',
                y: 76
            }, {
                name: 'Under 50',
                color: '#eb5f20',
                y: 24
            }]
        }, {
                type: "pie",

                size: '50%',
                data: [{
                    name: '60 or over',
                    color: '#7370b2',
                    y: 40
                }, {
                    name: 'Under 60',
                    color: '#eb5f20',
                    y: 60
                }]
            }]
    });
    container = document.querySelector("#container")

    window.onresize = function () {
        resizeContainer();
    };
})();  

function resizeContainer() {
    clearTimeout(resize);
    resize = setTimeout(function () {
        if (prevHeight !== container.offsetHeight) {
            prevHeight = container.offsetHeight;
            VLE.resize_iframe();
        } else {
            clearTimeout(resize);
        }
    }, 250);
}