$(document).ready(function (){
	
	/* TOOLTIP */	
	
	var changeTooltipPosition = function(event) {
		
		switch(this.id){
			case"button1":
			case"button2":
			 	var tooltipX = event.pageX + 10;
	  			var tooltipY = event.pageY - 50;
			  	$('div.tooltipleft').css({top: tooltipY, left: tooltipX});
			break;
			case"button3":
			case"button4":
			case"button5":
			case"button6":
			case"button7":
			 	var tooltipX = event.pageX - 160;
	  			var tooltipY = event.pageY - 50;
	  			$('div.tooltipright').css({top: tooltipY, left: tooltipX});
			break;
		} 
	};

	var showTooltip = function(event) {
		
		switch(this.id){
			case"button1":
				$('div.tooltipleft').remove();
				$('<div class="tooltipleft"><div class="tooltiplefttext">Island arc volcanoes <br/> e.g. (Philippines)</div></div>').appendTo('body');
			break;
			case"button2":
			 	$('div.tooltipleft').remove();
	  			$('<div class="tooltipleft">Plates collide with <br/> continental crust</div>').appendTo('body');
			break;
			case"button3":
				$('div.tooltipright').remove();
	  			$('<div class="tooltipright"><div class="tooltiprighttext">Creation and spreading <br/> of new crust</div></div>').appendTo('body');
			break;
			case"button4":
				$('div.tooltipright').remove();
	  			$('<div class="tooltipright"><div class="tooltiprighttext">Magma rises  and<br/> pushes plates sideways</div></div>').appendTo('body');
			break;
			case"button5":
				$('div.tooltipright').remove();
	  			$('<div class="tooltipright"><div class="tooltiprighttext">Mountain range <br/> (e.g. Andes)</div></div>').appendTo('body');
			break;
			case"button6":
				$('div.tooltipright').remove();
	  			$('<div class="tooltipright"><div class="tooltiprighttext">Active volcanoes</div></div>').appendTo('body');
			break;
			case"button7":
			 	$('div.tooltipright').remove();
	  			$('<div class="tooltipright"><div class="tooltiprighttext">Plates collide with <br/> continental crust</div></div>').appendTo('body');
			break;
		}
			 
	  changeTooltipPosition(event);
	};

	var hideTooltip = function() {
		switch(this.id){
			case"button1":
			case"button2":
			 	$('div.tooltipleft').remove();
			break;
			case"button3":
			case"button4":
			case"button5":
			case"button6":
			case"button7":
			 	$('div.tooltipright').remove();
			break;
		}
	   
	};

	$("#button1,#button2,#button3,#button4,#button5,#button6,#button7").bind({
	   mousemove : changeTooltipPosition,
	   mouseenter : showTooltip,
	   mouseleave: hideTooltip
	});		
		
	/* HIDE SLIDES */ 
	
	$("#animations").hide();
	$("#description1").hide();
	$("#image").hide();
	$("#desc").hide();	
	$("#descriptionlabel").hide();
	
	/* BUTTONS */
				
	$("#button1,#button2,#button3,#button4,#button5,#button6,#button7").click(function(){
		
		$("#image").hide();
		$("#desc").hide();	
		$("#instruction").hide();
		
		switch(this.id){
		case"button1": 
			$("#animations").css("background-image", "url(images/ou-volcano-island-arc-volcanoes.gif)");
			$("#desc").html("When magma erupts under the sea, it tends to give rise to an arc of volcanoes which forms the basis of oceanic islands such as those found in the western Pacific (e.g. Phillipines).");
			$("#image").css("background-image", "url(images/island_arc_volcanoes.jpg)");
			$("#descriptionlabel").html( "Island arc volcanoes");
			$("#descriptionlabel").delay(1000).fadeIn( "slow");
			break;
		case"button2": 
			$("#animations").css("background-image", "url(images/ou-volcano-plates-move-and-collide-left.gif)");
			$("#desc").html("The creation of new crust pushes the existing plates sideways, where they collide with other plates. When plates converge in this way, one of them will be forced downwards, deep below the earth surface. <br/> The immense force of one plate being driven under the other melts the crust into magma.");
			$("#image").css("background-image", "url(images/ou-volcano-plates-move-and-collide-zoom_242.gif)");
			$("#descriptionlabel").html( "Plates move and collide");
			$("#descriptionlabel").delay(1000).fadeIn( "slow");
			break;
		case"button3": 
			$("#animations").css("background-image", "url(images/ou-volcano-rising-magma.gif)");
			$("#desc").html("The rising magma that creates these tectonic plates wells up from beneath the earth’s crust along submarine ridges on the seabed.");
			$("#image").css("background-image", "url(images/rising_magma.jpg)");
			$("#descriptionlabel").html( "Rising magma");
			$("#descriptionlabel").delay(1000).fadeIn( "slow");
			break;
		case"button4": 
			$("#animations").css("background-image", "url(images/ou-volcano-rising-magma.gif)");
			$("#desc").html("The rising magma that creates these tectonic plates wells up from beneath the earth’s crust along submarine ridges on the seabed.");
			$("#image").css("background-image", "url(images/rising_magma.jpg)");			
			$("#descriptionlabel").html( "Rising magma");
			$("#descriptionlabel").delay(1000).fadeIn( "slow");
			break;
		case"button5": 
			$("#animations").css("background-image", "url(images/ou-volcano-creation-of-volcanic-mountain-ranges.gif)");
			$("#desc").html("When magma erupts on continental land then mountain ranges are formed (e.g. Andes).");
			$("#image").css("background-image", "url(images/creation_of_volcanic_mountain_ranges.jpg)");
			$("#descriptionlabel").html( "Creation of volcanic mountain ranges");
			$("#descriptionlabel").delay(1000).fadeIn( "slow");
			break;
		case"button6": 
			$("#animations").css("background-image", "url(images/ou-volcano-creation-of-volcanic-mountain-ranges.gif)");
			$("#desc").html("When magma erupts on continental land then mountain ranges are formed (e.g. Andes).");
			$("#image").css("background-image", "url(images/creation_of_volcanic_mountain_ranges.jpg)");
			$("#descriptionlabel").html( "Creation of volcanic mountain ranges");
			$("#descriptionlabel").delay(1000).fadeIn( "slow");
			break;
		case"button7": 
			$("#animations").css("background-image", "url(images/ou-volcano-plates-move-and-collide-right.gif)");
			$("#desc").html("The creation of new crust pushes the existing plates sideways, where they collide with other plates. When plates converge in this way, one of them will be forced downwards, deep below the earth surface. <br/> The immense force of one plate being driven under the other melts the crust into magma.");
			$("#image").css("background-image", "url(images/ou-volcano-plates-move-and-collide-zoom_242.gif)");
			$("#descriptionlabel").html( "Plates move and collide");
			$("#descriptionlabel").delay(1000).fadeIn( "slow");
			break;
							
		}
		
		$("#image").hide();
		$("#desc").hide();
		
		$("#animations").stop(true, true).show(0);
		$("#description1").show( "slide", {direction: "up" }, 500 );
		$("#image").stop(true, true).delay(600).show( "slide", {direction: "up" }, 500 );
		$("#desc").stop(true, true).delay(600).show( "slide", {direction: "up" }, 500 );
		
	});
	
})

	 
