* Calibration
 
* Parameters for variable initialization
Parameters
 CPI0         consumer price index
 DPI0         producer price index
 EG0          total current government expenditures
 EH0(H)       aggregate household consumption expenditure
 ETAX0        export tax revenue
 EXR0         exchange rate (dom. currency per unit of for. currency)
 FSAV0        foreign savings (in foreign currency units)
 FTAX0        factor use tax revenue
 GADJ0        government demand adjustment factor
 GOVSHR0      government share of total absorption
 GSAV0        government savings
 HTAX0        household income tax revenue
 IADJ0        investment scaling factor (for fixed capital formation)
 INVSHR0      invest ment share of total absorption
 MPS0(H)      marginal (and average) propensity to save for household h
 MPSADJ0      MPS household adjustment factor
 MTAX0        import tax revenue
 PA0(A)       outpur price of activity a
 PD0(C)       domestic price of domestic output c 
 PE0(C)       export price for c (domestic currency) 
 PM0(C)       import price for c (domestic currency)
 PQ0(C)       price of composite good c
 PTAX0        production tax revenue
 PVA0(A)      value-added price for activity a
 PWE0(C)      world price of exports
 PX0(C)       producer price for commodity c
 QA0(A)       level of domestic activity 
 QD0(C)       quantity of domestic sales
 QE0(C)       quantity of exports 
 QF0(F,A)     quantity demanded of factor f from activity a
 QFS0(F)      quantity of factor supply
 QG0(C)       quantity of government demand
 QH0(C,H)     quantity consumed of marketed commodity c by household h
 QINTCA0(C,A) qnty of intermediate demand for c from activity a
 QINV0(C)     quantity of fixed investment demand
 QM0(C)       quantity of imports
 QQ0(C)       quantity of composite goods supply
 QX0(C)       quantity of domestic output of commodity c
 STAX0        commodity sales tax revenue
 TABS0        total absorption
 TA0(A)       rate of tax on producer gross output value
 TE0(C)       rate of tax on exports
 TFA0(F,A)    rate of tax on factor use by activity
 TM0(C)       rate of import tariff
 TQ0(C)       rate of sales taxes
 TY0(H)       rate of income tax for household h
 WALRAS0      savings-investment imbalance (should be zero)
 WF0(F)       economy-wide wage (rent) for factor f
 WFDIST0(F,A) factor wage distortion variable
 YF0(F)       factor income
 YG0          total current government income
 YH0(H)       income of household h

;

* Assign parameters

*FACTOR EMPLOYMENT AND WAGES

*Defining factor employment and supply
* in this model factor employment is defined in terms of base year prices

 QF0(F,A)     = SAM(F,A);
 QFS0(F)      = SUM(A, QF0(F,A));

*Computing activity-specific wage
 wfa(F,A)$QF0(F,A) = SAM(F,A)/QF0(F,A);

*Computing average wage
 WF0(F)       = SUM(A, SAM(F,A))/SUM(A, QF0(F,A));

*Computing wage distortion factors
 WFDIST0(F,A) = wfa(F,A) / WF0(F);
 
* factor use tax rates
 TFA0(F,A)$SAM(F,A) = SUM(TFF$mapF2TFF(F,TFF), SAM(TFF,A))/SAM(F,A) ;

*PRICE BLOCK

* Normalize prices

 EXR0      = 1;       
 PA0(A)    = 1;
 PD0(C)    = 1;
 PE0(C)    = 1;
 PM0(C)    = 1;
 PX0(C)    = 1;

*Specify real quantities (defined in terms of base prices)
*QA is GROSS of tax, so base for ta is as well

 QA0(A)        = SAM('TOTAL',A)/PA0(A);
 QD0(C)        = (SUM(A, SAM(A,C)) - (SAM(C,'ROW') -
                 SAM('EXPTAX',C)) )/PD0(C);
 QE0(C)        = (SAM(C,'ROW') - SAM('EXPTAX',C))/PE0(C);
 QM0(C)        = (SAM('ROW',C) + SAM('IMPTAX',C))/PM0(C);
 QQ0(C)        = QD0(C) + QM0(C) ;
 QX0(C)        = QD0(C) + QE0(C) ;
*QX0(C)        = SUM(A, SAM(A,C))/PX0(C);

 TA0(A)        = SAM('ACTTAX',A)/(PA0(A)*QA0(A));
 TQ0(C)$QQ0(C) = SAM('COMTAX',C)/(SAM(C,'TOTAL') - SAM(C,'ROW')) ;                                    
 TE0(C)$CE(C)  = SAM('EXPTAX',C)/SAM(C,'ROW') ;
 PWE0(C)$CE(C) = (SAM(C,'ROW')/EXR0) / QE0(C); 
 TM0(C)$CM(C)  = SAM('IMPTAX',C)/SAM('ROW',C);
 pwm(C)$CM(C)  = PM0(C)/(EXR0*(1 + TM0(C)) );

*allow for situation when the commodity is 100% imports
 PQ0(C)$(CD(C) OR CM(C)) = (PD0(C)*QD0(C) + PM0(C)*QM0(C))/[(1 - TQ0(c))*QQ0(C)];

*PQ0(C)$QQ0(C) = (SAM(C,'TOTAL') - SAM(C,'ROW'))/QQ0(C);

 QINTCA0(C,A)$PQ0(C)
               = SAM(C,A)/PQ0(C);
           
 ica(C,A)      = QINTCA0(C,A)/QA0(A);
 
 theta(A,C)    = (SAM(A,C)/PX0(C))/QA0(A);
           
 PVA0(A)       = PA0(A)*(1-TA0(A)) - SUM(C, PQ0(C)*ica(C,A));
 
 cwts(C)       = SUM(H, SAM(C,H))/SUM((CP,H), SAM(CP,H));
 dwts(C)       = PD0(C)*QD0(C)/SUM(CP, PD0(CP)*QD0(CP) ) ;
 CPI0          = SUM(C, cwts(C)*PQ0(C)) ;
 DPI0          = SUM(C, dwts(C)*PD0(C)) ;
  
*PRODUCTION AND COMMODITY BLOCK
 
* Cobb-Douglas production function
* when there are factor use taxes
* expenditure shares should be based on total payment
* to the factors

Parameter
 FPAY(F,A)   Total payments to factors including TFA
 TotFPAY(A)  Total factor payments 
 ;
 
 FPAY(F,A)    = (1 + TFA0(F,A))*wfa(F,A)*QF0(F,A) ;
 TotFPAY(A)   = SUM(F, FPAY(F,A)) ;

 alpha(F,A)   = FPAY(F,A)/TotFPAY(A) ;
 
 ad(A)        = QA0(A) / PROD(F$AFA(F,A), QF0(F,A)**alpha(F,A));
 
* CES production Function
* calibrate CES with an arbitrary number of factors

 rhoa(A)       = 1/ESUBVA(A) - 1 ;
 
 deltaa(F,A)   = WF0(F)*WFDIST0(F,A)*(1+TFA0(F,A))*QF0(F,A)**(1+rhoa(A))/
                       SUM(FP, WF0(FP)*WFDIST0(FP,A)*
                       (1 + TFA0(FP,A))*QF0(FP,A)**(1+rhoa(A) )) ;
 alphaa(A)     = QA0(A)/
                       SUM(F, deltaa(F,A)*QF0(F,A)**(-rhoa(A)))
                       **(-1/rhoa(A)) ;

 rhox(C)$(CE(C) AND CD(C))  = 1/ETRAX(C) + 1;
 rhoq(C)$(CM(C) AND CD(C))  = 1/ESUBQ(C) - 1;

 deltax(C)$(CE(C) and CD(C)) = 1/(1 + (PD0(C)/PE0(C))*(QE0(C)/QD0(C))**(rhox(C)-1));

 alphax(C)$(CE(C) and CD(C)) = QX0(C) / ( deltax(C)*QE0(C)**rhox(C)
                   + (1-deltax(C))*QD0(C)**rhox(C) )**(1/rhox(C));

 deltaq(C)$(CM(C) and CD(C)) = 1/(1 + (PD0(C)/PM0(C))*(QD0(C)/QM0(C))**(1+rhoq(C)));

 alphaq(C)$(CM(C) and CD(C)) = QQ0(C) / (deltaq(C)*QM0(C)**(-rhoq(C))
                   + (1-deltaq(C))*QD0(C)**(-rhoq(C)))**(-1/rhoq(C));

*INSTITUTION BLOCK

 EG0         = SUM(C, SAM(C,'GOV')) + SUM(H, SAM(H,'GOV')) ;
 FSAV0       = SAM('S-I','ROW')/EXR0;
 GSAV0       = SAM('S-I','GOV') ;
 GADJ0       = 1 ;
 IADJ0       = 1 ;
 MPS0(H)     = SAM('S-I',H) / (SAM('TOTAL',H) - SAM('DIRTAX',H)); 
 QH0(C,H)$PQ0(C)  = SAM(C,H)/PQ0(C);
 QINV0(C)$PQ0(C)  = SAM(C,'S-I')/PQ0(C);
 QG0(C)$PQ0(C)    = SAM(C,'GOV')/PQ0(C);
 YF0(F)      = SUM(A, SAM(F,A));
 YG0         = SAM('GOV','TOTAL');
 YH0(H)      = SAM('TOTAL',H);          

*beta(C,H)   = SAM(C,H)/SUM(CP, SAM(CP,H));
 qgbar(C)$PQ0(C)    = SAM(C,'GOV')/PQ0(C);
 qinvbar(C)$PQ0(C)  = SAM(C,'S-I')/PQ0(C);
 shry(H,F)          = SAM(H,F) / SAM('TOTAL',F);
 TY0(H)             = SAM('DIRTAX',H) / SAM('TOTAL',H);

* EXPORT DEMAND

 econst(c)       = QE0(c) ;
 pwse(c)$QE0(c)  = PWE0(c) ;
 

*Calibrate LES demand system
*LES calibration===========================================

PARAMETERS
 BUDSHR(C,H)   budget share for marketed commodity c and househo
 ChkBUDSHR(H)  check that budget shares some to unity
 ChkELAS(H)    check that expenditure elasticities satisfy Engel aggregation
 SUBSIST(H)    subsistence spending
 FRISCH(H)     Frisch parameter
 LESELAS(C,H)  Income elasticities of demand for LES system
 FRISCH2(H)    alt. defn of Frisch -- ratio of cons to supernumerary cons
 ChkLES(H)     check on LES parameter definitions (error mssg if error)
 LESELASP(C,H) Own price elasticity for marketed commodities
 SuperNum(H)   supernumerary income in LES system
 SuperNumR(H)  ratio of supernum to EH
 beta0(C,H)    initial value of betam in LES system
 gamma0(C,H)   initial committed demand 
 ;
 
*Frisch0 and LESEALS0 loaded from spreadsheet
 Frisch(H)      = Frisch0(H) ;
 LESELAS(C,H)   = LESELAS0(C,H) ;

 EH0(H)         = SUM(C, SAM(C,H)) ;

 BUDSHR(C,H)    = SAM(C,H)/SUM(CP, SAM(CP,H)) ;

 ChkBUDSHR(H)   = SUM(C, BUDSHR(C,H))  - 1 ;

 ChkELAS(H)     = SUM(C, BUDSHR(C,H)*LESELAS(C,H)) - 1 ;


DISPLAY BUDSHR, ChkBUDSHR, LESELAS, ChkELAS, "LESELAS before adjustment" ;

*Correct elasticities to make them satisfy Engle aggregation exactly

 LESELAS(C,H)  = LESELAS(C,H)/(ChkELAS(H) + 1);

*Check Engle aggregation again
 ChkELAS(H)     = SUM(C, BUDSHR(C,H)*LESELAS(C,H)) - 1 ;
                 

DISPLAY "*#*#*# Engle aggregation after adjustment", ChkELAS, LESELAS ;

 beta0(C,H)  = BUDSHR(C,H)*LESELAS(C,H);

 beta(C,H)   = beta0(C,H);

 gamma0(C,H)$BUDSHR(C,H)
     =  ( (SUM(CP, SAM(CP,H)) )/ PQ0(C) )
                      * ( BUDSHR(C,H) + beta(C,H)/FRISCH(H));

 gamma(C,H)   =  gamma0(C,H);

*Checking LES parameters===================================

 SUPERNUM(H)   =  EH0(H) - SUM(C, gamma(C,H)*PQ0(C)) ;
 FRISCH2(H)    = -EH0(H)/SUPERNUM(H);
 ChkLES(H)     = FRISCH(H) - FRISCH2(H) ;
 SuperNumR(H)  = SuperNum(H)/EH0(H) ;

 LESELASP(C,H) = -LESELAS(C,H)*( PQ0(C)*gamma(C,H) /
                 (SUM(CP, SAM(CP,H))) - 1/FRISCH(H));
                  
*SYSTEM CONSTRAINT BLOCK ANDS MACRO CLOSURE
 mpsbar(H)    = mps0(H);
 mps01(H)     = 1 ;
 MPSADJ0      = 0 ;
*MPS(H) =E= MPSBAR(H)*(1 + MPSADJ*mps01(H)) ; 


 WALRAS0      = 0.0 ;
 
 TABS0        = SUM((C,H), PQ0(C)*QH0(C,H)) +
                SUM(C, PQ0(C)*(QG0(C) + QINV0(C))) ;
                          
 INVSHR0      = SUM(C, PQ0(C)*QINV0(C))/TABS0 ;

 GOVSHR0      = SUM(C, PQ0(C)*QG0(C))/TABS0 ;
* Taxes 
 ETAX0 = SUM(C$CE(C), TE0(C)*EXR0*PWE0(C)*QE0(C)) ;
 
 FTAX0 = SUM((f,a), TFA0(F,A)*WF0(F)*WFDIST0(F,A)*QF0(F,A)) ;
 
 HTAX0 = SUM(H, TY0(H)*YH0(H)) ;
 
 MTAX0 = SUM(C$CM(C), TM0(C)*EXR0*pwm(C)*QM0(C)) ;
 
 PTAX0 = SUM(A, TA0(A)*PA0(A)*QA0(A)) ;
 
 STAX0 = SUM(C, TQ0(C)*PQ0(C)*QQ0(C)) ;  
