*LES calibration===========================================

PARAMETERS
 BUDSHR(C,H)   budget share for marketed commodity c and househo
 ChkBUDSHR(H)  check that budget shares some to unity
 ChkELAS(H)    check that expenditure elasticities satisfy Engel aggregation
 SUBSIST(H)    subsistence spending
 FRISCH(H)     Frisch parameter
 LESELAS(C,H)  Income elasticities of demand for LES system
 FRISCH2(H)    alt. defn of Frisch -- ratio of cons to supernumerary cons
 ChkLES(H)     check on LES parameter definitions (error mssg if error)
 LESELASP(C,H) Own price elasticity for marketed commodities
 SuperNum(H)   supernumerary income in LES system
 SuperNumR(H)  ratio of supernum to EH
 beta0(C,H)    initial value of betam in LES system
 gamma0(C,H)   initial committed demand 
 ;
 
*Frisch0 and LESEALS0 loaded from spreadsheet
 Frisch(H)      = Frisch0(H) ;
 LESELAS(C,H)   = LESELAS0(C,H) ;

 EH0(H)         = SUM(C, SAM(C,H)) ;

 BUDSHR(C,H)    = SAM(C,H)/SUM(CP, SAM(CP,H)) ;

 ChkBUDSHR(H)   = SUM(C, BUDSHR(C,H))  - 1 ;

 ChkELAS(H)     = SUM(C, BUDSHR(C,H)*LESELAS(C,H)) - 1 ;


DISPLAY BUDSHR, ChkBUDSHR, LESELAS, ChkELAS, "LESELAS before adjustment" ;

*Correct elasticities to make them satisfy Engle aggregation exactly

 LESELAS(C,H)  = LESELAS(C,H)/(ChkELAS(H) + 1);

*Check Engle aggregation again
 ChkELAS(H)     = SUM(C, BUDSHR(C,H)*LESELAS(C,H)) - 1 ;
                 

DISPLAY "*#*#*# Engle aggregation after adjustment", ChkELAS, LESELAS ;

 beta0(C,H)  = BUDSHR(C,H)*LESELAS(C,H);

 beta(C,H)   = beta0(C,H);

 gamma0(C,H)$BUDSHR(C,H)
     =  ( (SUM(CP, SAM(CP,H)) )/ PQ0(C) )
                      * ( BUDSHR(C,H) + beta(C,H)/FRISCH(H));

 gamma(C,H)   =  gamma0(C,H);

*Checking LES parameters===================================

 SUPERNUM(H)   =  EH0(H) - SUM(C, gamma(C,H)*PQ0(C)) ;
 FRISCH2(H)    = -EH0(H)/SUPERNUM(H);
 ChkLES(H)     = FRISCH(H) - FRISCH2(H) ;
 SuperNumR(H)  = SuperNum(H)/EH0(H) ;

 LESELASP(C,H) = -LESELAS(C,H)*( PQ0(C)*gamma(C,H) /
                 (SUM(CP, SAM(CP,H))) - 1/FRISCH(H));
                 
 DISPLAY SUPERNUM, FRISCH, Frisch2, ChkLES, GAMMA, Beta, LESELASP ;
