*#*#*#*#*# START OF 1repbase-UNI.inc #*#*#*#*

$STITLE Input file: 1REPBASE-UNI.INC.
*Report on base solution for uni-cge model

$ontext

This is an include file to UNI.GMS. It produces the following reports
on the economy based on data for the base solution (with the name of the
relevant parameter in parentheses):
1. Economic structure table by activity   (STRUCBASE1)
2. Economic structure table by commoidity (STRUCBASE2)
3. GDP table (GDPBASE)
4. Macro SAM (MACROSAM)
5. Input shares, factor wages, and elasticities (FACTAB1 - 4)
6. Household incomes (HHDTAB1 - 2)
7. Regional export shares (REGETAB)
8. Regional import shares (REGMTAB)

For STRUCBASE, note that both activity and commodity data is presented
under commodity headings.

$offtext


*1. Economic structure table (STRUCBASE)=============================

SETS

 STRROW  Rows (only used to control order in display)
 /
 TOTAL-1
 TAGR
 TNAGR
 TOTAL-2
 /

 STRCOL  Columns
 /
 VAshr       value-added share (%)
 PRDshr      production share (%)
 EMPshr      share in total employment (%)
 QQSHR       total commodity supply shares
 EXPshr      sector share in total exports (%)
 EXP-OUTshr  exports as share in sector output (%)
 IMPshr      sector share in total imports (%)
 IMP-DEMshr  imports as share of domestic demand (%)
 /

 STRCOL2(STRCOL)  Columns for summation operation
/
 QQshr    sector share in total commodity supply (%)
 EXPshr   sector share in total exports (%)
 IMPshr   sector share in total imports (%)
/

 STRCOL3(STRCOL) columns for activities
/
 VAshr
 PRDshr
 EMPshr
/
;


PARAMETER
 STRUCBASE(*,STRCOL)   Economic structure in the base
 STRUCBASEA(*,STRCOL)  Economic structure by activity in the base
 ;
 
*structural data by activities
 STRUCBASEA(A,'VAshr')
$ontext
   = 100*PVA.L(A)*QVA.L(A)/
         SUM(AP, PVA.L(AP)*QVA.L(AP)) ;
$offtext

  = 100*(SUM(F, WF.L(F)*WFDIST.L(F,A)*(1+TFA.L(F,A))*QF.L(F,A)) )/
         SUM((F,AP), WF.L(F)*WFDIST.L(F,AP)*(1+TFA.L(F,AP))*QF.L(F,AP))  ;
  

 STRUCBASEA(A,'PRDshr')
   = 100*PA.L(A)*QA.L(A)/
         SUM(AP, PA.L(AP)*QA.L(AP)) ;

 STRUCBASEA(A,'EMPshr')
   = 100*SUM(FLAB, QF.L(FLAB,A))/
         SUM((AP,FLAB), QF.L(FLAB,AP)) ;

*structural data by commodity
 STRUCBASE(C,'QQshr')
  = 100*PQ.L(C)*QQ.L(C)/SUM(CP, PQ.L(CP)*QQ.L(CP));

 STRUCBASE(C,'EXPshr')
  = 100*PWE.L(C)*QE.L(C)/SUM(CP, PWE.L(CP)*QE.L(CP));

 STRUCBASE(C,'IMPshr')
   = 100*pwm(C)*QM.L(C)/SUM(CP, pwm(CP)*QM.L(CP));

 STRUCBASE(C,'EXP-OUTshr')$(PX.L(C)*QX.L(C))
  = 100*PE.L(C)*QE.L(C)/(PX.L(C)*QX.L(C));

 STRUCBASE('TOTAL-1','EXP-OUTshr')
 = 100*SUM(C, PE.L(C)*QE.L(C))/SUM(CP, PX.L(CP)*QX.L(CP)) ;

 STRUCBASE(C,'IMP-DEMshr')$(PQ.L(C)*(1 - TQ.L(C))*QQ.L(C))
   = 100*PM.L(C)*QM.L(C)/(PQ.L(C)*(1 - TQ.L(C))*QQ.L(C));

 STRUCBASE('TOTAL-1','IMP-DEMshr')
   = 100*SUM(C, PM.L(C)*QM.L(C))
                            /SUM(CP, PQ.L(CP)*(1 - TQ.L(CP))*QQ.L(CP));

*Summation=======================

*activities
 STRUCBASEA('TOTAL-1',STRCOL3)     = SUM(A, STRUCBASEA(A,STRCOL3)) ;
 STRUCBASE('TOTAL-2','IMP-DEMshr') = STRUCBASE('TOTAL-1','IMP-DEMshr') ;
 STRUCBASE('TOTAL-2','EXP-OUTshr') = STRUCBASE('TOTAL-1','EXP-OUTshr') ;

*=======

*OPTION  STRUCBASE:2,
DISPLAY STRUCBASE, STRUCBASEA ;


PARAMETER
 TRADESHARE(*,C) 'Exports (imports) as a share of production (absorption)'
*                  by commodity at initial prices'
 CONSSHARE(AC,*) 'commodity demand shares'
 ;

 TRADESHARE('EXPO',C)$(QX0(C)*PX0(C))
                               = 100 * (QE0(C)*PE0(C))/(QX0(C)*PX0(C));

 TRADESHARE('IMPO',C)          = 100 * (QM0(C)*PM0(C))/(QQ0(C)*PQ0(C));

 CONSSHARE(C,H)                = 100 * PQ0(C)*QH0(C,H) /
                                    SUM(CP, PQ0(CP)*QH0(CP,H)) ;

 CONSSHARE(C,A)                = 100 * PQ0(C)*QINTCA0(C,A) /
                                   SUM(CP,PQ0(CP)*QINTCA0(CP,A)) ;

 CONSSHARE(C,'intermed')       = 100*PQ0(C)*SUM(A, QINTCA0(C,A))/
                                         SUM((CP,A), PQ0(CP)*QINTCA0(CP,A)) ;

 CONSSHARE(C,'invest')         = 100*PQ0(C)*QINV0(C)/
                                         SUM(CP, PQ0(CP)*QINV0(CP)) ;                                
 CONSSHARE(C,'govt')           = 100*PQ0(C)*qgbar(C)/
                                         SUM(CP, PQ0(CP)*qgbar(CP)) ;

 CONSSHARE('TOTAL',H)          = SUM(C, CONSSHARE(C,H)) ;

 CONSSHARE('TOTAL','intermed') = SUM(C, CONSSHARE(C,'intermed')) ;

 CONSSHARE('TOTAL','invest')   = SUM(C, CONSSHARE(C,'invest')) ;

 CONSSHARE('TOTAL','govt')     = SUM(C, CONSSHARE(C,'govt')) ;

 CONSSHARE(C,'TOTALQ')         = 100 * PQ0(C)*QQ0(C) / SUM(CP,PQ0(CP)*QQ0(CP)) ;

 CONSSHARE('TOTAL','TOTALQ')   = SUM(C,CONSSHARE(C,'TOTALQ')) ;

option consshare:2 ;
DISPLAY CONSSHARE, TRADESHARE;

*2. GDP table (GDPBASE===============================================

SETS

 IGDPX  Items for GDP and national accounts
  /
  ABSORP   absorption
  PRVCON   private consumption
  FIXINV   fixed investment
  DSTOCK   stock change
  GOVCON   government consumption
  EXPORTS  exports
  IMPORTS  imports
  GDPMP    GDP at market prices (alt. 1: spending)
  GDPMP2   GDP at market prices (alt. 2: value-added)
  NETITAX  net indirect taxes
  GDPFC2   GDP at factor cost
  /

 IGDPXX(IGDPX)  Items for GDPMP summation
  /
  PRVCON   private consumption
  FIXINV   fixed investment
  DSTOCK   stock change
  GOVCON   government consumption
  EXPORTS  exports
  IMPORTS  imports
  /

 KGDPX  second index in GDP tables
 /
 VALUE, PERC-GDP, PERC-TOT
 /

*================================

PARAMETERS
 GDPBASE(IGDPX,KGDPX) Aggregate national accounts summary
 GDPERR               error if alt GDP definitions are not identical
 PVABASE(A)           real value added price by activity
 ;
*================================

 GDPBASE('PRVCON','VALUE')  =  SUM((C,H), PQ.L(C)*QH.L(C,H)) ;
 GDPBASE('FIXINV','VALUE')  =  SUM(C, PQ.L(C)*QINV.L(C));
 GDPBASE('GOVCON','VALUE')  =  SUM(C, PQ.L(C)*qgbar(C));
 GDPBASE('EXPORTS','VALUE') =  SUM((CE), PWE.L(CE)*EXR.L*QE.L(CE));
 GDPBASE('IMPORTS','VALUE') = -SUM((CM), PWM(CM)*EXR.L*QM.L(CM));
 GDPBASE('GDPMP','VALUE')   =  SUM(IGDPXX, GDPBASE(IGDPXX,'VALUE'));

 GDPBASE('ABSORP','VALUE')
  = GDPBASE('GDPMP','VALUE') - GDPBASE('IMPORTS','VALUE')
    - GDPBASE('EXPORTS','VALUE');

* Replace with factor payments to VA factors, f1. Commodity factors
* KT in the teaching model, VA factors are in the set f, not f1
 GDPBASE('GDPFC2','VALUE') = SUM((F,A), WF.L(F)*WFDIST.L(F,A)*QF.L(F,A));

 PVABASE(A) = SUM(F, WF.L(F)*WFDIST.L(F,A)*QF.L(F,A))/QA.L(A) ;

 GDPBASE('NETITAX','VALUE') =
            SUM(A, TA.L(A)*PA.L(A)*QA.L(A))
          + SUM((CM), TM.L(CM)*QM.L(CM)*PWM(CM))*EXR.L
          + SUM((CE), TE.L(CE)*QE.L(CE)*PWE.L(CE))*EXR.L
          + SUM(C, TQ.L(C)*PQ.L(C)*QQ.L(C))
          + SUM((F,A), TFA.L(F,A)*WF.L(F)*WFDIST.L(F,A)*QF.L(F,A))                  
  ;

 GDPBASE('GDPMP2','VALUE')
  = GDPBASE('GDPFC2','VALUE') + GDPBASE('NETITAX','VALUE');

 GDPERR = GDPBASE('GDPMP2','VALUE') - GDPBASE('GDPMP','VALUE') ;

 GDPBASE(IGDPX,'PERC-GDP')$GDPBASE('GDPMP','VALUE')
  = 100*GDPBASE(IGDPX,'VALUE')/GDPBASE('GDPMP','VALUE');

*==================
OPTION GDPBASE:2;
DISPLAY GDPERR, GDPBASE;

*3. Macro SAM (MACSAM)===============================================


SET
 ACMAC     macrosam accounts
 /
 ACT0        Activities
 COM0        Commodities
 FAC0        Factors
 TAX0        All tax revenue
 HOU0        Domestic non-gov institution (households + enterprises)
 GOV0        Current government
 S-I0        Savings investment account
 ROW0        Rest of World
 TOTAL2      totals
 /

 ACMACNT(ACMAC)  all macrosam accounts except TOTAL2

 ;

ACMACNT(ACMAC)    = YES;
ACMACNT('TOTAL2') = NO;

ALIAS(ACMAC,ACMACP),(ACMACNT,ACMACNTP);

PARAMETER
   MACROSAM(ACMAC,ACMACP) Macro SAM
   BALCHK2(ACMAC)         total balance check
   ;

*Defining SAM cells==============


 MACROSAM('COM0','ACT0')    = SUM((C,A), PQ.L(C)*QINTCA.L(C,A)) ;
 
 MACROSAM('FAC0','ACT0')    = SUM((F,A), WF.L(F)*WFDIST.L(F,A)*QF.L(F,A));
 
 MACROSAM('TAX0','HOU0')    = SUM(H, TY.L(H)*YH.L(H));
 
 MACROSAM('TAX0','ACT0')    = SUM(A, TA.L(A)*PA.L(A)*QA.L(A)) +
                              SUM((F,A), TFA.L(f,a)*WF.L(F)* WFDIST.L(F,A)*QF.L(F,A)) ;
                              
 MACROSAM('ACT0','COM0')    = SUM((C,A), theta(A,C)*QA.L(A)*PA.L(A));
 
 MACROSAM('ROW0','COM0')    = SUM(C,   pwm(C)*QM.L(C))*EXR.L;
 
 MACROSAM('TAX0','COM0')    = SUM(C,   TQ.L(C)*PQ.L(C)*QQ.L(C)) +
                              SUM((C), TM.L(C)*pwm(C)*QM.L(C))*EXR.L +
                              SUM((C), TE.L(C)*PWE.L(C)*QE.L(C))*EXR.L;

 MACROSAM('HOU0','FAC0')    = SUM(F, YF.L(F));

 MACROSAM('COM0','HOU0')    = SUM((C,H), PQ.L(C)*QH.L(C,H));
 
 MACROSAM('S-I0','HOU0')    = SUM(H, MPS.L(H)*(1 - TY.L(H))*YH.L(H)) ;
   
 MACROSAM('COM0','GOV0')    = SUM(C, PQ.L(C)*qgbar(C));

 MACROSAM('S-I0','GOV0')    = GSAV.L ;

 MACROSAM('COM0','ROW0')    = SUM(C, PWE.L(C)*QE.L(C))*EXR.L;

 MACROSAM('S-I0','ROW0')    = FSAV.L*EXR.L ;

 MACROSAM('COM0','S-I0')    = SUM(C, PQ.L(C)*QINV.L(C)) ;

 MACROSAM('GOV0','TAX0')    = SUM(ACMAC, MACROSAM('TAX0',ACMAC));

*Computing account totals========

 MACROSAM('TOTAL2', ACMAC)  = 0;
 MACROSAM(ACMAC,'TOTAL2')   = 0;

 MACROSAM('TOTAL2', ACMACNTP) = SUM(ACMACNT,  MACROSAM(ACMACNT,ACMACNTP));
 MACROSAM(ACMACNT,'TOTAL2')   = SUM(ACMACNTP, MACROSAM(ACMACNT,ACMACNTP));

*Checking account balances=======

 BALCHK2(ACMACNT) = MACROSAM('TOTAL2',ACMACNT) - MACROSAM(ACMACNT,'TOTAL2');
 BALCHK2(ACMACNT)$(ABS(Balchk2(ACMACNT)) lt 1e-6) = 0 ;

PARAMETER
 ChkMAC  error message if Macro SAM does not balance
 ;

 ChkMAC(ACMACNT)$(ABS(BALCHK2(ACMACNT)) LT 1E-6) = 0 ;

*==========


*4. Input shares, factor wages, and elasticities (FACTAB1 - 4)=======

*The parameters FACTAB1, FACTAB2, FACTAB3, FACTAB4 are covered in this
*section.


SETS
 FF(AC) all factor accounts and total
 AA(AC) all activity accounts and total
 ;

 FF(F)       = YES;
 FF('TOTAL') = YES;
 AA(A)       = YES;
 AA('TOTAL') = YES;


PARAMETERS
 FACTAB1(AC,ACP) Factor shares within sector
 FACTAB2(AC,ACP) Factor shares across sectors
 FACTAB3(AC,*)   Agg factor & intd. input shares & their sub. elasticity
 FACTAB4(AC,ACP) Factor wages by sector
 ;

 FACTAB1(A,F)       = WF.L(F)*wfdist.L(F,A)*QF.L(F,A) ;
 FACTAB1('TOTAL',F) = SUM(A, FACTAB1(A,F)) ;
 FACTAB1(A,'TOTAL') = SUM(F, FACTAB1(A,F)) ;
 FACTAB1('TOTAL','TOTAL') = SUM(F, FACTAB1('TOTAL',F)) ;
 FACTAB2(AA,FF)     = FACTAB1(AA,FF) ;
 FACTAB4(AA,FF)     = FACTAB1(AA,FF) ;

 FACTAB2(AA,FF)$FACTAB2('TOTAL',FF) = 100*FACTAB2(AA,FF)/FACTAB2('TOTAL',FF) ;
 FACTAB1(AA,FF)$FACTAB1(AA,'TOTAL') = 100*FACTAB1(AA,FF)/FACTAB1(AA,'TOTAL') ;

$ONTEXT
 FACTAB3(A,'QVASHR')   = 100*PVA.L(A)*QVA.L(A)/(PA.L(A)*(1-ta(A))*QA.L(A)) ;
 FACTAB3(A,'QINTSHR')  = 100*PINTA.L(A)*QINTA.L(A)/
                            (PA.L(A)*(1-ta.L(A))*QA.L(A)) ;
 FACTAB3('TOTAL','QVASHR')  = 100*SUM(A, PVA.L(A)*QVA.L(A)) /
                              SUM(A, PA.L(A)*(1-ta.L(A))*QA.L(A)) ;
 FACTAB3('TOTAL','QINTSHR') = 100*SUM(A, PINTA.L(A)*QINTA.L(A)) /
                              SUM(A, PA.L(A)*(1-ta.L(A))*QA.L(A)) ;
 FACTAB3(A,'ACES')     = ACES(A) ;
 FACTAB3(A,'SIGMAQA')$ACES(A) = PRODELAS2(A) ;
 FACTAB3(A,'SIGMAVA')  = PRODELAS(A) ;
$OFFTEXT 

 FACTAB4(AA,'TOTAL')    = 0 ;
 FACTAB4(A,F)$QF.L(F,A) = FACTAB4(A,F)/QF.L(F,A) ;
 FACTAB4('TOTAL',F)$SUM(A, QF.L(F,A)) = FACTAB4('TOTAL',F)/SUM(A, QF.L(F,A)) ;

 OPTION FACTAB1:1, FACTAB2:1, FACTAB3:1, FACTAB4:3 ;
 Display FACTAB1, FACTAB2, FACTAB4 ;


*5. Household incomes (HHDTAB1 - 2)==================================

PARAMETERS
 HHDTAB1(AC,ACP) Share of item ACP in the total income of hhd H (%)
 HHDTAB2(AC,ACP) Share of hhd AC in total hhd income from item ACP (%)
 ;

 HHDTAB1(H,ACNT)       = 100*SAM(H,ACNT)/SUM(ACNTP, SAM(H,ACNTP));
 HHDTAB1('TOTAL',ACNT) = 100*SUM(H, SAM(H,ACNT))/SUM((H,ACNTP), SAM(H,ACNTP));
 HHDTAB1(AC,'TOTAL')   = SUM(ACNT, HHDTAB1(AC,ACNT));

 HHDTAB2(H,ACNT)$SUM(HP, SAM(HP,ACNT)) = 100*SAM(H,ACNT)/SUM(HP, SAM(HP,ACNT));
 HHDTAB2(H,'TOTAL')                    = 100*SUM(ACNT, SAM(H,ACNT))/
                                             SUM((HP,ACNT), SAM(HP,ACNT));

 HHDTAB2('TOTAL',AC)                   = SUM(H, HHDTAB2(H,AC));

 OPTION  HHDTAB1:1, HHDTAB2:1;
 DISPLAY HHDTAB1, HHDTAB2;
 
*#*#*#*#*# END OF 1repbase.inc #*#*#*#*
$STITLE MAIN
