$TITLE CREATE BASE and RESULTS TABLES

* BASE Tables

* Base quantities

 SET
 
 QCTAB Items in quantity commodity tables
 /QQ1       composite domestic supply of commodity C
  QX1       domestic output of commodity C
  QD1       domestic output of commodity C sold domestically
  QINT      aggregate intermediate input demand for commoditiy C
  QM1       imports of commodity C
  QE1       exports of commodity C
  QHTOT     total private consumption of commodity C
  QG1       government consumption of commodity C 
  QINV1     investment demand for commodity C
  /
; 

 PARAMETER RES_QCOM_B(C,QCTAB)  Quantity ommodity results in the base
           RES_QCOM_L(C,QCTAB)  Quantity commodity results in Levels
           RES_QCOM_PC(C,QCTAB) Quantity commodity results percent change from base
           ;
  RES_QCOM_B(C,"QQ1")   = QQ0(C) ;
  RES_QCOM_B(C,"QX1")   = QX0(C) ;
  RES_QCOM_B(C,"QD1")   = QD0(C) ;
  RES_QCOM_B(C,"QINT")  = SUM(a, QINTCA0(c,a)) ;
  RES_QCOM_B(C,"QM1")   = QM0(C) ;
  RES_QCOM_B(C,"QE1")   = QE0(C) ;
  RES_QCOM_B(C,"QHTOT") = SUM(H, QH0(C,H)) ;
  RES_QCOM_B(C,"QG1")   = QG0(C) ;
  RES_QCOM_B(C,"QINV1") = QINV0(C) ;
  
  RES_QCOM_L(C,"QQ1")   = QQ.L(C) ;
  RES_QCOM_L(C,"QX1")   = QX.L(C) ;
  RES_QCOM_L(C,"QD1")   = QD.L(C) ;
  RES_QCOM_L(C,"QINT")  = SUM(a, QINTCA.L(c,a)) ;
  RES_QCOM_L(C,"QM1")   = QM.L(C) ;
  RES_QCOM_L(C,"QE1")   = QE.L(C) ;
  RES_QCOM_L(C,"QHTOT") = SUM(H, QH.L(C,H)) ;
  RES_QCOM_L(C,"QG1")   = QG.L(C) ;
  RES_QCOM_L(C,"QINV1") = QINV.L(C) ;
  
  RES_QCOM_PC(C,QCTAB)$RES_QCOM_B(C,QCTAB)
                        = 100*(RES_QCOM_L(C,QCTAB)/RES_QCOM_B(C,QCTAB) - 1) ;
  
* Base price tables

 SET PCTAB Items in price commodity table
 /PQ1      market price for composite commodity inclusive of sales tax
  PX1      producer price for commodity C (supply price averaged over domestic and export sales)
  PD1      domestic price of domestic output c (supply price of domestic product sold domestically)
  PE1      export price for commodity C (supply price of export in domestic currency)
  PWE1     world price of exports fob
  PM1      import price for commodity C (domestic market price of imports in domestic currency )
  PWM1     world price of imports cif
 /
 
;


 PARAMETER RES_PCOM_B(C,PCTAB)    Commodity prices in the base
           RES_PCOM_L(C,PCTAB)    Commodity prices in levels
           RES_PCOM_PC(C,PCTAB)   Percent change in commodity prices            
;

  RES_PCOM_B(C,'PQ1')       = PQ0(C); 
  RES_PCOM_B(C,'PX1')       = PX0(C) ;
  RES_PCOM_B(C,'PD1')       = PD0(C) ;
  RES_PCOM_B(C,'PE1')       = PM0(C) ;
  RES_PCOM_B(C,'PWE1')      = PWE0(C) ;
  RES_PCOM_B(C,'PM1')       = PM0(C) ;
  RES_PCOM_B(C,'PWM1')      = pwm0(C) ;

  RES_PCOM_L(C,'PQ1')       = PQ.L(C); 
  RES_PCOM_L(C,'PX1')       = PX.L(C) ;
  RES_PCOM_L(C,'PD1')       = PD.L(C) ;
  RES_PCOM_L(C,'PE1')       = PM.L(C) ;
  RES_PCOM_L(C,'PWE1')      = PWE.L(C) ;
  RES_PCOM_L(C,'PM1')       = PM.L(C) ;
  RES_PCOM_L(C,'PWM1')      = pwm(C) ;
  
  RES_PCOM_PC(C,PCTAB)$RES_PCOM_B(C,PCTAB)
                            = 100*(RES_PCOM_L(C,PCTAB)/RES_PCOM_B(C,PCTAB) - 1) ;

* Base GDP Tables

 SET
  GDPTAB  Items in GDP table       
 /PRVCON  Private consumption
  FIXINV  Fixed investment
  GOVCON  Government consumption
  EXPORTS Exports
  IMPORTS Imports
  GDPMP   GDP at market prices (spending)
  ABSORP1 Absorption
       /
        
;

 PARAMETER NGDPTAB_B(GDPTAB)  Nominal GDP table in base
           NGDPTAB_L(GDPTAB)  Nominal GDP table in levels
           NGDPTAB_PC(GDPTAB) Percent change in nominal GDP table
           RGDPTAB_B(GDPTAB)  Real GDP table in base
           RGDPTAB_L(GDPTAB)  Real GDP table  in levels
           RGDPTAB_PC(GDPTAB) Percent change in real GDP table  
;

* Nominal - base
  NGDPTAB_B('PRVCON')     = SUM((C,H), PQ0(C)*QH0(C,H)) ;
  NGDPTAB_B('FIXINV')     = SUM(C, PQ0(C)*QINV0(C)) ;
  NGDPTAB_B('GOVCON')     = SUM(C, PQ0(C)*QG0(C)) ;
  NGDPTAB_B('EXPORTS')    = SUM(C, PWE0(C)*EXR0*QE0(C)) ;
  NGDPTAB_B('IMPORTS')    = SUM(C, pwm(C)*EXR0*QM0(C)) ;
  NGDPTAB_B('GDPMP')      = NGDPTAB_B('PRVCON') + NGDPTAB_B('FIXINV') + NGDPTAB_B('GOVCON') +
                            NGDPTAB_B('EXPORTS') - NGDPTAB_B('IMPORTS') ;                            
  NGDPTAB_B('ABSORP1')    = NGDPTAB_B('GDPMP') - NGDPTAB_B('IMPORTS') - NGDPTAB_B('EXPORTS') ;
  
* Nominal - level 
  NGDPTAB_L('PRVCON')     = SUM((C,H), PQ.L(C)*QH.L(C,H)) ;
  NGDPTAB_L('FIXINV')     = SUM(C, PQ.L(C)*QINV.L(C)) ;
  NGDPTAB_L('GOVCON')     = SUM(C, PQ.L(C)*QG.L(C)) ;
  NGDPTAB_L('EXPORTS')    = SUM(C, PWE.L(C)*EXR.L*QE.L(C)) ;
  NGDPTAB_L('IMPORTS')    = SUM(C, pwm(C)*EXR.L*QM.L(C)) ;
  NGDPTAB_L('GDPMP')      = NGDPTAB_L('PRVCON') + NGDPTAB_L('FIXINV') + NGDPTAB_L('GOVCON') +
                            NGDPTAB_L('EXPORTS') - NGDPTAB_L('IMPORTS');
  NGDPTAB_L('ABSORP1')    = NGDPTAB_L('GDPMP') - NGDPTAB_L('IMPORTS') - NGDPTAB_L('EXPORTS') ;
  
  NGDPTAB_PC(GDPTAB)$NGDPTAB_B(GDPTAB)
                          = 100*(NGDPTAB_L(GDPTAB)/NGDPTAB_B(GDPTAB) - 1 ) ; 

* Real  - base
  RGDPTAB_B('PRVCON')     = SUM((C,H), PQ0(C)*QH0(C,H)) ;
  RGDPTAB_B('FIXINV')     = SUM(C, PQ0(C)*QINV0(C)) ;
  RGDPTAB_B('GOVCON')     = SUM(C, PQ0(C)*QG0(C)) ;
  RGDPTAB_B('EXPORTS')    = SUM(C, PWE0(C)*EXR0*QE0(C)) ;
  RGDPTAB_B('IMPORTS')    = SUM(C, pwm(C)*EXR0*QM0(C)) ;
  RGDPTAB_B('GDPMP')      = RGDPTAB_B('PRVCON') + RGDPTAB_B('FIXINV') + RGDPTAB_B('GOVCON') +
                            RGDPTAB_B('EXPORTS') - RGDPTAB_B('IMPORTS') ;

  RGDPTAB_B('ABSORP1')    = RGDPTAB_B('GDPMP') - RGDPTAB_B('IMPORTS') - RGDPTAB_B('EXPORTS') ;
  
  RGDPTAB_L('PRVCON')     = SUM((C,H), PQ0(C)*QH.L(C,H)) ;
  RGDPTAB_L('FIXINV')     = SUM(C, PQ0(C)*QINV.L(C)) ;
  RGDPTAB_L('GOVCON')     = SUM(C, PQ0(C)*QG.L(C)) ;
  RGDPTAB_L('EXPORTS')    = SUM(C, PWE.L(C)*EXR0*QE.L(C)) ;
  RGDPTAB_L('IMPORTS')    = SUM(C, pwm(C)*EXR0*QM.L(C)) ;
  RGDPTAB_L('GDPMP')      = RGDPTAB_L('PRVCON') + RGDPTAB_L('FIXINV') + RGDPTAB_L('GOVCON') +
                            RGDPTAB_L('EXPORTS') - RGDPTAB_L('IMPORTS') ;
  
  RGDPTAB_L('ABSORP1')    = RGDPTAB_L('GDPMP') - RGDPTAB_L('IMPORTS') - RGDPTAB_L('EXPORTS') ;
  
  RGDPTAB_PC(GDPTAB)$RGDPTAB_B(GDPTAB)
                          = 100*(RGDPTAB_L(GDPTAB)/RGDPTAB_B(GDPTAB) - 1);

*# Base scalar values

 Set SCALTAB Items in scalars table
 /EXR1         exchange rate (dom. currency per unit of for. currency)
  FSAV1        foreign savings (in foreign currency units)
  YG1          government revenue
  ETAX1        export tax revenue
  MTAX1        import tax revenue
  STAX1        commodity sales tax revenue
  PTAX1        production tax revenue
  FTAX1        factor use tax revenue
  HTAX1        household income tax revenue
  GSAV1        government savings
  EG1          government expenditures
  YHTOT        income of household h (all HH)
  EHTOT        aggregate household consumption expenditure (all HH)
  GOVSHR1      government consumption as share of total absorption
  INVSHR1      investment as share of total absorption
  GADJ1        government consumption adjustment factor
  IADJ1        investment adjustment factor
  MPS1         marginal (and average) propensity to save for household h (single HH)
  MPSADJ1      household MPS adjustment factor
  CPI1         consumer price index
  DPI1         producer price index
  WALRAS1      dummy variable (zero at equilibrium)
  /
;

 Parameter RES_SCAL_B(SCALTAB)   Scalar values in base
           RES_SCAL_L(SCALTAB)   Scalar values in levels
           RES_SCAL_PC(SCALTAB)  Percent change in scalar values in levels
 ;

  RES_SCAL_B('EXR1')     = EXR0 ;
  RES_SCAL_B('FSAV1')    = FSAV0 ;
  RES_SCAL_B('YG1')      = YG0 ;
  RES_SCAL_B('ETAX1')    = ETAX0 ;
  RES_SCAL_B('MTAX1')    = MTAX0 ;
  RES_SCAL_B('STAX1')    = STAX0 ;
  RES_SCAL_B('PTAX1')    = PTAX0 ; 
  RES_SCAL_B('FTAX1')    = FTAX0 ;
  RES_SCAL_B('HTAX1')    = HTAX0 ;
  RES_SCAL_B('GSAV1')    = GSAV0 ;
  RES_SCAL_B('EG1')      = EG0 ;
  RES_SCAL_B('YHTOT')    = SUM(H, YH0(H)) ;
  RES_SCAL_B('EHTOT')    = SUM(H, EH0(H)) ;
  RES_SCAL_B('GADJ1')    = GADJ0 ;
  RES_SCAL_B('GOVSHR1')  = GOVSHR0 ;
  RES_SCAL_B('IADJ1')    = IADJ0 ;
  RES_SCAL_B('INVSHR1')  = INVSHR0 ;
  RES_SCAL_B('MPS1')     = SUM(H, MPS0(H)) ;
  RES_SCAL_B('MPSADJ1')  = MPSADJ0 ;
  RES_SCAL_B('CPI1')     = CPI0 ;
  RES_SCAL_B('DPI1')     = DPI0 ;
  RES_SCAL_B('WALRAS1')  = WALRAS0 ;
  
  RES_SCAL_B(SCALTAB)$(RES_SCAL_B(SCALTAB) EQ 0) = EPS ;
  
  RES_SCAL_L('EXR1')     = EXR.L ;
  RES_SCAL_L('FSAV1')    = FSAV.L ;
  RES_SCAL_L('YG1')      = YG.L ;
  RES_SCAL_L('ETAX1')    = ETAX.L ;
  RES_SCAL_L('MTAX1')    = MTAX.L ;
  RES_SCAL_L('STAX1')    = STAX.L ;
  RES_SCAL_L('PTAX1')    = PTAX.L ; 
  RES_SCAL_L('FTAX1')    = FTAX.L ;
  RES_SCAL_L('HTAX1')    = HTAX.L ;
  RES_SCAL_L('GSAV1')    = GSAV.L ;
  RES_SCAL_L('EG1')      = EG.L ;
  RES_SCAL_L('YHTOT')    = SUM(H, YH.L(H)) ;
  RES_SCAL_L('EHTOT')    = SUM(H, EH.L(H)) ;
  RES_SCAL_L('GADJ1')    = GADJ.L ;
  RES_SCAL_L('GOVSHR1')  = GOVSHR.L ;
  RES_SCAL_L('IADJ1')    = IADJ.L ;
  RES_SCAL_L('INVSHR1')  = INVSHR.L ;
  RES_SCAL_L('MPS1')     = SUM(H, MPS.L(H)) ;
  RES_SCAL_L('MPSADJ1')  = MPSADJ.L ;
  RES_SCAL_L('CPI1')     = CPI.L ;
  RES_SCAL_L('DPI1')     = DPI.L ;
  RES_SCAL_L('WALRAS1')  = WALRAS.L ;
  
  RES_SCAL_L(SCALTAB)$(RES_SCAL_L(SCALTAB) EQ 0) = EPS ;
  
  RES_SCAL_PC(SCALTAB)$(RES_SCAL_B(SCALTAB) GT EPS)
                         = 100*(RES_SCAL_L(SCALTAB)/RES_SCAL_B(SCALTAB) - 1) ;
                         
  RES_SCAL_PC(SCALTAB)$(RES_SCAL_PC(SCALTAB) EQ 0) = EPS ;
 
*# Base factor data

 Set Items in fact table
  FTAB
  /WF1       average price of factor f
   YF1       factor income  
   QFS1      supply of factor f
   /  
;
  
 Parameter FACT_B(F,FTAB)  Factor results by factor in base
           FACT_L(F,FTAB)  Factor results by factor in levels
           FACT_PC(F,FTAB) Percent change in factor results 
 
;
  FACT_B(F,'WF1')  = WF0(F);
  FACT_B(F,'YF1')  = YF0(F);
  FACT_B(F,'QFS1') = QFS0(F);
  
  FACT_L(F,'WF1')  = WF.L(F);
  FACT_L(F,'YF1')  = YF.L(F);
  FACT_L(F,'QFS1') = QFS.L(F);
  
  FACT_PC(F,FTAB)$FACT_B(F,FTAB)
                   = 100*(FACT_L(F,FTAB)/FACT_B(F,FTAB) - 1) ;  
  
 Parameter QF_B(F,A) Factor results by factor and activity in base
           QF_L(F,A) Factor results by factor and activity in base
           QF_PC(F,A) Percent change in factor results by factor and activity            
;
  QF_B(F,A)        = QF0(F,A) ;
  QF_B(F,A)$(QF_B(F,A) EQ 0) = EPS ;  

  QF_L(F,A)        = QF.L(F,A) ;
  QF_L(F,A)$(QF_L(F,A) EQ 0) = EPS ;
  

  QF_PC(F,A)$QF0(F,A) = 100*(QF.L(F,A)/QF0(F,A) - 1) ;  
  QF_PC(F,A)$(QF_PC(F,A) EQ 0) = EPS ;

 Parameter WFA_B(F,A)  Factor prices by factor and activity in the base
           WFA_L(F,A)  Factor prices by factor and activity in levels
           WFA_PC(F,A) Percent change in base factor prices by factor and activity
 ;
   WFA_B(F,A)         = WF0(F)*WFDIST0(F,A)*QF0(F,A) ;
   WFA_B(F,A)$(WFA_B(F,A) EQ 0) = EPS ;   

   WFA_L(F,A)         = WF.L(F)*WFDIST.L(F,A)*QF.L(F,A) ;
   WFA_L(F,A)$(WFA_L(F,A) EQ 0) = EPS ;

   WFA_PC(F,A)$(WFA_B(F,A) GT EPS)
                      = 100*(WFA_L(F,A)/WFA_B(F,A) - 1) ;
                      
   WFA_PC(F,A)$(WFA_PC(F,A) EQ 0) = EPS ;

 Parameter WFDIST_B(F,A)  Factor price distortions by factor and activity in base
           WFDIST_L(F,A)  Factor price distortions by factor and activity in levels
           WFDIST_PC(F,A) Percent change in factor price distortions by factor and activity
 ;
 
   WFDIST_B(F,A)      = WFDIST0(F,A) ;
   WFDIST_L(F,A)      = WFDIST.L(F,A) ;
   WFDIST_PC(F,A)$WFDIST_B(F,A)
                      = 100*(WFDIST.L(F,A)/WFDIST0(F,A) - 1);
   
*# Base production
 Set PRODTAB items in production table
 /QA1       level of activity a
  PVA1      value-added price for activity a  
  /  
;

 Parameter RES_PROD_B(PRODTAB,A) Production and value added in base
           RES_PROD_L(PRODTAB,A) Production and value added in levels
           RES_PROD_PC(PRODTAB,A) Percent change in production and value added 
;

  RES_PROD_B('QA1',A)    = QA0(A);
  RES_PROD_B('PVA1',A)   = PVA0(A);
  
  RES_PROD_L('QA1',A)    = QA.L(A);
  RES_PROD_L('PVA1',A)   = PVA.L(A);
  
  RES_PROD_PC(PRODTAB,A)$RES_PROD_B(PRODTAB,A)
                         = 100*(RES_PROD_L(PRODTAB,A)/RES_PROD_B(PRODTAB,A) - 1);
  

*# Base tax rates 

 Set CTAXTAB items in commodity tax table
 /TQ1       rate of sales taxes
  TM1       rate of import tariff 
  TE1       rate of tax on exports
  /
; 

 Parameter CTAXR_B(c,CTAXTAB) Commodity tax rates in base
           CTAXR_L(c,CTAXTAB) Commodity tax rates in levels
           
;
  CTAXR_B(C,'TQ1')   = TQ0(C)*100;
  CTAXR_B(C,'TM1')   = TM0(C)*100;
  CTAXR_B(C,'TE1')   = TE0(C)*100;
  
  CTAXR_B(C,CTAXTAB)$(CTAXR_B(C,CTAXTAB) EQ 0) = EPS ;
  
  CTAXR_L(C,'TQ1')   = TQ.L(C)*100;
  CTAXR_L(C,'TM1')   = TM.L(C)*100;
  CTAXR_L(C,'TE1')   = TE.L(C)*100;
  
 CTAXR_L(C,CTAXTAB)$(CTAXR_L(C,CTAXTAB) EQ 0) = EPS ;
 
 Parameter ATAXR_B(A) Rate of tax on producer gross output value in base
           ATAXR_L(A) Rate of tax on producer gross output value in levels
 ;
  ATAXR_B(A)         = TA0(A)*100;
  ATAXR_B(A)$(ATAXR_B(A) EQ 0) = EPS ;
  
  ATAXR_L(A)         = TA.L(A)*100;
  ATAXR_L(A)$(ATAXR_L(A) EQ 0) = EPS ;

 Parameter YTAXR_B(H)  Rate of income tax for household in base
           YTAXR_L(H)  Rate of income tax for household in levels
;
  YTAXR_B(H)         = TY0(H)*100;
  YTAXR_B(H)$(YTAXR_B(H) EQ 0) = EPS ;
  
  YTAXR_L(H)         = TY.L(H)*100;
  YTAXR_L(H)$(YTAXR_L(H) EQ 0) = EPS ;

 Parameter TFATAXR_B(F,A) Rate of tax on factor use by activity in base
           TFATAXR_L(F,A) rate of tax on factor use by activity in levels
;
  TFATAXR_B(F,A)     = TFA0(F,A)*100 ;
  TFATAXR_B(F,A)$(TFATAXR_B(F,A) EQ 0) = EPS ;
  
  TFATAXR_L(F,A)     = TFA.L(F,A)*100 ;
  TFATAXR_L(F,A)$(TFATAXR_L(F,A) EQ 0) = EPS ;
  

Parameter BUDSHR_B(C,H), BUDSHR_L(C,H);
BUDSHR_B(C,H) = (PQ0(c) * QH0(C,H))/ SUM(CP, PQ0(C) *QH0(CP,H));
BUDSHR_L(C,H) = (PQ.l(c) * QH.l(C,H))/ SUM(CP,PQ.l(C) *QH.l(CP,H));

 
* write all results to Excel

Execute_unload 'UNI-RESULTS.gdx'
RES_QCOM_B,RES_QCOM_L,RES_QCOM_PC,
RES_PCOM_B,RES_PCOM_L,RES_PCOM_PC,
RGDPTAB_B,RGDPTAB_L,RGDPTAB_PC,
NGDPTAB_B,NGDPTAB_L,NGDPTAB_PC,
RES_SCAL_B,RES_SCAL_L,RES_SCAL_PC,
FACT_B,FACT_L,FACT_PC,
QF_B,QF_L,QF_PC,
WFA_B,WFA_L,WFA_PC,
WFDIST_B,WFDIST_L,WFDIST_PC,
RES_PROD_B,RES_PROD_L,RES_PROD_PC,
CTAXR_B,CTAXR_L,
ATAXR_B,ATAXR_L,
YTAXR_B,YTAXR_L,
TFATAXR_B,TFATAXR_L
;

$ontext
*CallTool Win32.ExcelTALK Close UNI-Results.xlsx
Execute "Gdxxrw UNI-RESULTS.gdx o=UNI-RESULTS.xlsx Index = Index!A4" ;

Display
RES_QCOM_B,RES_QCOM_PC,
RES_PCOM_B,RES_PCOM_PC,
RGDPTAB_B,RGDPTAB_PC,
NGDPTAB_B,NGDPTAB_PC,
RES_SCAL_B,RES_SCAL_PC,
FACT_B,FACT_PC,
QF_B,QF_PC,
WFA_B,WFA_PC,
WFDIST_B,WFDIST_PC,
RES_PROD_B,RES_PROD_PC,
CTAXR_B,CTAXR_L,
ATAXR_B,ATAXR_L,
YTAXR_B,YTAXR_L,
TFATAXR_B,TFATAXR_L,
BUDSHR_B,BUDSHR_L,
ESUBQ,ETRAX,EDE,LESELAS,FRISCH

;
$offText

embeddedCode Connect:
- GAMSReader:
    symbols:
      - name: RES_QCOM_B
      - name: RES_QCOM_PC
      - name: RES_PCOM_B
      - name: RES_PCOM_PC
      - name: RGDPTAB_B
      - name: RGDPTAB_PC
      - name: NGDPTAB_B
      - name: NGDPTAB_PC
      - name: RES_SCAL_B
      - name: RES_SCAL_PC
      - name: FACT_B
      - name: FACT_PC
      - name: QF_B
      - name: QF_PC
      - name: WFA_L
      - name: WFA_PC
      - name: WFDIST_L
      - name: WFDIST_PC
      - name: RES_PROD_B
      - name: RES_PROD_PC
      - name: CTAXR_B
      - name: CTAXR_L
      - name: ATAXR_B
      - name: ATAXR_L
      - name: YTAXR_B
      - name: YTAXR_L
      - name: TFATAXR_B
      - name: TFATAXR_L
      
        
- ExcelWriter:
    file: UNI-RESULTS-v2.xlsx 
    index: Index!A4   
endEmbeddedCode

